/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.util.vlist;

import com.novell.application.console.snapin.DefaultObjectEntryCollection;
import com.novell.application.console.snapin.IndexedObjectEntryEnumeration;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryChangeEvent;
import com.novell.application.console.snapin.ObjectEntryCollection;
import com.novell.application.console.snapin.ObjectEntryEnumeration;
import com.novell.application.console.snapin.SnapinException;
import com.novell.application.console.snapin.VirtualObjectEntryEnumeration;
import com.novell.application.console.util.vlist.BListAdjustmentEvent;
import com.novell.application.console.util.vlist.BListAdjustmentListener;
import com.novell.application.console.util.vlist.BListDataModel;
import com.novell.application.console.util.vlist.BListScrollBar;
import com.novell.application.console.util.vlist.DefaultSListSelectionModel;
import com.novell.application.console.util.vlist.SListSelectionEvent;
import com.novell.application.console.util.vlist.SelectionInfo;
import com.novell.application.console.util.vlist.VList;
import com.novell.application.console.util.vlist.VListContentPanel;
import com.novell.application.console.util.vlist.VListContentUI;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.CellRendererPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class BListContentUI
implements VListContentUI,
BListAdjustmentListener {
    private VListContentPanel contentPanel = null;
    private BListDataModel listModel = null;
    private DefaultSListSelectionModel selections = new DefaultSListSelectionModel();
    BListScrollBar theScrollBar = new BListScrollBar();
    int iEntriesPerColumn;
    int iColumnsVisible;
    int iWholeColumnsVisible;
    boolean bRecalcMetrics = false;
    boolean bFirstEntryIsOnScreen = false;
    boolean bLastEntryIsOnScreen = false;
    ObjectEntry[] oeScreenArray = null;
    CellRendererPane rendererPane = new CellRendererPane();
    long lLastActivityIndicator = -1L;

    public void processObjectEntryChangeEvent(ObjectEntryChangeEvent objectEntryChangeEvent) {
    }

    public void cleanUp() {
        if (this.contentPanel != null) {
            VList vList = (VList)this.contentPanel.getParent();
            vList.removeScrollBar(this.theScrollBar);
        }
    }

    public void setComponent(VListContentPanel vListContentPanel) {
        this.contentPanel = vListContentPanel;
    }

    public void setModel(ObjectEntryEnumeration objectEntryEnumeration) {
        this.contentPanel.setBusy(true);
        this.listModel = new BListDataModel(objectEntryEnumeration, this.contentPanel.getShell());
        ObjectEntry[] objectEntryArray = this.contentPanel.getGlobalEntries();
        if (objectEntryArray != null) {
            this.listModel.setGlobalEntries(objectEntryArray);
        }
        this.lLastActivityIndicator = this.listModel.setActivityIndicatorDifferent();
        this.setInitialEntryHeight();
        this.bRecalcMetrics = true;
        this.contentPanel.invalidate();
        this.contentPanel.repaint();
        this.contentPanel.setBusy(false);
    }

    public boolean isModelEmpty() {
        if (this.listModel == null) {
            return true;
        }
        ObjectEntry objectEntry = this.listModel.next();
        if (objectEntry != null) {
            this.listModel.previous();
            return false;
        }
        ObjectEntry objectEntry2 = this.listModel.previous();
        if (objectEntry2 != null) {
            this.listModel.next();
            return false;
        }
        return true;
    }

    public int getCount() {
        int n = -1;
        ObjectEntryEnumeration objectEntryEnumeration = this.listModel.getBaseModel();
        try {
            if (objectEntryEnumeration instanceof IndexedObjectEntryEnumeration) {
                n = ((IndexedObjectEntryEnumeration)objectEntryEnumeration).getCount();
            } else if (objectEntryEnumeration instanceof VirtualObjectEntryEnumeration) {
                n = ((VirtualObjectEntryEnumeration)objectEntryEnumeration).getCount();
            }
        }
        catch (SnapinException snapinException) {
            // empty catch block
        }
        return n;
    }

    public void setGlobalEntries(ObjectEntry[] objectEntryArray) {
        this.listModel.setGlobalEntries(objectEntryArray);
        this.listModel.moveFirst();
        this.clearSelection();
        this.bRecalcMetrics = true;
        this.contentPanel.invalidate();
        this.contentPanel.repaint();
    }

    public ObjectEntry locationToObject(Point point) {
        ListEntryInfo listEntryInfo = this.getObjectAtScreenPos(point.x, point.y);
        return listEntryInfo.getObjectEntry();
    }

    public void setSelectionMode(int n) {
        this.selections.setSelectionMode(n);
    }

    public int getSelectionMode() {
        return this.selections.getSelectionMode();
    }

    public void entryMetricsChanged() {
        this.bRecalcMetrics = true;
        this.contentPanel.invalidate();
        this.contentPanel.repaint();
    }

    public synchronized void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.selections.addListSelectionListener(listSelectionListener);
    }

    public synchronized void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.selections.removeListSelectionListener(listSelectionListener);
    }

    public ObjectEntry getSelectedObject() {
        ObjectEntry objectEntry = this.selections.getAnchorSelectionObject();
        return objectEntry;
    }

    public ObjectEntryCollection getSelectedObjects() {
        ObjectEntry[] objectEntryArray = this.selections.getSelectedObjects();
        return new DefaultObjectEntryCollection(objectEntryArray);
    }

    public void setSelectedObject(ObjectEntry objectEntry) {
        this.selections.setSelectionInterval(objectEntry);
    }

    public void setSelectedObjects(ObjectEntryCollection objectEntryCollection) {
        boolean bl = true;
        ObjectEntryEnumeration objectEntryEnumeration = objectEntryCollection.elements();
        while (objectEntryEnumeration.hasMoreElements()) {
            ObjectEntry objectEntry = objectEntryEnumeration.next();
            if (bl) {
                this.selections.setSelectionInterval(objectEntry);
                bl = false;
                continue;
            }
            this.selections.addSelectionInterval(objectEntry);
        }
    }

    public void addSelectedObjects(ObjectEntryCollection objectEntryCollection) {
        ObjectEntryEnumeration objectEntryEnumeration = objectEntryCollection.elements();
        while (objectEntryEnumeration.hasMoreElements()) {
            ObjectEntry objectEntry = objectEntryEnumeration.next();
            this.selections.addSelectionInterval(objectEntry);
        }
    }

    public SelectionInfo getSelectionInfoBeforeRefresh() {
        return new SelectionInfo(this.getSelectedObjects(), null);
    }

    public boolean setSelectedObjectsAfterRefresh(SelectionInfo selectionInfo) {
        this.setSelectedObjects(selectionInfo.getSelectedObjects());
        return true;
    }

    public void ensureObjectIsVisible(ObjectEntry objectEntry) {
        this.moveToObject(objectEntry);
        this.contentPanel.invalidate();
        this.contentPanel.repaint();
    }

    public void clearSelection() {
        this.selections.clearSelection();
    }

    public void selectAll() {
        Toolkit.getDefaultToolkit().beep();
    }

    public void moveTo(int n) {
    }

    public void moveTo(String string) {
        this.contentPanel.setBusy(true);
        this.listModel.moveTo(string);
        ObjectEntry objectEntry = this.listModel.getCurrent();
        if (objectEntry != null) {
            this.setSelectedObject(objectEntry);
            if (!this.bFirstEntryIsOnScreen || !this.bLastEntryIsOnScreen) {
                int n;
                if (this.iWholeColumnsVisible == 0) {
                    n = this.iEntriesPerColumn / 2;
                } else {
                    n = this.iEntriesPerColumn * this.iWholeColumnsVisible / 2;
                    if (this.iWholeColumnsVisible % 2 == 0) {
                        n += this.iEntriesPerColumn / 2;
                    }
                }
                this.listModel.moveModelLeft(n);
                this.contentPanel.invalidate();
                this.contentPanel.repaint();
            }
        }
        this.contentPanel.setBusy(false);
    }

    public void quickPaint(Rectangle rectangle) {
        Graphics graphics = this.contentPanel.getGraphics();
        if (graphics != null) {
            graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this.paintContent(graphics);
        }
    }

    public void paintContent(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        if (this.bRecalcMetrics) {
            this.calcColumnMetrics();
            this.setModelBlockSize();
            this.bRecalcMetrics = false;
        }
        this.populateScreenCache();
        this.calcScrollBarMetrics();
        int n = 0;
        int n2 = this.contentPanel.getContentUITopLeftX();
        int n3 = this.contentPanel.getContentUITopLeftY();
        int n4 = this.contentPanel.getEntryWidth();
        int n5 = this.contentPanel.getEntryHeight();
        int n6 = 0;
        while (n6 < this.iColumnsVisible) {
            int n7 = 0;
            while (n7 < this.iEntriesPerColumn) {
                Rectangle rectangle2 = new Rectangle(n2, n3, n4, n5);
                if (this.oeScreenArray.length > n && this.oeScreenArray[n] != null) {
                    if (rectangle2.intersects(rectangle)) {
                        this.paintCell(graphics, rectangle2, this.oeScreenArray[n]);
                    }
                } else {
                    graphics.setColor(this.contentPanel.getBackground());
                    graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                }
                n3 += n5;
                ++n;
                ++n7;
            }
            n2 += n4;
            n3 = this.contentPanel.getContentUITopLeftY();
            ++n6;
        }
        n3 = n5 * this.iEntriesPerColumn;
        if (n3 < this.contentPanel.getContentUIHeight()) {
            graphics.setColor(this.contentPanel.getBackground());
            graphics.fillRect(this.contentPanel.getContentUITopLeftX(), n3 + this.contentPanel.getContentUITopLeftY(), this.contentPanel.getContentUIWidth(), this.contentPanel.getContentUIHeight() - n3);
        }
    }

    protected void paintCell(Graphics graphics, Rectangle rectangle, ObjectEntry objectEntry) {
        ObjectEntry objectEntry2 = this.selections.getLeadSelectionObject();
        boolean bl = false;
        boolean bl2 = this.contentPanel.doesListHaveFocus();
        bl = bl2 ? objectEntry2 != null && objectEntry2.equals((Object)objectEntry) : this.selections.isSelectedObject(objectEntry);
        boolean bl3 = this.contentPanel.getDisplaySelectionOnlyIfFocus() ? bl2 && this.selections.isSelectedObject(objectEntry) : this.selections.isSelectedObject(objectEntry);
        Component component = this.contentPanel.getCellRenderer().getVListCellRendererComponent(objectEntry, -1, bl3, bl, this.contentPanel.getDisplayNameForObject(objectEntry), this.contentPanel.getDisplayIconForObject(objectEntry));
        this.rendererPane.paintComponent(graphics, component, null, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
    }

    private void populateScreenCache() {
        boolean bl = false;
        if (this.listModel.sameActivityIndicator(this.lLastActivityIndicator)) {
            return;
        }
        this.bFirstEntryIsOnScreen = false;
        this.bLastEntryIsOnScreen = false;
        if (this.iEntriesPerColumn == 0) {
            this.bFirstEntryIsOnScreen = true;
            this.bLastEntryIsOnScreen = true;
            this.oeScreenArray = new ObjectEntry[0];
            return;
        }
        ObjectEntry objectEntry = this.listModel.previous();
        if (objectEntry == null) {
            this.bFirstEntryIsOnScreen = true;
        } else {
            this.listModel.next();
        }
        this.oeScreenArray = new ObjectEntry[this.iColumnsVisible * this.iEntriesPerColumn];
        int n = 0;
        while (n < this.iColumnsVisible * this.iEntriesPerColumn) {
            this.oeScreenArray[n] = this.listModel.next();
            if (this.oeScreenArray[n] == null) {
                bl = true;
                ObjectEntry[] objectEntryArray = new ObjectEntry[n];
                int n2 = 0;
                while (n2 < n) {
                    objectEntryArray[n2] = this.oeScreenArray[n2];
                    ++n2;
                }
                this.oeScreenArray = objectEntryArray;
                break;
            }
            ++n;
        }
        if (!bl) {
            ObjectEntry objectEntry2 = this.listModel.next();
            if (objectEntry2 != null) {
                this.listModel.previous();
            } else {
                bl = true;
            }
        }
        if (bl) {
            int n3 = this.iWholeColumnsVisible * this.iEntriesPerColumn;
            if (n3 == 0) {
                n3 = this.iEntriesPerColumn;
            }
            if (this.oeScreenArray.length - 1 <= n3) {
                this.bLastEntryIsOnScreen = true;
            }
        }
        int n4 = 0;
        while (n4 < this.oeScreenArray.length) {
            this.listModel.previous();
            ++n4;
        }
        this.lLastActivityIndicator = this.listModel.getActivityIndicator();
    }

    public void onUpArrow() {
        ObjectEntry objectEntry = this.getSelectedObject();
        if (objectEntry == null) {
            return;
        }
        ListEntryInfo listEntryInfo = this.calcScreenPositionForObject(objectEntry);
        if (-1 != listEntryInfo.getScreenIndex()) {
            if (1 <= listEntryInfo.getScreenIndex()) {
                this.selections.setSelectionInterval(this.oeScreenArray[listEntryInfo.getScreenIndex() - 1]);
            } else if (listEntryInfo.getScreenIndex() == 0 && !this.bFirstEntryIsOnScreen) {
                this.listModel.moveModelLeft(this.iEntriesPerColumn);
                this.populateScreenCache();
                this.selections.setSelectionInterval(this.oeScreenArray[this.iEntriesPerColumn - 1]);
                this.bRecalcMetrics = true;
                this.contentPanel.invalidate();
                this.contentPanel.repaint();
            }
        } else {
            ObjectEntry objectEntry2 = this.selections.getLeadSelectionObject();
            this.moveToObject(objectEntry2);
            ObjectEntry objectEntry3 = this.listModel.previous();
            if (objectEntry3 != null) {
                this.listModel.next();
                this.selections.setSelectionInterval(objectEntry3);
                this.ensureObjectIsVisible(objectEntry3);
            }
        }
    }

    public void onDownArrow() {
        ListEntryInfo listEntryInfo;
        ObjectEntry objectEntry = this.getSelectedObject();
        if (objectEntry != null && -1 != (listEntryInfo = this.calcScreenPositionForObject(objectEntry)).getScreenIndex()) {
            if (this.oeScreenArray.length - 1 > listEntryInfo.getScreenIndex()) {
                ObjectEntry objectEntry2 = this.oeScreenArray[listEntryInfo.getScreenIndex() + 1];
                if (!this.isIndexWhollyVisible(listEntryInfo.getScreenIndex() + 1) && !this.isIndexInLeftmostColumn(listEntryInfo.getScreenIndex() + 1)) {
                    this.listModel.moveModelRight(this.iEntriesPerColumn);
                    this.contentPanel.invalidate();
                    this.contentPanel.repaint();
                }
                this.selections.setSelectionInterval(objectEntry2);
            } else if (this.oeScreenArray.length - 1 == listEntryInfo.getScreenIndex()) {
                int n;
                ObjectEntry[] objectEntryArray = this.listModel.peekAtModelRightEntries(this.iEntriesPerColumn, this.oeScreenArray.length);
                if (objectEntryArray != null && objectEntryArray.length != 0 && ((n = this.getArrayIndexForObjectEntry(objectEntryArray, objectEntry)) != 0 || objectEntryArray.length != 1)) {
                    this.listModel.moveModelRight(this.iEntriesPerColumn);
                    if (-1 == n) {
                        this.selections.setSelectionInterval(objectEntryArray[0]);
                    } else {
                        this.selections.setSelectionInterval(objectEntryArray[n + 1]);
                    }
                    this.contentPanel.invalidate();
                    this.contentPanel.repaint();
                }
            } else {
                ObjectEntry objectEntry3 = this.selections.getLeadSelectionObject();
                this.moveToObject(objectEntry3);
                ObjectEntry[] objectEntryArray = new ObjectEntry[]{this.listModel.next(), this.listModel.next()};
                if (objectEntryArray[0] != null) {
                    if (objectEntryArray[1] != null) {
                        this.listModel.previous();
                        this.selections.setSelectionInterval(objectEntryArray[1]);
                        this.ensureObjectIsVisible(objectEntryArray[1]);
                    } else {
                        this.selections.setSelectionInterval(objectEntryArray[0]);
                        this.ensureObjectIsVisible(objectEntryArray[0]);
                    }
                }
            }
        }
    }

    public void onRightArrow() {
        ObjectEntry objectEntry = this.getSelectedObject();
        if (objectEntry != null) {
            ListEntryInfo listEntryInfo = this.calcScreenPositionForObject(objectEntry);
            if (-1 != listEntryInfo.getScreenIndex()) {
                int n = listEntryInfo.getScreenIndex() + this.iEntriesPerColumn;
                int n2 = 0;
                while (!this.isIndexInLeftmostColumn(n) && !this.isIndexWhollyVisible(n)) {
                    n -= this.iEntriesPerColumn;
                    ++n2;
                }
                if (n2 == 0) {
                    if (n < this.oeScreenArray.length) {
                        this.selections.setSelectionInterval(this.oeScreenArray[n]);
                    }
                } else {
                    ObjectEntry[] objectEntryArray = this.listModel.peekAtModelRightEntries(this.iEntriesPerColumn * this.iColumnsVisible, this.iEntriesPerColumn * n2);
                    if (objectEntryArray != null && n < objectEntryArray.length) {
                        this.listModel.moveModelRight(this.iEntriesPerColumn * n2);
                        this.populateScreenCache();
                        this.bRecalcMetrics = true;
                        this.contentPanel.invalidate();
                        this.contentPanel.repaint();
                        this.selections.setSelectionInterval(objectEntryArray[n]);
                    }
                }
            } else {
                ObjectEntry objectEntry2 = this.selections.getLeadSelectionObject();
                this.moveToObject(objectEntry2);
                ObjectEntry[] objectEntryArray = this.listModel.peekAtModelRightEntries(this.iEntriesPerColumn + 1, 0);
                if (objectEntryArray != null && objectEntryArray.length != 0) {
                    this.listModel.moveModelRight(objectEntryArray.length);
                    this.selections.setSelectionInterval(objectEntryArray[objectEntryArray.length - 1]);
                    this.ensureObjectIsVisible(objectEntryArray[objectEntryArray.length - 1]);
                }
            }
        }
    }

    public void onLeftArrow() {
        ObjectEntry objectEntry = this.getSelectedObject();
        if (objectEntry != null) {
            ListEntryInfo listEntryInfo = this.calcScreenPositionForObject(objectEntry);
            if (-1 != listEntryInfo.getScreenIndex()) {
                if (!this.isIndexInLeftmostColumn(listEntryInfo.getScreenIndex())) {
                    this.selections.setSelectionInterval(this.oeScreenArray[listEntryInfo.getScreenIndex() - this.iEntriesPerColumn]);
                } else {
                    ObjectEntry[] objectEntryArray = this.listModel.peekAtModelLeftEntries(this.iEntriesPerColumn, 0);
                    if (objectEntryArray == null || objectEntryArray.length == 0) {
                        return;
                    }
                    this.listModel.moveModelLeft(objectEntryArray.length);
                    this.populateScreenCache();
                    this.selections.setSelectionInterval(this.oeScreenArray[listEntryInfo.getScreenIndex()]);
                    this.bRecalcMetrics = true;
                    this.contentPanel.invalidate();
                    this.contentPanel.repaint();
                }
            } else {
                ObjectEntry objectEntry2 = this.selections.getLeadSelectionObject();
                this.moveToObject(objectEntry2);
                ObjectEntry[] objectEntryArray = this.listModel.peekAtModelLeftEntries(this.iEntriesPerColumn, 0);
                if (objectEntryArray != null && objectEntryArray.length != 0) {
                    this.listModel.moveModelLeft(objectEntryArray.length);
                    this.selections.setSelectionInterval(objectEntryArray[0]);
                    this.ensureObjectIsVisible(objectEntryArray[0]);
                }
            }
        }
    }

    public void onShiftUpArrow() {
        ObjectEntry objectEntry = this.getSelectedObject();
        if (objectEntry == null) {
            return;
        }
        ListEntryInfo listEntryInfo = this.calcScreenPositionForObject(objectEntry);
        if (-1 != listEntryInfo.getScreenIndex()) {
            if (1 <= listEntryInfo.getScreenIndex()) {
                this.selections.addSelectionInterval(this.oeScreenArray[listEntryInfo.getScreenIndex() - 1]);
            } else if (listEntryInfo.getScreenIndex() == 0 && !this.bFirstEntryIsOnScreen) {
                this.listModel.moveModelLeft(this.iEntriesPerColumn);
                this.populateScreenCache();
                this.selections.addSelectionInterval(this.oeScreenArray[this.iEntriesPerColumn - 1]);
                this.bRecalcMetrics = true;
                this.contentPanel.invalidate();
                this.contentPanel.repaint();
            }
        } else {
            ObjectEntry objectEntry2 = this.selections.getLeadSelectionObject();
            this.moveToObject(objectEntry2);
            ObjectEntry objectEntry3 = this.listModel.previous();
            if (objectEntry3 != null) {
                this.listModel.next();
                this.selections.addSelectionInterval(objectEntry3);
                this.ensureObjectIsVisible(objectEntry3);
            }
        }
    }

    public void onShiftDownArrow() {
        ListEntryInfo listEntryInfo;
        ObjectEntry objectEntry = this.getSelectedObject();
        if (objectEntry != null && -1 != (listEntryInfo = this.calcScreenPositionForObject(objectEntry)).getScreenIndex()) {
            if (this.oeScreenArray.length - 1 > listEntryInfo.getScreenIndex()) {
                ObjectEntry objectEntry2 = this.oeScreenArray[listEntryInfo.getScreenIndex() + 1];
                if (!this.isIndexWhollyVisible(listEntryInfo.getScreenIndex() + 1) && !this.isIndexInLeftmostColumn(listEntryInfo.getScreenIndex() + 1)) {
                    this.listModel.moveModelRight(this.iEntriesPerColumn);
                    this.contentPanel.invalidate();
                    this.contentPanel.repaint();
                }
                this.selections.addSelectionInterval(objectEntry2);
            } else if (this.oeScreenArray.length - 1 == listEntryInfo.getScreenIndex()) {
                int n;
                ObjectEntry[] objectEntryArray = this.listModel.peekAtModelRightEntries(this.iEntriesPerColumn, this.oeScreenArray.length);
                if (objectEntryArray != null && objectEntryArray.length != 0 && ((n = this.getArrayIndexForObjectEntry(objectEntryArray, objectEntry)) != 0 || objectEntryArray.length != 1)) {
                    this.listModel.moveModelRight(this.iEntriesPerColumn);
                    if (-1 == n) {
                        this.selections.addSelectionInterval(objectEntryArray[0]);
                    } else {
                        this.selections.addSelectionInterval(objectEntryArray[n + 1]);
                    }
                    this.contentPanel.invalidate();
                    this.contentPanel.repaint();
                }
            } else {
                ObjectEntry objectEntry3 = this.selections.getLeadSelectionObject();
                this.moveToObject(objectEntry3);
                ObjectEntry[] objectEntryArray = new ObjectEntry[]{this.listModel.next(), this.listModel.next()};
                if (objectEntryArray[0] != null) {
                    if (objectEntryArray[1] != null) {
                        this.listModel.previous();
                        this.selections.addSelectionInterval(objectEntryArray[1]);
                        this.ensureObjectIsVisible(objectEntryArray[1]);
                    } else {
                        this.selections.addSelectionInterval(objectEntryArray[0]);
                        this.ensureObjectIsVisible(objectEntryArray[0]);
                    }
                }
            }
        }
    }

    public void onHome() {
        Toolkit.getDefaultToolkit().beep();
    }

    public void onEnd() {
        Toolkit.getDefaultToolkit().beep();
    }

    public void onShiftLeftArrow() {
        Toolkit.getDefaultToolkit().beep();
    }

    public void onShiftRightArrow() {
        Toolkit.getDefaultToolkit().beep();
    }

    public void onPageUp() {
        Toolkit.getDefaultToolkit().beep();
    }

    public void onPageDown() {
        Toolkit.getDefaultToolkit().beep();
    }

    public void onShiftPageUp() {
        Toolkit.getDefaultToolkit().beep();
    }

    public void onShiftPageDown() {
        Toolkit.getDefaultToolkit().beep();
    }

    private void calcColumnMetrics() {
        int n = this.contentPanel.getEntryWidth();
        int n2 = this.contentPanel.getEntryHeight();
        this.iEntriesPerColumn = this.contentPanel.getContentUIHeight() / n2;
        if (this.iEntriesPerColumn < 0) {
            this.iEntriesPerColumn = 0;
        }
        this.iColumnsVisible = this.contentPanel.getContentUIWidth() / n;
        if (this.iColumnsVisible < 0) {
            this.iColumnsVisible = 0;
        }
        this.iWholeColumnsVisible = this.iColumnsVisible;
        if (this.iColumnsVisible * n != this.contentPanel.getContentUIWidth()) {
            ++this.iColumnsVisible;
        }
    }

    private void calcScrollBarMetrics() {
        if (this.bFirstEntryIsOnScreen) {
            this.theScrollBar.setAtStartOfList(true);
            this.theScrollBar.setAtEndOfList(false);
        } else if (this.bLastEntryIsOnScreen && this.oeScreenArray.length != 0 && (this.isEntryWhollyVisible(this.oeScreenArray[this.oeScreenArray.length - 1]) || this.isEntryInLeftmostColumn(this.oeScreenArray[this.oeScreenArray.length - 1]))) {
            this.theScrollBar.setAtStartOfList(false);
            this.theScrollBar.setAtEndOfList(true);
        } else {
            this.theScrollBar.setAtStartOfList(false);
            this.theScrollBar.setAtEndOfList(false);
        }
        VList vList = (VList)this.contentPanel.getParent();
        boolean bl = false;
        bl = true == this.bFirstEntryIsOnScreen && true == this.bLastEntryIsOnScreen ? vList.removeScrollBar(this.theScrollBar) : vList.addScrollBar(this.theScrollBar);
        if (bl) {
            this.calcColumnMetrics();
            this.contentPanel.invalidate();
            this.contentPanel.repaint();
        }
    }

    private boolean isLastEntryFullyDisplayed() {
        if (!this.bLastEntryIsOnScreen) {
            return false;
        }
        return this.oeScreenArray.length > this.iWholeColumnsVisible * this.iEntriesPerColumn;
    }

    private boolean moveToObject(ObjectEntry objectEntry) {
        return this.listModel.moveTo(this.contentPanel.getDisplayNameForObject(objectEntry));
    }

    private ListEntryInfo getObjectAtScreenPos(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = this.contentPanel.getEntryWidth();
        int n6 = this.contentPanel.getEntryHeight();
        if (n < this.contentPanel.getContentUITopLeftX() || n2 < this.contentPanel.getContentUITopLeftY() || n2 > this.contentPanel.getContentUITopLeftY() + this.iEntriesPerColumn * n6) {
            BListContentUI bListContentUI = this;
            if (bListContentUI == null) {
                throw null;
            }
            return bListContentUI.new ListEntryInfo(null, 0, 0, 0, 0, -1);
        }
        int n7 = n5 + this.contentPanel.getContentUITopLeftX();
        while (n > n7) {
            n7 += n5;
            ++n3;
        }
        int n8 = n6 + this.contentPanel.getContentUITopLeftY();
        while (n2 > n8) {
            n8 += n6;
            ++n4;
        }
        int n9 = n3 * this.iEntriesPerColumn;
        if ((n9 += n4) >= this.oeScreenArray.length) {
            BListContentUI bListContentUI = this;
            if (bListContentUI == null) {
                throw null;
            }
            return bListContentUI.new ListEntryInfo(null, 0, 0, 0, 0, -1);
        }
        int n10 = n3 * n5 + this.contentPanel.getContentUITopLeftX();
        int n11 = n4 * n6 + this.contentPanel.getContentUITopLeftY();
        BListContentUI bListContentUI = this;
        if (bListContentUI == null) {
            throw null;
        }
        ListEntryInfo listEntryInfo = bListContentUI.new ListEntryInfo(this.oeScreenArray[n9], n10, n11, n5, n6, n9);
        return listEntryInfo;
    }

    private int getArrayIndexForObjectEntry(ObjectEntry[] objectEntryArray, ObjectEntry objectEntry) {
        int n = -1;
        if (objectEntryArray != null) {
            int n2 = 0;
            while (n2 < objectEntryArray.length) {
                if (objectEntry.equals((Object)objectEntryArray[n2])) {
                    n = n2;
                    break;
                }
                ++n2;
            }
        }
        return n;
    }

    private ListEntryInfo calcScreenPositionForObject(ObjectEntry objectEntry) {
        int n = this.contentPanel.getEntryWidth();
        int n2 = this.contentPanel.getEntryHeight();
        int n3 = this.getArrayIndexForObjectEntry(this.oeScreenArray, objectEntry);
        if (n3 == -1) {
            BListContentUI bListContentUI = this;
            if (bListContentUI == null) {
                throw null;
            }
            return bListContentUI.new ListEntryInfo(null, 0, 0, 0, 0, -1);
        }
        int n4 = n3;
        int n5 = n4 / this.iEntriesPerColumn;
        int n6 = n4 - n5 * this.iEntriesPerColumn;
        int n7 = n5 * n + this.contentPanel.getContentUITopLeftX();
        int n8 = n6 * n2 + this.contentPanel.getContentUITopLeftY();
        BListContentUI bListContentUI = this;
        if (bListContentUI == null) {
            throw null;
        }
        return bListContentUI.new ListEntryInfo(objectEntry, n7, n8, n, n2, n3);
    }

    private boolean isEntryInLeftmostColumn(ObjectEntry objectEntry) {
        ListEntryInfo listEntryInfo = this.calcScreenPositionForObject(objectEntry);
        if (-1 != listEntryInfo.getScreenIndex()) {
            return this.isIndexInLeftmostColumn(listEntryInfo.getScreenIndex());
        }
        return false;
    }

    private boolean isEntryInRightmostColumn(ObjectEntry objectEntry) {
        ListEntryInfo listEntryInfo = this.calcScreenPositionForObject(objectEntry);
        if (-1 != listEntryInfo.getScreenIndex()) {
            return this.isIndexInRightmostColumn(listEntryInfo.getScreenIndex());
        }
        return false;
    }

    private boolean isEntryInLeftmostColumn(ListEntryInfo listEntryInfo) {
        return this.isIndexInLeftmostColumn(listEntryInfo.getScreenIndex());
    }

    private boolean isEntryInRightmostColumn(ListEntryInfo listEntryInfo) {
        return this.isIndexInRightmostColumn(listEntryInfo.getScreenIndex());
    }

    private boolean isIndexInLeftmostColumn(int n) {
        return n < this.iEntriesPerColumn;
    }

    private boolean isIndexInRightmostColumn(int n) {
        if (this.iColumnsVisible == 0) {
            return false;
        }
        return n >= (this.iColumnsVisible - 1) * this.iEntriesPerColumn;
    }

    private boolean isEntryWhollyVisible(ObjectEntry objectEntry) {
        ListEntryInfo listEntryInfo = this.calcScreenPositionForObject(objectEntry);
        if (-1 != listEntryInfo.getScreenIndex()) {
            return this.isEntryWhollyVisible(listEntryInfo);
        }
        return false;
    }

    private boolean isEntryWhollyVisible(ListEntryInfo listEntryInfo) {
        return this.isIndexWhollyVisible(listEntryInfo.getScreenIndex());
    }

    private boolean isIndexWhollyVisible(int n) {
        return n < this.iEntriesPerColumn * this.iWholeColumnsVisible;
    }

    private void setInitialEntryHeight() {
        ObjectEntry[] objectEntryArray = new ObjectEntry[5];
        int n = 0;
        while (n < 5) {
            objectEntryArray[n] = this.listModel.next();
            if (objectEntryArray[n] == null) {
                ObjectEntry[] objectEntryArray2 = new ObjectEntry[n];
                int n2 = 0;
                while (n2 < n) {
                    objectEntryArray2[n2] = objectEntryArray[n2];
                    ++n2;
                }
                objectEntryArray = objectEntryArray2;
                break;
            }
            ++n;
        }
        n = 0;
        while (n < objectEntryArray.length) {
            this.listModel.previous();
            ++n;
        }
        this.contentPanel.setEntryHeightFromEntries(objectEntryArray);
        this.contentPanel.setEntryWidthFromEntries(objectEntryArray);
    }

    private void setModelBlockSize() {
        this.listModel.setBlockSize(this.iColumnsVisible * this.iEntriesPerColumn + 2);
    }

    public void onComponentResized(ComponentEvent componentEvent) {
        this.contentPanel.setBusy(true);
        this.calcColumnMetrics();
        this.setModelBlockSize();
        this.lLastActivityIndicator = this.listModel.setActivityIndicatorDifferent();
        this.populateScreenCache();
        if (this.bFirstEntryIsOnScreen && this.bLastEntryIsOnScreen) {
            this.listModel.moveFirst();
        }
        this.calcScrollBarMetrics();
        this.contentPanel.invalidate();
        this.contentPanel.repaint();
        this.contentPanel.setBusy(false);
    }

    public void onFocusGained(FocusEvent focusEvent) {
        this.repaintCellFocus();
    }

    public void onFocusLost(FocusEvent focusEvent) {
        this.repaintCellFocus();
    }

    protected void repaintCellFocus() {
        if (this.oeScreenArray != null && this.oeScreenArray.length != 0) {
            int n = 0;
            while (n < this.oeScreenArray.length) {
                Rectangle rectangle;
                ListEntryInfo listEntryInfo;
                if (this.oeScreenArray[n] != null && this.selections.isSelectedObject(this.oeScreenArray[n]) && -1 != (listEntryInfo = this.calcScreenPositionForObject(this.oeScreenArray[n])).getScreenIndex() && (rectangle = listEntryInfo.getRectangle()) != null) {
                    this.quickPaint(rectangle);
                }
                ++n;
            }
        }
    }

    public void onMousePressed(MouseEvent mouseEvent) {
        if (this.contentPanel.isCellWidthAdjustmentActive()) {
            return;
        }
        ListEntryInfo listEntryInfo = this.getObjectAtScreenPos(mouseEvent.getX(), mouseEvent.getY());
        ObjectEntry objectEntry = listEntryInfo.getObjectEntry();
        if (objectEntry == null) {
            return;
        }
        ObjectEntry objectEntry2 = this.selections.getAnchorSelectionObject();
        if ((mouseEvent.getModifiers() & 4) == 0 || !this.selections.isSelectedObject(objectEntry)) {
            if (mouseEvent.isControlDown()) {
                if (this.selections.isSelectedObject(objectEntry)) {
                    this.selections.removeSelectionInterval(objectEntry);
                } else {
                    this.selections.addSelectionInterval(objectEntry);
                }
            } else if (mouseEvent.isShiftDown() && objectEntry2 != null) {
                ListEntryInfo listEntryInfo2 = this.calcScreenPositionForObject(objectEntry2);
                int n = listEntryInfo2.getScreenIndex();
                int n2 = listEntryInfo.getScreenIndex();
                if (-1 != n && -1 != n2) {
                    if (n > n2) {
                        int n3 = n;
                        n = n2;
                        n2 = n3;
                    }
                    ObjectEntry[] objectEntryArray = new ObjectEntry[n2 - n + 1];
                    int n4 = 0;
                    while (n4 < n2 - n + 1) {
                        objectEntryArray[n4] = this.oeScreenArray[n + n4];
                        ++n4;
                    }
                    this.selections.addSelectionInterval(objectEntryArray);
                }
            } else {
                this.selections.setSelectionInterval(objectEntry);
            }
        }
    }

    public void onMouseReleased(MouseEvent mouseEvent) {
    }

    public void onMouseDragged(MouseEvent mouseEvent) {
    }

    public void onMouseMoved(MouseEvent mouseEvent) {
    }

    public void adjustmentMade(BListAdjustmentEvent bListAdjustmentEvent) {
        this.contentPanel.setBusy(true);
        if (1 == bListAdjustmentEvent.getType()) {
            this.listModel.moveFirst();
        } else if (2 == bListAdjustmentEvent.getType()) {
            this.listModel.moveLast();
            int n = this.iWholeColumnsVisible * this.iEntriesPerColumn;
            if (n == 0) {
                n = this.iEntriesPerColumn;
            }
            if (n >= 1) {
                --n;
            }
            this.listModel.moveModelLeft(n);
        } else if (3 == bListAdjustmentEvent.getType()) {
            this.listModel.moveModelRight(this.iEntriesPerColumn);
        } else if (4 == bListAdjustmentEvent.getType()) {
            this.listModel.moveModelLeft(this.iEntriesPerColumn);
        }
        this.populateScreenCache();
        this.calcScrollBarMetrics();
        this.contentPanel.invalidate();
        this.contentPanel.repaint();
        this.contentPanel.setBusy(false);
    }

    public BListContentUI() {
        this.theScrollBar.addBListAdjustmentListener(this);
        BListContentUI bListContentUI = this;
        if (bListContentUI == null) {
            throw null;
        }
        this.selections.addListSelectionListener(bListContentUI.new SelectionListener());
    }

    public class ListEntryInfo {
        public Rectangle rect;
        public ObjectEntry obj;
        public int iScreenIndex;

        Rectangle getRectangle() {
            return this.rect;
        }

        ObjectEntry getObjectEntry() {
            return this.obj;
        }

        int getScreenIndex() {
            return this.iScreenIndex;
        }

        public ListEntryInfo(ObjectEntry objectEntry, int n, int n2, int n3, int n4, int n5) {
            this.rect = new Rectangle(n, n2, n3, n4);
            this.obj = objectEntry;
            this.iScreenIndex = n5;
        }
    }

    public class SelectionListener
    implements ListSelectionListener,
    Serializable {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent instanceof SListSelectionEvent) {
                SListSelectionEvent sListSelectionEvent = (SListSelectionEvent)listSelectionEvent;
                ObjectEntry[] objectEntryArray = sListSelectionEvent.getChangedObjects();
                int n = 0;
                while (n < objectEntryArray.length) {
                    ListEntryInfo listEntryInfo = BListContentUI.this.calcScreenPositionForObject(objectEntryArray[n]);
                    ObjectEntry objectEntry = listEntryInfo.getObjectEntry();
                    if (objectEntry != null) {
                        Rectangle rectangle = listEntryInfo.getRectangle();
                        BListContentUI.this.quickPaint(rectangle);
                    }
                    ++n;
                }
            }
        }
    }
}

