/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.util.vlist;

import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.util.vlist.SListSelectionEvent;
import com.novell.application.console.util.vlist.VList;
import com.objectspace.jgl.Array;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DefaultSListSelectionModel {
    Array m_selectedEntries = new Array();
    ObjectEntry m_anchor = null;
    ObjectEntry m_lead = null;
    EventListenerList m_listenerList = new EventListenerList();
    int m_selectionMode = 2;
    boolean selectionIsAdjusting = false;
    private static /* synthetic */ Class class$Ljavax$swing$event$ListSelectionListener;

    public boolean getValueIsAdjusting() {
        return this.selectionIsAdjusting;
    }

    public void setValueIsAdjusting(boolean bl) {
        if (bl != this.selectionIsAdjusting) {
            this.selectionIsAdjusting = bl;
            if (!this.selectionIsAdjusting) {
                this.postExternalSelectionChangedEvent();
            }
        }
    }

    public void postExternalSelectionChangedEvent() {
        SListSelectionEvent sListSelectionEvent = new SListSelectionEvent(this, null, this.selectionIsAdjusting);
        if (this.m_listenerList.getListenerCount() != 0) {
            Object[] objectArray = this.m_listenerList.getListenerList();
            int n = objectArray.length - 2;
            while (n >= 0) {
                if (objectArray[n] == (class$Ljavax$swing$event$ListSelectionListener != null ? class$Ljavax$swing$event$ListSelectionListener : DefaultSListSelectionModel.class$("javax.swing.event.ListSelectionListener")) && objectArray[n + 1] instanceof VList) {
                    ((ListSelectionListener)objectArray[n + 1]).valueChanged(sListSelectionEvent);
                }
                n -= 2;
            }
        }
    }

    public void setSelectionMode(int n) {
        if (n == 2 || n == 1 || n == 0) {
            if (n == 1) {
                n = 2;
            }
            this.m_selectionMode = n;
        }
    }

    public int getSelectionMode() {
        return this.m_selectionMode;
    }

    void setSelectionInterval(ObjectEntry objectEntry) {
        ObjectEntry[] objectEntryArray = new ObjectEntry[]{objectEntry};
        this.setSelectionInterval(objectEntryArray);
    }

    void setSelectionInterval(ObjectEntry[] objectEntryArray) {
        ObjectEntry[] objectEntryArray2;
        if (objectEntryArray.length == 0) {
            this.clearSelection();
            return;
        }
        if (this.m_selectionMode == 0 && objectEntryArray.length > 1) {
            objectEntryArray2 = new ObjectEntry[]{objectEntryArray[0]};
            objectEntryArray = objectEntryArray2;
        }
        objectEntryArray2 = new ObjectEntry[objectEntryArray.length + this.m_selectedEntries.size()];
        int n = 0;
        while (n < objectEntryArray.length) {
            objectEntryArray2[n] = objectEntryArray[n];
            ++n;
        }
        n = 0;
        while (n < this.m_selectedEntries.size()) {
            objectEntryArray2[n + objectEntryArray.length] = (ObjectEntry)this.m_selectedEntries.at(n);
            ++n;
        }
        this.m_selectedEntries = new Array();
        this.m_anchor = objectEntryArray[0];
        this.m_lead = objectEntryArray[objectEntryArray.length - 1];
        n = 0;
        while (n < objectEntryArray.length) {
            if (!this.isSelectedObject(objectEntryArray[n])) {
                this.m_selectedEntries.add((Object)objectEntryArray[n]);
            }
            ++n;
        }
        SListSelectionEvent sListSelectionEvent = new SListSelectionEvent(this, objectEntryArray2, this.selectionIsAdjusting);
        this.broadcastListSelectionEvent(sListSelectionEvent);
    }

    void addSelectionInterval(ObjectEntry objectEntry) {
        ObjectEntry[] objectEntryArray = new ObjectEntry[]{objectEntry};
        this.addSelectionInterval(objectEntryArray);
    }

    void addSelectionInterval(ObjectEntry[] objectEntryArray) {
        if (objectEntryArray.length == 0) {
            return;
        }
        if (this.m_selectionMode == 0) {
            this.setSelectionInterval(objectEntryArray[0]);
            return;
        }
        ObjectEntry objectEntry = this.m_anchor;
        ObjectEntry objectEntry2 = this.m_lead;
        this.m_anchor = objectEntryArray[0];
        this.m_lead = objectEntryArray[objectEntryArray.length - 1];
        int n = 0;
        while (n < objectEntryArray.length) {
            if (!this.isSelectedObject(objectEntryArray[n])) {
                this.m_selectedEntries.add((Object)objectEntryArray[n]);
            }
            ++n;
        }
        n = objectEntryArray.length;
        if (objectEntry != null) {
            ++n;
        }
        if (objectEntry2 != null) {
            ++n;
        }
        ObjectEntry[] objectEntryArray2 = new ObjectEntry[n];
        int n2 = 0;
        while (n2 < objectEntryArray.length) {
            objectEntryArray2[n2] = objectEntryArray[n2];
            ++n2;
        }
        n2 = objectEntryArray.length;
        if (objectEntry != null) {
            objectEntryArray2[n2++] = objectEntry;
        }
        if (objectEntry2 != null) {
            objectEntryArray2[n2] = objectEntry2;
        }
        SListSelectionEvent sListSelectionEvent = new SListSelectionEvent(this, objectEntryArray2, this.selectionIsAdjusting);
        this.broadcastListSelectionEvent(sListSelectionEvent);
    }

    void removeSelectionInterval(ObjectEntry objectEntry) {
        ObjectEntry[] objectEntryArray = new ObjectEntry[]{objectEntry};
        this.removeSelectionInterval(objectEntryArray);
    }

    void removeSelectionInterval(ObjectEntry[] objectEntryArray) {
        if (objectEntryArray.length == 0 || this.m_selectedEntries.size() == 0) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        ObjectEntry objectEntry = this.m_anchor;
        ObjectEntry objectEntry2 = this.m_lead;
        int n = 0;
        while (n < objectEntryArray.length) {
            if (this.m_anchor.equals((Object)objectEntryArray[n])) {
                this.m_anchor = this.resolveAnchorOrLeadObject(this.m_anchor);
                bl = true;
            }
            if (this.m_lead.equals((Object)objectEntryArray[n])) {
                this.m_lead = this.resolveAnchorOrLeadObject(this.m_lead);
                bl2 = true;
            }
            this.m_selectedEntries.remove((Object)objectEntryArray[n]);
            ++n;
        }
        n = objectEntryArray.length;
        if (bl) {
            ++n;
        }
        if (bl2) {
            ++n;
        }
        ObjectEntry[] objectEntryArray2 = new ObjectEntry[n];
        int n2 = 0;
        while (n2 < objectEntryArray.length) {
            objectEntryArray2[n2] = objectEntryArray[n2];
            ++n2;
        }
        n2 = objectEntryArray.length;
        if (bl) {
            objectEntryArray2[n2++] = objectEntry;
        }
        if (bl2) {
            objectEntryArray2[n2] = objectEntry2;
        }
        SListSelectionEvent sListSelectionEvent = new SListSelectionEvent(this, objectEntryArray2, this.selectionIsAdjusting);
        this.broadcastListSelectionEvent(sListSelectionEvent);
    }

    boolean isSelectedObject(ObjectEntry objectEntry) {
        boolean bl = false;
        if (-1 != this.findObject(objectEntry)) {
            bl = true;
        }
        return bl;
    }

    ObjectEntry[] getSelectedObjects() {
        ObjectEntry[] objectEntryArray = new ObjectEntry[this.m_selectedEntries.size()];
        int n = 0;
        while (n < this.m_selectedEntries.size()) {
            objectEntryArray[n] = (ObjectEntry)this.m_selectedEntries.at(n);
            ++n;
        }
        return objectEntryArray;
    }

    ObjectEntry getAnchorSelectionObject() {
        return this.m_anchor;
    }

    ObjectEntry getLeadSelectionObject() {
        return this.m_lead;
    }

    void clearSelection() {
        ObjectEntry[] objectEntryArray = new ObjectEntry[this.m_selectedEntries.size()];
        int n = 0;
        while (n < this.m_selectedEntries.size()) {
            objectEntryArray[n] = (ObjectEntry)this.m_selectedEntries.at(n);
            ++n;
        }
        this.m_selectedEntries = new Array();
        this.m_anchor = null;
        this.m_lead = null;
        SListSelectionEvent sListSelectionEvent = new SListSelectionEvent(this, objectEntryArray, this.selectionIsAdjusting);
        this.broadcastListSelectionEvent(sListSelectionEvent);
    }

    boolean isSelectionEmpty() {
        return this.m_selectedEntries.size() == 0;
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.m_listenerList.add(class$Ljavax$swing$event$ListSelectionListener != null ? class$Ljavax$swing$event$ListSelectionListener : (class$Ljavax$swing$event$ListSelectionListener = DefaultSListSelectionModel.class$("javax.swing.event.ListSelectionListener")), listSelectionListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.m_listenerList.remove(class$Ljavax$swing$event$ListSelectionListener != null ? class$Ljavax$swing$event$ListSelectionListener : (class$Ljavax$swing$event$ListSelectionListener = DefaultSListSelectionModel.class$("javax.swing.event.ListSelectionListener")), listSelectionListener);
    }

    private void broadcastListSelectionEvent(ListSelectionEvent listSelectionEvent) {
        if (this.m_listenerList.getListenerCount() != 0) {
            Object[] objectArray = this.m_listenerList.getListenerList();
            int n = objectArray.length - 2;
            while (n >= 0) {
                if (objectArray[n] == (class$Ljavax$swing$event$ListSelectionListener != null ? class$Ljavax$swing$event$ListSelectionListener : DefaultSListSelectionModel.class$("javax.swing.event.ListSelectionListener"))) {
                    ((ListSelectionListener)objectArray[n + 1]).valueChanged(listSelectionEvent);
                }
                n -= 2;
            }
        }
    }

    private int findObject(ObjectEntry objectEntry) {
        int n = -1;
        int n2 = this.m_selectedEntries.size();
        int n3 = 0;
        while (n3 < n2) {
            ObjectEntry objectEntry2 = (ObjectEntry)this.m_selectedEntries.at(n3);
            if (objectEntry.equals((Object)objectEntry2)) {
                n = n3;
                break;
            }
            ++n3;
        }
        return n;
    }

    private ObjectEntry resolveAnchorOrLeadObject(ObjectEntry objectEntry) {
        ObjectEntry objectEntry2 = null;
        int n = this.findObject(objectEntry);
        if (-1 != n) {
            if (n != 0) {
                objectEntry2 = (ObjectEntry)this.m_selectedEntries.at(n - 1);
            } else if (n + 1 < this.m_selectedEntries.size()) {
                objectEntry2 = (ObjectEntry)this.m_selectedEntries.at(n + 1);
            }
        } else if (this.m_selectedEntries.size() != 0) {
            objectEntry2 = (ObjectEntry)this.m_selectedEntries.at(0);
        }
        return objectEntry2;
    }

    private void debugShowSelectionCount() {
        System.out.println("Selection Count: " + this.m_selectedEntries.size());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

