/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.util.vlist;

import com.novell.application.console.snapin.DefaultObjectEntryCollection;
import com.novell.application.console.snapin.NConeFactory;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryChangeEvent;
import com.novell.application.console.snapin.ObjectEntryCollection;
import com.novell.application.console.snapin.ObjectEntryEnumeration;
import com.novell.application.console.util.vlist.CachedObjectEntry;
import com.novell.application.console.util.vlist.IListDataModel;
import com.novell.application.console.util.vlist.SelectionInfo;
import com.novell.application.console.util.vlist.VList;
import com.novell.application.console.util.vlist.VListContentPanel;
import com.novell.application.console.util.vlist.VListContentUI;
import com.objectspace.jgl.Array;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.BoundedRangeModel;
import javax.swing.CellRendererPane;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JScrollBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class IListContentUI
implements VListContentUI,
AdjustmentListener {
    private VListContentPanel contentPanel = null;
    private IListDataModel listModel = null;
    private DefaultListSelectionModel selections = new DefaultListSelectionModel();
    private int iTotalCount = 0;
    private int iTopLeftIndex = 0;
    private JScrollBar theScrollBar = NConeFactory.novellJScrollBar(new JScrollBar(0), "", "");
    private int currentAdjustmentValue = 0;
    private int iEntriesPerColumn;
    private int iColumnsVisible;
    private int iWholeColumnsVisible;
    private int iTotalColumns;
    private boolean bRecalcMetrics = false;
    private boolean bIgnoreAdjustments = false;
    private CellRendererPane rendererPane = new CellRendererPane();
    private Array m_externalListSelectionListeners = new Array();
    private ListSelectionEvent m_lastInternalListSelectionEvent = null;
    private boolean bMouseSelActive;
    private int iMouseSelLastX;
    private int iMouseSelLastY;
    private int iMouseSelCurrentX;
    private int iMouseSelCurrentY;
    private int iMouseSelAnchorX;
    private int iMouseSelAnchorY;
    private int iAnchorColTopIndex;
    private int iAnchorColBottomIndex;
    private int iAnchorRowIndex;
    private int iAnchorIndex;
    private int iLastMouseSelStartIndex;
    private int iLastMouseSelEndIndex;
    private int iLastMouseSelStartRowIndex;
    private int iLastMouseSelEndRowIndex;
    private int iCacheTopLeftIndex = -1;
    private CachedObjectEntry[] arScreenCache;

    public void cleanUp() {
        if (this.contentPanel != null) {
            VList vList = (VList)this.contentPanel.getParent();
            vList.removeScrollBar(this.theScrollBar);
        }
    }

    public void setComponent(VListContentPanel vListContentPanel) {
        this.contentPanel = vListContentPanel;
    }

    public void setModel(ObjectEntryEnumeration objectEntryEnumeration) {
        this.listModel = new IListDataModel(objectEntryEnumeration, this.contentPanel.getShell());
        ObjectEntry[] objectEntryArray = this.contentPanel.getGlobalEntries();
        if (objectEntryArray != null) {
            this.listModel.setGlobalEntries(objectEntryArray);
        }
        this.iTopLeftIndex = this.listModel.moveFirst();
        this.iTotalCount = this.listModel.getCount();
        this.clearSelection();
        this.iCacheTopLeftIndex = -1;
        this.bRecalcMetrics = true;
        this.setInitialEntryHeight();
        this.contentPanel.invalidate();
        this.contentPanel.paintImmediately(0, 0, this.contentPanel.getWidth(), this.contentPanel.getHeight());
    }

    public boolean isModelEmpty() {
        if (this.listModel == null || this.iTotalCount == 0) {
            return true;
        }
        ObjectEntry[] objectEntryArray = this.listModel.getNext(1);
        if (objectEntryArray != null && objectEntryArray.length != 0 && objectEntryArray[0] != null) {
            this.listModel.getPrev(1);
            return false;
        }
        ObjectEntry[] objectEntryArray2 = this.listModel.getPrev(1);
        if (objectEntryArray2 != null && objectEntryArray2.length != 0 && objectEntryArray2[0] != null) {
            this.listModel.getNext(1);
            return false;
        }
        return true;
    }

    public int getCount() {
        int n = -1;
        if (this.listModel != null) {
            n = this.listModel.getCount();
        }
        return n;
    }

    public void setGlobalEntries(ObjectEntry[] objectEntryArray) {
        this.listModel.setGlobalEntries(objectEntryArray);
        this.iTotalCount = this.listModel.getCount();
        this.clearSelection();
        this.iCacheTopLeftIndex = -1;
        this.bRecalcMetrics = true;
        this.contentPanel.invalidate();
        this.contentPanel.paintImmediately(0, 0, this.contentPanel.getWidth(), this.contentPanel.getHeight());
    }

    public ObjectEntry locationToObject(Point point) {
        ListEntryInfo listEntryInfo = this.calcObjectIndexFromPos(point.x, point.y);
        if (-1 == listEntryInfo.getIndex()) {
            return null;
        }
        this.listModel.moveTo(listEntryInfo.getIndex());
        ObjectEntry[] objectEntryArray = this.listModel.getNext(1);
        this.listModel.moveTo(this.iTopLeftIndex);
        if (objectEntryArray == null || objectEntryArray.length == 0) {
            return null;
        }
        return objectEntryArray[0];
    }

    public void setSelectionMode(int n) {
        this.selections.setSelectionMode(n);
    }

    public int getSelectionMode() {
        return this.selections.getSelectionMode();
    }

    public synchronized void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.m_externalListSelectionListeners.add((Object)listSelectionListener);
        this.selections.addListSelectionListener(listSelectionListener);
    }

    public synchronized void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.m_externalListSelectionListeners.remove((Object)listSelectionListener);
        this.selections.removeListSelectionListener(listSelectionListener);
    }

    public ObjectEntry getSelectedObject() {
        int n = this.selections.getMinSelectionIndex();
        if (-1 == n) {
            return null;
        }
        if (n != this.listModel.moveTo(n)) {
            return null;
        }
        ObjectEntry[] objectEntryArray = this.listModel.getNext(1);
        if (objectEntryArray.length != 0 && objectEntryArray[0] != null) {
            return objectEntryArray[0];
        }
        return null;
    }

    public void setSelectedObjects(ObjectEntryCollection objectEntryCollection) {
        if (objectEntryCollection == null || objectEntryCollection.hasNoElements()) {
            this.clearSelection();
            return;
        }
        boolean bl = true;
        ObjectEntryEnumeration objectEntryEnumeration = objectEntryCollection.elements();
        this.selections.setValueIsAdjusting(true);
        while (objectEntryEnumeration.hasMoreElements()) {
            ObjectEntry objectEntry = objectEntryEnumeration.next();
            int n = this.calcEntryIndex(objectEntry);
            if (-1 == n) continue;
            if (bl) {
                this.selections.setSelectionInterval(n, n);
                bl = false;
                continue;
            }
            this.selections.addSelectionInterval(n, n);
        }
        this.selections.setValueIsAdjusting(false);
    }

    public void addSelectedObjects(ObjectEntryCollection objectEntryCollection) {
        ObjectEntryEnumeration objectEntryEnumeration = objectEntryCollection.elements();
        this.selections.setValueIsAdjusting(true);
        while (objectEntryEnumeration.hasMoreElements()) {
            ObjectEntry objectEntry = objectEntryEnumeration.next();
            int n = this.calcEntryIndex(objectEntry);
            if (-1 == n) continue;
            this.selections.addSelectionInterval(n, n);
        }
        this.selections.setValueIsAdjusting(false);
    }

    public SelectionInfo getSelectionInfoBeforeRefresh() {
        ObjectEntry[] objectEntryArray;
        ObjectEntryCollection objectEntryCollection = this.getSelectedObjects();
        DefaultListSelectionModel defaultListSelectionModel = this.selections;
        int n = defaultListSelectionModel.getMinSelectionIndex();
        int n2 = defaultListSelectionModel.getMaxSelectionIndex();
        int n3 = 0;
        ObjectEntry objectEntry = null;
        if (n2 >= 0 && (n3 = n2 + 1) < this.getCount()) {
            objectEntryArray = null;
            if (n3 == this.listModel.moveTo(n3) && (objectEntryArray = this.listModel.getNext(1)).length > 0) {
                objectEntry = objectEntryArray[0];
            }
        }
        if (objectEntry == null && n >= 0) {
            n3 = n - 1;
            objectEntryArray = null;
            if (n3 == this.listModel.moveTo(n3) && (objectEntryArray = this.listModel.getNext(1)).length > 0) {
                objectEntry = objectEntryArray[0];
            }
        }
        objectEntryArray = new SelectionInfo(objectEntryCollection, objectEntry);
        return objectEntryArray;
    }

    public boolean setSelectedObjectsAfterRefresh(SelectionInfo selectionInfo) {
        int n;
        ObjectEntry objectEntry;
        ObjectEntryCollection objectEntryCollection = selectionInfo.getSelectedObjects();
        if (objectEntryCollection == null || objectEntryCollection.hasNoElements()) {
            this.clearSelection();
            return true;
        }
        boolean bl = false;
        boolean bl2 = true;
        ObjectEntryEnumeration objectEntryEnumeration = objectEntryCollection.elements();
        this.selections.setValueIsAdjusting(true);
        while (objectEntryEnumeration.hasMoreElements()) {
            objectEntry = objectEntryEnumeration.next();
            n = this.calcEntryIndex(objectEntry);
            if (-1 == n) continue;
            if (bl2) {
                this.selections.setSelectionInterval(n, n);
                bl2 = false;
                bl = true;
                continue;
            }
            this.selections.addSelectionInterval(n, n);
        }
        objectEntry = selectionInfo.getExtraOe();
        if (!bl && objectEntry != null && -1 != (n = this.calcEntryIndex(objectEntry)) && bl2) {
            this.selections.setSelectionInterval(n, n);
            bl = true;
        }
        this.selections.setValueIsAdjusting(false);
        return bl;
    }

    public void clearSelection() {
        this.selections.clearSelection();
    }

    public void selectAll() {
        int n = this.listModel.getCount();
        if (n != 0) {
            this.selections.setSelectionInterval(0, n - 1);
        }
    }

    public void ensureObjectIsVisible(ObjectEntry objectEntry) {
        int n = this.calcEntryIndex(objectEntry);
        if (-1 != n) {
            this.ensureIndexIsVisible(n);
        }
    }

    private int getSelectedIndex() {
        return this.selections.getLeadSelectionIndex();
    }

    public ObjectEntryCollection getSelectedObjects() {
        DefaultListSelectionModel defaultListSelectionModel = this.selections;
        int n = defaultListSelectionModel.getMinSelectionIndex();
        int n2 = defaultListSelectionModel.getMaxSelectionIndex();
        if (n < 0 || n2 < 0) {
            return new DefaultObjectEntryCollection(new ObjectEntry[0]);
        }
        ObjectEntry[] objectEntryArray = new ObjectEntry[1 + (n2 - n)];
        int n3 = 0;
        ObjectEntry[] objectEntryArray2 = null;
        int n4 = n;
        while (n4 <= n2) {
            if (defaultListSelectionModel.isSelectedIndex(n4) && n4 == this.listModel.moveTo(n4) && (objectEntryArray2 = this.listModel.getNext(1)).length != 0) {
                objectEntryArray[n3++] = objectEntryArray2[0];
            }
            ++n4;
        }
        ObjectEntry[] objectEntryArray3 = new ObjectEntry[n3];
        System.arraycopy(objectEntryArray, 0, objectEntryArray3, 0, n3);
        return new DefaultObjectEntryCollection(objectEntryArray3);
    }

    public void setSelectedIndex(int n) {
        this.selections.setSelectionInterval(n, n);
    }

    public void moveTo(int n) {
        int n2 = n == 0 ? this.listModel.moveFirst() : (1000 == n ? this.listModel.moveLast() : this.listModel.moveTo(this.iTotalCount * n / 1000));
        this.setSelectedIndex(n2);
        this.ensureIndexIsVisible(n2);
    }

    public void moveTo(String string) {
        int n = this.listModel.moveTo(string);
        this.setSelectedIndex(n);
        this.ensureIndexIsVisible(n);
    }

    public void entryMetricsChanged() {
        this.iCacheTopLeftIndex = -1;
        this.bRecalcMetrics = true;
        this.contentPanel.invalidate();
        this.contentPanel.paintImmediately(0, 0, this.contentPanel.getWidth(), this.contentPanel.getHeight());
    }

    public void quickPaint(Rectangle rectangle) {
        Graphics graphics = this.contentPanel.getGraphics();
        if (graphics != null) {
            this.contentPanel.invalidate();
            this.contentPanel.paintImmediately(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void paintContent(Graphics graphics) {
        int n;
        if (this.contentPanel.getContentUIHeight() == 0 || this.contentPanel.getContentUIWidth() == 0 || this.contentPanel.getCellRenderer() == null) {
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        if (this.bRecalcMetrics) {
            this.calcColumnMetrics();
            this.calcScrollBarMetrics();
            this.setModelBlockSize();
            this.bRecalcMetrics = false;
        }
        if (this.iCacheTopLeftIndex != this.iTopLeftIndex) {
            this.listModel.moveTo(this.iTopLeftIndex);
            ObjectEntry[] objectEntryArray = this.listModel.getNext(this.iColumnsVisible * this.iEntriesPerColumn);
            this.arScreenCache = new CachedObjectEntry[objectEntryArray.length];
            n = 0;
            while (n < objectEntryArray.length) {
                if (objectEntryArray[n] != null) {
                    this.arScreenCache[n] = new CachedObjectEntry(objectEntryArray[n]);
                }
                ++n;
            }
            this.iCacheTopLeftIndex = this.iTopLeftIndex;
        }
        int n2 = 0;
        n = this.contentPanel.getContentUITopLeftX();
        int n3 = this.contentPanel.getContentUITopLeftY();
        int n4 = this.iTopLeftIndex;
        int n5 = this.contentPanel.getEntryWidth();
        int n6 = this.contentPanel.getEntryHeight();
        int n7 = 0;
        while (n7 < this.iColumnsVisible) {
            int n8 = 0;
            while (n8 < this.iEntriesPerColumn) {
                Rectangle rectangle2 = new Rectangle(n, n3, n5, n6);
                if (this.arScreenCache.length > n2 && this.arScreenCache[n2] != null) {
                    if (rectangle2.intersects(rectangle)) {
                        if (!this.arScreenCache[n2].isComplete()) {
                            this.arScreenCache[n2].complete(this.contentPanel);
                        }
                        this.paintCell(graphics, n4, rectangle2, this.arScreenCache[n2]);
                    }
                } else {
                    graphics.setColor(this.contentPanel.getBackground());
                    graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                }
                n3 += n6;
                ++n2;
                ++n4;
                ++n8;
            }
            n += n5;
            n3 = this.contentPanel.getContentUITopLeftY();
            ++n7;
        }
        n3 = n6 * this.iEntriesPerColumn;
        if (n3 < this.contentPanel.getContentUIHeight()) {
            graphics.setColor(this.contentPanel.getBackground());
            graphics.fillRect(this.contentPanel.getContentUITopLeftX(), n3 + this.contentPanel.getContentUITopLeftY(), this.contentPanel.getContentUIWidth(), this.contentPanel.getContentUIHeight() - n3);
        }
    }

    protected void paintCell(Graphics graphics, int n, Rectangle rectangle, CachedObjectEntry cachedObjectEntry) {
        boolean bl;
        boolean bl2 = false;
        boolean bl3 = this.contentPanel.doesListHaveFocus();
        if (bl3) {
            boolean bl4 = bl = n == this.selections.getLeadSelectionIndex();
            if (bl) {
                bl2 = this.selections.isSelectedIndex(this.selections.getLeadSelectionIndex());
            }
        } else {
            bl2 = this.selections.isSelectedIndex(n);
        }
        bl = this.contentPanel.getDisplaySelectionOnlyIfFocus() ? bl3 && this.selections.isSelectedIndex(n) : this.selections.isSelectedIndex(n);
        String string = cachedObjectEntry.getDisplayName();
        Icon icon = cachedObjectEntry.getIcon();
        Component component = this.contentPanel.getCellRenderer().getVListCellRendererComponent(cachedObjectEntry.getObjectEntry(), n, bl, bl2, string, icon);
        this.rendererPane.paintComponent(graphics, component, null, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
    }

    private void setModelBlockSize() {
        this.listModel.setBlockSize(3 * (this.iColumnsVisible * this.iEntriesPerColumn));
    }

    public void onHome() {
        this.moveTo(0);
    }

    public void onEnd() {
        this.moveTo(1000);
    }

    public void onUpArrow() {
        int n = this.getSelectedIndex();
        if (n > 0) {
            this.setSelectedIndex(--n);
            this.ensureIndexIsVisible(n);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void onDownArrow() {
        int n = this.getSelectedIndex();
        if (n + 1 < this.listModel.getCount()) {
            this.setSelectedIndex(++n);
            this.ensureIndexIsVisible(n);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void onLeftArrow() {
        int n = this.getSelectedIndex();
        if (n - this.iEntriesPerColumn >= 0) {
            this.setSelectedIndex(n -= this.iEntriesPerColumn);
            this.ensureIndexIsVisible(n);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void onRightArrow() {
        int n = this.getSelectedIndex();
        if (n + this.iEntriesPerColumn < this.listModel.getCount()) {
            this.setSelectedIndex(n += this.iEntriesPerColumn);
            this.ensureIndexIsVisible(n);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void onShiftUpArrow() {
        int n = this.selections.getLeadSelectionIndex();
        if (n > 0) {
            ListEntryInfo listEntryInfo;
            this.selections.setLeadSelectionIndex(--n);
            this.ensureIndexIsVisible(n);
            ListEntryInfo listEntryInfo2 = this.calcObjectPosFromIndex(n + 1);
            if (-1 != listEntryInfo2.getIndex()) {
                this.quickPaint(listEntryInfo2.getRectangle());
            }
            if (-1 != (listEntryInfo = this.calcObjectPosFromIndex(n)).getIndex()) {
                this.quickPaint(listEntryInfo.getRectangle());
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void onShiftDownArrow() {
        int n = this.selections.getLeadSelectionIndex();
        if (n + 1 < this.listModel.getCount()) {
            ListEntryInfo listEntryInfo;
            this.selections.setLeadSelectionIndex(++n);
            this.ensureIndexIsVisible(n);
            ListEntryInfo listEntryInfo2 = this.calcObjectPosFromIndex(n - 1);
            if (-1 != listEntryInfo2.getIndex()) {
                this.quickPaint(listEntryInfo2.getRectangle());
            }
            if (-1 != (listEntryInfo = this.calcObjectPosFromIndex(n)).getIndex()) {
                this.quickPaint(listEntryInfo.getRectangle());
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void onShiftLeftArrow() {
        ListEntryInfo listEntryInfo;
        int n = this.selections.getLeadSelectionIndex();
        int n2 = n;
        if (n2 == 0) {
            Toolkit.getDefaultToolkit().beep();
        }
        n2 = n2 - this.iEntriesPerColumn > 0 ? (n2 -= this.iEntriesPerColumn) : 0;
        this.selections.setLeadSelectionIndex(n2);
        this.ensureIndexIsVisible(n2);
        ListEntryInfo listEntryInfo2 = this.calcObjectPosFromIndex(n);
        if (-1 != listEntryInfo2.getIndex()) {
            this.quickPaint(listEntryInfo2.getRectangle());
        }
        if (-1 != (listEntryInfo = this.calcObjectPosFromIndex(n2)).getIndex()) {
            this.quickPaint(listEntryInfo.getRectangle());
        }
    }

    public void onShiftRightArrow() {
        ListEntryInfo listEntryInfo;
        int n = this.selections.getLeadSelectionIndex();
        int n2 = n;
        if (n2 == this.listModel.getCount()) {
            Toolkit.getDefaultToolkit().beep();
        }
        n2 = n2 + this.iEntriesPerColumn < this.listModel.getCount() ? (n2 += this.iEntriesPerColumn) : this.listModel.getCount();
        this.selections.setLeadSelectionIndex(n2);
        this.ensureIndexIsVisible(n2);
        ListEntryInfo listEntryInfo2 = this.calcObjectPosFromIndex(n);
        if (-1 != listEntryInfo2.getIndex()) {
            this.quickPaint(listEntryInfo2.getRectangle());
        }
        if (-1 != (listEntryInfo = this.calcObjectPosFromIndex(n2)).getIndex()) {
            this.quickPaint(listEntryInfo.getRectangle());
        }
    }

    public void onPageUp() {
        int n;
        int n2;
        if (this.iTotalColumns == 0 || this.iEntriesPerColumn == 0) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        if (this.iTopLeftIndex == 0) {
            Toolkit.getDefaultToolkit().beep();
        }
        if ((n2 = this.iEntriesPerColumn * this.iWholeColumnsVisible) == 0) {
            n2 = this.iEntriesPerColumn;
        }
        this.iTopLeftIndex = (n = this.iTopLeftIndex - n2) > 0 ? n : 0;
        this.setSelectedIndex(this.iTopLeftIndex);
        this.calcScrollBarMetrics();
        this.contentPanel.invalidate();
        this.contentPanel.paintImmediately(0, 0, this.contentPanel.getWidth(), this.contentPanel.getHeight());
    }

    public void onPageDown() {
        int n;
        if (this.iTotalColumns == 0 || this.iEntriesPerColumn == 0) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        int n2 = this.iEntriesPerColumn * this.iWholeColumnsVisible;
        if (n2 == 0) {
            n2 = this.iEntriesPerColumn;
        }
        if ((n = this.iTopLeftIndex + n2) < this.listModel.getCount()) {
            this.iTopLeftIndex = n;
            this.setSelectedIndex(this.iTopLeftIndex);
            this.calcScrollBarMetrics();
            this.contentPanel.invalidate();
            this.contentPanel.paintImmediately(0, 0, this.contentPanel.getWidth(), this.contentPanel.getHeight());
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void onShiftPageUp() {
        ListEntryInfo listEntryInfo;
        if (this.iTotalColumns == 0 || this.iEntriesPerColumn == 0) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        int n = this.iEntriesPerColumn * this.iColumnsVisible;
        int n2 = this.selections.getLeadSelectionIndex();
        int n3 = n2;
        if (n3 == 0) {
            Toolkit.getDefaultToolkit().beep();
        }
        n3 = n3 - n > 0 ? (n3 -= n) : 0;
        this.selections.setLeadSelectionIndex(n3);
        this.ensureIndexIsVisible(n3);
        ListEntryInfo listEntryInfo2 = this.calcObjectPosFromIndex(n2);
        if (-1 != listEntryInfo2.getIndex()) {
            this.quickPaint(listEntryInfo2.getRectangle());
        }
        if (-1 != (listEntryInfo = this.calcObjectPosFromIndex(n3)).getIndex()) {
            this.quickPaint(listEntryInfo.getRectangle());
        }
    }

    public void onShiftPageDown() {
        ListEntryInfo listEntryInfo;
        if (this.iTotalColumns == 0 || this.iEntriesPerColumn == 0) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        int n = this.iEntriesPerColumn * this.iColumnsVisible;
        int n2 = this.selections.getLeadSelectionIndex();
        int n3 = n2;
        if (n3 == this.listModel.getCount()) {
            Toolkit.getDefaultToolkit().beep();
        }
        n3 = n3 + n < this.listModel.getCount() ? (n3 += n) : this.listModel.getCount();
        this.selections.setLeadSelectionIndex(n3);
        this.ensureIndexIsVisible(n3);
        ListEntryInfo listEntryInfo2 = this.calcObjectPosFromIndex(n2);
        if (-1 != listEntryInfo2.getIndex()) {
            this.quickPaint(listEntryInfo2.getRectangle());
        }
        if (-1 != (listEntryInfo = this.calcObjectPosFromIndex(n3)).getIndex()) {
            this.quickPaint(listEntryInfo.getRectangle());
        }
    }

    public void ensureIndexIsVisible(int n) {
        if (this.iEntriesPerColumn == 0) {
            return;
        }
        if (n < 0 || n > this.listModel.getCount()) {
            return;
        }
        int n2 = this.iTopLeftIndex + this.iEntriesPerColumn * this.iWholeColumnsVisible;
        if (n2 == this.iTopLeftIndex) {
            n2 += this.iEntriesPerColumn;
        }
        if (this.iTopLeftIndex <= n && n < n2) {
            return;
        }
        int n3 = 0;
        if (n < this.iTopLeftIndex) {
            n3 = this.iTopLeftIndex;
            while (n3 > n) {
                n3 -= this.iEntriesPerColumn;
            }
        } else if (n >= n2) {
            n3 = this.iTopLeftIndex;
            while (n2 <= n) {
                n3 += this.iEntriesPerColumn;
                n2 += this.iEntriesPerColumn;
            }
        }
        this.iTopLeftIndex = n3;
        this.calcScrollBarMetrics();
        this.contentPanel.invalidate();
        this.contentPanel.paintImmediately(0, 0, this.contentPanel.getWidth(), this.contentPanel.getHeight());
    }

    public void processObjectEntryChangeEvent(ObjectEntryChangeEvent objectEntryChangeEvent) {
        int n = this.listModel.processObjectEntryChangeEvent(objectEntryChangeEvent);
        if (n != -1 && this.selections.getMaxSelectionIndex() != -1 && this.selections.getMinSelectionIndex() != -1) {
            if (n <= this.selections.getMaxSelectionIndex() && n >= this.selections.getMinSelectionIndex()) {
                this.clearSelection();
            } else if (n < this.selections.getMinSelectionIndex()) {
                this.bIgnoreAdjustments = true;
                if (objectEntryChangeEvent.getTypeOfModification() == 2) {
                    int n2 = this.selections.getAnchorSelectionIndex();
                    int n3 = this.selections.getLeadSelectionIndex();
                    this.selections.setSelectionInterval(n2 - 1, n3 - 1);
                } else if (objectEntryChangeEvent.getTypeOfModification() == 1) {
                    int n4 = this.selections.getAnchorSelectionIndex();
                    int n5 = this.selections.getLeadSelectionIndex();
                    this.selections.setSelectionInterval(n4 + 1, n5 + 1);
                }
                this.bIgnoreAdjustments = false;
            }
        }
        this.iTotalCount = this.listModel.getCount();
        if (this.iTopLeftIndex >= this.iTotalCount) {
            this.iTopLeftIndex = 0;
        }
        this.iCacheTopLeftIndex = -1;
        this.bRecalcMetrics = true;
        this.contentPanel.invalidate();
        this.contentPanel.paintImmediately(0, 0, this.contentPanel.getWidth(), this.contentPanel.getHeight());
    }

    private void calcColumnMetrics() {
        this.iEntriesPerColumn = 0;
        this.iWholeColumnsVisible = 0;
        this.iColumnsVisible = 0;
        this.iTotalColumns = 0;
        int n = this.contentPanel.getContentUIHeight();
        if (n != 0) {
            int n2 = this.contentPanel.getContentUIWidth();
            this.iEntriesPerColumn = n / this.contentPanel.getEntryHeight();
            if (this.iEntriesPerColumn == 0) {
                this.iEntriesPerColumn = 1;
            }
            this.iWholeColumnsVisible = this.iColumnsVisible = n2 / this.contentPanel.getEntryWidth();
            if (this.iColumnsVisible * this.contentPanel.getEntryWidth() != n2) {
                ++this.iColumnsVisible;
            }
            this.iTotalColumns = this.iTotalCount / this.iEntriesPerColumn;
            if (this.iTotalColumns * this.iEntriesPerColumn != this.iTotalCount) {
                ++this.iTotalColumns;
            }
        }
    }

    private void calcScrollBarMetrics() {
        BoundedRangeModel boundedRangeModel = this.theScrollBar.getModel();
        this.bIgnoreAdjustments = true;
        boundedRangeModel.setValue(0);
        boundedRangeModel.setMinimum(0);
        boundedRangeModel.setMaximum(this.iTotalColumns);
        boundedRangeModel.setExtent(this.iWholeColumnsVisible != 0 ? this.iWholeColumnsVisible : 1);
        int n = this.iTopLeftIndex / this.iEntriesPerColumn;
        if (n > this.iTotalColumns - this.iWholeColumnsVisible) {
            n = this.iTotalColumns - this.iWholeColumnsVisible;
        }
        boundedRangeModel.setValue(n);
        this.theScrollBar.setUnitIncrement(1);
        this.theScrollBar.setBlockIncrement(this.iWholeColumnsVisible);
        this.bIgnoreAdjustments = false;
        this.theScrollBar.setModel(boundedRangeModel);
        this.currentAdjustmentValue = this.theScrollBar.getValue();
        VList vList = (VList)this.contentPanel.getParent();
        boolean bl = false;
        bl = this.iWholeColumnsVisible * this.iEntriesPerColumn >= this.iTotalCount || 1 == this.iTotalColumns ? vList.removeScrollBar(this.theScrollBar) : vList.addScrollBar(this.theScrollBar);
        if (bl) {
            this.calcColumnMetrics();
            this.contentPanel.invalidate();
            this.contentPanel.paintImmediately(0, 0, this.contentPanel.getWidth(), this.contentPanel.getHeight());
        }
    }

    private ListEntryInfo calcObjectIndexFromPos(int n, int n2) {
        if (n <= this.contentPanel.getContentUITopLeftX() || n2 <= this.contentPanel.getContentUITopLeftY() || n > this.contentPanel.getContentUITopLeftX() + this.contentPanel.getContentUIWidth() || n2 > this.contentPanel.getContentUITopLeftY() + this.contentPanel.getContentUIHeight()) {
            IListContentUI iListContentUI = this;
            if (iListContentUI == null) {
                throw null;
            }
            return iListContentUI.new ListEntryInfo(-1, 0, 0, 0, 0);
        }
        int n3 = this.contentPanel.getEntryWidth();
        int n4 = this.contentPanel.getEntryHeight();
        int n5 = 0;
        int n6 = 0;
        int n7 = n3 + this.contentPanel.getContentUITopLeftX();
        while (n > n7) {
            n7 += n3;
            ++n5;
        }
        int n8 = n4 + this.contentPanel.getContentUITopLeftY();
        while (n2 > n8) {
            n8 += n4;
            ++n6;
        }
        int n9 = this.iTopLeftIndex;
        n9 += n5 * this.iEntriesPerColumn;
        if (n6 >= this.iEntriesPerColumn || n5 >= this.iColumnsVisible || (n9 += n6) >= this.iTotalCount) {
            IListContentUI iListContentUI = this;
            if (iListContentUI == null) {
                throw null;
            }
            return iListContentUI.new ListEntryInfo(-1, 0, 0, 0, 0);
        }
        int n10 = n5 * n3 + this.contentPanel.getContentUITopLeftX();
        int n11 = n6 * n4 + this.contentPanel.getContentUITopLeftY();
        IListContentUI iListContentUI = this;
        if (iListContentUI == null) {
            throw null;
        }
        ListEntryInfo listEntryInfo = iListContentUI.new ListEntryInfo(n9, n10, n11, n3, n4);
        return listEntryInfo;
    }

    private ListEntryInfo calcObjectPosFromIndex(int n) {
        if (n < this.iTopLeftIndex || this.iEntriesPerColumn == 0) {
            IListContentUI iListContentUI = this;
            if (iListContentUI == null) {
                throw null;
            }
            return iListContentUI.new ListEntryInfo(-1, 0, 0, 0, 0);
        }
        int n2 = n - this.iTopLeftIndex;
        int n3 = n2 / this.iEntriesPerColumn;
        int n4 = n2 - n3 * this.iEntriesPerColumn;
        int n5 = this.contentPanel.getEntryWidth();
        int n6 = this.contentPanel.getEntryHeight();
        int n7 = n3 * n5 + this.contentPanel.getContentUITopLeftX();
        int n8 = n4 * n6 + this.contentPanel.getContentUITopLeftY();
        IListContentUI iListContentUI = this;
        if (iListContentUI == null) {
            throw null;
        }
        return iListContentUI.new ListEntryInfo(n, n7, n8, n5, n6);
    }

    private int calcColumnFromIndex(int n) {
        if (n < this.iTopLeftIndex || this.iEntriesPerColumn == 0) {
            return -1;
        }
        int n2 = n - this.iTopLeftIndex;
        return n2 / this.iEntriesPerColumn;
    }

    private int calcColumnIndexFromXPos(int n) {
        int n2 = 0;
        int n3 = this.contentPanel.getEntryWidth() + this.contentPanel.getContentUITopLeftX();
        int n4 = this.contentPanel.getContentUITopLeftX() + this.contentPanel.getContentUIWidth();
        while (n > n3 && n3 < n4) {
            n3 += this.contentPanel.getEntryWidth();
            ++n2;
        }
        return n2;
    }

    private int calcRowIndexFromYPos(int n) {
        if (this.iEntriesPerColumn == 0) {
            return 0;
        }
        int n2 = 0;
        int n3 = this.contentPanel.getEntryHeight() + this.contentPanel.getContentUITopLeftY();
        int n4 = this.contentPanel.getContentUITopLeftY() + this.contentPanel.getContentUIHeight();
        int n5 = this.contentPanel.getEntryHeight();
        while (n > n3 && n3 + n5 <= n4) {
            n3 += n5;
            ++n2;
        }
        if (n2 >= this.iEntriesPerColumn) {
            n2 = this.iEntriesPerColumn - 1;
        }
        return n2;
    }

    private int calcTopEntryIndexForColumn(int n) {
        return this.iTopLeftIndex + n * this.iEntriesPerColumn;
    }

    private int calcBottomEntryIndexForColumn(int n) {
        return this.calcTopEntryIndexForColumn(n) + this.iEntriesPerColumn - 1;
    }

    private int calcEntryIndexForColumnAndRow(int n, int n2) {
        int n3 = this.iTopLeftIndex + n * this.iEntriesPerColumn;
        if ((n3 += n2) >= this.listModel.getCount()) {
            n3 = this.listModel.getCount() - 1;
        }
        return n3;
    }

    private int calcEntryIndex(ObjectEntry objectEntry) {
        String string;
        ObjectEntry[] objectEntryArray;
        String string2;
        int n;
        int n2 = -1;
        if (objectEntry != null && -1 != (n = this.listModel.moveTo(string2 = this.contentPanel.getDisplayNameForObject(objectEntry))) && (objectEntryArray = this.listModel.getNext(1)).length != 0 && objectEntryArray[0] != null && (string = this.contentPanel.getDisplayNameForObject(objectEntryArray[0])).equalsIgnoreCase(string2)) {
            n2 = n;
        }
        return n2;
    }

    private void setInitialEntryHeight() {
        ObjectEntry[] objectEntryArray = this.listModel.getNext(5);
        this.listModel.getPrev(objectEntryArray.length);
        this.contentPanel.setEntryHeightFromEntries(objectEntryArray);
    }

    public void onComponentResized(ComponentEvent componentEvent) {
        this.iTotalCount = this.listModel.getCount();
        this.calcColumnMetrics();
        this.setModelBlockSize();
        int n = this.iTopLeftIndex / this.iEntriesPerColumn;
        this.iTopLeftIndex = n * this.iEntriesPerColumn;
        int n2 = this.iTotalCount - this.iTopLeftIndex;
        int n3 = n2 / this.iEntriesPerColumn;
        if (n2 % this.iEntriesPerColumn != 0) {
            ++n3;
        }
        while (n3 < this.iWholeColumnsVisible && this.iTopLeftIndex >= this.iEntriesPerColumn) {
            this.iTopLeftIndex -= this.iEntriesPerColumn;
            ++n3;
        }
        if (this.theScrollBar != null) {
            this.calcScrollBarMetrics();
        }
        this.iCacheTopLeftIndex = -1;
        this.contentPanel.invalidate();
        this.contentPanel.paintImmediately(0, 0, this.contentPanel.getWidth(), this.contentPanel.getHeight());
    }

    public void onFocusGained(FocusEvent focusEvent) {
        this.repaintCellFocus();
    }

    public void onFocusLost(FocusEvent focusEvent) {
        this.repaintCellFocus();
    }

    protected void repaintCellFocus() {
        if (-1 != this.iCacheTopLeftIndex) {
            int n = this.iCacheTopLeftIndex;
            int n2 = 0;
            while (n2 < this.arScreenCache.length) {
                Rectangle rectangle;
                ListEntryInfo listEntryInfo;
                if (this.selections.isSelectedIndex(n) && -1 != (listEntryInfo = this.calcObjectPosFromIndex(n)).getIndex() && (rectangle = listEntryInfo.getRectangle()) != null) {
                    this.contentPanel.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                ++n;
                ++n2;
            }
        }
    }

    public void onMousePressed(MouseEvent mouseEvent) {
        this.m_lastInternalListSelectionEvent = null;
        Enumeration enumeration = this.m_externalListSelectionListeners.elements();
        while (enumeration.hasMoreElements()) {
            ListSelectionListener listSelectionListener = (ListSelectionListener)enumeration.nextElement();
            if (listSelectionListener == null) continue;
            this.selections.removeListSelectionListener(listSelectionListener);
        }
        if (this.contentPanel.isCellWidthAdjustmentActive()) {
            return;
        }
        this.iMouseSelCurrentX = this.iMouseSelAnchorX = mouseEvent.getX();
        this.iMouseSelLastX = this.iMouseSelAnchorX;
        this.iMouseSelCurrentY = this.iMouseSelAnchorY = mouseEvent.getY();
        this.iMouseSelLastY = this.iMouseSelAnchorY;
        int n = this.calcColumnIndexFromXPos(this.iMouseSelAnchorX);
        this.iAnchorColTopIndex = this.calcTopEntryIndexForColumn(n);
        this.iAnchorColBottomIndex = this.calcBottomEntryIndexForColumn(n);
        this.iAnchorRowIndex = this.calcRowIndexFromYPos(this.iMouseSelAnchorY);
        this.iAnchorIndex = this.calcEntryIndexForColumnAndRow(n, this.iAnchorRowIndex);
        this.iLastMouseSelStartIndex = -1;
        this.iLastMouseSelEndIndex = -1;
        this.iLastMouseSelStartRowIndex = -1;
        this.iLastMouseSelEndRowIndex = -1;
        this.bMouseSelActive = false;
        ListEntryInfo listEntryInfo = this.calcObjectIndexFromPos(mouseEvent.getX(), mouseEvent.getY());
        int n2 = listEntryInfo.getIndex();
        if (-1 != n2) {
            int n3 = this.selections.getAnchorSelectionIndex();
            if ((mouseEvent.getModifiers() & 4) == 0 || !this.selections.isSelectedIndex(n2)) {
                if (mouseEvent.isControlDown()) {
                    if (this.selections.isSelectedIndex(n2)) {
                        this.selections.removeSelectionInterval(n2, n2);
                    } else {
                        this.selections.addSelectionInterval(n2, n2);
                    }
                } else if (mouseEvent.isShiftDown() && n3 != -1) {
                    this.selections.setSelectionInterval(n3, n2);
                } else {
                    this.selections.setSelectionInterval(n2, n2);
                }
            }
        }
    }

    public void onMouseReleased(MouseEvent mouseEvent) {
        this.bMouseSelActive = false;
        Enumeration enumeration = this.m_externalListSelectionListeners.elements();
        while (enumeration.hasMoreElements()) {
            ListSelectionListener listSelectionListener = (ListSelectionListener)enumeration.nextElement();
            if (listSelectionListener == null) continue;
            if (this.m_lastInternalListSelectionEvent != null) {
                listSelectionListener.valueChanged(this.m_lastInternalListSelectionEvent);
            }
            this.selections.addListSelectionListener(listSelectionListener);
        }
    }

    public void onMouseDragged(MouseEvent mouseEvent) {
        int n;
        int n2;
        if (this.contentPanel.isCellWidthAdjustmentActive()) {
            return;
        }
        if (!this.bMouseSelActive) {
            n2 = this.iMouseSelAnchorX - mouseEvent.getX();
            n = this.iMouseSelAnchorY - mouseEvent.getY();
            if (Math.abs(n2) > this.contentPanel.getEntryHeight() / 2 || Math.abs(n) > this.contentPanel.getEntryHeight() / 2) {
                this.bMouseSelActive = true;
            }
        }
        if (this.bMouseSelActive) {
            int n3;
            int n4;
            this.iMouseSelLastX = this.iMouseSelCurrentX;
            this.iMouseSelCurrentX = mouseEvent.getX();
            this.iMouseSelLastY = this.iMouseSelCurrentY;
            this.iMouseSelCurrentY = mouseEvent.getY();
            if (this.iMouseSelCurrentX > this.contentPanel.getContentUITopLeftX() + this.contentPanel.getContentUIWidth()) {
                if (this.arScreenCache.length == this.iEntriesPerColumn * this.iColumnsVisible && this.iTopLeftIndex + this.arScreenCache.length < this.listModel.getCount() - 1) {
                    this.iTopLeftIndex += this.iEntriesPerColumn;
                    this.quickPaint(new Rectangle(this.contentPanel.getContentUITopLeftX(), this.contentPanel.getContentUITopLeftY(), this.contentPanel.getContentUITopLeftX() + this.contentPanel.getContentUIWidth(), this.contentPanel.getContentUITopLeftY() + this.contentPanel.getContentUIHeight()));
                    this.calcScrollBarMetrics();
                }
            } else if (this.iTopLeftIndex != 0 && this.iMouseSelCurrentX < this.contentPanel.getContentUITopLeftX()) {
                this.iTopLeftIndex -= this.iEntriesPerColumn;
                this.quickPaint(new Rectangle(this.contentPanel.getContentUITopLeftX(), this.contentPanel.getContentUITopLeftY(), this.contentPanel.getContentUITopLeftX() + this.contentPanel.getContentUIWidth(), this.contentPanel.getContentUITopLeftY() + this.contentPanel.getContentUIHeight()));
                this.calcScrollBarMetrics();
            }
            n2 = this.calcColumnIndexFromXPos(this.iMouseSelCurrentX);
            n = this.calcTopEntryIndexForColumn(n2);
            int n5 = this.calcBottomEntryIndexForColumn(n2);
            int n6 = this.calcRowIndexFromYPos(this.iMouseSelCurrentY);
            if (n == this.iAnchorColTopIndex) {
                n4 = this.iAnchorColTopIndex;
                n3 = this.iAnchorColBottomIndex;
            } else if (n < this.iAnchorColTopIndex) {
                n4 = n;
                n3 = this.iAnchorColBottomIndex;
            } else {
                n4 = this.iAnchorColTopIndex;
                n3 = n5;
            }
            int n7 = Math.min(this.iAnchorRowIndex, n6);
            int n8 = Math.max(this.iAnchorRowIndex, n6);
            if (this.iLastMouseSelStartIndex != n4 || this.iLastMouseSelEndIndex != n3 || this.iLastMouseSelStartRowIndex != n7 || this.iLastMouseSelEndRowIndex != n8) {
                int n9;
                int n10;
                int n11;
                this.selections.setValueIsAdjusting(true);
                if (this.iLastMouseSelStartIndex == -1) {
                    this.clearSelection();
                    n11 = n4;
                    while (n11 < n3) {
                        this.selections.addSelectionInterval(n11 + n7, n11 + n8);
                        n11 += this.iEntriesPerColumn;
                    }
                } else {
                    n11 = this.iLastMouseSelStartIndex;
                    while (n11 < this.iLastMouseSelEndIndex) {
                        if (n11 < n4 || n11 > n3) {
                            this.selections.removeSelectionInterval(n11 + this.iLastMouseSelStartRowIndex, n11 + this.iLastMouseSelEndRowIndex);
                        } else {
                            if (this.iLastMouseSelStartRowIndex < n7) {
                                n10 = n11 + this.iLastMouseSelStartRowIndex;
                                n9 = n11 + n7 - 1;
                                this.selections.removeSelectionInterval(n10, n9);
                            }
                            if (this.iLastMouseSelEndRowIndex > n8) {
                                n10 = n11 + this.iLastMouseSelEndRowIndex;
                                n9 = n11 + n8 + 1;
                                this.selections.removeSelectionInterval(n10, n9);
                            }
                        }
                        n11 += this.iEntriesPerColumn;
                    }
                }
                n11 = n4;
                while (n11 < n3) {
                    if (n11 < this.iLastMouseSelStartIndex || n11 > this.iLastMouseSelEndIndex) {
                        this.selections.addSelectionInterval(n11 + n7, n11 + n8);
                    } else {
                        if (n7 < this.iLastMouseSelStartRowIndex) {
                            n10 = n11 + n7;
                            n9 = n11 + this.iLastMouseSelStartRowIndex - 1;
                            this.selections.addSelectionInterval(n10, n9);
                        }
                        if (n8 > this.iLastMouseSelEndRowIndex) {
                            n10 = n11 + this.iLastMouseSelEndRowIndex + 1;
                            n9 = n11 + n8;
                            this.selections.addSelectionInterval(n10, n9);
                        }
                    }
                    n11 += this.iEntriesPerColumn;
                }
                this.iLastMouseSelStartIndex = n4;
                this.iLastMouseSelEndIndex = n3;
                this.iLastMouseSelStartRowIndex = n7;
                this.iLastMouseSelEndRowIndex = n8;
                this.selections.removeSelectionInterval(this.iAnchorIndex, this.iAnchorIndex);
                this.selections.addSelectionInterval(this.iAnchorIndex, this.iAnchorIndex);
                this.selections.setValueIsAdjusting(false);
            }
        }
    }

    public void onMouseMoved(MouseEvent mouseEvent) {
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (this.bIgnoreAdjustments) {
            return;
        }
        if (this.currentAdjustmentValue == adjustmentEvent.getValue()) {
            return;
        }
        if (this.currentAdjustmentValue + 1 == adjustmentEvent.getValue()) {
            this.iTopLeftIndex += this.iEntriesPerColumn;
            this.listModel.moveTo(this.iTopLeftIndex);
            if (this.iTopLeftIndex + this.iColumnsVisible * this.iEntriesPerColumn > this.iTotalCount) {
                this.iTotalCount = this.listModel.getCount();
                this.calcColumnMetrics();
                this.calcScrollBarMetrics();
            }
        } else if (this.currentAdjustmentValue - 1 == adjustmentEvent.getValue()) {
            this.iTopLeftIndex -= this.iEntriesPerColumn;
            if (this.iTopLeftIndex < 0) {
                this.iTopLeftIndex = 0;
            }
        } else {
            this.iTopLeftIndex = adjustmentEvent.getValue() * this.iEntriesPerColumn;
        }
        this.currentAdjustmentValue = adjustmentEvent.getValue();
        this.contentPanel.invalidate();
        this.contentPanel.paintImmediately(0, 0, this.contentPanel.getWidth(), this.contentPanel.getHeight());
    }

    static /* synthetic */ ListSelectionEvent access$0(IListContentUI iListContentUI) {
        return iListContentUI.m_lastInternalListSelectionEvent;
    }

    public IListContentUI() {
        this.theScrollBar.addAdjustmentListener(this);
        IListContentUI iListContentUI = this;
        if (iListContentUI == null) {
            throw null;
        }
        this.selections.addListSelectionListener(iListContentUI.new SelectionListener());
    }

    public class ListEntryInfo {
        private Rectangle rect;
        private int index;

        Rectangle getRectangle() {
            return this.rect;
        }

        int getIndex() {
            return this.index;
        }

        public ListEntryInfo(int n, int n2, int n3, int n4, int n5) {
            this.rect = new Rectangle(n2, n3, n4, n5);
            this.index = n;
        }
    }

    public class SelectionListener
    implements ListSelectionListener,
    Serializable {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            IListContentUI.this.m_lastInternalListSelectionEvent = listSelectionEvent;
            if (IListContentUI.this.iEntriesPerColumn == 0) {
                return;
            }
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            int n = listSelectionEvent.getFirstIndex();
            int n2 = listSelectionEvent.getLastIndex();
            ListEntryInfo listEntryInfo = IListContentUI.this.calcObjectPosFromIndex(n);
            Rectangle rectangle = listEntryInfo.getRectangle();
            if (n == n2 && -1 != listEntryInfo.getIndex()) {
                IListContentUI.this.quickPaint(listEntryInfo.getRectangle());
                return;
            }
            ListEntryInfo listEntryInfo2 = IListContentUI.this.calcObjectPosFromIndex(n2);
            Rectangle rectangle2 = listEntryInfo2.getRectangle();
            int n3 = IListContentUI.this.calcColumnFromIndex(n);
            int n4 = IListContentUI.this.calcColumnFromIndex(n2);
            int n5 = IListContentUI.this.contentPanel.getEntryWidth();
            int n6 = IListContentUI.this.contentPanel.getEntryHeight();
            if (n3 == n4) {
                IListContentUI.this.quickPaint(new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle2.y + n6 - rectangle.y));
                return;
            }
            IListContentUI.this.quickPaint(new Rectangle(rectangle.x, rectangle.y, rectangle.width, IListContentUI.this.contentPanel.getContentUIHeight() - rectangle.y));
            ++n3;
            while (n3 < n4) {
                Rectangle rectangle3 = new Rectangle(IListContentUI.this.contentPanel.getContentUITopLeftX() + n5 * n3, IListContentUI.this.contentPanel.getContentUITopLeftY(), n5, IListContentUI.this.contentPanel.getContentUIHeight());
                IListContentUI.this.quickPaint(rectangle3);
                ++n3;
            }
            IListContentUI.this.quickPaint(new Rectangle(rectangle2.x, IListContentUI.this.contentPanel.getContentUITopLeftY(), rectangle2.width, rectangle2.y + n6));
        }
    }
}

