/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.util.vlist;

import com.novell.application.console.snapin.DefaultIndexedObjectEntryEnumeration;
import com.novell.application.console.snapin.IndexedObjectEntryEnumeration;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryChangeEvent;
import com.novell.application.console.snapin.ObjectEntryEnumeration;
import com.novell.application.console.snapin.Shell;
import com.novell.application.console.snapin.SnapinException;

public class IListDataModel {
    IndexedObjectEntryEnumeration vEnum = null;
    ObjectEntry[] globalEntries = null;
    int iGlobalIndex = -1;
    Shell shell = null;

    public void setGlobalEntries(ObjectEntry[] objectEntryArray) {
        if (objectEntryArray.length == 0) {
            objectEntryArray = null;
        }
        int n = 0;
        while (n < objectEntryArray.length) {
            if (objectEntryArray[n] == null) {
                objectEntryArray = null;
                break;
            }
            ++n;
        }
        this.globalEntries = objectEntryArray;
        this.iGlobalIndex = -1;
    }

    public int moveFirst() {
        int n;
        this.iGlobalIndex = -1;
        if (this.getGlobalEntryCount() != 0) {
            this.iGlobalIndex = 0;
        }
        try {
            n = this.vEnum.moveFirst();
        }
        catch (SnapinException snapinException) {
            n = 0;
        }
        return n;
    }

    public int moveLast() {
        int n;
        try {
            if (this.globalEntries != null && this.vEnum.getCount() == 0) {
                this.iGlobalIndex = this.getGlobalEntryCount() - 1;
                return this.iGlobalIndex;
            }
            this.iGlobalIndex = -1;
            n = this.vEnum.moveLast() + this.getGlobalEntryCount();
        }
        catch (SnapinException snapinException) {
            n = 0;
        }
        return n;
    }

    public int moveTo(int n) {
        int n2;
        if (this.globalEntries != null && n < this.getGlobalEntryCount()) {
            this.iGlobalIndex = n;
            return this.iGlobalIndex;
        }
        try {
            this.iGlobalIndex = -1;
            n2 = this.vEnum.moveTo(n - this.getGlobalEntryCount());
        }
        catch (SnapinException snapinException) {
            n2 = 0;
        }
        return n2 + this.getGlobalEntryCount();
    }

    public int moveTo(String string) {
        int n;
        try {
            n = this.vEnum.moveTo(string);
        }
        catch (SnapinException snapinException) {
            n = 0;
        }
        return n + this.getGlobalEntryCount();
    }

    public ObjectEntry[] getNext(int n) {
        ObjectEntry[] objectEntryArray = new ObjectEntry[]{};
        try {
            if (-1 == this.iGlobalIndex) {
                objectEntryArray = this.vEnum.getNext(n);
            } else {
                ObjectEntry[] objectEntryArray2 = null;
                int n2 = this.getGlobalEntryCount() - this.iGlobalIndex;
                if (n > n2) {
                    this.vEnum.moveFirst();
                    objectEntryArray2 = this.vEnum.getNext(n - n2);
                }
                int n3 = 0;
                if (objectEntryArray2 != null) {
                    n3 = objectEntryArray2.length;
                }
                objectEntryArray = new ObjectEntry[n2 + n3];
                int n4 = 0;
                int n5 = this.iGlobalIndex;
                while (n5 < this.getGlobalEntryCount()) {
                    objectEntryArray[n4] = this.globalEntries[n5];
                    ++n4;
                    ++n5;
                }
                if (n3 != 0) {
                    n5 = 0;
                    while (n5 < objectEntryArray2.length) {
                        objectEntryArray[n4] = objectEntryArray2[n5];
                        ++n4;
                        ++n5;
                    }
                    this.iGlobalIndex = -1;
                }
            }
        }
        catch (SnapinException snapinException) {
            objectEntryArray = new ObjectEntry[]{};
        }
        return objectEntryArray;
    }

    public ObjectEntry[] getPrev(int n) {
        ObjectEntry[] objectEntryArray = new ObjectEntry[]{};
        try {
            if (-1 != this.iGlobalIndex) {
                if (this.iGlobalIndex == 0) {
                    objectEntryArray = new ObjectEntry[]{this.globalEntries[0]};
                } else if (n <= this.iGlobalIndex) {
                    objectEntryArray = new ObjectEntry[n];
                    int n2 = 0;
                    int n3 = this.iGlobalIndex - n;
                    while (n3 < this.iGlobalIndex) {
                        objectEntryArray[n2] = this.globalEntries[n3];
                        ++n2;
                        ++n3;
                    }
                    this.iGlobalIndex -= n;
                } else {
                    objectEntryArray = new ObjectEntry[this.iGlobalIndex];
                    int n4 = 0;
                    while (n4 < this.iGlobalIndex) {
                        objectEntryArray[n4] = this.globalEntries[n4];
                        ++n4;
                    }
                    this.iGlobalIndex = 0;
                }
            } else {
                ObjectEntry[] objectEntryArray2 = this.vEnum.getPrev(n);
                if (n == objectEntryArray2.length) {
                    return objectEntryArray2;
                }
                if (this.getGlobalEntryCount() == 0) {
                    return objectEntryArray2;
                }
                int n5 = n - objectEntryArray2.length;
                if (n5 > this.getGlobalEntryCount()) {
                    n5 = this.getGlobalEntryCount();
                }
                objectEntryArray = new ObjectEntry[n5 + objectEntryArray2.length];
                int n6 = 0;
                int n7 = this.getGlobalEntryCount() - n5;
                while (n7 < this.getGlobalEntryCount()) {
                    objectEntryArray[n6] = this.globalEntries[n7];
                    ++n6;
                    ++n7;
                }
                n7 = 0;
                while (n7 < objectEntryArray2.length) {
                    objectEntryArray[n6] = objectEntryArray2[n7];
                    ++n6;
                    ++n7;
                }
                this.iGlobalIndex = this.getGlobalEntryCount() - n5;
            }
        }
        catch (SnapinException snapinException) {
            objectEntryArray = new ObjectEntry[]{};
        }
        return objectEntryArray;
    }

    public int getCount() {
        int n;
        try {
            n = this.vEnum.getCount() + this.getGlobalEntryCount();
        }
        catch (SnapinException snapinException) {
            n = 0;
        }
        return n;
    }

    public void setBlockSize(int n) {
        this.vEnum.setBlockSize(n);
    }

    private int getGlobalEntryCount() {
        if (this.globalEntries == null) {
            return 0;
        }
        return this.globalEntries.length;
    }

    public int processObjectEntryChangeEvent(ObjectEntryChangeEvent objectEntryChangeEvent) {
        if (!(this.vEnum instanceof DefaultIndexedObjectEntryEnumeration)) {
            this.vEnum = new DefaultIndexedObjectEntryEnumeration((ObjectEntryEnumeration)this.vEnum, this.shell);
        }
        DefaultIndexedObjectEntryEnumeration defaultIndexedObjectEntryEnumeration = (DefaultIndexedObjectEntryEnumeration)this.vEnum;
        switch (objectEntryChangeEvent.getTypeOfModification()) {
            case 1: {
                if (objectEntryChangeEvent.getInsertionIndex() == -1) {
                    defaultIndexedObjectEntryEnumeration.append(objectEntryChangeEvent.getObjectEntry());
                    break;
                }
                defaultIndexedObjectEntryEnumeration.insert(objectEntryChangeEvent.getObjectEntry(), objectEntryChangeEvent.getInsertionIndex());
                return objectEntryChangeEvent.getInsertionIndex();
            }
            case 2: {
                return defaultIndexedObjectEntryEnumeration.remove(objectEntryChangeEvent.getObjectEntry());
            }
            case 3: {
                defaultIndexedObjectEntryEnumeration.replace(objectEntryChangeEvent.getOldObjectEntry(), objectEntryChangeEvent.getObjectEntry());
                break;
            }
        }
        return -1;
    }

    public IListDataModel(ObjectEntryEnumeration objectEntryEnumeration, Shell shell) {
        this.shell = shell;
        this.vEnum = objectEntryEnumeration instanceof IndexedObjectEntryEnumeration ? (IndexedObjectEntryEnumeration)objectEntryEnumeration : new DefaultIndexedObjectEntryEnumeration(objectEntryEnumeration, shell);
    }
}

