/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.util.vlist;

import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryEnumeration;
import com.novell.application.console.snapin.Shell;
import com.novell.application.console.util.vlist.SListDataModel;

public class SListCachedDataModel {
    private int m_iLastCurrentPosition = 0;
    private long m_lLastCurrentPositionActivityIndicator = 0L;
    private long m_lActivityIndicator = 1L;
    private int m_iLastBlockSize = -1;
    private SListDataModel listModel;

    public void setGlobalEntries(ObjectEntry[] objectEntryArray) {
        this.incActivityIndicator();
        this.listModel.setGlobalEntries(objectEntryArray);
    }

    public int moveTo(int n) {
        this.incActivityIndicator();
        return this.listModel.moveTo(n);
    }

    public int moveTo(String string) {
        this.incActivityIndicator();
        return this.listModel.moveTo(string);
    }

    public int moveLeft(int n) {
        this.incActivityIndicator();
        return this.listModel.moveLeft(n);
    }

    public int moveRight(int n) {
        this.incActivityIndicator();
        return this.listModel.moveRight(n);
    }

    public ObjectEntry[] getNext(int n) {
        this.incActivityIndicator();
        return this.listModel.getNext(n);
    }

    public ObjectEntry[] getPrev(int n) {
        this.incActivityIndicator();
        return this.listModel.getPrev(n);
    }

    public int getCurrentPosition() {
        if (this.m_lLastCurrentPositionActivityIndicator == this.m_lActivityIndicator) {
            return this.m_iLastCurrentPosition;
        }
        this.m_lLastCurrentPositionActivityIndicator = this.m_lActivityIndicator;
        this.m_iLastCurrentPosition = this.listModel.getCurrentPosition();
        return this.m_iLastCurrentPosition;
    }

    public int getLastEntryPosition() {
        return this.listModel.getLastEntryPosition();
    }

    public void setBlockSize(int n) {
        if (n != this.m_iLastBlockSize) {
            this.listModel.setBlockSize(n);
            this.m_iLastBlockSize = n;
        }
    }

    public int getCount() {
        return this.listModel.getCount();
    }

    public int moveFirst() {
        int n = this.moveTo(0);
        return n;
    }

    public int moveLast() {
        int n = this.moveTo(this.getLastEntryPosition());
        return n;
    }

    public boolean atFirst() {
        return this.listPositionTester(0);
    }

    public boolean atLast() {
        return this.listPositionTester(this.getLastEntryPosition());
    }

    public boolean beforeStartOfList() {
        return this.listPositionTester(-1);
    }

    public boolean pastEndOfList() {
        return this.listPositionTester(-2);
    }

    private boolean listPositionTester(int n) {
        int n2 = this.getCurrentPosition();
        return n == n2;
    }

    public ObjectEntry getCurrent() {
        ObjectEntry[] objectEntryArray = this.getNext(1);
        if (objectEntryArray != null && objectEntryArray.length != 0 && objectEntryArray[0] != null) {
            this.getPrev(1);
            return objectEntryArray[0];
        }
        return null;
    }

    public ObjectEntry[] peekAtRightEntries(int n, int n2) {
        ObjectEntry[] objectEntryArray = new ObjectEntry[]{};
        int n3 = 0;
        if (n2 > 0) {
            n3 = this.moveRight(n2);
        }
        objectEntryArray = this.getNext(n);
        this.moveLeft(objectEntryArray.length + n3);
        return objectEntryArray;
    }

    public ObjectEntry[] peekAtLeftEntries(int n, int n2) {
        ObjectEntry[] objectEntryArray = new ObjectEntry[]{};
        if (-1 == this.getCurrentPosition() || this.getCurrentPosition() == 0) {
            return objectEntryArray;
        }
        int n3 = this.moveLeft(n2 + n);
        if (n3 != n2 + n) {
            if (n3 <= n2) {
                this.moveRight(n3);
            } else {
                objectEntryArray = this.getNext(n3 - n2);
                this.moveLeft(objectEntryArray.length);
                this.moveRight(n3);
            }
        } else {
            objectEntryArray = this.getNext(n);
            this.moveLeft(objectEntryArray.length);
            this.moveRight(n3);
        }
        return objectEntryArray;
    }

    public boolean sameActivityIndicator(long l) {
        return l == this.m_lActivityIndicator;
    }

    public long setActivityIndicatorDifferent() {
        this.m_lActivityIndicator = 1L;
        this.m_lLastCurrentPositionActivityIndicator = 0L;
        return 0L;
    }

    public long getActivityIndicator() {
        return this.m_lActivityIndicator;
    }

    private void incActivityIndicator() {
        ++this.m_lActivityIndicator;
    }

    public SListCachedDataModel(ObjectEntryEnumeration objectEntryEnumeration, Shell shell) {
        this.listModel = new SListDataModel(objectEntryEnumeration, shell);
    }
}

