/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.util.vlist;

import com.novell.application.console.snapin.DefaultVirtualObjectEntryEnumeration;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryEnumeration;
import com.novell.application.console.snapin.Shell;
import com.novell.application.console.snapin.SnapinException;
import com.novell.application.console.snapin.VirtualObjectEntryEnumeration;

public class SListDataModel {
    private static final int InvalidEntryCount = -1;
    private VirtualObjectEntryEnumeration vEnum = null;
    private ObjectEntry[] globalEntries = null;
    private int iGlobalIndex = -1;
    private int m_iLastEntryPosition;
    private int m_iTotalEntryCount = -1;

    public void setGlobalEntries(ObjectEntry[] objectEntryArray) {
        if (objectEntryArray.length == 0) {
            objectEntryArray = null;
        }
        int n = 0;
        while (n < objectEntryArray.length) {
            if (objectEntryArray[n] == null) {
                objectEntryArray = null;
                break;
            }
            ++n;
        }
        this.globalEntries = objectEntryArray;
        this.iGlobalIndex = -1;
    }

    public int moveTo(int n) {
        int n2 = 0;
        int n3 = -3;
        if (this.getGlobalEntryCount() != 0) {
            if (n == 0) {
                this.iGlobalIndex = 0;
                n = 0;
                n3 = 0;
            } else if (n == -1) {
                this.iGlobalIndex = -2;
                n = 0;
                n3 = -1;
            } else if (n == this.m_iLastEntryPosition) {
                this.iGlobalIndex = -1;
            } else {
                int n4 = this.translatePositionToIndex(n);
                if (n4 < this.getGlobalEntryCount()) {
                    this.iGlobalIndex = n4;
                    n3 = this.translateIndexToPosition(n4);
                    n = 0;
                } else {
                    n = this.translateListIndexToListPosition(n4 - this.getGlobalEntryCount());
                    n3 = this.translateListModelPosition(n);
                    this.iGlobalIndex = -1;
                }
            }
        }
        try {
            n2 = this.vEnum.moveTo(n);
        }
        catch (SnapinException snapinException) {
            // empty catch block
        }
        if (-3 == n3) {
            this.iGlobalIndex = -1;
            return n2;
        }
        return n3;
    }

    public int moveTo(String string) {
        int n = 0;
        try {
            n = this.vEnum.moveTo(string);
        }
        catch (SnapinException snapinException) {
            // empty catch block
        }
        if (this.getGlobalEntryCount() != 0) {
            n = this.translateListModelPosition(n);
        }
        this.iGlobalIndex = -1;
        return n;
    }

    public int moveLeft(int n) {
        int n2 = 0;
        if (n == 0) {
            return 0;
        }
        try {
            if (-1 != this.iGlobalIndex) {
                if (this.iGlobalIndex == 0 || -2 == this.iGlobalIndex) {
                    return n2;
                }
                if (n <= this.iGlobalIndex) {
                    this.iGlobalIndex -= n;
                    return n;
                }
                n2 = this.iGlobalIndex;
                this.iGlobalIndex = -2;
                return n2;
            }
            int n3 = this.vEnum.moveLeft(n);
            if (n != n3 && this.getGlobalEntryCount() != 0) {
                int n4 = n - n3;
                if (n4 > this.getGlobalEntryCount()) {
                    n4 = this.getGlobalEntryCount();
                }
                n2 = n3 + n4;
                this.iGlobalIndex = this.getGlobalEntryCount() - n4;
                this.vEnum.moveTo(0);
            } else {
                n2 = n3;
            }
        }
        catch (SnapinException snapinException) {
            // empty catch block
        }
        return n2;
    }

    public int moveRight(int n) {
        int n2 = 0;
        if (n == 0) {
            return 0;
        }
        try {
            if (-2 == this.iGlobalIndex) {
                this.iGlobalIndex = 0;
            }
            if (-1 == this.iGlobalIndex) {
                n2 = this.vEnum.moveRight(n);
            } else {
                int n3 = 0;
                int n4 = 0;
                int n5 = this.getGlobalEntryCount() - this.iGlobalIndex;
                if (n > n5) {
                    this.vEnum.moveTo(0);
                    n3 = this.vEnum.moveRight(n - n5);
                    n4 = n5;
                    this.iGlobalIndex = -1;
                } else if (n == n5) {
                    this.vEnum.moveTo(0);
                    this.iGlobalIndex = -1;
                    n4 = n5;
                } else {
                    this.iGlobalIndex += n;
                    n4 = n;
                }
                n2 = n4 + n3;
            }
        }
        catch (SnapinException snapinException) {
            // empty catch block
        }
        return n2;
    }

    public ObjectEntry[] getNext(int n) {
        ObjectEntry[] objectEntryArray = new ObjectEntry[]{};
        try {
            if (-2 == this.iGlobalIndex) {
                this.iGlobalIndex = 0;
            }
            if (-1 == this.iGlobalIndex) {
                objectEntryArray = this.vEnum.getNext(n);
            } else {
                ObjectEntry[] objectEntryArray2 = null;
                int n2 = this.getGlobalEntryCount() - this.iGlobalIndex;
                int n3 = 0;
                if (n < n2) {
                    n3 = n;
                } else if (n == n2) {
                    n3 = n;
                    this.vEnum.moveTo(0);
                } else if (n > n2) {
                    n3 = n2;
                    this.vEnum.moveTo(0);
                    objectEntryArray2 = this.vEnum.getNext(n - n3);
                }
                int n4 = 0;
                if (objectEntryArray2 != null) {
                    n4 = objectEntryArray2.length;
                }
                objectEntryArray = new ObjectEntry[n3 + n4];
                int n5 = 0;
                int n6 = this.iGlobalIndex;
                while (n6 < this.iGlobalIndex + n3) {
                    objectEntryArray[n5] = this.globalEntries[n6];
                    ++n5;
                    ++n6;
                }
                if (n4 != 0) {
                    n6 = 0;
                    while (n6 < objectEntryArray2.length) {
                        objectEntryArray[n5] = objectEntryArray2[n6];
                        ++n5;
                        ++n6;
                    }
                    this.iGlobalIndex = -1;
                } else {
                    this.iGlobalIndex += n3;
                    if (this.iGlobalIndex >= this.getGlobalEntryCount()) {
                        this.iGlobalIndex = -1;
                    }
                }
            }
        }
        catch (SnapinException snapinException) {
            // empty catch block
        }
        return objectEntryArray;
    }

    public ObjectEntry[] getPrev(int n) {
        ObjectEntry[] objectEntryArray = new ObjectEntry[]{};
        try {
            if (-1 != this.iGlobalIndex) {
                if (this.iGlobalIndex == 0 || -2 == this.iGlobalIndex) {
                    objectEntryArray = new ObjectEntry[]{};
                } else if (n <= this.iGlobalIndex) {
                    objectEntryArray = new ObjectEntry[n];
                    int n2 = 0;
                    int n3 = this.iGlobalIndex - n;
                    while (n3 < this.iGlobalIndex) {
                        objectEntryArray[n2] = this.globalEntries[n3];
                        ++n2;
                        ++n3;
                    }
                    this.iGlobalIndex -= n;
                } else {
                    objectEntryArray = new ObjectEntry[this.iGlobalIndex];
                    int n4 = 0;
                    while (n4 < this.iGlobalIndex) {
                        objectEntryArray[n4] = this.globalEntries[n4];
                        ++n4;
                    }
                    this.iGlobalIndex = -2;
                }
            } else {
                ObjectEntry[] objectEntryArray2 = this.vEnum.getPrev(n);
                if (n != objectEntryArray2.length && this.getGlobalEntryCount() != 0) {
                    int n5 = n - objectEntryArray2.length;
                    if (n5 > this.getGlobalEntryCount()) {
                        n5 = this.getGlobalEntryCount();
                    }
                    objectEntryArray = new ObjectEntry[n5 + objectEntryArray2.length];
                    int n6 = 0;
                    int n7 = this.getGlobalEntryCount() - n5;
                    while (n7 < this.getGlobalEntryCount()) {
                        objectEntryArray[n6] = this.globalEntries[n7];
                        ++n6;
                        ++n7;
                    }
                    n7 = 0;
                    while (n7 < objectEntryArray2.length) {
                        objectEntryArray[n6] = objectEntryArray2[n7];
                        ++n6;
                        ++n7;
                    }
                    this.iGlobalIndex = this.getGlobalEntryCount() - n5;
                    this.vEnum.moveTo(0);
                } else {
                    objectEntryArray = objectEntryArray2;
                }
            }
        }
        catch (SnapinException snapinException) {
            // empty catch block
        }
        return objectEntryArray;
    }

    public int getCurrentPosition() {
        int n = 0;
        if (this.iGlobalIndex >= 0) {
            if (this.iGlobalIndex == 0) {
                return 0;
            }
            return this.translateIndexToPosition(this.iGlobalIndex);
        }
        if (-2 == this.iGlobalIndex) {
            return -1;
        }
        try {
            n = this.vEnum.getCurrentPosition();
            if (this.getGlobalEntryCount() != 0) {
                if (n == -1) {
                    this.vEnum.moveTo(0);
                    n = 0;
                } else if (n == -2) {
                    return n;
                }
                n = this.translateListModelPosition(n);
            }
        }
        catch (SnapinException snapinException) {
            // empty catch block
        }
        return n;
    }

    public int getLastEntryPosition() {
        return this.m_iLastEntryPosition;
    }

    public void setBlockSize(int n) {
        this.vEnum.setBlockSize(n);
    }

    public int getCount() {
        if (-1 == this.m_iTotalEntryCount) {
            int n = 0;
            try {
                n = this.vEnum.getCount();
            }
            catch (SnapinException snapinException) {
                // empty catch block
            }
            this.m_iTotalEntryCount = n + this.getGlobalEntryCount();
        }
        return this.m_iTotalEntryCount;
    }

    private int translatePositionToIndex(int n) {
        int n2 = this.getCount() - this.getGlobalEntryCount();
        float f = this.getGlobalEntryCount() + n2;
        f *= (float)n;
        int n3 = (int)(f /= 1000.0f);
        return n3;
    }

    private int translateIndexToPosition(int n) {
        int n2 = this.getCount() - this.getGlobalEntryCount();
        float f = n * 1000 / (this.getGlobalEntryCount() + n2);
        int n3 = (int)f;
        return n3;
    }

    private int translateListIndexToListPosition(int n) {
        int n2 = this.getCount() - this.getGlobalEntryCount();
        if (n > n2) {
            n = n2;
        }
        float f = n * 1000 / n2;
        int n3 = (int)f;
        return n3;
    }

    private int translateListModelPosition(int n) {
        if (this.getGlobalEntryCount() == 0) {
            return n;
        }
        int n2 = this.getCount() - this.getGlobalEntryCount();
        float f = n * n2 / 1000 + this.getGlobalEntryCount();
        f /= (float)(n2 + this.getGlobalEntryCount());
        int n3 = (int)(f *= 1000.0f);
        return n3;
    }

    private int getGlobalEntryCount() {
        if (this.globalEntries == null) {
            return 0;
        }
        return this.globalEntries.length;
    }

    public SListDataModel(ObjectEntryEnumeration objectEntryEnumeration, Shell shell) {
        this.vEnum = objectEntryEnumeration instanceof VirtualObjectEntryEnumeration ? (VirtualObjectEntryEnumeration)objectEntryEnumeration : new DefaultVirtualObjectEntryEnumeration(objectEntryEnumeration, shell);
        try {
            this.m_iLastEntryPosition = this.vEnum.getLastEntryPosition();
        }
        catch (SnapinException snapinException) {
            // empty catch block
        }
    }
}

