/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.util.vlist;

import com.novell.application.console.util.vlist.NonTraverseLabel;
import com.novell.application.console.util.vlist.VList;
import com.novell.application.console.util.vlist.VListConstants;
import com.novell.application.console.util.vlist.VListContentPanel;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class VListStatusBar
extends JComponent
implements ComponentListener {
    public static final int FilterStateUnknown = 0;
    public static final int FilterStateFiltered = 1;
    public static final int FilterStateUnFiltered = 2;
    public static final int UnknownCount = -1;
    int m_filteredState = 0;
    ImageIcon m_filteredIcon;
    ImageIcon m_unFilteredIcon;
    ImageIcon m_filteredUnknownIcon;
    NonTraverseLabel m_containerCount = new NonTraverseLabel();
    int m_iCount = -1;
    JTextField m_typeDown;
    JComponent m_theScrollBar;
    VListContentPanel m_contentPanel;
    Dimension m_dimTypeDownPreferredSize;
    NonTraverseLabel m_emptyScrollBar = new NonTraverseLabel();
    NonTraverseLabel m_filterIndicator = null;
    boolean m_bCountEnabled = true;
    boolean m_bFilterEnabled = true;
    boolean m_bTypeDownOn = false;
    boolean m_bCountOn = false;
    boolean m_bFilteredOn = true;
    String m_strCountDescription;
    String m_strFilteredImagePath = VListConstants.VListFilterStateFilteredImage;
    String m_strUnFilteredImagePath = VListConstants.VListFilterStateUnFilteredImage;
    String m_strUnknownFilteredImagePath = VListConstants.VListFilterStateUnknownImage;
    String m_strTypeDownToolTip = null;
    String m_strContainerCountToolTip = null;
    String m_strFilterIndicatorToolTip = null;
    int m_iScrollBarX = 0;
    int m_iScrollBarWidth = 5;
    int m_iCountX = 5;
    int m_iCountWidth = 2;
    int m_iFilteredX = 7;
    int m_iFilteredWidth = 1;
    int m_iTypeDownX = 5;
    int m_iTypeDownWidth = 3;
    int m_iTypeDownInitialColumns = 10;
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints m_countConstraints = new GridBagConstraints();
    GridBagConstraints m_filterConstraints = new GridBagConstraints();
    GridBagConstraints m_scrollBarConstraints = new GridBagConstraints();
    GridBagConstraints m_typeDownConstraints = new GridBagConstraints();

    private void displayCount(int n) {
        if (-1 == n) {
            this.m_containerCount.setText("");
        } else {
            this.m_containerCount.setText(String.valueOf(n) + this.m_strCountDescription);
        }
        this.ValidateComponents();
    }

    public void setCount(int n) {
        this.m_iCount = n;
        if (this.m_bCountEnabled) {
            this.displayCount(this.m_iCount);
        } else {
            this.displayCount(-1);
        }
    }

    public void enableCount(boolean bl) {
        if (this.m_bCountEnabled != bl) {
            this.m_bCountEnabled = bl;
            if (bl) {
                this.displayCount(this.m_iCount);
            } else {
                this.displayCount(-1);
            }
        }
    }

    public void enableFilterIndicator(boolean bl) {
        if (this.m_bFilterEnabled != bl) {
            this.m_bFilterEnabled = bl;
            if (bl) {
                this.displayCount(this.m_filteredState);
            } else {
                this.m_filterIndicator.setIcon(null);
            }
        }
    }

    public void setFiltered(int n) {
        if (n == 2) {
            this.m_filterIndicator.setIcon(this.m_unFilteredIcon);
            this.m_filteredState = n;
        } else if (n == 1) {
            this.m_filterIndicator.setIcon(this.m_filteredIcon);
            this.m_filteredState = n;
        } else {
            this.m_filterIndicator.setIcon(this.m_filteredUnknownIcon);
            this.m_filteredState = 0;
        }
    }

    public void removeScrollBar() {
        if (this.m_theScrollBar != this.m_emptyScrollBar) {
            this.remove(this.m_theScrollBar);
            this.m_theScrollBar = this.m_emptyScrollBar;
            this.gbl.setConstraints(this.m_theScrollBar, this.m_scrollBarConstraints);
            this.add(this.m_theScrollBar);
            this.validate();
            this.repaint();
            this.ValidateComponents();
        }
    }

    public void addScrollBar(JComponent jComponent) {
        if (this.m_theScrollBar == this.m_emptyScrollBar) {
            this.remove(this.m_theScrollBar);
            this.m_theScrollBar = jComponent;
            this.gbl.setConstraints(this.m_theScrollBar, this.m_scrollBarConstraints);
            this.add(this.m_theScrollBar);
            this.validate();
            this.repaint();
            this.ValidateComponents();
        }
    }

    public void startTypeDown(int n) {
        if (!this.m_bTypeDownOn) {
            if (this.m_bCountOn) {
                this.remove(this.m_containerCount);
            }
            if (this.m_bFilteredOn) {
                this.remove(this.m_filterIndicator);
            }
            this.gbl.setConstraints(this.m_typeDown, this.m_typeDownConstraints);
            this.add(this.m_typeDown);
            Dimension dimension = new Dimension(this.m_dimTypeDownPreferredSize);
            if (dimension.width > this.getSize().width) {
                dimension.width = this.getSize().width;
            }
            this.m_typeDown.setMinimumSize(dimension);
            this.m_typeDown.setSize(dimension);
            this.m_typeDown.setText(this.m_typeDown.getText() + (char)n);
            this.validate();
            this.repaint();
            this.m_typeDown.requestFocus();
            this.m_bTypeDownOn = true;
        } else {
            this.m_typeDown.requestFocus();
        }
    }

    public void endTypeDown() {
        if (this.m_bTypeDownOn) {
            Dimension dimension = this.m_typeDown.getPreferredSize();
            this.remove(this.m_typeDown);
            if (this.m_bCountOn) {
                this.add(this.m_containerCount);
            }
            if (this.m_bFilteredOn) {
                this.add(this.m_filterIndicator);
            }
            this.validate();
            this.repaint();
            this.m_bTypeDownOn = false;
        }
    }

    public Dimension getMinimumSize() {
        Dimension dimension = this.getPreferredSize();
        return new Dimension(5, dimension.height);
    }

    public Dimension getMaximumSize() {
        Dimension dimension = this.getPreferredSize();
        return new Dimension(Short.MAX_VALUE, dimension.height);
    }

    private ImageIcon GetIcon(String string) {
        ImageIcon imageIcon = null;
        URL uRL = this.getClass().getResource(string);
        if (uRL != null) {
            Image image = Toolkit.getDefaultToolkit().getImage(uRL);
            imageIcon = new ImageIcon(image);
        }
        return imageIcon;
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.ValidateComponents();
    }

    private void ValidateComponents() {
        boolean bl = false;
        if (this.m_theScrollBar != this.m_emptyScrollBar) {
            Dimension dimension = this.getSize();
            Dimension dimension2 = this.m_containerCount.getSize();
            Dimension dimension3 = this.m_filterIndicator.getSize();
            int n = dimension.width / 5;
            if (this.m_bCountOn) {
                if ((dimension2.width >= n || -1 == this.m_iCount) && this.RemoveCountFromStatusBar()) {
                    bl = true;
                }
            } else if (dimension2.width < n && -1 != this.m_iCount && this.AddCountToStatusBar()) {
                bl = true;
            }
            n = dimension.width / 4;
            if (this.m_bFilteredOn) {
                if (dimension3.width >= n && this.RemoveFilteredFromStatusBar()) {
                    bl = true;
                }
            } else if (dimension3.width < n && this.AddFilteredToStatusBar()) {
                bl = true;
            }
        } else {
            if (-1 != this.m_iCount) {
                if (this.AddCountToStatusBar()) {
                    bl = true;
                }
            } else if (this.RemoveCountFromStatusBar()) {
                bl = true;
            }
            if (this.AddFilteredToStatusBar()) {
                bl = true;
            }
        }
        if (bl) {
            this.validate();
            this.repaint();
        }
    }

    private boolean AddCountToStatusBar() {
        boolean bl = false;
        if (!this.m_bCountOn) {
            this.add(this.m_containerCount);
            this.m_bCountOn = true;
            bl = true;
        }
        return bl;
    }

    private boolean RemoveCountFromStatusBar() {
        boolean bl = false;
        if (this.m_bCountOn) {
            this.remove(this.m_containerCount);
            this.m_bCountOn = false;
            bl = true;
        }
        return bl;
    }

    private boolean AddFilteredToStatusBar() {
        boolean bl = false;
        if (!this.m_bFilteredOn) {
            this.add(this.m_filterIndicator);
            this.m_bFilteredOn = true;
            bl = true;
        }
        return bl;
    }

    private boolean RemoveFilteredFromStatusBar() {
        boolean bl = false;
        if (this.m_bFilteredOn) {
            this.remove(this.m_filterIndicator);
            this.m_bFilteredOn = false;
            bl = true;
        }
        return bl;
    }

    public VListStatusBar(VListContentPanel vListContentPanel) {
        if (VList.res == null) {
            this.m_strCountDescription = " items";
        } else {
            this.m_strCountDescription = (String)VList.res.getObject("VListItemKnownCountDescription");
            this.m_strTypeDownToolTip = (String)VList.res.getObject("VListTypeDownToolTip");
            this.m_strContainerCountToolTip = (String)VList.res.getObject("VListCountToolTip");
            this.m_strFilterIndicatorToolTip = (String)VList.res.getObject("VListFilteredToolTip");
            this.m_iScrollBarX = (Integer)VList.res.getObject("VListStatusBarScrollBarX");
            this.m_iScrollBarWidth = (Integer)VList.res.getObject("VListStatusBarScrollBarWidth");
            this.m_iCountX = (Integer)VList.res.getObject("VListStatusBarCountX");
            this.m_iCountWidth = (Integer)VList.res.getObject("VListStatusBarCountWidth");
            this.m_iFilteredX = (Integer)VList.res.getObject("VListStatusBarFilteredX");
            this.m_iFilteredWidth = (Integer)VList.res.getObject("VListStatusBarFilteredWidth");
            this.m_iTypeDownX = (Integer)VList.res.getObject("VListStatusBarTypeDownX");
            this.m_iTypeDownWidth = (Integer)VList.res.getObject("VListStatusBarTypeDownWidth");
            this.m_iTypeDownInitialColumns = (Integer)VList.res.getObject("VListStatusBarTypeDownInitialColumns");
        }
        this.m_typeDown = new JTextField(this.m_iTypeDownInitialColumns);
        this.m_dimTypeDownPreferredSize = this.m_typeDown.getPreferredSize();
        this.addComponentListener(this);
        this.m_contentPanel = vListContentPanel;
        this.m_filteredIcon = this.GetIcon(this.m_strFilteredImagePath);
        this.m_unFilteredIcon = this.GetIcon(this.m_strUnFilteredImagePath);
        this.m_filteredUnknownIcon = this.GetIcon(this.m_strUnknownFilteredImagePath);
        this.m_filterIndicator = new NonTraverseLabel(this.m_filteredUnknownIcon);
        this.m_countConstraints.gridx = this.m_iCountX;
        this.m_countConstraints.gridy = 0;
        this.m_countConstraints.gridwidth = this.m_iCountWidth;
        this.m_countConstraints.gridheight = 1;
        this.m_countConstraints.fill = 0;
        this.m_countConstraints.ipadx = 0;
        this.m_countConstraints.ipady = 0;
        this.m_countConstraints.insets = new Insets(0, 3, 0, 3);
        this.m_countConstraints.anchor = 17;
        this.m_countConstraints.weightx = 0.0;
        this.m_countConstraints.weighty = 0.0;
        this.gbl.setConstraints(this.m_containerCount, this.m_countConstraints);
        this.m_filterConstraints.gridx = this.m_iFilteredX;
        this.m_filterConstraints.gridy = 0;
        this.m_filterConstraints.gridwidth = this.m_iFilteredWidth;
        this.m_filterConstraints.gridheight = 1;
        this.m_filterConstraints.fill = 0;
        this.m_filterConstraints.ipadx = 0;
        this.m_filterConstraints.ipady = 0;
        this.m_filterConstraints.insets = new Insets(0, 3, 0, 3);
        this.m_filterConstraints.anchor = 17;
        this.m_filterConstraints.weightx = 0.0;
        this.gbl.setConstraints(this.m_filterIndicator, this.m_filterConstraints);
        this.m_typeDownConstraints.gridx = this.m_iTypeDownX;
        this.m_typeDownConstraints.gridy = 0;
        this.m_typeDownConstraints.gridwidth = this.m_iTypeDownWidth;
        this.m_typeDownConstraints.gridheight = 1;
        this.m_typeDownConstraints.fill = 0;
        this.m_typeDownConstraints.ipadx = 0;
        this.m_typeDownConstraints.ipady = 0;
        this.m_typeDownConstraints.insets = new Insets(0, 3, 0, 3);
        this.m_typeDownConstraints.anchor = 17;
        this.m_typeDownConstraints.weightx = 0.0;
        this.gbl.setConstraints(this.m_typeDown, this.m_typeDownConstraints);
        this.m_theScrollBar = this.m_emptyScrollBar;
        this.m_scrollBarConstraints.gridx = this.m_iScrollBarX;
        this.m_scrollBarConstraints.gridy = 0;
        this.m_scrollBarConstraints.gridwidth = this.m_iScrollBarWidth;
        this.m_scrollBarConstraints.gridheight = 1;
        this.m_scrollBarConstraints.fill = 2;
        this.m_scrollBarConstraints.ipadx = 0;
        this.m_scrollBarConstraints.ipady = 0;
        this.m_scrollBarConstraints.insets = new Insets(0, 0, 0, 3);
        this.m_scrollBarConstraints.anchor = 17;
        this.m_scrollBarConstraints.weightx = 1.0;
        this.m_scrollBarConstraints.weighty = 1.0;
        this.gbl.setConstraints(this.m_theScrollBar, this.m_scrollBarConstraints);
        if (this.m_strTypeDownToolTip != null) {
            this.m_typeDown.setToolTipText(this.m_strTypeDownToolTip);
        }
        if (this.m_strContainerCountToolTip != null) {
            this.m_containerCount.setToolTipText(this.m_strContainerCountToolTip);
        }
        if (this.m_strFilterIndicatorToolTip != null) {
            this.m_filterIndicator.setToolTipText(this.m_strFilterIndicatorToolTip);
        }
        this.setLayout(this.gbl);
        this.add(this.m_theScrollBar);
        this.add(this.m_filterIndicator);
        VListStatusBar vListStatusBar = this;
        if (vListStatusBar == null) {
            throw null;
        }
        this.m_typeDown.addKeyListener(new KeyListener(vListStatusBar){
            private final /* synthetic */ VListStatusBar this$0;

            public void keyPressed(KeyEvent keyEvent) {
                if (this.this$0.m_bTypeDownOn && (keyEvent.getKeyCode() == 27 || keyEvent.getKeyCode() == 10)) {
                    String string = this.this$0.m_typeDown.getText();
                    this.this$0.m_typeDown.setText("");
                    this.this$0.m_contentPanel.requestFocus();
                    if (string.length() != 0 && keyEvent.getKeyCode() != 27) {
                        this.this$0.m_contentPanel.moveTo(string);
                    }
                    this.this$0.endTypeDown();
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
            }
            {
                this.this$0 = vListStatusBar;
                this.constructor$0(vListStatusBar);
            }

            private final void constructor$0(VListStatusBar vListStatusBar) {
            }
        });
        VListStatusBar vListStatusBar2 = this;
        if (vListStatusBar2 == null) {
            throw null;
        }
        this.m_typeDown.addFocusListener(new FocusListener(vListStatusBar2){
            private final /* synthetic */ VListStatusBar this$0;

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
                if (this.this$0.m_bTypeDownOn) {
                    this.this$0.endTypeDown();
                }
            }
            {
                this.this$0 = vListStatusBar;
                this.constructor$0(vListStatusBar);
            }

            private final void constructor$0(VListStatusBar vListStatusBar) {
            }
        });
    }
}

