/*
 * Decompiled with CFR 0.152.
 */
package com.novell.utility.layouts;

import com.objectspace.jgl.adapters.VectorArray;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import java.util.Enumeration;

public class VerticalFlowLayout
implements LayoutManager2,
Serializable {
    public static final String CENTER = "Center";
    public static final String LEFT = "Left";
    public static final String RIGHT = "Right";
    private VectorArray m_components;
    private boolean m_bUniformWidths;
    private int m_vGap;
    private int m_externalPadLeft;
    private int m_externalPadRight;
    private int m_externalPadTop;
    private int m_externalPadBottom;
    private int m_internalPadX;
    private int m_internalPadY;
    private int m_widestWidth;
    private Dimension m_preferredSize;
    private Insets m_insets;
    private boolean m_bDirty = false;

    public void addLayoutComponent(String string, Component component) {
        VerticalFlowLayout verticalFlowLayout;
        if (component == null) {
            throw new IllegalArgumentException("Cannot add component: component is null.");
        }
        if (string == null || string.length() == 0) {
            string = LEFT;
        }
        if (string.equals(CENTER) || string.equals(LEFT) || string.equals(RIGHT)) {
            verticalFlowLayout = this;
            if (verticalFlowLayout == null) {
                throw null;
            }
        } else {
            throw new IllegalArgumentException("Cannot add component: constraint is invalid.");
        }
        AlignedComponent alignedComponent = verticalFlowLayout.new AlignedComponent(component, string);
        this.m_components.add((Object)alignedComponent);
        this.m_bDirty = true;
    }

    public void removeLayoutComponent(Component component) {
        if (component != null) {
            Enumeration enumeration = this.m_components.elements();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    AlignedComponent alignedComponent = (AlignedComponent)enumeration.nextElement();
                    Component component2 = alignedComponent.getComponent();
                    if (component != component2) continue;
                    this.m_components.remove((Object)alignedComponent);
                    this.m_bDirty = true;
                    break;
                }
            }
        } else {
            throw new IllegalArgumentException("Cannot remove component: component is null.");
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        return container.getSize();
    }

    public Dimension preferredLayoutSize(Container container) {
        if (this.m_insets == null || this.m_insets != container.getInsets()) {
            this.m_bDirty = true;
        }
        if (this.m_preferredSize == null || this.m_bDirty) {
            Enumeration enumeration;
            int n = 0;
            this.m_widestWidth = 0;
            this.m_preferredSize = null;
            int n2 = 0;
            int n3 = 0;
            this.m_insets = container.getInsets();
            if (this.m_insets != null) {
                n2 = this.m_insets.left + this.m_insets.right;
                n3 = this.m_insets.bottom + this.m_insets.top;
            }
            if ((enumeration = this.m_components.elements()) != null) {
                while (enumeration.hasMoreElements()) {
                    AlignedComponent alignedComponent = (AlignedComponent)enumeration.nextElement();
                    Dimension dimension = alignedComponent.getComponent().getPreferredSize();
                    int n4 = dimension.width;
                    if (n4 > this.m_widestWidth) {
                        this.m_widestWidth = n4;
                    }
                    n += dimension.height + this.m_internalPadY * 2 + this.m_vGap;
                }
                this.m_preferredSize = new Dimension(this.m_widestWidth + this.m_externalPadLeft + this.m_externalPadRight + this.m_internalPadX * 2, n + this.m_externalPadTop + this.m_externalPadBottom);
                this.m_preferredSize.width += n2;
                this.m_preferredSize.height += n3;
            } else {
                this.m_preferredSize = new Dimension(n2, n3);
            }
            this.m_bDirty = false;
        }
        return this.m_preferredSize;
    }

    public void layoutContainer(Container container) {
        Enumeration enumeration;
        Dimension dimension;
        int n = this.m_externalPadTop;
        int n2 = this.m_externalPadBottom;
        int n3 = this.m_externalPadLeft;
        int n4 = this.m_externalPadRight;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (this.m_insets == null || this.m_insets != container.getInsets()) {
            this.m_bDirty = true;
        }
        if (this.m_bDirty) {
            this.preferredLayoutSize(container);
        }
        if ((dimension = container.getMinimumSize()) != null) {
            n6 = dimension.width;
            n7 = dimension.height;
        }
        if (this.m_insets != null) {
            n += this.m_insets.top;
            n2 += this.m_insets.bottom;
            n3 += this.m_insets.left;
            n4 += this.m_insets.right;
        }
        if ((enumeration = this.m_components.elements()) != null) {
            while (enumeration.hasMoreElements()) {
                AlignedComponent alignedComponent = (AlignedComponent)enumeration.nextElement();
                Component component = alignedComponent.getComponent();
                String string = alignedComponent.getAlignment();
                if (!component.isVisible()) continue;
                int n8 = component.getPreferredSize().height + this.m_internalPadY * 2;
                n5 = this.m_bUniformWidths ? this.m_widestWidth + this.m_internalPadX * 2 : component.getPreferredSize().width + this.m_internalPadX * 2;
                if (string.equals(LEFT) || n6 == 0 || n5 > n6) {
                    component.setLocation(n3, n);
                } else if (string.equals(RIGHT)) {
                    component.setLocation(n6 - n4 - n5, n);
                } else {
                    int n9 = n3 + (n6 - n3 - n4) / 2;
                    component.setLocation(n9 - n5 / 2, n);
                }
                component.setSize(n5, n8);
                n += n8 + this.m_vGap;
            }
        }
    }

    public void addLayoutComponent(Component component, Object object) {
        if (object != null && !(object instanceof String)) {
            throw new IllegalArgumentException("cannot add to layout: constraint must be a string (or null)");
        }
        this.addLayoutComponent((String)object, component);
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
    }

    public boolean areWidthsUniform() {
        return this.m_bUniformWidths;
    }

    public int getVerticalGap() {
        return this.m_vGap;
    }

    public int getExternalPadLeft() {
        return this.m_externalPadLeft;
    }

    public int getExternalPadRight() {
        return this.m_externalPadRight;
    }

    public int getExternalPadTop() {
        return this.m_externalPadTop;
    }

    public int getExternalPadBottom() {
        return this.m_externalPadBottom;
    }

    public int getInternalPadX() {
        return this.m_internalPadX;
    }

    public int getInternalPadY() {
        return this.m_internalPadY;
    }

    public void setUniformWidths(boolean bl) {
        this.m_bUniformWidths = bl;
    }

    public void setVerticalGap(int n) {
        this.m_vGap = n;
    }

    public void setExternalPadLeft(int n) {
        this.m_externalPadLeft = n;
    }

    public void setExternalPadRight(int n) {
        this.m_externalPadRight = n;
    }

    public void setExternalPadTop(int n) {
        this.m_externalPadTop = n;
    }

    public void setExternalPadBottom(int n) {
        this.m_externalPadBottom = n;
    }

    public void setInternalPadX(int n) {
        this.m_internalPadX = n;
    }

    public void setInternalPadY(int n) {
        this.m_internalPadY = n;
    }

    public VerticalFlowLayout() {
        this.m_bUniformWidths = true;
        this.m_vGap = 5;
        this.m_externalPadLeft = 0;
        this.m_externalPadRight = 0;
        this.m_externalPadTop = 0;
        this.m_externalPadBottom = 0;
        this.m_internalPadX = 0;
        this.m_internalPadY = 0;
        this.m_components = new VectorArray();
    }

    public VerticalFlowLayout(boolean bl, int n) {
        this.m_bUniformWidths = bl;
        this.m_vGap = n;
        this.m_components = new VectorArray();
    }

    private class AlignedComponent {
        Component m_comp;
        String m_alignment;

        public Component getComponent() {
            return this.m_comp;
        }

        public String getAlignment() {
            return this.m_alignment;
        }

        public AlignedComponent(Component component, String string) {
            this.m_comp = component;
            this.m_alignment = string;
        }
    }
}

