/*
 * Decompiled with CFR 0.152.
 */
package com.novell.utility.mpec;

import com.novell.utility.mpec.Orientation;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class ColumnLayout
implements LayoutManager {
    private static int _defaultGap = 5;
    private int gap;
    private Orientation horizontalOrientation;
    private Orientation verticalOrientation;

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        Insets insets = container.getInsets();
        Dimension dimension = new Dimension(0, 0);
        int n = container.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            Component component = container.getComponent(n2);
            if (component.isVisible()) {
                Dimension dimension2 = component.getPreferredSize();
                if (n2 > 0) {
                    dimension.height += this.gap;
                }
                dimension.height += dimension2.height;
                dimension.width = Math.max(dimension2.width, dimension.width);
            }
            ++n2;
        }
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    public Dimension minimumLayoutSize(Container container) {
        Insets insets = container.getInsets();
        Dimension dimension = new Dimension(0, 0);
        int n = container.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            Component component = container.getComponent(n2);
            if (component.isVisible()) {
                Dimension dimension2 = component.getMinimumSize();
                dimension.width = Math.max(dimension2.width, dimension.width);
                dimension.height += dimension2.height;
                if (n2 > 0) {
                    dimension.height += this.gap;
                }
            }
            ++n2;
        }
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int n = insets.top;
        int n2 = 0;
        int n3 = container.getComponentCount();
        Dimension dimension = container.getPreferredSize();
        Dimension dimension2 = container.getSize();
        if (this.verticalOrientation == Orientation.CENTER) {
            n += dimension2.height / 2 - dimension.height / 2;
        } else if (this.verticalOrientation == Orientation.BOTTOM) {
            n = dimension2.height - dimension.height + insets.top;
        }
        int n4 = 0;
        while (n4 < n3) {
            Component component = container.getComponent(n4);
            n2 = insets.left;
            if (component.isVisible()) {
                Dimension dimension3 = component.getPreferredSize();
                if (this.horizontalOrientation == Orientation.CENTER) {
                    n2 = dimension2.width / 2 - dimension3.width / 2;
                } else if (this.horizontalOrientation == Orientation.RIGHT) {
                    n2 = dimension2.width - dimension3.width - insets.right;
                }
                component.setBounds(n2, n, dimension3.width, dimension3.height);
                n += dimension3.height + this.gap;
            }
            ++n4;
        }
    }

    public ColumnLayout() {
        this(Orientation.CENTER, Orientation.CENTER, _defaultGap);
    }

    public ColumnLayout(int n) {
        this(Orientation.CENTER, Orientation.CENTER, n);
    }

    public ColumnLayout(Orientation orientation, Orientation orientation2) {
        this(orientation, orientation2, _defaultGap);
    }

    public ColumnLayout(Orientation orientation, Orientation orientation2, int n) {
        this.gap = n;
        this.verticalOrientation = orientation2;
        this.horizontalOrientation = orientation;
    }
}

