/*
 * Decompiled with CFR 0.152.
 */
package com.novell.utility.mpec;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

class TempCardLayout
implements LayoutManager,
Serializable {
    Hashtable tab = new Hashtable();

    public void addLayoutComponent(String string, Component component) {
        if (this.tab.size() > 0) {
            component.setVisible(false);
        } else {
            component.setVisible(true);
        }
        this.tab.put(string, component);
    }

    public void removeLayoutComponent(Component component) {
        Enumeration enumeration = this.tab.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (this.tab.get(string) != component) continue;
            this.tab.remove(string);
            return;
        }
    }

    public Dimension preferredLayoutSize(Container container) {
        Insets insets = container.getInsets();
        int n = container.getComponentCount();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            Component component = container.getComponent(n4);
            Dimension dimension = component.getPreferredSize();
            if (dimension.width > n2) {
                n2 = dimension.width;
            }
            if (dimension.height > n3) {
                n3 = dimension.height;
            }
            ++n4;
        }
        return new Dimension(insets.left + insets.right + n2, insets.top + insets.bottom + n3);
    }

    public Dimension minimumLayoutSize(Container container) {
        Insets insets = container.getInsets();
        int n = container.getComponentCount();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            Component component = container.getComponent(n4);
            Dimension dimension = component.getMinimumSize();
            if (dimension.width > n2) {
                n2 = dimension.width;
            }
            if (dimension.height > n3) {
                n3 = dimension.height;
            }
            ++n4;
        }
        return new Dimension(insets.left + insets.right + n2, insets.top + insets.bottom + n3);
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int n = container.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            Component component = container.getComponent(n2);
            if (component.isVisible()) {
                Dimension dimension = container.getSize();
                component.setBounds(insets.left, insets.top, dimension.width - (insets.left + insets.right), dimension.height - (insets.top + insets.bottom));
            }
            ++n2;
        }
    }

    void checkLayout(Container container) {
        if (container.getLayout() != this) {
            throw new IllegalArgumentException("wrong parent for CardLayout");
        }
    }

    public void show(Container container, String string) {
        this.checkLayout(container);
        Component component = (Component)this.tab.get(string);
        if (component != null && !component.isVisible()) {
            int n = container.getComponentCount();
            int n2 = 0;
            while (n2 < n) {
                Component component2 = container.getComponent(n2);
                if (component2.isVisible()) {
                    component2.setVisible(false);
                    break;
                }
                ++n2;
            }
            component.setVisible(true);
            container.validate();
        }
    }

    public String toString() {
        return this.getClass().getName();
    }

    TempCardLayout() {
    }
}

