/*
 * Decompiled with CFR 0.152.
 */
package com.novell.utility.nmsgbox;

import com.novell.application.console.shell.D;
import com.novell.application.console.shell.ShellStubs;
import com.novell.application.console.snapin.NConeFactory;
import com.novell.application.console.testing.C1Automation;
import com.novell.application.console.testing.C1Hooks;
import com.novell.application.console.widgets.NDialog;
import com.novell.application.console.widgets.NUniformFlowLayout;
import com.novell.application.console.widgets.NWrapLabel;
import com.novell.utility.localization.Loc;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class NMsgBox
extends NDialog
implements ActionListener,
KeyListener,
ImageObserver,
C1Automation {
    private static ResourceBundle res = null;
    public static final int CONFIRM = 0;
    public static final int INFO = 1;
    public static final int WARN = 2;
    public static final int ERROR = 3;
    public static final int WARN_ALL = 4;
    public static final int WARN_WITH_CANCEL = 5;
    public static final int WARN_ALL_WITH_CANCEL = 6;
    public static final int WARN_PROMPT_WITH_CANCEL = 7;
    public static final int ERROR_IGNORE = 8;
    public static final int OK = 1;
    public static final int CANCEL = 2;
    public static final int CLOSE = 4;
    public static final int YES = 8;
    public static final int NO = 16;
    public static final int DETAILS = 32;
    public static final int YES_ALL = 64;
    public static final int NO_ALL = 128;
    public static final int PROMPT = 256;
    public static final int IGNORE = 512;
    public static final int IGNORE_ALL = 1024;
    private static final String errorImageKey = "ErrorAnim.gif";
    private static final String warnImageKey = "WarnAnim.gif";
    private static final String warnAllImageKey = "WarnAnim.gif";
    private static final String infoImageKey = "InfoAnim.gif";
    private static final String confirmImageKey = "ConfirmAnim.gif";
    private static final String imageLocationKey = "/com/novell/utility/nmsgbox/images/";
    private Frame parentFrame;
    private String helpSetName;
    private String helpID;
    private String msg;
    private JButton okButton;
    private JButton cancelButton;
    private JButton closeButton;
    private JButton yesButton;
    private JButton noButton;
    private JButton yesAllButton;
    private JButton noAllButton;
    private JButton detailsButton;
    private JButton ignoreButton;
    private JButton ignoreAllButton;
    private JButton promptButton;
    private JButton defaultButton = null;
    private JButton currentButton = null;
    private JPanel buttonsPanel;
    private Image image;
    private JLabel imageLabel = new JLabel("@");
    private boolean requestedFocus = false;
    private boolean internalSetVisibleCachedState;
    private int setupCachedType;
    private int pressedButton = 2;
    private String sTitle;

    public static String getBundleName() {
        return "com.novell.utility.nmsgbox.resources.NMsgBoxResourceBundle";
    }

    public static void setBundle(ResourceBundle resourceBundle) {
        res = resourceBundle;
    }

    private void setup(Component component, String string, String string2, int n) {
        this.setupCachedType = n;
        if (component instanceof Frame) {
            this.parentFrame = (Frame)component;
        }
        if (string2 == null) {
            string2 = "";
        }
        this.msg = string2;
        C1Hooks.registerWindow((Window)((Object)this));
        ((Component)((Object)this)).setName("NMsgBox");
        this.sTitle = string;
        NMsgBox nMsgBox = this;
        if (nMsgBox == null) {
            throw null;
        }
        Runnable runnable = new Runnable(nMsgBox){
            private final /* synthetic */ NMsgBox this$0;

            public void run() {
                Container container = ((JDialog)((Object)this.this$0)).getContentPane();
                container.setLayout(new BorderLayout());
                NWrapLabel nWrapLabel = new NWrapLabel(NMsgBox.access$0(this.this$0), false);
                container.add("Center", (Component)nWrapLabel);
                int n = NMsgBox.access$2(this.this$0, NMsgBox.access$1(this.this$0));
                NMsgBox.access$3(this.this$0).setBorder(BorderFactory.createEmptyBorder(0, 0, NMsgBox.getInt("MsgBoxSpaceBelowImageKey"), NMsgBox.getInt("MsgBoxSpaceBetweenImageAndTextKey")));
                container.add("West", NMsgBox.access$3(this.this$0));
                container.add("South", NMsgBox.access$4(this.this$0, n));
                if (container instanceof JComponent) {
                    int n2 = NMsgBox.getInt("MsgBoxInsetGapKey");
                    ((JComponent)container).setBorder(BorderFactory.createEmptyBorder(n2, n2, n2, n2));
                }
                ((Window)((Object)this.this$0)).pack();
                ((Dialog)((Object)this.this$0)).setResizable(false);
            }
            {
                this.this$0 = nMsgBox;
                this.constructor$0(nMsgBox);
            }

            private final void constructor$0(NMsgBox nMsgBox) {
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                D.out("+++NMsgBox: Error -- Couldn't invokeAndWait the setup");
            }
        }
    }

    private int getButtonFlags(int n) {
        int n2 = 0;
        switch (n) {
            case 2: {
                this.createImageLabel(this, "WarnAnim.gif");
                n2 = 24;
                break;
            }
            case 4: {
                this.createImageLabel(this, "WarnAnim.gif");
                n2 = 216;
                break;
            }
            case 5: {
                this.createImageLabel(this, "WarnAnim.gif");
                n2 = 26;
                break;
            }
            case 6: {
                this.createImageLabel(this, "WarnAnim.gif");
                n2 = 218;
                break;
            }
            case 7: {
                this.createImageLabel(this, "WarnAnim.gif");
                n2 = 282;
                break;
            }
            case 8: {
                this.createImageLabel(this, errorImageKey);
                n2 = 1538;
                break;
            }
            case 0: {
                this.createImageLabel(this, confirmImageKey);
                n2 = 24;
                break;
            }
            case 3: {
                this.createImageLabel(this, errorImageKey);
                n2 = 4;
                break;
            }
            default: {
                this.createImageLabel(this, infoImageKey);
                n2 = 1;
                break;
            }
        }
        if (this.helpSetName != null) {
            n2 |= 0x20;
        }
        return n2;
    }

    public Component add(Component component) {
        return this.buttonsPanel.add(component);
    }

    public Dimension getPreferredSize() {
        int n;
        Dimension dimension = super.getPreferredSize();
        FontMetrics fontMetrics = null;
        Font font = null;
        Font font2 = null;
        int n2 = 0;
        int n3 = NMsgBox.getInt("MsgBoxMaxWidestCharsPerTitleKey");
        if (((Dialog)((Object)this)).getTitle() != null) {
            font = ((Component)((Object)this)).getFont();
            font2 = new Font(font.getName(), 3, font.getSize() + 2);
            fontMetrics = ((Component)((Object)this)).getFontMetrics(font2);
            n2 = fontMetrics.stringWidth(((Dialog)((Object)this)).getTitle());
            int n4 = fontMetrics.stringWidth(NMsgBox.getString("WidestCharacterKey"));
            n = n4 * n3;
            n2 = Math.min(n, n2);
        }
        JDialog jDialog = new JDialog((Dialog)((Object)this), " ");
        jDialog.getContentPane().setLayout(new BorderLayout());
        jDialog.getContentPane().add("Center", new JLabel(""));
        jDialog.setResizable(false);
        jDialog.pack();
        n = jDialog.getPreferredSize().width;
        jDialog.dispose();
        if (n2 + n > dimension.width) {
            dimension.width = n2 + n;
        }
        return dimension;
    }

    private void createImageLabel(Object object, String string) {
        this.image = null;
        String string2 = imageLocationKey;
        string = string.replace(':', '_');
        String string3 = new String(string2 + string);
        URL uRL = object.getClass().getResource(string3);
        try {
            this.image = Toolkit.getDefaultToolkit().createImage((ImageProducer)uRL.getContent());
            this.imageLabel = new JLabel(new ImageIcon(this.image));
        }
        catch (Exception exception) {
            D.out("+++NMsgBox: Error -- Couldn't create image " + string + "...");
        }
    }

    static String getString(String string) {
        return res.getString(string);
    }

    static int getInt(String string) {
        Integer n = (Integer)res.getObject(string);
        return n;
    }

    static Font getFont(String string) {
        return (Font)res.getObject(string);
    }

    public int launch() {
        this.setVisible(true);
        return this.getPressedButton();
    }

    public void setVisible(boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            super.setVisible(bl);
        } else {
            this.internalSetVisibleCachedState = bl;
            NMsgBox nMsgBox = this;
            if (nMsgBox == null) {
                throw null;
            }
            Runnable runnable = new Runnable(nMsgBox){
                private final /* synthetic */ NMsgBox this$0;

                public void run() {
                    NMsgBox.access$6(this.this$0, NMsgBox.access$5(this.this$0));
                }
                {
                    this.this$0 = nMsgBox;
                    this.constructor$0(nMsgBox);
                }

                private final void constructor$0(NMsgBox nMsgBox) {
                }
            };
            if (((Dialog)((Object)this)).isModal()) {
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (Exception exception) {
                    D.out("+++NMsgBox: Error -- Couldn't invokeAndWait with setVisible method");
                }
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    private void internalSetVisible(boolean bl) {
        super.setVisible(bl);
    }

    public void paint(Graphics graphics) {
        if (!this.requestedFocus) {
            if (this.defaultButton != null) {
                NConeFactory.novellJButton(this.defaultButton, this.msg + "\t" + this.defaultButton.getName(), "");
                this.defaultButton.requestFocus();
            }
            this.requestedFocus = true;
        }
        super.paint(graphics);
    }

    public int getPressedButton() {
        return this.pressedButton;
    }

    private JPanel getButtonPanel(int n) {
        Component[] componentArray;
        NUniformFlowLayout nUniformFlowLayout = new NUniformFlowLayout();
        this.buttonsPanel = new JPanel((LayoutManager)nUniformFlowLayout);
        nUniformFlowLayout.setExternalPadTop(NMsgBox.getInt("MsgBoxSpaceAboveButtonsKey"));
        nUniformFlowLayout.setExternalPadBottom(0);
        nUniformFlowLayout.setInternalPadY(0);
        if ((n & 8) == 8) {
            this.yesButton = new JButton();
            this.yesButton.setName("Yes");
            Loc.setText(this.yesButton, NMsgBox.getString("yesKey"));
            this.buttonsPanel.add(this.yesButton);
            this.yesButton.addActionListener(this);
            this.yesButton.addKeyListener(this);
            this.defaultButton = this.yesButton;
            NMsgBox nMsgBox = this;
            if (nMsgBox == null) {
                throw null;
            }
            this.yesButton.addFocusListener(nMsgBox.new buttonFocusListener());
            NConeFactory.novellJButton(this.yesButton, this.yesButton.getName(), "");
        }
        if ((n & 0x40) == 64) {
            this.yesAllButton = new JButton();
            this.yesAllButton.setName("YesToAll");
            Loc.setText(this.yesAllButton, NMsgBox.getString("yesAllKey"));
            this.buttonsPanel.add(this.yesAllButton);
            this.yesAllButton.addActionListener(this);
            this.yesAllButton.addKeyListener(this);
            NMsgBox nMsgBox = this;
            if (nMsgBox == null) {
                throw null;
            }
            this.yesAllButton.addFocusListener(nMsgBox.new buttonFocusListener());
            NConeFactory.novellJButton(this.yesAllButton, this.yesAllButton.getName(), "");
        }
        if ((n & 0x10) == 16) {
            this.noButton = new JButton();
            this.noButton.setName("No");
            Loc.setText(this.noButton, NMsgBox.getString("noKey"));
            this.buttonsPanel.add(this.noButton);
            this.noButton.addActionListener(this);
            this.noButton.addKeyListener(this);
            NMsgBox nMsgBox = this;
            if (nMsgBox == null) {
                throw null;
            }
            this.noButton.addFocusListener(nMsgBox.new buttonFocusListener());
            NConeFactory.novellJButton(this.noButton, this.noButton.getName(), "");
        }
        if ((n & 0x80) == 128) {
            this.noAllButton = new JButton();
            this.noAllButton.setName("NoToAll");
            Loc.setText(this.noAllButton, NMsgBox.getString("noAllKey"));
            this.buttonsPanel.add(this.noAllButton);
            this.noAllButton.addActionListener(this);
            this.noAllButton.addKeyListener(this);
            NMsgBox nMsgBox = this;
            if (nMsgBox == null) {
                throw null;
            }
            this.noAllButton.addFocusListener(nMsgBox.new buttonFocusListener());
            NConeFactory.novellJButton(this.noAllButton, this.noAllButton.getName(), "");
        }
        if ((n & 1) == 1) {
            this.okButton = new JButton();
            this.okButton.setName("OK");
            Loc.setText(this.okButton, NMsgBox.getString("okKey"));
            this.buttonsPanel.add(this.okButton);
            this.okButton.addActionListener(this);
            this.okButton.addKeyListener(this);
            this.defaultButton = this.okButton;
            NMsgBox nMsgBox = this;
            if (nMsgBox == null) {
                throw null;
            }
            this.okButton.addFocusListener(nMsgBox.new buttonFocusListener());
            NConeFactory.novellJButton(this.okButton, this.okButton.getName(), "");
        }
        if ((n & 4) == 4) {
            this.closeButton = new JButton();
            this.closeButton.setName("Close");
            Loc.setText(this.closeButton, NMsgBox.getString("closeKey"));
            this.buttonsPanel.add(this.closeButton);
            this.closeButton.addActionListener(this);
            this.closeButton.addKeyListener(this);
            this.defaultButton = this.closeButton;
            NMsgBox nMsgBox = this;
            if (nMsgBox == null) {
                throw null;
            }
            this.closeButton.addFocusListener(nMsgBox.new buttonFocusListener());
            NConeFactory.novellJButton(this.closeButton, this.closeButton.getName(), "");
        }
        if ((n & 0x100) == 256) {
            this.promptButton = new JButton();
            this.promptButton.setName("Prompt");
            Loc.setText(this.promptButton, NMsgBox.getString("promptKey"));
            this.buttonsPanel.add(this.promptButton);
            this.promptButton.addActionListener(this);
            this.promptButton.addKeyListener(this);
            NMsgBox nMsgBox = this;
            if (nMsgBox == null) {
                throw null;
            }
            this.promptButton.addFocusListener(nMsgBox.new buttonFocusListener());
            NConeFactory.novellJButton(this.promptButton, this.promptButton.getName(), "");
        }
        if ((n & 0x200) == 512) {
            this.ignoreButton = new JButton();
            this.ignoreButton.setName("Ignore");
            Loc.setText(this.ignoreButton, NMsgBox.getString("ignoreKey"));
            Loc.setText(this.ignoreButton, NMsgBox.getString("ignoreKey"));
            this.buttonsPanel.add(this.ignoreButton);
            this.ignoreButton.addActionListener(this);
            this.ignoreButton.addKeyListener(this);
            this.defaultButton = this.ignoreButton;
            NMsgBox nMsgBox = this;
            if (nMsgBox == null) {
                throw null;
            }
            this.ignoreButton.addFocusListener(nMsgBox.new buttonFocusListener());
            NConeFactory.novellJButton(this.ignoreButton, this.ignoreButton.getName(), "");
        }
        if ((n & 0x400) == 1024) {
            this.ignoreAllButton = new JButton();
            this.ignoreAllButton.setName("IgnoreAll");
            Loc.setText(this.ignoreButton, NMsgBox.getString("ignoreKey"));
            this.buttonsPanel.add(this.ignoreAllButton);
            this.ignoreAllButton.addActionListener(this);
            this.ignoreAllButton.addKeyListener(this);
            NMsgBox nMsgBox = this;
            if (nMsgBox == null) {
                throw null;
            }
            this.ignoreAllButton.addFocusListener(nMsgBox.new buttonFocusListener());
            NConeFactory.novellJButton(this.ignoreAllButton, this.ignoreAllButton.getName(), "");
        }
        if ((n & 2) == 2) {
            this.cancelButton = new JButton();
            this.cancelButton.setName("Cancel");
            Loc.setText(this.cancelButton, NMsgBox.getString("cancelKey"));
            this.buttonsPanel.add(this.cancelButton);
            this.cancelButton.addActionListener(this);
            this.cancelButton.addKeyListener(this);
            NMsgBox nMsgBox = this;
            if (nMsgBox == null) {
                throw null;
            }
            this.cancelButton.addFocusListener(nMsgBox.new buttonFocusListener());
            NConeFactory.novellJButton(this.cancelButton, this.cancelButton.getName(), "");
        }
        if ((n & 0x20) == 32) {
            this.detailsButton = new JButton();
            this.detailsButton.setName("Details");
            Loc.setText(this.detailsButton, NMsgBox.getString("detailsKey"));
            Loc.setText(this.detailsButton, NMsgBox.getString("detailsKey"));
            this.buttonsPanel.add(this.detailsButton);
            this.detailsButton.addActionListener(this);
            this.detailsButton.addKeyListener(this);
            NMsgBox nMsgBox = this;
            if (nMsgBox == null) {
                throw null;
            }
            this.detailsButton.addFocusListener(nMsgBox.new buttonFocusListener());
            NConeFactory.novellJButton(this.detailsButton, this.detailsButton.getName(), "");
        }
        if (this.defaultButton == null && (componentArray = this.buttonsPanel.getComponents()) != null) {
            int n2 = 0;
            while (n2 < componentArray.length) {
                if (componentArray[n2] instanceof JButton) {
                    this.defaultButton = (JButton)componentArray[n2];
                    break;
                }
                ++n2;
            }
        }
        return this.buttonsPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JButton) {
            this.buttonPressed((JButton)object);
        }
        super.actionPerformed(actionEvent);
    }

    public void dispose() {
        super.dispose();
        if (this.image != null) {
            this.image.flush();
            this.image = null;
        }
    }

    private void buttonPressed(JButton jButton) {
        if (jButton == this.okButton) {
            this.pressedButton = 1;
            this.dispose();
        } else if (jButton == this.yesButton) {
            this.pressedButton = 8;
            this.dispose();
        } else if (jButton == this.noButton) {
            this.pressedButton = 16;
            this.dispose();
        } else if (jButton == this.yesAllButton) {
            this.pressedButton = 64;
            this.dispose();
        } else if (jButton == this.noAllButton) {
            this.pressedButton = 128;
            this.dispose();
        } else if (jButton == this.closeButton) {
            this.pressedButton = 4;
            this.dispose();
        } else if (jButton == this.cancelButton) {
            this.pressedButton = 2;
            this.dispose();
        } else if (jButton == this.ignoreButton) {
            this.pressedButton = 512;
            this.dispose();
        } else if (jButton == this.ignoreAllButton) {
            this.pressedButton = 1024;
            this.dispose();
        } else if (jButton == this.detailsButton) {
            this.help();
        } else if (jButton == this.promptButton) {
            this.pressedButton = 256;
            this.dispose();
        }
    }

    protected void help() {
        if (this.helpSetName != null && this.helpID != null) {
            try {
                ShellStubs.launchHelp(this.helpSetName, this.helpID, (Window)((Object)this));
            }
            catch (Exception exception) {
                NMsgBox nMsgBox = new NMsgBox(this.parentFrame, NMsgBox.getString("helpErrorKey"), NMsgBox.getString("helpConnectionKey"), 3);
                nMsgBox.setVisible(true);
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        Object object;
        if ((keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 32) && (object = keyEvent.getSource()) instanceof JButton) {
            this.buttonPressed((JButton)object);
        }
    }

    public Vector c1AutomationInvoke(Vector vector) {
        String string = (String)vector.elementAt(0);
        Vector<Object> vector2 = new Vector<Object>();
        if (string.equalsIgnoreCase("getTitle")) {
            vector2.addElement(this.sTitle);
        } else if (string.equalsIgnoreCase("getText")) {
            vector2.addElement(this.msg);
        } else {
            vector2.addElement(new Integer(-1));
            vector2.addElement("NMSgBox::c1AutomationInvoke: Unsupported API: " + string);
        }
        return vector2;
    }

    static /* synthetic */ int access$1(NMsgBox nMsgBox) {
        return nMsgBox.setupCachedType;
    }

    static /* synthetic */ int access$2(NMsgBox nMsgBox, int n) {
        return nMsgBox.getButtonFlags(n);
    }

    static /* synthetic */ JLabel access$3(NMsgBox nMsgBox) {
        return nMsgBox.imageLabel;
    }

    static /* synthetic */ JPanel access$4(NMsgBox nMsgBox, int n) {
        return nMsgBox.getButtonPanel(n);
    }

    static /* synthetic */ boolean access$5(NMsgBox nMsgBox) {
        return nMsgBox.internalSetVisibleCachedState;
    }

    static /* synthetic */ void access$6(NMsgBox nMsgBox, boolean bl) {
        nMsgBox.internalSetVisible(bl);
    }

    public NMsgBox(Component component, String string, String string2, int n, String string3, String string4) {
        super(component, string, true);
        this.helpSetName = string3;
        this.helpID = string4;
        this.setup(component, string, string2, n);
    }

    public NMsgBox(Component component, String string, String string2, int n, String string3) {
        super(component, string, true);
        this.helpSetName = string3;
        this.helpID = null;
        this.setup(component, string, string2, n);
    }

    public NMsgBox(Component component, String string, String string2, int n) {
        super(component, string, true);
        this.helpSetName = null;
        this.helpID = null;
        this.setup(component, string, string2, n);
    }

    static {
        try {
            res = ResourceBundle.getBundle(NMsgBox.getBundleName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class buttonFocusListener
    implements FocusListener {
        public void focusGained(FocusEvent focusEvent) {
            Object object = focusEvent.getSource();
            if (!(object instanceof JButton) || NMsgBox.this.currentButton == null) {
                return;
            }
            if (NMsgBox.this.currentButton.equals(object)) {
                NConeFactory.novellJButton(NMsgBox.this.currentButton, NMsgBox.this.msg + "\t" + NMsgBox.this.currentButton.getName(), "");
            } else {
                NConeFactory.novellJButton(NMsgBox.this.currentButton, NMsgBox.this.currentButton.getName(), "");
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            Object object = focusEvent.getSource();
            if (!(object instanceof JButton)) {
                return;
            }
            NMsgBox.this.currentButton = (JButton)object;
        }

        buttonFocusListener() {
        }
    }
}

