/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.common;

import com.novell.gw.admin.common.DefaultErrorDialog;
import com.novell.gw.admin.common.ErrorDescription;
import com.novell.gw.admin.common.ErrorDialog;
import com.novell.gw.admin.common.ErrorInterpreter;
import com.novell.gw.admin.common.ErrorLog;
import com.novell.gw.admin.common.ErrorReport;
import com.novell.gw.admin.common.MessageOptions;
import com.novell.gw.util.Debug;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Vector;

public class ErrorHandler {
    protected static ErrorDialog errorDlg = new DefaultErrorDialog();
    protected static ErrorLog errorLog = null;
    protected static String errorHeader = null;
    protected static Vector errorInterpreters = new Vector();

    public static void setErrorDialog(ErrorDialog errorDialog) {
        errorDlg = errorDialog;
    }

    public static void setDialogHeader(String string) {
        errorHeader = string;
    }

    public static String getDialogHeader() {
        return errorHeader;
    }

    public static void setErrorLog(ErrorLog errorLog) {
        ErrorHandler.errorLog = errorLog;
    }

    public static void addErrorInterpreter(ErrorInterpreter errorInterpreter) {
        errorInterpreters.addElement(errorInterpreter);
    }

    public static int handleError(Component component, Exception exception, String string, String string2, int n) {
        return ErrorHandler.handleError(component, exception, string, new MessageOptions(n, string2));
    }

    public static int handleError(Component component, Exception exception, String string, String string2, Object[] objectArray, Object object) {
        return ErrorHandler.handleError(component, exception, string, new MessageOptions(objectArray, object, string2));
    }

    public static int handleError(Component component, Exception exception, String string, MessageOptions messageOptions) {
        if (Debug.assrtTag) {
            Debug.assrtPrecondition((errorDlg != null ? 1 : 0) != 0, (String)"Error Dialog not initialized");
        }
        ErrorReport errorReport = ErrorHandler.buildErrorReport(exception, string);
        if (messageOptions != null) {
            errorReport.setOptions(messageOptions);
        }
        Debug.trace((String)"ErrorHandler.handleError: about to display dialog");
        return errorDlg.show(component, errorHeader, errorReport);
    }

    public static int reportError(Component component, String string, Object[] objectArray, String string2, Object[] objectArray2, String string3, MessageOptions messageOptions) {
        if (Debug.assrtTag) {
            Debug.assrtPrecondition((errorDlg != null ? 1 : 0) != 0, (String)"Error Dialog not initialized");
        }
        if (objectArray != null) {
            string = MessageFormat.format(string, objectArray);
        }
        if (objectArray2 != null) {
            string2 = MessageFormat.format(string2, objectArray2);
        }
        ErrorReport errorReport = ErrorHandler.buildErrorReport(string2, string3, string);
        if (messageOptions != null) {
            errorReport.setOptions(messageOptions);
        }
        return errorDlg.show(component, errorHeader, errorReport);
    }

    public static int reportError(String string, Object[] objectArray, MessageOptions messageOptions) {
        return ErrorHandler.reportError(null, null, null, string, objectArray, null, messageOptions);
    }

    public static int reportError(Component component, String string, String string2, MessageOptions messageOptions) {
        return ErrorHandler.reportError(component, string, null, string2, null, null, messageOptions);
    }

    public static int reportError(String string, String string2, MessageOptions messageOptions) {
        return ErrorHandler.reportError(null, string, null, string2, null, null, messageOptions);
    }

    public static int reportError(String string) {
        return ErrorHandler.reportError(null, null, null, string, null, null, null);
    }

    private static ErrorReport buildErrorReport(Exception exception, String string) {
        ErrorReport errorReport = new ErrorReport();
        ErrorDescription errorDescription = null;
        Enumeration enumeration = errorInterpreters.elements();
        while (enumeration.hasMoreElements()) {
            ErrorInterpreter errorInterpreter = (ErrorInterpreter)enumeration.nextElement();
            if (!errorInterpreter.handles(exception)) continue;
            errorDescription = errorInterpreter.getErrorDescription(exception);
            break;
        }
        if (Debug.assrtTag) {
            Debug.assrt((errorDescription != null ? 1 : 0) != 0, (String)("ErrorHandler -> No ErrorInterpreter installed to handle\n" + exception.toString()));
        }
        errorReport.setDetails(errorDescription);
        if (string != null) {
            errorDescription.setContextMessage(string);
        }
        return errorReport;
    }

    private static ErrorReport buildErrorReport(String string, String string2, String string3) {
        ErrorDescription errorDescription = new ErrorDescription(string, string3, string2, null);
        ErrorReport errorReport = new ErrorReport();
        errorReport.setDetails(errorDescription);
        return errorReport;
    }
}

