/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.ui;

import com.novell.application.console.snapin.NConeFactory;
import com.novell.application.console.widgets.NDateTimeControl;
import com.novell.application.console.widgets.events.TimeControlListener;
import com.novell.gw.admin.ui.DsuiLayout;
import com.novell.gw.admin.ui.DsuiResource;
import com.novell.gw.admin.ui.DsuiView;
import com.novell.gw.admin.widgets.WC;
import com.novell.utility.localization.Loc;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemListener;
import java.util.Date;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DateTimeEditor
extends DsuiView {
    protected NDateTimeControl dateCtrl;
    protected JCheckBox enableBox;
    private JLabel label;
    private JDialog parent;
    protected boolean showEnableBox = true;

    public DateTimeEditor() {
        this(new DsuiLayout(), null, true);
    }

    public DateTimeEditor(JDialog jDialog) {
        this(new DsuiLayout(), jDialog, true);
    }

    public DateTimeEditor(JDialog jDialog, boolean bl) {
        this(new DsuiLayout(), jDialog, bl);
    }

    public DateTimeEditor(DsuiLayout dsuiLayout, JDialog jDialog, boolean bl) {
        this.parent = jDialog;
        this.showEnableBox = bl;
        String string = new String(DsuiResource.getString("DateTimeEditorEnableLabel"));
        this.setLayout(dsuiLayout);
        this.label = new JLabel();
        this.dateCtrl = jDialog != null ? new NDateTimeControl((Component)jDialog) : new NDateTimeControl((Component)this);
        this.dateCtrl.clear();
        JTextField jTextField = this.dateCtrl.getTextField();
        jTextField.setOpaque(false);
        jTextField.setMargin(WC.JTXT_FLD_MARGIN);
        this.enableBox = new JCheckBox(string);
        NConeFactory.novellJCheckBox((JCheckBox)this.enableBox, (String)(Loc.removeHotChar((String)this.label.getText()) + string), (String)"");
        this.add((Component)this.label, DsuiLayout.LABEL);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        if (bl) {
            jPanel.add((Component)this.enableBox, "West");
            this.updateEnabledDate();
        } else {
            this.enableBox.setSelected(true);
        }
        jPanel.add((Component)this.dateCtrl, "Center");
        this.add((Component)jPanel, DsuiLayout.FIELD);
    }

    public Object getEventDispatcher() {
        return this;
    }

    public void setLabel(String string) {
        this.label.setText(string);
    }

    public void addTimeControlListener(TimeControlListener timeControlListener) {
        this.dateCtrl.addTimeControlListener(timeControlListener);
    }

    public void addItemListener(ItemListener itemListener) {
        this.enableBox.addItemListener(itemListener);
    }

    public boolean isDateEnableSelected() {
        return this.enableBox.isSelected();
    }

    public void setEnabled(boolean bl) {
        this.enableBox.setEnabled(bl);
        this.updateEnabledDate();
    }

    public void setLabelEnabled(boolean bl) {
        this.label.setEnabled(bl);
    }

    public void setLabelVisible(boolean bl) {
        this.label.setVisible(bl);
    }

    public void updateEnabledDate() {
        boolean bl = this.enableBox.isSelected();
        this.dateCtrl.setEnabled(bl);
        if (this.showEnableBox && bl && !this.dateCtrl.isDataValid()) {
            this.dateCtrl.reset();
        }
    }

    public void setValue(Object object) {
        int n = 0;
        if (object instanceof Integer) {
            n = (Integer)object;
        }
        if (n > 0) {
            this.setDate(n);
            this.dateCtrl.reset();
            if (!this.enableBox.isSelected()) {
                this.enableBox.setSelected(true);
            }
        } else {
            this.dateCtrl.clear();
            if (this.showEnableBox && this.enableBox.isSelected()) {
                this.enableBox.setSelected(false);
            }
        }
    }

    protected void setDate(int n) {
        long l = (long)n * 1000L;
        this.dateCtrl.setDate(new Date(l));
    }

    public Object getValue() {
        if (this.dateCtrl.isEnabled() && this.dateCtrl.isDataValid()) {
            return this.getDate();
        }
        return new Integer(0);
    }

    protected Integer getDate() {
        Date date = this.dateCtrl.getDate();
        int n = (int)(date.getTime() / 1000L);
        return new Integer(n);
    }
}

