/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.ui;

import com.novell.gw.admin.ui.Dsui;
import com.novell.gw.admin.ui.DsuiAttrDescriptor;
import com.novell.gw.admin.ui.DsuiController;
import com.novell.gw.admin.ui.DsuiModel;
import com.novell.gw.admin.ui.DsuiResource;
import com.novell.gw.admin.ui.DsuiView;
import com.novell.gw.util.Debug;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.JPanel;

public class DsuiGroup {
    protected GridBagConstraints gbc;
    protected Box box;
    protected JPanel panel;
    protected DsuiModel model;

    public DsuiGroup(DsuiModel dsuiModel) {
        this.model = dsuiModel;
        this.box = Box.createVerticalBox();
    }

    public DsuiGroup(DsuiModel dsuiModel, String string) {
        this(dsuiModel);
        this.addDsuiResourceGroup(string);
    }

    public void addDsuiResourceGroup(String string) {
        String string2;
        try {
            string2 = DsuiResource.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            string2 = "";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            String string4 = DsuiResource.getString(string3 + ".label");
            String string5 = DsuiResource.getString(string3 + ".editor");
            String string6 = DsuiResource.getString(string5 + ".controller");
            Dsui dsui = new Dsui(new DsuiAttrDescriptor(string3, string4), this.model, (DsuiView)this.newInstance(string5), (DsuiController)this.newInstance(string6));
            this.box.add(dsui.getView());
        }
    }

    public void addDsui(DsuiAttrDescriptor dsuiAttrDescriptor) {
        Dsui dsui = new Dsui(dsuiAttrDescriptor, this.model);
        this.box.add(dsui.getView());
    }

    public void addDsui(DsuiAttrDescriptor dsuiAttrDescriptor, DsuiView dsuiView) {
        Dsui dsui = new Dsui(dsuiAttrDescriptor, this.model, dsuiView);
        this.box.add(dsui.getView());
    }

    public void addDsui(DsuiAttrDescriptor dsuiAttrDescriptor, DsuiView dsuiView, DsuiController dsuiController) {
        Dsui dsui = new Dsui(dsuiAttrDescriptor, this.model, dsuiView, dsuiController);
        this.box.add(dsui.getView());
    }

    public void addVerticalSpacing(int n) {
        Component component = Box.createRigidArea(new Dimension(2, n));
        this.box.add(component);
    }

    public void setEnabled(boolean bl) {
        for (int i = 0; i < this.box.getComponentCount(); ++i) {
            DsuiView dsuiView = (DsuiView)this.box.getComponent(i);
            dsuiView.setDsuiEnabledWithRights(bl);
        }
    }

    public Box getView() {
        return this.box;
    }

    private Object newInstance(String string) {
        try {
            return Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            Debug.trace((String)("Dsui exception caught: " + exception));
            return null;
        }
    }
}

