/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class DsuiLayout
extends GridBagLayout {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final Integer LABEL = new Integer(0);
    public static final Integer FIELD = new Integer(1);
    public static final int DEFAULT_WIDTH = 100;
    public static final int DEFAULT_HEIGHT = 21;
    public static final double DEFAULT_FIELD_WEIGHT = 0.65;
    public boolean useDsuiWidth = true;
    public int orientation;
    public int preferredWidth;
    public int preferredHeight = 0;
    public double labelWeight;
    public double fieldWeight;
    private static final GridBagConstraints labelGbc = new GridBagConstraints();
    private static final GridBagConstraints fieldGbc;
    private static final GridBagConstraints vertLabelGbc;
    private static final GridBagConstraints vertFieldGbc;

    public DsuiLayout() {
        this(0.65, 100, 0);
    }

    public DsuiLayout(int n) {
        this(0.65, 100, n);
    }

    public DsuiLayout(double d) {
        this(d, 100, 0);
    }

    public DsuiLayout(double d, int n) {
        this(d, n, 0);
    }

    public DsuiLayout(double d, int n, int n2) {
        this.orientation = n2;
        this.preferredWidth = n > 0 ? n : 100;
        this.fieldWeight = d > 0.0 && d < 1.0 ? d : 0.65;
        this.labelWeight = 1.0 - this.fieldWeight;
    }

    public void addLayoutComponent(Component component, Object object) {
        if (component instanceof JComponent) {
            boolean bl;
            JComponent jComponent = (JComponent)component;
            Dimension dimension = jComponent.getPreferredSize();
            boolean bl2 = this.preferredHeight > 0;
            boolean bl3 = bl = this.useDsuiWidth || bl2;
            if (bl2) {
                dimension.height = this.preferredHeight;
            } else if (dimension.height == 0) {
                dimension.height = 21;
            }
            if (object.equals(LABEL)) {
                if (this.useDsuiWidth) {
                    dimension.width = (int)((double)this.preferredWidth * this.labelWeight);
                }
                if (bl) {
                    jComponent.setPreferredSize(dimension);
                }
                DsuiLayout.labelGbc.weightx = this.labelWeight;
                if (this.orientation == 0) {
                    super.addLayoutComponent(jComponent, labelGbc);
                } else {
                    super.addLayoutComponent(jComponent, vertLabelGbc);
                }
            } else if (object.equals(FIELD)) {
                if (this.useDsuiWidth) {
                    dimension.width = (int)((double)this.preferredWidth * this.fieldWeight);
                }
                if (bl) {
                    jComponent.setPreferredSize(dimension);
                }
                DsuiLayout.fieldGbc.weightx = this.fieldWeight;
                if (this.orientation == 0) {
                    super.addLayoutComponent(jComponent, fieldGbc);
                } else {
                    super.addLayoutComponent(jComponent, vertFieldGbc);
                }
            }
        } else {
            Container container = component.getParent();
            container.remove(component);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.add(component, "Center");
            container.add((Component)jPanel, object);
        }
    }

    static {
        DsuiLayout.labelGbc.anchor = 17;
        DsuiLayout.labelGbc.gridx = 0;
        DsuiLayout.labelGbc.insets = new Insets(2, 0, 3, 0);
        DsuiLayout.labelGbc.weightx = 1.0;
        DsuiLayout.labelGbc.weighty = 1.0;
        DsuiLayout.labelGbc.fill = 2;
        fieldGbc = new GridBagConstraints();
        DsuiLayout.fieldGbc.anchor = 17;
        DsuiLayout.fieldGbc.gridx = 1;
        DsuiLayout.fieldGbc.insets = new Insets(2, 0, 3, 0);
        DsuiLayout.fieldGbc.weightx = 1.0;
        DsuiLayout.fieldGbc.weighty = 1.0;
        DsuiLayout.fieldGbc.fill = 2;
        vertLabelGbc = new GridBagConstraints();
        DsuiLayout.vertLabelGbc.anchor = 17;
        DsuiLayout.vertLabelGbc.gridx = 0;
        DsuiLayout.vertLabelGbc.insets = new Insets(2, 0, 0, 0);
        DsuiLayout.vertLabelGbc.weightx = 1.0;
        DsuiLayout.vertLabelGbc.fill = 2;
        vertFieldGbc = new GridBagConstraints();
        DsuiLayout.vertFieldGbc.anchor = 17;
        DsuiLayout.vertFieldGbc.gridx = 0;
        DsuiLayout.vertFieldGbc.insets = new Insets(0, 0, 3, 0);
        DsuiLayout.vertFieldGbc.weightx = 1.0;
        DsuiLayout.vertFieldGbc.fill = 2;
    }
}

