/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.ui;

import com.novell.application.console.snapin.NConeFactory;
import com.novell.gw.admin.ui.DsuiLayout;
import com.novell.gw.admin.ui.DsuiResource;
import com.novell.gw.admin.ui.DsuiView;
import com.novell.gw.admin.widgets.IncrementBox;
import com.novell.utility.localization.Loc;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.MissingResourceException;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TimeIntervalEditor
extends DsuiView
implements PropertyChangeListener {
    public static final double DEFAULT_SECOND_LABEL_WEIGHT = 0.7;
    public static final String TIME_INTERVAL = "TIME INTERVAL";
    private IncrementBox hoursIncBox;
    private IncrementBox minsIncBox;
    private JLabel hoursLabel;
    private JLabel minsLabel;
    private JLabel label;
    private int oldValue = 0;

    public TimeIntervalEditor() {
        this(new DsuiLayout(), 0.7, 0, Integer.MAX_VALUE);
    }

    public TimeIntervalEditor(double d) {
        this(new DsuiLayout(), d, 0, Integer.MAX_VALUE);
    }

    public TimeIntervalEditor(DsuiLayout dsuiLayout) {
        this(dsuiLayout, 0.7, 0, Integer.MAX_VALUE);
    }

    public TimeIntervalEditor(DsuiLayout dsuiLayout, double d) {
        this(dsuiLayout, d, 0, Integer.MAX_VALUE);
    }

    public TimeIntervalEditor(int n, int n2) {
        this(new DsuiLayout(), 0.7, n, n2);
    }

    public TimeIntervalEditor(DsuiLayout dsuiLayout, int n, int n2) {
        this(dsuiLayout, 0.7, n, n2);
    }

    public TimeIntervalEditor(DsuiLayout dsuiLayout, double d, int n, int n2) {
        this.setLayout(dsuiLayout);
        this.label = new JLabel();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.hoursIncBox = new IncrementBox(0, 23, 0);
        this.hoursIncBox.setHorizontalAlignment(4);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0 - d;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.hoursIncBox, gridBagConstraints);
        jPanel.add(Box.createHorizontalStrut(5));
        this.hoursLabel = NConeFactory.novellJLabel((JLabel)new JLabel(DsuiResource.getString("Hours")), (String)DsuiResource.getString("Hours"), (String)"This is a label");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = d;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.hoursLabel, gridBagConstraints);
        this.minsIncBox = new IncrementBox(0, 59, 0);
        this.minsIncBox.setHorizontalAlignment(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0 - d;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.minsIncBox, gridBagConstraints);
        jPanel.add(Box.createHorizontalStrut(5));
        this.minsLabel = NConeFactory.novellJLabel((JLabel)new JLabel(DsuiResource.getString("Minutes")), (String)DsuiResource.getString("Minutes"), (String)"This is a label");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = d;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.minsLabel, gridBagConstraints);
        this.add((Component)this.label, DsuiLayout.LABEL);
        this.add((Component)jPanel, DsuiLayout.FIELD);
        this.hoursIncBox.addPropertyChangeListener(this);
        this.minsIncBox.addPropertyChangeListener(this);
    }

    public Object getEventDispatcher() {
        return this;
    }

    public Object getValue() {
        int n = this.hoursIncBox.getValue() * 60;
        return new Integer(n += this.minsIncBox.getValue());
    }

    public Object getHoursValue() {
        int n = this.hoursIncBox.getValue();
        return new Integer(n);
    }

    public Object getMinutesValue() {
        int n = this.minsIncBox.getValue();
        return new Integer(n);
    }

    public void setEnabled(boolean bl) {
        this.hoursIncBox.setEnabled(bl);
        this.minsIncBox.setEnabled(bl);
    }

    public void setLabel(String string) {
        this.label.setText(string);
        try {
            NConeFactory.novellJLabel((JLabel)this.label, (String)string, (String)"");
            NConeFactory.novellJTextField((JTextField)this.hoursIncBox.getTextField(), (String)Loc.removeHotChar((String)(this.label.getText() + DsuiResource.getString("Hours"))), (String)"");
            NConeFactory.novellJTextField((JTextField)this.minsIncBox.getTextField(), (String)Loc.removeHotChar((String)(this.label.getText() + DsuiResource.getString("Minutes"))), (String)"");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    public void setLabelEnabled(boolean bl) {
        this.label.setEnabled(bl);
        this.hoursLabel.setEnabled(bl);
        this.minsLabel.setEnabled(bl);
    }

    public void setValue(Object object) {
        if (object != null) {
            int n;
            if (object instanceof Integer) {
                n = (Integer)object;
            } else {
                try {
                    n = Integer.parseInt(object.toString());
                }
                catch (ClassCastException classCastException) {
                    n = 0;
                }
            }
            this.hoursIncBox.setValue(n / 60);
            this.minsIncBox.setValue(n % 60);
            NConeFactory.makeRelation((JLabel)this.label, (JTextField)this.hoursIncBox.getTextField());
            NConeFactory.novellJTextField((JTextField)this.hoursIncBox.getTextField(), (String)(Loc.removeHotChar((String)this.label.getText()) + " " + Loc.removeHotChar((String)this.hoursLabel.getText())), (String)"");
        }
    }

    public void setHoursMax(int n) {
        this.hoursIncBox.setBounds(0, n);
    }

    public void setMinutesMax(int n) {
        this.minsIncBox.setBounds(0, n);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        int n = this.hoursIncBox.getValue() * 60;
        this.firePropertyChange(TIME_INTERVAL, this.oldValue, n += this.minsIncBox.getValue());
        this.oldValue = n;
    }
}

