/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.ui;

import com.novell.application.console.snapin.NConeFactory;
import com.novell.gw.admin.ui.DsuiLayout;
import com.novell.gw.admin.ui.DsuiView;
import com.novell.gw.admin.widgets.GWComboBox;
import com.novell.gw.ds.ExtendedDirContext;
import com.novell.gw.util.Debug;
import java.awt.Component;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchResult;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class TimeZoneEditor
extends DsuiView {
    private JLabel label;
    private GWComboBox cb;
    private String valueCache;
    private Vector timeZones;
    private Vector tzCodes;
    private ExtendedDirContext ictx;

    public TimeZoneEditor(ExtendedDirContext extendedDirContext) {
        this.ictx = extendedDirContext;
        this.setLayout(new DsuiLayout());
        this.label = new JLabel();
        this.cb = new GWComboBox();
        this.cb.setLightWeightPopupEnabled(false);
        this.add((Component)this.label, DsuiLayout.LABEL);
        this.add((Component)this.cb, DsuiLayout.FIELD);
        this.timeZones = new Vector();
        this.tzCodes = new Vector();
    }

    public Object getEventDispatcher() {
        return this.cb;
    }

    public void setLabel(String string) {
        this.label.setText(string);
        NConeFactory.makeRelation((JLabel)this.label, (JComboBox)this.cb);
        this.loadTimeZones();
        this.buildList();
    }

    public void setEnabled(boolean bl) {
        this.cb.setEnabled(bl);
    }

    public void setValue(Object object) {
        if (object != null) {
            int n = 0;
            try {
                this.valueCache = new String(object.toString());
                n = this.tzCodes.indexOf(this.valueCache);
            }
            catch (Exception exception) {
                return;
            }
            this.cb.setSelectedIndex(n);
        }
    }

    public Object getValue() {
        return this.tzCodes.elementAt(this.cb.getSelectedIndex());
    }

    private void buildList() {
        this.cb.removeAllItems();
        int n = this.timeZones.size();
        for (int i = 0; i < n; ++i) {
            this.cb.addItem((String)this.timeZones.elementAt(i));
        }
    }

    private void loadTimeZones() {
        if (this.ictx == null) {
            return;
        }
        try {
            String[] stringArray = new String[]{String.valueOf(50032)};
            BasicAttributes basicAttributes = new BasicAttributes();
            basicAttributes.put("Search Index", new Integer(238));
            basicAttributes.put(String.valueOf("Search New Record Type"), new Integer(103));
            NamingEnumeration namingEnumeration = this.ictx.search("", (Attributes)basicAttributes, stringArray);
            while (namingEnumeration.hasMore()) {
                String string;
                int n;
                SearchResult searchResult = (SearchResult)namingEnumeration.next();
                Attributes attributes = searchResult.getAttributes();
                Attribute attribute = attributes.get(stringArray[0]);
                if (attribute == null) continue;
                String string2 = (String)attribute.get();
                int n2 = this.timeZones.size();
                for (n = 0; n < n2 && string2.compareToIgnoreCase(string = (String)this.timeZones.elementAt(n)) >= 0; ++n) {
                }
                this.timeZones.insertElementAt(string2, n);
                this.tzCodes.insertElementAt(searchResult.getName(), n);
            }
        }
        catch (NamingException namingException) {
            Debug.trace((String)("Exception reading domain time zones.\n" + namingException));
        }
    }
}

