/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.ui.mvc;

import com.novell.application.console.snapin.NConeFactory;
import com.novell.application.console.widgets.NDateTimeControl;
import com.novell.application.console.widgets.events.TimeControlEvent;
import com.novell.application.console.widgets.events.TimeControlListener;
import com.novell.gw.admin.ui.DsuiResource;
import com.novell.gw.admin.ui.mvc.MvcControl;
import com.novell.gw.admin.ui.mvc.MvcModel;
import com.novell.gw.admin.widgets.WC;
import com.novell.utility.localization.Loc;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Date;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class DateTimeControl
extends MvcControl
implements ItemListener,
TimeControlListener {
    private JLabel label;
    protected JCheckBox enableBox;
    protected NDateTimeControl dateCtrl;
    private JPanel panel = new JPanel();

    public DateTimeControl(MvcModel mvcModel, JDialog jDialog, boolean bl) {
        super(mvcModel);
        Object object;
        this.panel.setLayout(new BorderLayout());
        String string = mvcModel.getLabel();
        if (bl) {
            object = new String(DsuiResource.getString("DateTimeEditorEnableLabel"));
            this.enableBox = new JCheckBox((String)object);
            this.enableBox.getAccessibleContext().setAccessibleName(Loc.removeHotChar((String)((String)object + " " + string)));
            this.panel.add((Component)this.enableBox, "West");
        }
        this.dateCtrl = new NDateTimeControl((Component)jDialog);
        this.dateCtrl.clear();
        object = this.dateCtrl.getTextField();
        ((JComponent)object).setOpaque(false);
        ((JTextComponent)object).setMargin(WC.JTXT_FLD_MARGIN);
        ((JTextField)object).getAccessibleContext().setAccessibleName(Loc.removeHotChar((String)string));
        this.panel.add((Component)this.dateCtrl, "Center");
        this.init();
        this.dateCtrl.addTimeControlListener((TimeControlListener)this);
        if (this.enableBox != null) {
            this.enableBox.addItemListener(this);
        }
    }

    public JLabel getLabel() {
        if (this.label == null) {
            this.label = new JLabel(this.model.getLabel());
            NConeFactory.makeRelation((JLabel)this.label, (NDateTimeControl)this.dateCtrl);
            this.label.setEnabled(this.enableBox.isEnabled());
        }
        return this.label;
    }

    public JComponent getControl() {
        return this.panel;
    }

    protected void setEnabled(boolean bl) {
        if (this.label != null) {
            this.label.setEnabled(bl);
        }
        if (this.enableBox != null) {
            this.enableBox.setEnabled(bl);
        }
        this.updateEnabledDate(bl);
    }

    private void updateEnabledDate(boolean bl) {
        this.dateCtrl.setEnabled(bl);
        if (this.enableBox != null && bl && !this.dateCtrl.isDataValid()) {
            this.dateCtrl.reset();
        }
    }

    protected void updateView(Object object) {
        boolean bl;
        int n = 0;
        if (object instanceof Integer) {
            n = (Integer)object;
        }
        boolean bl2 = bl = n > 0;
        if (bl) {
            this.setDate(n);
            this.dateCtrl.reset();
        } else {
            this.dateCtrl.clear();
        }
        if (this.enableBox != null && this.enableBox.isSelected()) {
            this.enableBox.setSelected(bl);
        }
    }

    protected void setDate(int n) {
        long l = (long)n * 1000L;
        this.dateCtrl.setDate(new Date(l));
    }

    public void timeControlChanged(TimeControlEvent timeControlEvent) {
        this.viewChanged();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl = this.enableBox.isSelected();
        this.updateEnabledDate(bl);
        this.viewChanged();
    }

    private void viewChanged() {
        Integer n = null;
        if (this.dateCtrl.isEnabled() && this.dateCtrl.isDataValid()) {
            n = this.getDate();
        }
        this.viewChanged(n);
    }

    protected Integer getDate() {
        Date date = this.dateCtrl.getDate();
        int n = (int)(date.getTime() / 1000L);
        return new Integer(n);
    }
}

