/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.ui.mvc;

import com.novell.application.console.snapin.NConeFactory;
import com.novell.gw.admin.ui.mvc.MvcControl;
import com.novell.gw.admin.ui.mvc.MvcModel;
import com.novell.gw.admin.widgets.GWTextField;
import com.novell.gw.admin.widgets.RB;
import com.novell.gw.admin.widgets.TCPAddressEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class IpControl
extends MvcControl
implements ActionListener {
    private String dlgTitle;
    private JLabel label;
    private JDialog parent;
    private JButton editButton;
    private GWTextField idomField;
    private JPanel panel;

    public IpControl(MvcModel mvcModel, JDialog jDialog, String string) {
        super(mvcModel);
        this.parent = jDialog;
        this.dlgTitle = string;
        this.initComponents();
        this.init();
        this.editButton.addActionListener(this);
    }

    private void initComponents() {
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.idomField = new GWTextField();
        this.idomField.setOpaque(false);
        this.idomField.setEditable(false);
        this.panel.add((Component)this.idomField, "Center");
        int n = this.idomField.getPreferredSize().height;
        this.editButton = RB.getIconButton("edit.gif");
        this.editButton.getAccessibleContext().setAccessibleName(RB.getString("EditImageKey"));
        this.editButton.setPreferredSize(new Dimension(n, n));
        this.panel.add((Component)this.editButton, "East");
    }

    public JComponent getControl() {
        return this.panel;
    }

    public JLabel getLabel() {
        if (this.label == null) {
            this.label = new JLabel(this.model.getLabel());
            NConeFactory.makeRelation((JLabel)this.label, (JTextField)this.idomField);
            this.label.setEnabled(this.idomField.isEnabled());
        }
        return this.label;
    }

    protected void setEnabled(boolean bl) {
        this.idomField.setEnabled(bl);
        this.editButton.setEnabled(bl);
        if (this.label != null) {
            this.label.setEnabled(bl);
        }
    }

    protected void updateView(Object object) {
        this.idomField.setText((String)object);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        IpDlg ipDlg = new IpDlg();
        ipDlg.setLocationRelativeTo(this.panel);
        ipDlg.show();
    }

    private class IpDlg
    extends JDialog
    implements ActionListener,
    ChangeListener {
        private TCPAddressEditor tcpEditor;
        private JButton okButton;
        private JButton cancelButton;

        public IpDlg() {
            super(IpControl.this.parent, IpControl.this.dlgTitle, true);
            this.initComponents();
            this.fillFields();
            this.addActions();
            this.pack();
        }

        private void initComponents() {
            Container container = this.getContentPane();
            container.setLayout(new GridBagLayout());
            this.tcpEditor = new TCPAddressEditor();
            this.tcpEditor.setPreferredSize(new Dimension(350, this.tcpEditor.getPreferredSize().height));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(10, 10, 0, 10);
            container.add((Component)this.tcpEditor, gridBagConstraints);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(1, 0, 5, 0));
            this.okButton = RB.getUnsizedButton("okKey");
            this.okButton.setEnabled(false);
            this.okButton.addActionListener(this);
            jPanel.add(this.okButton);
            this.cancelButton = RB.getUnsizedButton("cancelKey");
            this.cancelButton.addActionListener(this);
            jPanel.add(this.cancelButton);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 13;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.insets = new Insets(20, 10, 10, 10);
            container.add((Component)jPanel, gridBagConstraints);
            this.getRootPane().setDefaultButton(this.okButton);
            this.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ IpDlg this$1;
                {
                    this.this$1 = ipDlg;
                }

                public void windowOpened(WindowEvent windowEvent) {
                    IpDlg.access$200(this.this$1).requestFocus();
                }
            });
        }

        private void fillFields() {
            String string = (String)IpControl.this.model.getValue();
            if (string != null) {
                this.tcpEditor.setValue(string);
            }
        }

        private void addActions() {
            this.tcpEditor.addChangeListener(this);
        }

        private void updateOkButton() {
            boolean bl = this.tcpEditor.isAddressValid();
            if (!bl) {
                bl = this.tcpEditor.getValue().equals("");
            }
            this.okButton.setEnabled(bl);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.updateOkButton();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.okButton) {
                IpControl.this.viewChanged(this.tcpEditor.getValue());
                IpControl.this.updateView(this.tcpEditor.getValue());
                this.dispose();
            } else if (object == this.cancelButton) {
                this.dispose();
            }
        }

        static /* synthetic */ TCPAddressEditor access$200(IpDlg ipDlg) {
            return ipDlg.tcpEditor;
        }
    }
}

