/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.ui.mvc;

import com.novell.gw.admin.ui.mvc.MvcModel;
import com.novell.gw.admin.ui.mvc.MvcModelListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;

public abstract class MvcControl
implements MvcModelListener {
    private boolean updatingView = false;
    private boolean updatingModel = false;
    protected MvcModel model;

    public abstract JLabel getLabel();

    public abstract JComponent getControl();

    protected abstract void setEnabled(boolean var1);

    protected abstract void updateView(Object var1);

    public MvcControl(MvcModel mvcModel) {
        this.model = mvcModel;
        mvcModel.addModelListener(this);
    }

    public final void requestEnabled(boolean bl) {
        this.setEnabled(bl &= this.model.canWrite());
    }

    protected void init() {
        this.updateView(this.model.getValue());
        this.requestEnabled(this.model.canWrite());
    }

    protected final void viewChanged(Object object) {
        if (!this.updatingView) {
            this.updatingModel = true;
            this.model.setValue(object);
            this.updatingModel = false;
        }
    }

    public final void modelChanged() {
        if (!this.updatingModel) {
            this.updatingView = true;
            Object object = this.model.getValue();
            this.updateView(object);
            this.updatingView = false;
        }
    }

    public void addToContainer(Container container, int n, int n2) {
        this.addToContainer(container, n, n2, 0);
    }

    public void addToContainer(Container container, int n, int n2, int n3) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = n;
        gridBagConstraints.insets = new Insets(n2, n3, 0, 0);
        container.add((Component)this.getLabel(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = n;
        gridBagConstraints.insets = new Insets(n2, 10, 0, 0);
        gridBagConstraints.weightx = 1.0;
        container.add((Component)this.getControl(), gridBagConstraints);
    }
}

