/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.ui.mvc;

import com.novell.application.console.snapin.NConeFactory;
import com.novell.gw.admin.ui.mvc.MvcControl;
import com.novell.gw.admin.ui.mvc.MvcModel;
import com.novell.gw.admin.widgets.IncrementBox;
import com.novell.utility.localization.Loc;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class NumericControl
extends MvcControl
implements PropertyChangeListener {
    private IncrementBox incrementBox;
    private JLabel label;
    private JLabel unitsLabel;
    private JPanel panel = new JPanel();

    public NumericControl(MvcModel mvcModel) {
        this(mvcModel, 0, Integer.MAX_VALUE);
    }

    public NumericControl(MvcModel mvcModel, int n, int n2) {
        super(mvcModel);
        this.panel.setLayout(new GridBagLayout());
        this.incrementBox = new IncrementBox(n, n2, 0);
        this.incrementBox.setHorizontalAlignment(4);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panel.add((Component)this.incrementBox, gridBagConstraints);
        this.unitsLabel = new JLabel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panel.add((Component)this.unitsLabel, gridBagConstraints);
        this.init();
        this.incrementBox.addPropertyChangeListener(this);
    }

    public JComponent getControl() {
        return this.panel;
    }

    public JLabel getLabel() {
        if (this.label == null) {
            this.label = new JLabel(this.model.getLabel());
            this.label.setEnabled(this.incrementBox.isEnabled());
        }
        return this.label;
    }

    public void setUnitsLabel(String string) {
        this.unitsLabel.setText(string);
    }

    public void setInterval(int n) {
        this.incrementBox.setInterval(n);
    }

    protected void setEnabled(boolean bl) {
        this.incrementBox.setEnabled(bl);
        this.unitsLabel.setEnabled(bl);
        if (this.label != null) {
            this.label.setEnabled(bl);
        }
    }

    protected void updateView(Object object) {
        int n = 0;
        if (object != null) {
            n = (Integer)object;
        }
        this.incrementBox.setValue(n);
        NConeFactory.makeRelation((JLabel)this.getLabel(), (JTextField)this.incrementBox.getTextField());
        NConeFactory.novellJTextField((JTextField)this.incrementBox.getTextField(), (String)(Loc.removeHotChar((String)this.label.getText()) + " " + Loc.removeHotChar((String)this.unitsLabel.getText())), (String)"");
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        int n = this.incrementBox.getValue();
        this.viewChanged(new Integer(n));
    }

    public void addToContainer(Container container, int n, int n2, int n3) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = n;
        gridBagConstraints.insets = new Insets(n2, n3, 0, 0);
        container.add((Component)this.getLabel(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = n;
        gridBagConstraints.insets = new Insets(n2, 10, 0, 0);
        gridBagConstraints.weightx = 1.0;
        container.add((Component)this.getControl(), gridBagConstraints);
    }
}

