/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.widgets;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.HexValue;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.nds.NDSAttributeDefinition;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSObjectAttribute;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.application.console.snapin.NConeFactory;
import com.novell.application.console.snapin.PageSnapin;
import com.novell.application.console.snapin.PropertyBook;
import com.novell.application.console.snapin.Shell;
import com.novell.application.console.snapin.SnapinVetoException;
import com.novell.gw.admin.widgets.BlackoutSchedule;
import com.novell.gw.admin.widgets.GridBox;
import com.novell.gw.util.Debug;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Enumeration;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BlackoutPanel
extends JPanel
implements PropertyChangeListener,
ItemListener,
ChangeListener {
    private GridBox[] gridbox = new GridBox[7];
    private JLabel[] labels = new JLabel[7];
    private BlackoutSchedule pollSchedule = new BlackoutSchedule();
    private String attrName;
    private JCheckBox disableCheckbox;
    private JRadioButton useGroupSchedule;
    private JRadioButton useThisSchedule;
    private GridBoxPanel gbp;
    private boolean onMonitorServer = false;
    private boolean ignorePropertyBook = true;
    private NSObject nsObj = null;
    private Shell shell = null;
    private PropertyBook thePropBook = null;
    private PageSnapin snapin = null;
    private NDSNamespace ns = null;

    public BlackoutPanel() {
        this(null, null, null, null, "POLL_BLACKOUT");
    }

    public BlackoutPanel(NSObject nSObject, Shell shell, PropertyBook propertyBook, PageSnapin pageSnapin, String string) {
        super(new GridBagLayout(), true);
        this.nsObj = nSObject;
        this.shell = shell;
        this.thePropBook = propertyBook;
        this.snapin = pageSnapin;
        this.attrName = string;
        if (shell != null) {
            this.ns = (NDSNamespace)shell.getTreeSelectionNamespace();
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.useGroupSchedule = new JRadioButton("GroupBlackout");
        this.useGroupSchedule = NConeFactory.novellJRadioButton((JRadioButton)this.useGroupSchedule, (String)"GroupBlackout", (String)"");
        this.useGroupSchedule.setMnemonic(71);
        this.useGroupSchedule.addChangeListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        ((GridBagLayout)this.getLayout()).setConstraints(this.useGroupSchedule, gridBagConstraints);
        this.add(this.useGroupSchedule);
        this.useThisSchedule = new JRadioButton("ThisBlackout");
        this.useThisSchedule = NConeFactory.novellJRadioButton((JRadioButton)this.useThisSchedule, (String)"ThisBlackout", (String)"");
        this.useThisSchedule.setMnemonic(84);
        this.useThisSchedule.addChangeListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        ((GridBagLayout)this.getLayout()).setConstraints(this.useThisSchedule, gridBagConstraints);
        this.add(this.useThisSchedule);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.useThisSchedule);
        buttonGroup.add(this.useGroupSchedule);
        this.gbp = new GridBoxPanel(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.weighty = 10.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 3;
        ((GridBagLayout)this.getLayout()).setConstraints(this.gbp, gridBagConstraints);
        this.add(this.gbp);
        this.disableCheckbox = NConeFactory.novellJCheckBox((JCheckBox)new JCheckBox("DisableBlackout"), (String)"DisableBlackout", (String)"");
        this.disableCheckbox.setMnemonic(68);
        this.disableCheckbox.addChangeListener(this);
        this.disableCheckbox.setVerticalAlignment(1);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(8, 3, 0, 0);
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 3;
        ((GridBagLayout)this.getLayout()).setConstraints(this.disableCheckbox, gridBagConstraints);
        this.add(this.disableCheckbox);
        JPanel jPanel = NConeFactory.novellJPanel((JPanel)new JPanel(), (String)"", (String)"");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 2.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        ((GridBagLayout)this.getLayout()).setConstraints(jPanel, gridBagConstraints);
        this.add(jPanel);
        if (nSObject != null && nSObject.getObjectEntry().getObjectType().getName().equals("MONITOR_SERVER")) {
            this.onMonitorServer = true;
            this.useThisSchedule.setSelected(true);
            this.useThisSchedule.setVisible(false);
            this.useGroupSchedule.setVisible(false);
        }
        if (!this.readSchedule()) {
            (this.onMonitorServer ? this.useThisSchedule : this.useGroupSchedule).setSelected(true);
        }
        this.ignorePropertyBook = false;
    }

    public void setRangeValues(int[][] nArray) {
        for (int i = 0; i < 7; ++i) {
            this.gridbox[i].setRangeValues(nArray[i]);
        }
    }

    public int[][] getRangeValues() {
        int[][] nArrayArray = new int[7][];
        for (int i = 0; i < 7; ++i) {
            int[] nArray = this.gridbox[i].getRangeValues();
            nArrayArray[i] = new int[nArray.length];
            System.arraycopy(nArray, 0, nArrayArray[i], 0, nArray.length);
        }
        return nArrayArray;
    }

    private boolean readSchedule() {
        Enumeration enumeration;
        boolean bl = false;
        ObjectAttribute objectAttribute = null;
        if (this.nsObj != null) {
            objectAttribute = this.nsObj.getAttribute(this.attrName);
        }
        if (objectAttribute != null && (enumeration = objectAttribute.getValueComponents()).hasMoreElements()) {
            bl = true;
            HexValue hexValue = (HexValue)((ValueComponent)enumeration.nextElement());
            byte[] byArray = hexValue.getValue();
            if (byArray != null && byArray.length > 0) {
                try {
                    this.pollSchedule.setBlackoutValues(byArray);
                }
                catch (IOException iOException) {
                    System.out.println(iOException);
                }
                int n = this.pollSchedule.getBlackoutUsage();
                switch (n) {
                    case 3: {
                        if (!this.onMonitorServer) {
                            this.useThisSchedule.setSelected(true);
                            this.useThisSchedule.setEnabled(false);
                            this.useGroupSchedule.setEnabled(false);
                        }
                        this.disableCheckbox.setSelected(true);
                        break;
                    }
                    case 1: {
                        if (this.onMonitorServer) {
                            this.useThisSchedule.setSelected(true);
                            break;
                        }
                        this.useGroupSchedule.setSelected(true);
                        break;
                    }
                    case 2: {
                        this.useThisSchedule.setSelected(true);
                        break;
                    }
                    default: {
                        Debug.trace((String)"invalid data");
                    }
                }
                this.setRangeValues(this.pollSchedule.getBlackoutRanges());
            }
        }
        return bl;
    }

    public boolean saveData() throws NamespaceException, ComponentCreationException, SPIException, SnapinVetoException {
        int[][] nArrayArray = new int[7][];
        for (int i = 0; i < 7; ++i) {
            nArrayArray[i] = this.gridbox[i].getRangeValues();
        }
        this.pollSchedule.setBlackoutValues(nArrayArray);
        if (this.disableCheckbox.isSelected()) {
            this.pollSchedule.setBlackoutUsage(3);
        } else if (this.useGroupSchedule.isSelected()) {
            this.pollSchedule.setBlackoutUsage(1);
        } else {
            this.pollSchedule.setBlackoutUsage(2);
        }
        try {
            byte[] byArray = this.pollSchedule.getBlackoutByteArray();
            ValueComponent[] valueComponentArray = new ValueComponent[]{NDSSyntax.SYN_OCTET_STRING.createValueComponent((Object)byArray)};
            NDSObjectAttribute nDSObjectAttribute = new NDSObjectAttribute((AttributeDefinition)((NDSAttributeDefinition)this.ns.getAttributeDefinition(this.nsObj.getObjectEntry(), this.attrName)), valueComponentArray);
            ObjectAttribute objectAttribute = this.nsObj.getAttribute(this.attrName);
            if (objectAttribute != null) {
                this.nsObj.deleteAttribute(this.attrName);
                this.ns.update(this.nsObj);
            }
            this.nsObj.addAttribute((ObjectAttribute)nDSObjectAttribute);
            this.ns.update(this.nsObj);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
        return true;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equalsIgnoreCase("DIRTY")) {
            this.thePropBook.setModified(true, this.snapin);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        int n = this.gridbox.length;
        GridBox gridBox = (GridBox)itemEvent.getItem();
        for (int i = 0; i < n; ++i) {
            if (gridBox == this.gridbox[i]) continue;
            this.gridbox[i].setSelection(-1, -1);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object == this.disableCheckbox) {
            boolean bl = this.disableCheckbox.isSelected();
            if (this.useThisSchedule.isSelected()) {
                this.gbp.setEnabled(!bl);
            }
            if (!this.onMonitorServer) {
                this.useThisSchedule.setEnabled(!bl);
                this.useGroupSchedule.setEnabled(!bl);
            }
        } else if (object == this.useThisSchedule) {
            if (this.useThisSchedule.isSelected() && !this.disableCheckbox.isSelected()) {
                this.gbp.setEnabled(true);
            }
        } else if (object == this.useGroupSchedule && this.useGroupSchedule.isSelected()) {
            this.gbp.setEnabled(false);
        }
        if (this.thePropBook != null && !this.ignorePropertyBook) {
            this.thePropBook.setModified(true, this.snapin);
        }
    }

    class GridBoxPanel
    extends JPanel {
        GridBoxPanel(BlackoutPanel blackoutPanel2) {
            super(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.1;
            gridBagConstraints.weighty = 1.5;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 1;
            gridBagConstraints.ipadx = 3;
            gridBagConstraints.ipady = 0;
            for (int i = 0; i < 7; ++i) {
                ((BlackoutPanel)BlackoutPanel.this).labels[i] = NConeFactory.novellJLabel((JLabel)new JLabel("Day" + i), (String)("Day" + i), (String)"");
                ((GridBagLayout)this.getLayout()).setConstraints(BlackoutPanel.this.labels[i], gridBagConstraints);
                this.add(BlackoutPanel.this.labels[i]);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.weightx = 5.0;
                ((BlackoutPanel)BlackoutPanel.this).gridbox[i] = new GridBox(2, "Day" + i);
                BlackoutPanel.this.gridbox[i].addPropertyChangeListener(blackoutPanel2);
                BlackoutPanel.this.gridbox[i].addItemListener(blackoutPanel2);
                if (i % 2 == 0) {
                    BlackoutPanel.this.gridbox[i].setBackground(Color.white);
                } else {
                    BlackoutPanel.this.gridbox[i].setBackground(new Color(223, 223, 223));
                }
                ((GridBagLayout)this.getLayout()).setConstraints(BlackoutPanel.this.gridbox[i], gridBagConstraints);
                this.add(BlackoutPanel.this.gridbox[i]);
                if (i != 0) {
                    BlackoutPanel.this.gridbox[i].hideHeader();
                } else {
                    gridBagConstraints.weighty = 0.6;
                }
                ++gridBagConstraints.gridy;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.weightx = 0.1;
                this.setBorder(new CompoundBorder(new EtchedBorder(1), new EmptyBorder(4, 4, 4, 4)));
            }
        }

        public void setEnabled(boolean bl) {
            Component[] componentArray = this.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                componentArray[i].setEnabled(bl);
            }
        }
    }
}

