/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.widgets;

import com.novell.gw.admin.ui.DsuiResource;
import com.novell.gw.util.Debug;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComboBox;

public class ComboMapper {
    private String attrID;
    private JComboBox cb;
    private Vector mappings;

    public ComboMapper(JComboBox jComboBox, String string) {
        this.cb = jComboBox;
        this.attrID = string;
        this.buildList();
    }

    private void buildList() {
        try {
            this.mappings = new Vector(10);
            String string = DsuiResource.getString(this.attrID + ".mapping");
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                this.mappings.addElement(string2);
                this.cb.addItem(string3);
            }
            this.mappings.trimToSize();
        }
        catch (MissingResourceException missingResourceException) {
            Debug.traceException((Throwable)missingResourceException);
        }
    }

    public Integer getSelectedValue() {
        int n = this.cb.getSelectedIndex();
        if (n == -1) {
            return null;
        }
        try {
            Object e = this.mappings.elementAt(n);
            return new Integer(e.toString());
        }
        catch (NumberFormatException numberFormatException) {
            Debug.traceException((Throwable)numberFormatException);
            return null;
        }
    }

    public void setSelectedValue(Object object) {
        int n = -1;
        if (object != null) {
            n = this.mappings.indexOf(object.toString());
        }
        if (this.cb.getSelectedIndex() != n) {
            this.cb.setSelectedIndex(n);
        }
    }

    public void removeMapping(Object object) {
        int n = this.mappings.indexOf(object.toString());
        if (n != -1) {
            this.mappings.removeElementAt(n);
            this.cb.removeItemAt(n);
        }
    }
}

