/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.widgets;

import com.novell.application.console.snapin.NConeFactory;
import com.novell.gw.admin.widgets.GWTextField;
import com.novell.gw.admin.widgets.RB;
import com.novell.gw.admin.widgets.UncFileChooser;
import com.novell.gw.admin.widgets.WebButton;
import com.novell.gw.directory.util.Path;
import com.novell.gw.directory.util.PathException;
import com.novell.gw.util.CommonStatic;
import com.novell.gw.util.Debug;
import com.novell.gw.util.PlatformCheck;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class FileCombo
extends JPanel
implements KeyListener {
    public static final String FILE_SELECTION = "FILE SELECTION";
    private int fileSelectionMode = 2;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private GWTextField textField;
    private JButton fileButton;
    private JFileChooser fileChooser;
    private boolean displayUNC;
    private boolean useUNC;
    private boolean convertPath;
    private Window parent;

    public FileCombo() {
        this(null, false, false, true);
    }

    public FileCombo(boolean bl) {
        this(null, bl, false, true);
    }

    public FileCombo(Window window, boolean bl) {
        this(window, bl, false, true);
    }

    public FileCombo(Window window, boolean bl, boolean bl2) {
        this(window, bl, bl2, true);
    }

    public FileCombo(Window window, boolean bl, boolean bl2, boolean bl3) {
        this.parent = window;
        this.useUNC = bl;
        this.convertPath = bl3;
        this.displayUNC = PlatformCheck.isPlatformLinux() ? false : bl;
        this.initComponents(bl2);
    }

    private void initComponents(boolean bl) {
        this.textField = new FocusTextField();
        this.textField.addKeyListener(this);
        URL uRL = this.getClass().getResource("/com/novell/gw/admin/widgets/images/Directory.gif");
        ImageIcon imageIcon = new ImageIcon(uRL);
        this.setPreferredSize(new Dimension(imageIcon.getIconWidth() + 15, this.textField.getPreferredSize().height));
        this.fileButton = bl ? new WebButton(imageIcon) : new JButton(imageIcon);
        Dimension dimension = this.textField.getMinimumSize();
        Dimension dimension2 = new Dimension(dimension.height + 2, dimension.height);
        this.fileButton.setMinimumSize(dimension2);
        this.fileButton.setPreferredSize(dimension2);
        this.fileButton.setMaximumSize(dimension2);
        NConeFactory.novellJButton((JButton)this.fileButton, (String)"Browse", (String)"");
        this.fileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                File file;
                String string;
                Container container = FileCombo.this.parent;
                if (container == null) {
                    container = FileCombo.this;
                }
                if (FileCombo.this.fileChooser == null) {
                    FileCombo.this.createFileChooser();
                }
                if ((string = FileCombo.this.textField.getText()) != null && !string.equals("") && (file = new File(string)).exists()) {
                    FileCombo.this.fileChooser.setCurrentDirectory(file);
                }
                int n = FileCombo.this.fileChooser.showOpenDialog(container);
                if (FileCombo.this.parent != null) {
                    FileCombo.this.parent.requestFocus();
                }
                if (n == 0) {
                    FileCombo.this.setFilePath();
                }
            }
        });
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        jPanel.add((Component)this.textField, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "Center");
        jPanel2.add((Component)this.fileButton, "East");
        this.setLayout(new GridBagLayout());
        this.add((Component)jPanel2, gridBagConstraints);
        this.enableEvents(4L);
    }

    private void createFileChooser() {
        this.fileChooser = new UncFileChooser();
        this.fileChooser.setApproveButtonText(RB.getString("DirSelect"));
        this.fileChooser.setDialogTitle(RB.getString("SelectDirectory"));
        this.fileChooser.setFileSelectionMode(1);
        this.fileChooser.setMultiSelectionEnabled(false);
        this.setFileSelectionMode();
    }

    public void addFileFilter(FileFilter fileFilter) {
        this.getFileChooser();
        this.fileChooser.addChoosableFileFilter(fileFilter);
    }

    public void setFileSelectionMode(int n) {
        this.fileSelectionMode = n;
        if (this.fileChooser != null) {
            this.setFileSelectionMode();
        }
    }

    private void setFileSelectionMode() {
        this.fileChooser.setFileSelectionMode(this.fileSelectionMode);
        if (this.fileSelectionMode == 1) {
            this.fileChooser.setApproveButtonText(RB.getString("DirSelect"));
            this.fileChooser.setDialogTitle(RB.getString("SelectDirectory"));
        } else if (this.fileSelectionMode == 2) {
            this.fileChooser.setApproveButtonText(RB.getString("DirSelect"));
            this.fileChooser.setDialogTitle(RB.getString("SelectFileOrDirectory"));
        } else if (this.fileSelectionMode == 0) {
            this.fileChooser.setApproveButtonText(RB.getString("FileSelect"));
            this.fileChooser.setDialogTitle(RB.getString("SelectFile"));
        }
    }

    public JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.createFileChooser();
        }
        return this.fileChooser;
    }

    public void setFileChooser(JFileChooser jFileChooser) {
        this.fileChooser = jFileChooser;
    }

    public GWTextField getTextField() {
        return this.textField;
    }

    public String getText() {
        return this.textField.getText();
    }

    public String getPath() {
        Debug.trace((String)("FileCombo.getPath   useUnc: " + this.useUNC + "  displayUNC: " + this.displayUNC));
        String string = this.convertPath(this.textField.getText(), this.useUNC);
        Debug.trace((String)("  returning filePath = " + string));
        return string;
    }

    private String convertPath(String string, boolean bl) {
        String string2 = string;
        if (this.convertPath) {
            try {
                Path path = new Path(string, CommonStatic.getLinuxMountPoint());
                String string3 = bl ? path.getPathTryUnc() : path.getLocalPath();
                path = null;
                if (string3 != null && string3.length() > 0) {
                    string2 = string3;
                }
            }
            catch (PathException pathException) {
                Debug.traceException((Throwable)pathException);
            }
        }
        return string2;
    }

    public String setText(String string) {
        return this.setText(string, false);
    }

    public String setText(String string, boolean bl) {
        String string2 = bl ? string : this.convertPath(string, this.displayUNC);
        this.textField.setText(string2);
        return string2;
    }

    public void addTextFieldKeyListener(KeyListener keyListener) {
        this.textField.addKeyListener(keyListener);
    }

    public void removeTextFieldKeyListener(KeyListener keyListener) {
        this.textField.removeKeyListener(keyListener);
    }

    public boolean isTextField(Object object) {
        return object == this.textField;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    private void setFilePath() {
        File file;
        if (this.fileChooser != null && (file = this.fileChooser.getSelectedFile()) != null) {
            String string = this.textField.getText();
            String string2 = this.setText(file.toString());
            this.pcs.firePropertyChange(FILE_SELECTION, string, string2);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        String string = this.textField.getText();
        this.pcs.firePropertyChange(FILE_SELECTION, null, string);
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void setEnabled(boolean bl) {
        this.textField.setEnabled(bl);
        this.fileButton.setEnabled(bl);
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        int n = focusEvent.getID();
        if (n == 1004) {
            this.textField.requestFocus();
        }
    }

    public void setEditable(boolean bl) {
        this.textField.setEditable(bl);
        this.fileButton.setEnabled(bl);
    }

    public void setButtonVisible(boolean bl) {
        this.fileButton.setVisible(bl);
    }

    public void setUseUNC(boolean bl) {
        this.useUNC = bl;
        this.displayUNC = PlatformCheck.isPlatformLinux() ? false : bl;
    }

    private class FocusTextField
    extends GWTextField {
        public FocusTextField() {
            this.enableEvents(4L);
        }

        protected void processFocusEvent(FocusEvent focusEvent) {
            String string;
            char c;
            String string2;
            int n = focusEvent.getID();
            if (n == 1005 && FileCombo.this.displayUNC && (string2 = FileCombo.this.textField.getText()) != null && string2.length() > 1 && (c = string2.charAt(1)) == ':' && !(string = FileCombo.this.convertPath(string2, FileCombo.this.displayUNC)).equalsIgnoreCase(string2)) {
                FileCombo.this.textField.setText(string);
                FileCombo.this.pcs.firePropertyChange(FileCombo.FILE_SELECTION, string2, string);
            }
            super.processFocusEvent(focusEvent);
        }
    }
}

