/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.widgets;

import com.novell.application.console.shell.D;
import com.novell.application.console.shell.ShellStubs;
import com.novell.application.console.snapin.NConeFactory;
import com.novell.application.console.testing.C1Automation;
import com.novell.application.console.testing.C1Hooks;
import com.novell.application.console.widgets.NDialog;
import com.novell.application.console.widgets.NWrapLabel;
import com.novell.gw.admin.widgets.GWButton;
import com.novell.gw.admin.widgets.RB;
import com.novell.gw.util.Debug;
import com.novell.utility.localization.Loc;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.net.URL;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class GWMsgBox
extends NDialog
implements ActionListener,
KeyListener,
ImageObserver,
C1Automation {
    private boolean doBeep = true;
    public static final int CONFIRM = 0;
    public static final int INFO = 1;
    public static final int WARN = 2;
    public static final int ERROR = 3;
    public static final int WARN_ALL = 4;
    public static final int WARN_WITH_CANCEL = 5;
    public static final int WARN_ALL_WITH_CANCEL = 6;
    public static final int WARN_PROMPT_WITH_CANCEL = 7;
    public static final int ERROR_IGNORE = 8;
    public static final int ERROR_WITH_CANCEL = 9;
    public static final int CONFIRM_ALL = 10;
    public static final int WARN_OK = 11;
    public static final int WARN_OK_WITH_CANCEL = 12;
    public static final int CONFIRM_CONTINUE = 13;
    public static final int OK = 1;
    public static final int CANCEL = 2;
    public static final int CLOSE = 4;
    public static final int YES = 8;
    public static final int NO = 16;
    public static final int DETAILS = 32;
    public static final int YES_ALL = 64;
    public static final int NO_ALL = 128;
    public static final int PROMPT = 256;
    public static final int IGNORE = 512;
    public static final int IGNORE_ALL = 1024;
    public static final int CONTINUE = 2048;
    private static final String errorImageKey = "ErrorAnim.gif";
    private static final String warnImageKey = "WarnAnim.gif";
    private static final String infoImageKey = "InfoAnim.gif";
    private static final String confirmImageKey = "ConfirmAnim.gif";
    private static final String imageLocationKey = "/com/novell/utility/nmsgbox/images/";
    private Frame parentFrame;
    private String helpSetName;
    private String helpID;
    private boolean useHelpInsteadOfDetails = false;
    private String msg;
    private JPanel zpanel;
    private GWButton okButton;
    protected GWButton cancelButton;
    private GWButton closeButton;
    private GWButton continueButton;
    protected GWButton yesButton;
    protected GWButton noButton;
    private GWButton yesAllButton;
    private GWButton noAllButton;
    private GWButton detailsButton;
    private GWButton ignoreButton;
    private GWButton ignoreAllButton;
    private GWButton promptButton;
    private GWButton defaultButton = null;
    private GWButton currentButton = null;
    private JPanel buttonsPanel;
    private Image image;
    private JLabel imageLabel = new JLabel("@");
    private boolean requestedFocus = false;
    private boolean internalSetVisibleCachedState;
    private int setupCachedType;
    private int pressedButton = 2;
    private boolean singleButton = false;
    private String sTitle;

    public GWMsgBox(Component component, String string, String string2, int n) {
        this(component, string, string2, n, null, null, false);
    }

    public GWMsgBox(Component component, String string, String string2, int n, String string3, String string4) {
        this(component, string, string2, n, string3, string4, false);
    }

    public GWMsgBox(Component component, String string, String string2, int n, String string3) {
        this(component, string, string2, n, string3, null, false);
    }

    public GWMsgBox(Component component, String string, String string2, int n, String string3, String string4, boolean bl) {
        super(component, string, true);
        this.helpSetName = string3;
        this.helpID = string4;
        this.useHelpInsteadOfDetails = bl;
        this.setup(component, string, string2, n, null);
    }

    public GWMsgBox(Component component, String string, JPanel jPanel, int n) {
        this(component, string, jPanel, n, null, null, true);
    }

    public GWMsgBox(Component component, String string, JPanel jPanel, int n, String string2, String string3, boolean bl) {
        super(component, string, true);
        this.helpSetName = string2;
        this.helpID = string3;
        this.useHelpInsteadOfDetails = bl;
        this.setup(component, string, null, n, jPanel);
    }

    private void setup(Component component, String string, String string2, int n, JPanel jPanel) {
        this.setupCachedType = n;
        if (component instanceof Frame) {
            this.parentFrame = (Frame)component;
        }
        if (string2 == null) {
            string2 = "";
        }
        this.msg = string2;
        this.zpanel = jPanel;
        C1Hooks.registerWindow((Window)((Object)this));
        this.setName("GWMsgBox");
        this.sTitle = string;
        Runnable runnable = new Runnable(){

            public void run() {
                JPanel jPanel = new JPanel(new BorderLayout());
                GWMsgBox.this.getContentPane().setLayout(new GridLayout(1, 1));
                GWMsgBox.this.getContentPane().add(jPanel);
                JPanel jPanel2 = GWMsgBox.this.zpanel;
                if (jPanel2 != null) {
                    if (!GWMsgBox.this.singleButton) {
                        jPanel2.setBorder(new EmptyBorder(0, 0, 0, 8));
                    }
                    jPanel.add("Center", jPanel2);
                } else {
                    NWrapLabel nWrapLabel = new NWrapLabel(GWMsgBox.this.msg, false);
                    jPanel.add("Center", (Component)nWrapLabel);
                }
                int n = GWMsgBox.this.getButtonFlags(GWMsgBox.this.setupCachedType);
                GWMsgBox.this.imageLabel.setBorder(new EmptyBorder(0, 0, 5, 10));
                jPanel.add("West", GWMsgBox.this.imageLabel);
                jPanel.add("South", GWMsgBox.this.getButtonPanel(n));
                GWMsgBox.this.pack();
                GWMsgBox.this.setResizable(false);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                D.out((String)"+++GWMsgBox: Error -- Couldn't invokeAndWait the setup");
            }
        }
    }

    public void repaintButtonsPanel() {
        Dimension dimension = this.buttonsPanel.getSize();
        this.buttonsPanel.paintImmediately(0, 0, dimension.width, dimension.height);
    }

    private int getButtonFlags(int n) {
        int n2 = 0;
        switch (n) {
            case 2: {
                this.createImageLabel(this, warnImageKey);
                n2 = 24;
                break;
            }
            case 4: {
                this.createImageLabel(this, warnImageKey);
                n2 = 216;
                break;
            }
            case 5: {
                this.createImageLabel(this, warnImageKey);
                n2 = 26;
                break;
            }
            case 6: {
                this.createImageLabel(this, warnImageKey);
                n2 = 218;
                break;
            }
            case 7: {
                this.createImageLabel(this, warnImageKey);
                n2 = 282;
                break;
            }
            case 8: {
                this.createImageLabel(this, errorImageKey);
                n2 = 1538;
                break;
            }
            case 0: {
                this.createImageLabel(this, confirmImageKey);
                n2 = 24;
                break;
            }
            case 10: {
                this.createImageLabel(this, confirmImageKey);
                n2 = 90;
                break;
            }
            case 3: {
                this.createImageLabel(this, errorImageKey);
                n2 = 4;
                break;
            }
            case 9: {
                this.createImageLabel(this, errorImageKey);
                n2 = 2050;
                break;
            }
            case 11: {
                this.createImageLabel(this, warnImageKey);
                n2 = 1;
                break;
            }
            case 12: {
                this.createImageLabel(this, warnImageKey);
                n2 = 3;
                break;
            }
            case 13: {
                this.createImageLabel(this, confirmImageKey);
                n2 = 2050;
                break;
            }
            default: {
                this.createImageLabel(this, infoImageKey);
                n2 = 1;
            }
        }
        if (this.helpSetName != null) {
            n2 |= 0x20;
        }
        this.singleButton = this.helpSetName == null && (n2 == 4 || n2 == 1);
        return n2;
    }

    public Component add(Component component) {
        return this.buttonsPanel.add(component);
    }

    public Dimension getPreferredSize() {
        int n;
        Dimension dimension = super.getPreferredSize();
        FontMetrics fontMetrics = null;
        Font font = null;
        Font font2 = null;
        int n2 = 0;
        int n3 = 48;
        if (this.getTitle() != null) {
            font = this.getFont();
            font2 = new Font(font.getName(), 3, font.getSize() + 2);
            fontMetrics = this.getFontMetrics(font2);
            n2 = fontMetrics.stringWidth(this.getTitle());
            int n4 = fontMetrics.stringWidth(GWMsgBox.getString("WidestCharacterKey"));
            n = n4 * n3;
            n2 = Math.min(n, n2);
        }
        JDialog jDialog = new JDialog((Frame)null, " ");
        jDialog.getContentPane().setLayout(new BorderLayout());
        jDialog.getContentPane().add("Center", new JLabel(""));
        jDialog.setResizable(false);
        jDialog.pack();
        n = jDialog.getPreferredSize().width;
        jDialog.dispose();
        if (n2 + n > dimension.width) {
            dimension.width = n2 + n;
        }
        return dimension;
    }

    private void createImageLabel(Object object, String string) {
        this.image = null;
        String string2 = imageLocationKey;
        string = string.replace(':', '_');
        String string3 = new String(string2 + string);
        URL uRL = object.getClass().getResource(string3);
        try {
            this.image = Toolkit.getDefaultToolkit().createImage((ImageProducer)uRL.getContent());
            this.imageLabel = new JLabel(new ImageIcon(this.image));
        }
        catch (Exception exception) {
            Debug.traceDlg((String)("+++GWMsgBox: Error -- Couldn't create image " + string + "..."));
        }
    }

    static String getString(String string) {
        return RB.getString(string);
    }

    private GWButton getButton(String string) {
        GWButton gWButton = new GWButton(string);
        String string2 = Loc.removeHotChar((String)string);
        gWButton.setName(string2);
        Loc.setText((AbstractButton)gWButton, (String)string);
        gWButton.addFocusListener(new buttonFocusListener());
        NConeFactory.novellJButton((JButton)gWButton, (String)string2, (String)"");
        return gWButton;
    }

    public void setBeeping(boolean bl) {
        this.doBeep = bl;
    }

    public int launch() {
        this.setVisible(true);
        return this.getPressedButton();
    }

    public void setVisible(boolean bl) {
        if (bl && this.doBeep) {
            this.getToolkit().beep();
        }
        if (SwingUtilities.isEventDispatchThread()) {
            super.setVisible(bl);
        } else {
            this.internalSetVisibleCachedState = bl;
            Runnable runnable = new Runnable(){

                public void run() {
                    GWMsgBox.this.internalSetVisible(GWMsgBox.this.internalSetVisibleCachedState);
                }
            };
            if (this.isModal()) {
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (Exception exception) {
                    D.out((String)"+++GWMsgBox: Error -- Couldn't invokeAndWait with setVisible method");
                }
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    private void internalSetVisible(boolean bl) {
        super.setVisible(bl);
    }

    public void paint(Graphics graphics) {
        if (!this.requestedFocus) {
            if (this.defaultButton != null) {
                NConeFactory.novellJButton((JButton)this.defaultButton, (String)(this.msg + "   " + this.defaultButton.getName()), (String)"");
                this.defaultButton.requestFocus();
            }
            this.requestedFocus = true;
        }
        super.paint(graphics);
    }

    public int getPressedButton() {
        return this.pressedButton;
    }

    private JPanel getButtonPanel(int n) {
        Object object;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.buttonsPanel = new JPanel();
        this.buttonsPanel.setLayout(new GridLayout(1, 0, 5, 0));
        if ((n & 8) == 8) {
            this.yesButton = this.getButton(GWMsgBox.getString("yesKey"));
            this.buttonsPanel.add(this.yesButton);
            this.yesButton.addActionListener(this);
            this.yesButton.addKeyListener(this);
            this.defaultButton = this.yesButton;
        }
        if ((n & 0x40) == 64) {
            this.yesAllButton = this.getButton(GWMsgBox.getString("yesAllKey"));
            this.buttonsPanel.add(this.yesAllButton);
            this.yesAllButton.addActionListener(this);
            this.yesAllButton.addKeyListener(this);
        }
        if ((n & 0x10) == 16) {
            this.noButton = this.getButton(GWMsgBox.getString("noKey"));
            this.buttonsPanel.add(this.noButton);
            this.noButton.addActionListener(this);
            this.noButton.addKeyListener(this);
        }
        if ((n & 0x80) == 128) {
            this.noAllButton = this.getButton(GWMsgBox.getString("noAllKey"));
            this.buttonsPanel.add(this.noAllButton);
            this.noAllButton.addActionListener(this);
            this.noAllButton.addKeyListener(this);
        }
        if ((n & 1) == 1) {
            this.okButton = this.getButton(GWMsgBox.getString("okKey"));
            this.buttonsPanel.add(this.okButton);
            this.okButton.addActionListener(this);
            this.okButton.addKeyListener(this);
            this.defaultButton = this.okButton;
        }
        if ((n & 4) == 4) {
            this.closeButton = this.getButton(GWMsgBox.getString("closeKey"));
            this.buttonsPanel.add(this.closeButton);
            this.closeButton.addActionListener(this);
            this.closeButton.addKeyListener(this);
            this.defaultButton = this.closeButton;
        }
        if ((n & 0x800) == 2048) {
            this.continueButton = this.getButton(GWMsgBox.getString("continueKey"));
            this.buttonsPanel.add(this.continueButton);
            this.continueButton.addActionListener(this);
            this.continueButton.addKeyListener(this);
            this.defaultButton = this.continueButton;
        }
        if ((n & 0x100) == 256) {
            this.promptButton = this.getButton(GWMsgBox.getString("promptKey"));
            this.buttonsPanel.add(this.promptButton);
            this.promptButton.addActionListener(this);
            this.promptButton.addKeyListener(this);
        }
        if ((n & 0x200) == 512) {
            this.ignoreButton = this.getButton(GWMsgBox.getString("ignoreKey"));
            this.buttonsPanel.add(this.ignoreButton);
            this.ignoreButton.addActionListener(this);
            this.ignoreButton.addKeyListener(this);
            this.defaultButton = this.ignoreButton;
        }
        if ((n & 0x400) == 1024) {
            this.ignoreAllButton = this.getButton(GWMsgBox.getString("ignoreAllKey"));
            this.buttonsPanel.add(this.ignoreAllButton);
            this.ignoreAllButton.addActionListener(this);
            this.ignoreAllButton.addKeyListener(this);
        }
        if ((n & 2) == 2) {
            this.cancelButton = this.getButton(GWMsgBox.getString("cancelKey"));
            this.buttonsPanel.add(this.cancelButton);
            this.cancelButton.addActionListener(this);
            this.cancelButton.addKeyListener(this);
        }
        if ((n & 0x20) == 32) {
            this.detailsButton = this.useHelpInsteadOfDetails ? this.getButton(GWMsgBox.getString("helpKey")) : this.getButton(GWMsgBox.getString("detailsKey"));
            this.buttonsPanel.add(this.detailsButton);
            this.detailsButton.addActionListener(this);
            this.detailsButton.addKeyListener(this);
        }
        if (this.defaultButton == null && (object = this.buttonsPanel.getComponents()) != null) {
            for (int i = 0; i < ((Component[])object).length; ++i) {
                if (!(object[i] instanceof GWButton)) continue;
                this.defaultButton = (GWButton)object[i];
                break;
            }
        }
        object = new GridBagConstraints();
        object.insets = new Insets(10, 0, 0, 0);
        jPanel.add((Component)this.buttonsPanel, object);
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof GWButton) {
            this.buttonPressed((GWButton)object);
        }
        super.actionPerformed(actionEvent);
    }

    public void dispose() {
        super.dispose();
        if (this.image != null) {
            this.image.flush();
            this.image = null;
        }
    }

    private void buttonPressed(GWButton gWButton) {
        if (gWButton == this.okButton) {
            this.pressedButton = 1;
            this.dispose();
        } else if (gWButton == this.yesButton) {
            this.pressedButton = 8;
            this.dispose();
        } else if (gWButton == this.noButton) {
            this.pressedButton = 16;
            this.dispose();
        } else if (gWButton == this.yesAllButton) {
            this.pressedButton = 64;
            this.dispose();
        } else if (gWButton == this.noAllButton) {
            this.pressedButton = 128;
            this.dispose();
        } else if (gWButton == this.closeButton) {
            this.pressedButton = 4;
            this.dispose();
        } else if (gWButton == this.continueButton) {
            this.pressedButton = 2048;
            this.dispose();
        } else if (gWButton == this.cancelButton) {
            this.pressedButton = 2;
            this.dispose();
        } else if (gWButton == this.ignoreButton) {
            this.pressedButton = 512;
            this.dispose();
        } else if (gWButton == this.ignoreAllButton) {
            this.pressedButton = 1024;
            this.dispose();
        } else if (gWButton == this.detailsButton) {
            this.help();
        } else if (gWButton == this.promptButton) {
            this.pressedButton = 256;
            this.dispose();
        }
    }

    public void setHelpId(String string) {
        this.helpID = string;
    }

    protected void help() {
        Debug.trace((String)("GWMsgBox.help: set,id= " + this.helpSetName + "," + this.helpID));
        try {
            ShellStubs.launchHelp((String)this.helpSetName, (String)this.helpID, (Window)((Object)this));
        }
        catch (Exception exception) {
            GWMsgBox gWMsgBox = new GWMsgBox((Component)this.parentFrame, GWMsgBox.getString("helpErrorKey"), GWMsgBox.getString("helpConnectionKey"), 3);
            gWMsgBox.setVisible(true);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        Object object;
        if ((keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 32) && (object = keyEvent.getSource()) instanceof GWButton) {
            this.buttonPressed((GWButton)object);
        }
    }

    public Vector c1AutomationInvoke(Vector vector) {
        String string = (String)vector.elementAt(0);
        Vector<Object> vector2 = new Vector<Object>();
        if (string.equalsIgnoreCase("getTitle")) {
            vector2.addElement(this.sTitle);
        } else if (string.equalsIgnoreCase("getText")) {
            vector2.addElement(this.msg);
        } else {
            vector2.addElement(new Integer(-1));
            vector2.addElement("NMSgBox::c1AutomationInvoke: Unsupported API: " + string);
        }
        return vector2;
    }

    class buttonFocusListener
    implements FocusListener {
        buttonFocusListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
            Object object = focusEvent.getSource();
            if (!(object instanceof GWButton) || GWMsgBox.this.currentButton == null) {
                return;
            }
            if (GWMsgBox.this.currentButton.equals(object)) {
                NConeFactory.novellJButton((JButton)GWMsgBox.this.currentButton, (String)(GWMsgBox.this.msg + "   " + GWMsgBox.this.currentButton.getName()), (String)"");
            } else {
                NConeFactory.novellJButton((JButton)GWMsgBox.this.currentButton, (String)GWMsgBox.this.currentButton.getName(), (String)"");
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            Object object = focusEvent.getSource();
            if (!(object instanceof GWButton)) {
                return;
            }
            GWMsgBox.this.currentButton = (GWButton)object;
        }
    }
}

