/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.widgets;

import com.novell.gw.admin.widgets.SmartBits;
import com.novell.gw.admin.widgets.WidgetIcon;
import com.objectspace.jgl.BinaryPredicate;
import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.adapters.VectorIterator;
import com.objectspace.jgl.algorithms.Sorting;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.event.EventListenerList;

public class GridBox
extends JComponent
implements MouseMotionListener,
ActionListener,
ItemSelectable {
    public static final String DIRTY = "DIRTY";
    public static final int TYPE_SINGLE = 1;
    public static final int TYPE_RANGE = 2;
    private WidgetIcon icon = null;
    private WidgetIcon grayIcon = null;
    private WidgetIcon patternIcon = null;
    private WidgetIcon resizeIcon = null;
    private static final int NUM_TICKS = 48;
    private static final int NUM_PIXELS_PER_TICK = 11;
    private int TICK_LENGTH = 0;
    private int HEADER_SIZEY = 30;
    private int HEADER_SIZEX = 20;
    private int iPixelsPerTick = 0;
    private SmartBits bits = null;
    private PropertyChangeSupport pcs = null;
    private int type;
    private Ranges ranges = new Ranges();
    private Cursor handCursor;
    private Cursor crossHairCursor;
    private Cursor resizeCursor;
    private Cursor pointerCursor;
    private boolean selectedBorder = false;
    private boolean ignoreMouse = false;
    private boolean capture = false;
    private int startSelPos = 0;
    private int endSelPos = 0;
    private String debugName = "";
    private EventListenerList listenrList;
    private ItemEvent selectEvent = null;
    private Point mouseDownPoint = new Point();
    private int highlightColumn = -1;
    private int numPaint = 0;
    static /* synthetic */ Class class$java$awt$event$ItemListener;

    public GridBox(int n) {
        this.type = n;
        this.icon = new WidgetIcon(this.getClass(), "GreenDiamond.gif");
        this.grayIcon = new WidgetIcon(this.getClass(), "GrayDiamond.gif");
        this.patternIcon = new WidgetIcon(this.getClass(), "steel_texture.gif");
        this.resizeIcon = new WidgetIcon(this.getClass(), "sizer.gif");
        this.HEADER_SIZEX = this.icon.getIconWidth() / 2 + 1;
        this.pcs = new PropertyChangeSupport(this);
        this.bits = new SmartBits();
        this.init();
    }

    public GridBox(int n, String string) {
        this(n);
        this.debugName = new String(string);
    }

    public GridBox(int n, SmartBits smartBits) {
        this(n);
        this.bits = (SmartBits)smartBits.clone();
    }

    private void init() {
        this.listenrList = new EventListenerList();
        this.setOpaque(true);
        this.addMouseListener(new MouseList());
        this.addMouseMotionListener(this);
        this.pointerCursor = new Cursor(Cursor.getDefaultCursor().getType());
        this.handCursor = new Cursor(12);
        this.crossHairCursor = new Cursor(1);
        this.resizeCursor = new Cursor(10);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(127, 0, true);
        this.registerKeyboardAction(this, keyStroke, 0);
        keyStroke = KeyStroke.getKeyStroke(8, 0, true);
        this.registerKeyboardAction(this, keyStroke, 0);
        this.addFocusListener(new FocusList());
    }

    public boolean isFocusable() {
        return true;
    }

    public void setSelection(int n, int n2) {
        if (n == -1 || n2 == -1) {
            if (this.selectedBorder) {
                Rectangle rectangle = this.getRectangle(this.startSelPos, this.endSelPos);
                this.startSelPos = 0;
                this.endSelPos = 0;
                this.selectedBorder = false;
                this.repaint(rectangle.x, rectangle.y, rectangle.width, this.getHeight());
            }
        } else {
            RangeItem rangeItem = this.ranges.getRangeItem(n);
            if (rangeItem != null) {
                this.startSelPos = rangeItem.start;
                this.endSelPos = rangeItem.end;
            } else {
                this.startSelPos = n;
                this.endSelPos = n2;
            }
            this.selectedBorder = true;
            Rectangle rectangle = this.getRectangle(this.startSelPos, this.endSelPos);
            this.fireNewSelection();
            this.repaint(rectangle.x, rectangle.y, rectangle.width, this.getHeight());
        }
    }

    public void doLayout() {
        this.setVisible(false);
        super.doLayout();
        this.iPixelsPerTick = (this.getWidth() - this.HEADER_SIZEX) / 48;
        int n = (this.getWidth() - this.HEADER_SIZEX) % 48;
        if (this.iPixelsPerTick < 11) {
            this.iPixelsPerTick = 11;
        }
        this.setSize(48 * this.iPixelsPerTick + this.HEADER_SIZEX + 2, this.getHeight());
        this.setVisible(true);
    }

    public SmartBits getSingleValues() throws RuntimeException {
        if (this.type != 1) {
            throw new RuntimeException("getSingleValues() invalid for class type");
        }
        return (SmartBits)this.bits.clone();
    }

    public void setSingleValues(SmartBits smartBits) throws RuntimeException {
        if (this.type != 1) {
            throw new RuntimeException("setSingleValues() invalid for class type");
        }
        this.bits = (SmartBits)smartBits.clone();
    }

    public int[] getRangeValues() throws RuntimeException {
        if (this.type != 2) {
            throw new RuntimeException("getRangeValues() invalid for class type");
        }
        int n = this.ranges.items();
        int[] nArray = new int[n * 2];
        if (n > 0) {
            this.ranges.sort();
            Enumeration enumeration = this.ranges.elements();
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                RangeItem rangeItem = (RangeItem)enumeration.nextElement();
                nArray[n2 * 2] = rangeItem.start;
                nArray[n2 * 2 + 1] = rangeItem.end;
                ++n2;
            }
        }
        return nArray;
    }

    public void setRangeValues(int[] nArray) throws RuntimeException {
        if (this.type != 2) {
            throw new RuntimeException("setRangeValues() invalid for class type");
        }
        int n = nArray.length / 2 - 1;
        this.ranges.removeAllItems();
        for (int i = n; i >= 0; --i) {
            this.ranges.addItem(new RangeItem(nArray[i * 2], nArray[i * 2 + 1]));
        }
    }

    protected void drawText(Graphics graphics, String string, int n, int n2) {
        Color color = graphics.getColor();
        if (this.isEnabled()) {
            graphics.setColor(Color.black);
        } else {
            graphics.setColor(Color.white);
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.drawString(string, n, n2 -= fontMetrics.getDescent());
        if (!this.isEnabled()) {
            graphics.setColor(Color.gray);
            graphics.drawString(string, n + 1, n2 + 1);
        }
        graphics.setColor(color);
    }

    protected void paintComponent(Graphics graphics) {
        graphics.setColor(this.getParent().getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.HEADER_SIZEY);
        graphics.setFont(new Font("Dialog", 0, 12));
        if (this.isEnabled()) {
            graphics.setColor(this.getBackground());
        } else {
            graphics.setColor(this.getBackground().darker());
            Color color = this.getBackground();
            graphics.setColor(new Color(Math.max((int)((double)color.getRed() * 0.85), 0), Math.max((int)((double)color.getGreen() * 0.85), 0), Math.max((int)((double)color.getBlue() * 0.85), 0)));
        }
        graphics.fillRect(0, this.HEADER_SIZEY, this.getWidth(), this.getHeight() - this.HEADER_SIZEY);
        for (int i = 0; i < 48; ++i) {
            int n;
            int n2 = i * this.iPixelsPerTick + this.HEADER_SIZEX;
            if (i == 0) {
                int n3 = graphics.getFontMetrics().stringWidth("12");
                this.drawText(graphics, "12", n2 - n3 / 2 + 1, this.HEADER_SIZEY - 1);
            } else if (i % 2 == 0) {
                String string = Integer.toString(i > 24 ? (i - 24) / 2 : i / 2);
                n = graphics.getFontMetrics().stringWidth(string);
                this.drawText(graphics, string, n2 - n / 2, this.HEADER_SIZEY - 1);
            }
            if (i == 12) {
                String string = "AM";
                n = graphics.getFontMetrics().stringWidth(string);
                this.drawText(graphics, string, n2 - n / 2, this.HEADER_SIZEY / 2 - 1);
            } else if (i == 36) {
                String string = "PM";
                n = graphics.getFontMetrics().stringWidth(string);
                this.drawText(graphics, string, n2 - n / 2, this.HEADER_SIZEY / 2 - 1);
            }
            if (i == this.highlightColumn && this.isEnabled()) {
                graphics.setColor(Color.red);
            } else {
                graphics.setColor(Color.gray);
            }
            graphics.drawLine(n2, this.HEADER_SIZEY, n2, this.getHeight());
            if (this.type != 1 || !this.bits.get(i)) continue;
            if (this.isEnabled()) {
                this.icon.paintIcon(this, graphics, n2 - this.icon.getIconWidth() / 2 + 1, (this.getHeight() - this.HEADER_SIZEY) / 2 + this.HEADER_SIZEY - this.icon.getIconHeight() / 2);
                continue;
            }
            this.grayIcon.paintIcon(this, graphics, n2 - this.icon.getIconWidth() / 2 + 1, (this.getHeight() - this.HEADER_SIZEY) / 2 + this.HEADER_SIZEY - this.icon.getIconHeight() / 2);
        }
        if (this.type == 2) {
            Enumeration enumeration = this.ranges.elements();
            while (enumeration.hasMoreElements()) {
                RangeItem rangeItem = (RangeItem)enumeration.nextElement();
                this.paintRange(graphics, rangeItem.start, rangeItem.end);
            }
            if (this.selectedBorder && this.startSelPos != this.endSelPos) {
                this.drawSelectedRect(graphics, this.getRectangle(this.startSelPos, this.endSelPos));
            }
        }
    }

    private void drawSelectedRect(Graphics graphics, Rectangle rectangle) {
        int n;
        Rectangle rectangle2 = graphics.getClipBounds();
        graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        int n2 = this.resizeIcon.getIconWidth();
        int n3 = this.resizeIcon.getIconHeight();
        int n4 = rectangle.width / n2;
        int n5 = rectangle.width % n2;
        for (n = 0; n < n4; ++n) {
            this.resizeIcon.paintIcon(this, graphics, rectangle.x + n * n2, rectangle.y);
            this.resizeIcon.paintIcon(this, graphics, rectangle.x + n * n2, rectangle.y + rectangle.height - n3);
        }
        if (n5 > 0) {
            this.resizeIcon.paintIcon(this, graphics, rectangle.x + n * n2, rectangle.y);
            this.resizeIcon.paintIcon(this, graphics, rectangle.x + n * n2, rectangle.y + rectangle.height - n3);
        }
        n4 = rectangle.height / n3 - 1;
        n5 = rectangle.height % n3;
        for (n = 1; n < n4; ++n) {
            this.resizeIcon.paintIcon(this, graphics, rectangle.x, rectangle.y + n * n3);
            this.resizeIcon.paintIcon(this, graphics, rectangle.x + rectangle.width - n2, rectangle.y + n * n3);
        }
        if (n5 > 0) {
            graphics.setClip(rectangle.x, rectangle.y + n * n3, rectangle.width, n5);
            this.resizeIcon.paintIcon(this, graphics, rectangle.x, rectangle.y + n * n3);
            this.resizeIcon.paintIcon(this, graphics, rectangle.x + rectangle.width - n2, rectangle.y + n * n3);
        }
        graphics.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
    }

    private Rectangle getRectangle(int n, int n2) {
        if (n > n2) {
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        Rectangle rectangle = new Rectangle();
        int n4 = n * this.iPixelsPerTick + this.HEADER_SIZEX;
        int n5 = this.HEADER_SIZEY + this.TICK_LENGTH + 3;
        int n6 = (n2 - n) * this.iPixelsPerTick + 1;
        int n7 = this.getHeight() - (n5 + 2);
        rectangle.setBounds(n4, n5, n6, n7);
        return rectangle;
    }

    private void fillRectIcon(Graphics graphics, Rectangle rectangle, Icon icon) {
        Rectangle rectangle2 = graphics.getClipBounds();
        graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        int n = icon.getIconWidth();
        int n2 = icon.getIconHeight();
        int n3 = rectangle.width / n + 1;
        int n4 = rectangle.height / n2 + 1;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                icon.paintIcon(this, graphics, rectangle.x + j * n, rectangle.y + i * n2);
            }
        }
        graphics.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
    }

    private void paintRange(Graphics graphics, int n, int n2) {
        if (n != n2) {
            Rectangle rectangle = this.getRectangle(n, n2);
            graphics.setColor(Color.gray);
            this.fillRectIcon(graphics, rectangle, this.patternIcon);
            graphics.draw3DRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
            graphics.draw3DRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2, true);
        }
    }

    private int getIntColumn(Point point, boolean bl) {
        int n = (point.x - this.HEADER_SIZEX / 2) / this.iPixelsPerTick;
        if (n < 0) {
            n = 0;
        } else if (n >= 48 && !bl) {
            n = 47;
        } else if (n > 48 && bl) {
            n = 48;
        }
        return n;
    }

    public void hideHeader() {
        this.HEADER_SIZEY = 0;
    }

    public void hideTicks() {
        this.TICK_LENGTH = 0;
    }

    private Rectangle getInvalidRect(int n) {
        int n2;
        int n3 = this.startSelPos;
        if (n < n3) {
            n3 = n;
        }
        if (this.endSelPos < n3) {
            n3 = this.endSelPos;
        }
        if (n > (n2 = this.endSelPos)) {
            n2 = n;
        }
        if (this.startSelPos > n2) {
            n2 = this.startSelPos;
        }
        Rectangle rectangle = this.getRectangle(n3, n2);
        rectangle.grow(2, 2);
        return rectangle;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.selectedBorder && this.isEnabled()) {
            this.firePropertyChange(DIRTY, null, null);
            this.ranges.removeItem(new RangeItem(this.startSelPos, this.endSelPos));
            this.selectedBorder = false;
            Rectangle rectangle = this.getRectangle(this.startSelPos, this.endSelPos);
            rectangle.grow(2, 2);
            this.repaint(rectangle.x, rectangle.y, rectangle.width, this.getHeight());
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            this.setCursor(this.pointerCursor);
            return;
        }
        Cursor cursor = this.getCursor();
        Point point = mouseEvent.getPoint();
        RangeItem rangeItem = null;
        int n = this.getIntColumn(point, true);
        if (point.y >= this.HEADER_SIZEY) {
            if (this.type == 1) {
                this.setCursor(this.handCursor);
                if (this.highlightColumn != n) {
                    Rectangle rectangle = this.getInvalidRect(n);
                    if (this.highlightColumn != -1) {
                        rectangle.add(this.getInvalidRect(this.highlightColumn));
                    }
                    this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    if (n < 48) {
                        this.highlightColumn = n;
                    } else if (n == 48) {
                        this.highlightColumn = -1;
                    }
                }
            } else {
                rangeItem = this.ranges.getRangeItem(n);
                if (rangeItem != null) {
                    cursor = this.ranges.getBorderCursor(n);
                    if (cursor.getType() != 0) {
                        this.setCursor(cursor);
                    } else {
                        this.setCursor(this.pointerCursor);
                    }
                } else {
                    this.setCursor(this.crossHairCursor);
                }
            }
        } else {
            this.setCursor(this.pointerCursor);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n;
        if (!this.isEnabled()) {
            return;
        }
        if (this.type == 2 && !this.ignoreMouse && (n = this.getIntColumn(mouseEvent.getPoint(), true)) != this.endSelPos) {
            this.setCursor(this.resizeCursor);
            Rectangle rectangle = this.getInvalidRect(n);
            this.endSelPos = n;
            this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        this.pcs.firePropertyChange(string, object, object2);
    }

    public Object[] getSelectedObjects() {
        Object[] objectArray = null;
        if (this.selectedBorder) {
            objectArray = new Object[]{new RangeItem(this.startSelPos, this.endSelPos)};
        }
        return objectArray;
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        this.listenerList.add(class$java$awt$event$ItemListener == null ? (class$java$awt$event$ItemListener = GridBox.class$("java.awt.event.ItemListener")) : class$java$awt$event$ItemListener, itemListener);
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        this.listenerList.remove(class$java$awt$event$ItemListener == null ? (class$java$awt$event$ItemListener = GridBox.class$("java.awt.event.ItemListener")) : class$java$awt$event$ItemListener, itemListener);
    }

    protected void fireNewSelection() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$java$awt$event$ItemListener == null ? GridBox.class$("java.awt.event.ItemListener") : class$java$awt$event$ItemListener)) continue;
            if (this.selectEvent == null) {
                this.selectEvent = new ItemEvent(this, 0, this, 1);
            }
            ((ItemListener)objectArray[i + 1]).itemStateChanged(this.selectEvent);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class LessThanRangeItem
    implements BinaryPredicate {
        LessThanRangeItem() {
        }

        public boolean execute(Object object, Object object2) {
            return ((RangeItem)object).lessThan((RangeItem)object2);
        }
    }

    class FocusList
    implements FocusListener {
        FocusList() {
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            GridBox.this.highlightColumn = -1;
            GridBox.this.repaint(0L);
        }
    }

    class Ranges {
        Vector v = new Vector();

        public RangeItem collapse(RangeItem rangeItem) {
            Enumeration enumeration = this.v.elements();
            while (enumeration.hasMoreElements()) {
                RangeItem rangeItem2 = (RangeItem)enumeration.nextElement();
                if (!rangeItem2.overlaps(rangeItem)) continue;
                rangeItem = rangeItem2.union(rangeItem);
                this.v.removeElement(rangeItem2);
                enumeration = this.v.elements();
            }
            return rangeItem;
        }

        public Cursor getBorderCursor(int n) {
            int n2 = 0;
            Enumeration enumeration = this.v.elements();
            while (enumeration.hasMoreElements()) {
                RangeItem rangeItem = (RangeItem)enumeration.nextElement();
                if (n == rangeItem.start) {
                    n2 = 10;
                    break;
                }
                if (n != rangeItem.end) continue;
                n2 = 11;
                break;
            }
            return new Cursor(n2);
        }

        public RangeItem getRangeItem(int n) {
            RangeItem rangeItem = null;
            Enumeration enumeration = this.v.elements();
            while (enumeration.hasMoreElements()) {
                RangeItem rangeItem2 = (RangeItem)enumeration.nextElement();
                if (n < rangeItem2.start || n > rangeItem2.end) continue;
                rangeItem = new RangeItem(rangeItem2);
                break;
            }
            return rangeItem;
        }

        public void addItem(RangeItem rangeItem) {
            rangeItem = this.collapse(rangeItem);
            this.v.addElement(rangeItem);
        }

        public void removeItem(RangeItem rangeItem) {
            int n = this.v.indexOf(rangeItem);
            if (n >= 0) {
                this.v.removeElementAt(n);
            }
        }

        public Enumeration elements() {
            return this.v.elements();
        }

        public int items() {
            return this.v.size();
        }

        public void removeAllItems() {
            this.v.removeAllElements();
        }

        public void sort() {
            Sorting.sort((ForwardIterator)VectorIterator.begin((Vector)this.v), (ForwardIterator)VectorIterator.end((Vector)this.v), (BinaryPredicate)new LessThanRangeItem());
        }

        public boolean contains(RangeItem rangeItem) {
            return this.v.contains(rangeItem);
        }
    }

    class RangeItem {
        public int start = 0;
        public int end = 0;

        public RangeItem(int n, int n2) {
            if (n > n2) {
                int n3 = n;
                n = n2;
                n2 = n3;
            }
            this.start = n;
            this.end = n2;
        }

        public RangeItem(RangeItem rangeItem) {
            this(rangeItem.start, rangeItem.end);
        }

        public boolean lessThan(RangeItem rangeItem) {
            return this.start < rangeItem.start;
        }

        public boolean overlaps(RangeItem rangeItem) {
            return rangeItem.end >= this.start && rangeItem.start <= this.end;
        }

        public RangeItem intersection(RangeItem rangeItem) {
            int n = Math.max(this.start, rangeItem.start);
            int n2 = Math.min(this.end, rangeItem.end);
            return new RangeItem(n, n2);
        }

        public RangeItem union(RangeItem rangeItem) {
            int n = Math.min(this.start, rangeItem.start);
            int n2 = Math.max(this.end, rangeItem.end);
            return new RangeItem(n, n2);
        }

        public boolean equals(Object object) {
            RangeItem rangeItem = (RangeItem)object;
            return rangeItem.start == this.start;
        }

        public String toString() {
            return new String("start = " + this.start + " end = " + this.end + "; ");
        }
    }

    class MouseList
    extends MouseAdapter {
        MouseList() {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (GridBox.this.isEnabled()) {
                GridBox.this.requestFocus();
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (GridBox.this.isEnabled()) {
                GridBox.this.repaint();
            }
        }

        public void myMouseClicked(MouseEvent mouseEvent) {
            if (!GridBox.this.isEnabled()) {
                return;
            }
            Point point = mouseEvent.getPoint();
            if (point.y >= GridBox.this.HEADER_SIZEY && GridBox.this.type == 1) {
                int n = GridBox.this.getIntColumn(point, false);
                if (GridBox.this.bits.get(n)) {
                    GridBox.this.bits.clear(n);
                } else {
                    GridBox.this.bits.set(n);
                }
                GridBox.this.repaint(0L);
                GridBox.this.firePropertyChange(GridBox.DIRTY, null, null);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!GridBox.this.isEnabled()) {
                return;
            }
            Point point = mouseEvent.getPoint();
            GridBox.this.mouseDownPoint = point;
            if (point.y >= GridBox.this.HEADER_SIZEY && GridBox.this.type == 2) {
                int n = GridBox.this.getIntColumn(point, true);
                RangeItem rangeItem = GridBox.this.ranges.getRangeItem(n);
                if (rangeItem != null) {
                    if (n == rangeItem.start || n == rangeItem.end) {
                        int n2 = GridBox.this.getCursor().getType();
                        if (n2 == 10) {
                            GridBox.this.startSelPos = rangeItem.end;
                            GridBox.this.endSelPos = rangeItem.start;
                        } else if (n2 == 11) {
                            GridBox.this.startSelPos = rangeItem.start;
                            GridBox.this.endSelPos = rangeItem.end;
                        }
                        GridBox.this.ranges.removeItem(rangeItem);
                        GridBox.this.setSelection(GridBox.this.startSelPos, GridBox.this.endSelPos);
                    } else if (n > rangeItem.start && n < rangeItem.end) {
                        GridBox.this.ignoreMouse = true;
                        if (GridBox.this.selectedBorder) {
                            GridBox.this.setSelection(-1, -1);
                        }
                        GridBox.this.setSelection(rangeItem.start, rangeItem.end);
                    }
                } else if (rangeItem == null) {
                    if (GridBox.this.selectedBorder) {
                        GridBox.this.setSelection(-1, -1);
                    }
                    GridBox.this.setSelection(n, n);
                }
            }
            GridBox.this.capture = true;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!GridBox.this.isEnabled()) {
                return;
            }
            int n = 4;
            Point point = mouseEvent.getPoint();
            boolean bl = true;
            if (GridBox.this.type == 2 && !GridBox.this.ignoreMouse) {
                if (GridBox.this.selectedBorder && GridBox.this.startSelPos != GridBox.this.endSelPos) {
                    RangeItem rangeItem = new RangeItem(GridBox.this.startSelPos, GridBox.this.endSelPos);
                    GridBox.this.ranges.addItem(rangeItem);
                    GridBox.this.setSelection(rangeItem.start, rangeItem.end);
                }
                GridBox.this.firePropertyChange(GridBox.DIRTY, null, null);
            }
            int n2 = Math.max(((GridBox)GridBox.this).mouseDownPoint.x, point.x);
            int n3 = Math.max(((GridBox)GridBox.this).mouseDownPoint.y, point.y);
            int n4 = Math.min(((GridBox)GridBox.this).mouseDownPoint.x, point.x);
            int n5 = Math.min(((GridBox)GridBox.this).mouseDownPoint.y, point.y);
            if (n2 - n4 <= n && n3 - n5 < n) {
                this.myMouseClicked(mouseEvent);
            }
            GridBox.this.ignoreMouse = false;
            GridBox.this.capture = false;
        }
    }
}

