/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.widgets;

import com.novell.application.console.widgets.NJTable;
import com.novell.gw.admin.widgets.GWTableHeader;
import com.novell.gw.util.Debug;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyEvent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class GwTable
extends NJTable {
    private Clipboard clipboard;

    public static GwTable createResizableTable() {
        GwTable gwTable = new GwTable();
        gwTable.setAutoResizeMode(0);
        gwTable.setTableHeader(new GWTableHeader(gwTable.getColumnModel()));
        return gwTable;
    }

    public GwTable() {
        this.enableEvents(8L);
    }

    public void myFocusGained() {
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        EventQueue.invokeLater(new SelectionCheck());
    }

    public void sizeColumnsToFitData() {
        int n = this.getColumnCount();
        for (int i = 0; i < n; ++i) {
            this.sizeColumnToFitData(i);
        }
        this.fillEmptySpace();
    }

    public void sizeColumnToFitData(int n) {
        int n2;
        if (this.getAutoResizeMode() != 0) {
            return;
        }
        int n3 = 0;
        TableColumn tableColumn = this.columnModel.getColumn(n);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = this.tableHeader.getDefaultRenderer();
        }
        Component component = tableCellRenderer.getTableCellRendererComponent((JTable)((Object)this), tableColumn.getHeaderValue(), false, false, -1, n);
        n3 = component.getPreferredSize().width;
        int n4 = this.dataModel.getRowCount();
        for (n2 = 0; n2 < n4; ++n2) {
            Object object = this.dataModel.getValueAt(n2, n);
            if (object == null) continue;
            tableCellRenderer = this.getCellRenderer(n2, n);
            component = this.prepareRenderer(tableCellRenderer, n2, n);
            int n5 = component.getPreferredSize().width;
            n3 = Math.max(n3, n5);
        }
        n2 = n3 + 10;
        tableColumn.setWidth(n2);
        tableColumn.setPreferredWidth(n2);
    }

    public void fillEmptySpace() {
        Container container;
        int n;
        int n2 = this.columnModel.getTotalColumnWidth();
        if (n2 < (n = (container = this.getParent()).getWidth())) {
            int n3 = n - n2;
            int n4 = this.getColumnCount();
            int n5 = n3 / n4;
            int n6 = 0;
            for (int i = 0; i < n4; ++i) {
                TableColumn tableColumn = this.columnModel.getColumn(i);
                int n7 = tableColumn.getWidth();
                int n8 = n7 + n5;
                n6 += n8;
                if (i == n4 - 1) {
                    int n9 = n - n6;
                    n8 += n9;
                }
                tableColumn.setWidth(n8);
                tableColumn.setPreferredWidth(n8);
            }
        }
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401) {
            int n = keyEvent.getKeyCode();
            switch (n) {
                case 67: {
                    int n2 = keyEvent.getModifiers();
                    if (n2 == 2 || n2 == 3) {
                        this.copySelectedRowsToClipboard();
                    }
                }
                case 9: {
                    int n2 = keyEvent.getModifiers();
                    int n3 = this.getSelectedColumn();
                    int n4 = this.getSelectedRow();
                    int n5 = this.getRowCount() - 1;
                    int n6 = this.getColumnCount() - 1;
                    if ((n2 & 1) > 0) {
                        if (n5 >= 0 && (n4 != 0 || n3 != 0)) break;
                        this.transferFocusBackward();
                        keyEvent.consume();
                        return;
                    }
                    if (n5 >= 0 && (n4 != n5 || n3 != n6)) break;
                    this.transferFocus();
                    keyEvent.consume();
                    return;
                }
            }
        }
        super.processKeyEvent(keyEvent);
    }

    public void copySelectedRowsToClipboard() {
        if (this.clipboard == null) {
            this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        String string = "";
        int n = this.getColumnCount();
        int n2 = this.selectionModel.getMinSelectionIndex();
        int n3 = this.selectionModel.getMaxSelectionIndex();
        for (int i = n2; i <= n3; ++i) {
            if (!this.selectionModel.isSelectedIndex(i)) continue;
            boolean bl = true;
            for (int j = 0; j < n; ++j) {
                if (this.getColumnSelectionAllowed() && !this.isColumnSelected(j)) continue;
                if (!bl) {
                    string = string + "\t";
                } else {
                    bl = false;
                }
                Object object = this.getValueAt(i, j);
                if (object == null) continue;
                string = string + object.toString();
            }
            string = string + "\n";
        }
        StringSelection stringSelection = new StringSelection(string);
        this.clipboard.setContents(stringSelection, stringSelection);
    }

    private class SelectionCheck
    implements Runnable {
        private SelectionCheck() {
        }

        public void run() {
            try {
                if (GwTable.this.getColumnCount() > 0) {
                    if (GwTable.this.getSelectedColumn() == -1) {
                        GwTable.this.setColumnSelectionInterval(0, 0);
                    }
                    if (GwTable.this.getRowCount() > 0 && GwTable.this.getSelectedRow() == -1) {
                        GwTable.this.setRowSelectionInterval(0, 0);
                    }
                }
            }
            catch (Exception exception) {
                Debug.traceException((Throwable)exception);
            }
        }
    }
}

