/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.widgets;

import com.novell.application.console.snapin.NConeFactory;
import com.novell.gw.admin.widgets.FileCombo;
import com.novell.gw.admin.widgets.GwTextArea;
import com.novell.gw.admin.widgets.RB;
import com.novell.gw.admin.widgets.ToolBarButton;
import com.novell.gw.admin.widgets.ToolBarToggleButton;
import com.novell.gw.admin.widgets.UncFileChooser;
import com.novell.gw.directory.util.Path;
import com.novell.gw.directory.util.PathException;
import com.novell.gw.util.CommonStatic;
import com.novell.gw.util.Debug;
import com.novell.utility.localization.Loc;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class HtmlEditor
extends JPanel
implements KeyListener {
    private static final int MODE_PLAIN_EDIT = 0;
    private static final int FRAME_WIDTH = 640;
    private static final int FRAME_HEIGHT = 480;
    private static final String FONT_SIZE = "body {font-size: 12;}";
    private static final String FONT_FAMILY = "body {font-family: monospaced;}";
    private static final String SAMPLE_TEXT = "0123456789";
    private static final String DEFAULT_FONT_FAMILY = "Monospaced";
    private static final Integer DEFAULT_FONT_SIZE = new Integer(12);
    private static final Object[] fontSizes = new Object[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"};
    private static final Object[] hyperLinkTypes = new Object[]{"ftp", "http", "https"};
    private JTextPane editor;
    private JButton clearFormatting;
    private JTextArea plainTextArea;
    private ToolBarToggleButton tbBtnBold;
    private ToolBarToggleButton tbBtnItalic;
    private ToolBarToggleButton tbBtnUnderline;
    private ToolBarToggleButton tbBtnLeftAlign;
    private ToolBarToggleButton tbBtnCenterAlign;
    private ToolBarToggleButton tbBtnRightAlign;
    private JComboBox cbFontNames;
    private JComboBox cbFontSizes;
    private ToolBarButton tbBtnColor;
    private ToolBarButton tbBtnInsertLink;
    private ToolBarButton tbBtnInsertImage;
    private int caretPosition = 0;
    private JDialog parent;

    public HtmlEditor(JDialog jDialog) {
        this.parent = jDialog;
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setLayout(new GridBagLayout());
        this.tbBtnBold = RB.getToolBarToggleButton("FontBold.png");
        this.tbBtnBold.addActionListener(new StyledEditorKit.BoldAction());
        this.tbBtnBold.setToolTipText(RB.getString("Bold_TT"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.add((Component)this.tbBtnBold, gridBagConstraints);
        this.tbBtnItalic = RB.getToolBarToggleButton("FontItalic.png");
        this.tbBtnItalic.addActionListener(new StyledEditorKit.ItalicAction());
        this.tbBtnItalic.setToolTipText(RB.getString("Italic_TT"));
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)this.tbBtnItalic, gridBagConstraints);
        this.tbBtnUnderline = RB.getToolBarToggleButton("FontUnderline.png");
        this.tbBtnUnderline.addActionListener(new StyledEditorKit.UnderlineAction());
        this.tbBtnUnderline.setToolTipText(RB.getString("Underline_TT"));
        jPanel.add((Component)this.tbBtnUnderline, gridBagConstraints);
        this.tbBtnLeftAlign = RB.getToolBarToggleButton("FontAlignLeft.png");
        this.tbBtnLeftAlign.addActionListener(new ActionAlignParagraph("GWAlignLeft", 0));
        this.tbBtnLeftAlign.setToolTipText(RB.getString("AlignLeft_TT"));
        jPanel.add((Component)this.tbBtnLeftAlign, gridBagConstraints);
        this.tbBtnCenterAlign = RB.getToolBarToggleButton("FontAlignCenter.png");
        this.tbBtnCenterAlign.addActionListener(new ActionAlignParagraph("GWAlignCenter", 1));
        this.tbBtnCenterAlign.setToolTipText(RB.getString("AlignCenter_TT"));
        jPanel.add((Component)this.tbBtnCenterAlign, gridBagConstraints);
        this.tbBtnRightAlign = RB.getToolBarToggleButton("FontAlignRight.png");
        this.tbBtnRightAlign.addActionListener(new ActionAlignParagraph("GWAlignRight", 2));
        this.tbBtnRightAlign.setToolTipText(RB.getString("AlignRight_TT"));
        jPanel.add((Component)this.tbBtnRightAlign, gridBagConstraints);
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
        this.cbFontNames = new JComboBox<String>(stringArray);
        this.cbFontNames.setFocusable(false);
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].equals(DEFAULT_FONT_FAMILY)) continue;
            this.cbFontNames.setSelectedItem(DEFAULT_FONT_FAMILY);
            Debug.trace((String)(" Default Font Name: " + (String)this.cbFontNames.getSelectedItem() + "  index: " + this.cbFontNames.getSelectedIndex()));
            break;
        }
        this.cbFontNames.addActionListener(new ActionFontName());
        jPanel.add((Component)this.cbFontNames, gridBagConstraints);
        this.cbFontSizes = new JComboBox<Object>(fontSizes);
        this.cbFontSizes.setFocusable(false);
        this.cbFontSizes.setSelectedItem(DEFAULT_FONT_SIZE.toString());
        this.cbFontSizes.addActionListener(new ActionFontSize());
        jPanel.add((Component)this.cbFontSizes, gridBagConstraints);
        this.tbBtnColor = RB.getToolBarButton("FontColor.png");
        this.tbBtnColor.addActionListener(new ActionForegroundColor());
        this.tbBtnColor.setToolTipText(RB.getString("FontColor_TT"));
        jPanel.add((Component)this.tbBtnColor, gridBagConstraints);
        this.tbBtnInsertLink = RB.getToolBarButton("InsertLink.png");
        this.tbBtnInsertLink.addActionListener(new ActionInsertLink("GWInsertLink"));
        this.tbBtnInsertLink.setToolTipText(RB.getString("InsertLink_TT"));
        jPanel.add((Component)this.tbBtnInsertLink, gridBagConstraints);
        this.tbBtnInsertImage = RB.getToolBarButton("InsertImage.png");
        this.tbBtnInsertImage.addActionListener(new ActionInsertImage("GWInsertImage"));
        this.tbBtnInsertImage.setToolTipText(RB.getString("InsertImage_TT"));
        jPanel.add((Component)this.tbBtnInsertImage, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.setBorder(new CompoundBorder(new EtchedBorder(1), new EmptyBorder(0, 2, 2, 2)));
        jPanel2.setBorder(new TitledBorder(this.getBorder(), new String("HTML")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        jPanel2.add((Component)jPanel, gridBagConstraints);
        this.editor = this.createEditor();
        this.editor.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                HtmlEditor.this.caretPosition = caretEvent.getDot();
                HtmlEditor.this.updateButtons(HtmlEditor.this.caretPosition - 1);
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.editor);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel2.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jPanel2, gridBagConstraints);
        this.plainTextArea = new GwTextArea();
        this.plainTextArea.setFont(this.getFont());
        this.plainTextArea.setLineWrap(true);
        this.plainTextArea.setWrapStyleWord(true);
        JScrollPane jScrollPane2 = new JScrollPane(this.plainTextArea);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        jPanel3.setBorder(new CompoundBorder(new EtchedBorder(1), new EmptyBorder(0, 2, 2, 2)));
        jPanel3.setBorder(new TitledBorder(this.getBorder(), RB.getString("PlainText")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel3.add((Component)jScrollPane2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jPanel3, gridBagConstraints);
    }

    public void requestFocus() {
        this.editor.requestFocus();
    }

    private JTextPane createEditor() {
        JTextPane jTextPane = new JTextPane(){

            public void paintComponent(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                super.paintComponent(graphics2D);
            }
        };
        jTextPane.setEditorKit(new HTMLEditorKit());
        jTextPane.addKeyListener(this);
        HTMLDocument hTMLDocument = (HTMLDocument)jTextPane.getDocument();
        Element element = hTMLDocument.getDefaultRootElement();
        Element element2 = element.getElement(0);
        HTMLDocument.BlockElement blockElement = (HTMLDocument.BlockElement)element2.getElement(0);
        try {
            hTMLDocument.setOuterHTML(blockElement, "<div></div>");
        }
        catch (Exception exception) {
            Debug.traceException((Throwable)exception);
        }
        return jTextPane;
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)this.editor.getEditorKitForContentType("text/html");
            HTMLDocument hTMLDocument = (HTMLDocument)this.editor.getDocument();
            int n = this.editor.getCaretPosition();
            try {
                hTMLEditorKit.insertHTML(hTMLDocument, n, "<br>", 0, 0, HTML.Tag.BR);
                this.editor.setCaretPosition(n + 1);
            }
            catch (BadLocationException badLocationException) {
                Debug.traceException((Throwable)badLocationException);
            }
            catch (IOException iOException) {
                Debug.traceException((Throwable)iOException);
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private void updateButtons(int n) {
        boolean bl;
        boolean bl2;
        AttributeSet attributeSet = ((HTMLDocument)this.editor.getDocument()).getCharacterElement(n).getAttributes();
        boolean bl3 = StyleConstants.isBold(attributeSet);
        AttributeSet attributeSet2 = attributeSet.getResolveParent();
        if (attributeSet2 != null) {
            boolean bl4 = bl3 = bl3 || attributeSet2.getAttribute(StyleConstants.NameAttribute) == HTML.Tag.STRONG;
        }
        if (bl3 != this.tbBtnBold.isSelected()) {
            this.tbBtnBold.setSelected(bl3);
        }
        if ((bl2 = StyleConstants.isItalic(attributeSet)) != this.tbBtnItalic.isSelected()) {
            this.tbBtnItalic.setSelected(bl2);
        }
        if ((bl = StyleConstants.isUnderline(attributeSet)) != this.tbBtnUnderline.isSelected()) {
            this.tbBtnUnderline.setSelected(bl);
        }
        String string = StyleConstants.getFontFamily(attributeSet);
        if (!this.cbFontNames.getSelectedItem().equals(string)) {
            this.cbFontNames.setSelectedItem(string);
        }
        Integer n2 = new Integer(StyleConstants.getFontSize(attributeSet));
        if (!this.cbFontSizes.getSelectedItem().equals(n2.toString())) {
            this.cbFontSizes.setSelectedItem(n2.toString());
        }
        int n3 = StyleConstants.ParagraphConstants.getAlignment(attributeSet);
        this.updateAlignmentButtons(n3);
    }

    private void updateAlignmentButtons(int n) {
        this.tbBtnLeftAlign.setSelected(n == 0);
        this.tbBtnCenterAlign.setSelected(n == 1);
        this.tbBtnRightAlign.setSelected(n == 2);
        if (n != 0 && n != 1 && n != 2) {
            this.tbBtnLeftAlign.setSelected(true);
        }
    }

    public HTMLDocument getDocument() {
        return (HTMLDocument)this.editor.getDocument();
    }

    public String getPlainText() {
        String string = null;
        String string2 = this.plainTextArea.getText();
        if (string2 != null && string2.length() > 0) {
            string = new String(string2);
        } else {
            EditorKit editorKit = this.editor.getEditorKitForContentType("text/plain");
            HTMLDocument hTMLDocument = (HTMLDocument)this.editor.getDocument();
            StringWriter stringWriter = new StringWriter(hTMLDocument.getLength());
            try {
                editorKit.write(stringWriter, (Document)hTMLDocument, 0, hTMLDocument.getLength());
                string = stringWriter.toString();
            }
            catch (Exception exception) {
                Debug.traceException((Throwable)exception);
            }
        }
        return string;
    }

    public String getText() {
        return this.editor.getText();
    }

    public void setPlainText(String string) {
        this.plainTextArea.setText(string);
    }

    public void setText(String string) {
        this.editor.setText(string);
    }

    private class ActionInsertImage
    extends AbstractAction {
        private String name;

        public ActionInsertImage(String string) {
            super(string);
            this.name = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)HtmlEditor.this.editor.getEditorKitForContentType("text/html");
            HTMLDocument hTMLDocument = (HTMLDocument)HtmlEditor.this.editor.getDocument();
            InsertImageDialog insertImageDialog = new InsertImageDialog(null, null, null);
            insertImageDialog.setLocationRelativeTo(HtmlEditor.this);
            insertImageDialog.show();
        }

        private class InsertImageDialog
        extends JDialog
        implements ActionListener {
            private FileCombo imageFileCombo;
            private JLabel altTextLabel;
            private JTextField altText;
            private JLabel urlLabel;
            private JTextField urlText;
            private JButton okButton;
            private JButton cancelButton;
            private String originalAltText = null;
            private String originalURLText = null;
            private String originalText;

            public InsertImageDialog(String string, String string2, String string3) {
                super(HtmlEditor.this.parent, RB.getString("HyperlinkTitle"), true);
                Container container = this.getContentPane();
                container.setLayout(new GridBagLayout());
                JLabel jLabel = new JLabel(Loc.removeHotChar((String)RB.getString("ImageLocation")));
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.anchor = 17;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.insets = new Insets(10, 10, 0, 10);
                container.add((Component)jLabel, gridBagConstraints);
                UncFileChooser uncFileChooser = new UncFileChooser();
                NConeFactory.novellJFileChooser((JFileChooser)uncFileChooser, (String)jLabel.getText(), (String)"");
                uncFileChooser.setDialogTitle(RB.getString("InsertImage"));
                uncFileChooser.setFileSelectionMode(2);
                uncFileChooser.setFileHidingEnabled(false);
                uncFileChooser.setMultiSelectionEnabled(false);
                this.imageFileCombo = new FileCombo(true);
                this.imageFileCombo.setFileChooser(uncFileChooser);
                if (string != null) {
                    this.imageFileCombo.setText(string);
                }
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.fill = 2;
                gridBagConstraints.insets = new Insets(5, 15, 0, 10);
                NConeFactory.makeRelation((JLabel)new JLabel(Loc.removeHotChar((String)RB.getString("ImageLocation"))), (JTextField)this.imageFileCombo.getTextField());
                container.add((Component)this.imageFileCombo, gridBagConstraints);
                this.altTextLabel = new JLabel(Loc.removeHotChar((String)RB.getString("AlternateText")));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.anchor = 17;
                gridBagConstraints.insets = new Insets(10, 10, 0, 10);
                gridBagConstraints.gridy = 2;
                container.add((Component)this.altTextLabel, gridBagConstraints);
                this.altText = new JTextField();
                if (string2 != null && string2.length() > 0) {
                    this.altText.setText(string2);
                    this.originalAltText = new String(string2);
                }
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridy = 3;
                gridBagConstraints.fill = 2;
                gridBagConstraints.insets = new Insets(5, 15, 0, 10);
                NConeFactory.makeRelation((JLabel)this.altTextLabel, (JTextField)this.altText);
                container.add((Component)this.altText, gridBagConstraints);
                this.urlLabel = new JLabel(Loc.removeHotChar((String)"URL:"));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.anchor = 17;
                gridBagConstraints.gridy = 4;
                gridBagConstraints.insets = new Insets(10, 10, 0, 10);
                container.add((Component)this.urlLabel, gridBagConstraints);
                this.urlText = new JTextField();
                if (string3 != null && string3.length() > 0) {
                    this.urlText.setText(string3);
                    this.originalURLText = new String(string3);
                }
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridy = 5;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 2;
                gridBagConstraints.insets = new Insets(5, 15, 0, 10);
                NConeFactory.makeRelation((JLabel)this.urlLabel, (JTextField)this.urlText);
                container.add((Component)this.urlText, gridBagConstraints);
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new GridLayout(1, 0, 5, 0));
                this.okButton = RB.getButton("okKey");
                this.okButton.addActionListener(this);
                jPanel.add(this.okButton);
                this.cancelButton = RB.getButton("cancelKey");
                this.cancelButton.addActionListener(this);
                jPanel.add(this.cancelButton);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.anchor = 14;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.insets = new Insets(10, 5, 5, 10);
                container.add((Component)jPanel, gridBagConstraints);
                this.getRootPane().setDefaultButton(this.okButton);
                this.pack();
                this.setSize(400, this.getHeight());
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object == this.okButton) {
                    HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)HtmlEditor.this.editor.getEditorKitForContentType("text/html");
                    HTMLDocument hTMLDocument = (HTMLDocument)HtmlEditor.this.editor.getDocument();
                    int n = HtmlEditor.this.editor.getCaretPosition();
                    String string = this.imageFileCombo.getText();
                    try {
                        Path path = null;
                        path = new Path(string, CommonStatic.getLinuxMountPoint());
                        String string2 = path.getLocalPath();
                        String string3 = null;
                        if (this.urlText.getText().length() > 0) {
                            string3 = new String("<a href=\"");
                            int n2 = this.urlText.getText().indexOf("://");
                            if (n2 < 0) {
                                string3 = string3.concat(new String("http://"));
                            }
                            string3 = string3.concat(this.urlText.getText());
                            string3 = string3.concat("\">");
                        }
                        string3 = string3 == null ? new String("<img src=\"file:///" + string2 + "\"") : string3.concat(new String("<img src=\"file:///" + string2 + "\""));
                        if (this.altText.getText().length() > 0) {
                            string3 = string3.concat(new String(" alt=\"" + this.altText.getText() + "\""));
                        }
                        string3 = string3.concat(new String(" border=\"0\">"));
                        if (this.urlText.getText().length() > 0) {
                            string3 = string3.concat("</a>");
                        }
                        if (this.urlText.getText().length() > 0) {
                            hTMLEditorKit.insertHTML(hTMLDocument, n, string3 + " ", 0, 0, HTML.Tag.A);
                        } else {
                            hTMLEditorKit.insertHTML(hTMLDocument, n, string3 + " ", 0, 0, HTML.Tag.IMG);
                        }
                    }
                    catch (PathException pathException) {
                        Debug.traceException((Throwable)pathException);
                    }
                    catch (BadLocationException badLocationException) {
                        Debug.traceException((Throwable)badLocationException);
                    }
                    catch (IOException iOException) {
                        Debug.traceException((Throwable)iOException);
                    }
                    catch (RuntimeException runtimeException) {
                        Debug.traceException((Throwable)runtimeException);
                    }
                    HtmlEditor.this.editor.revalidate();
                    HtmlEditor.this.editor.repaint();
                    this.dispose();
                } else if (object == this.cancelButton) {
                    this.dispose();
                }
            }
        }
    }

    private class ActionInsertLink
    extends AbstractAction {
        private String name;

        public ActionInsertLink(String string) {
            super(string);
            this.name = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = HtmlEditor.this.editor.getSelectedText();
            InsertLinkDialog insertLinkDialog = null;
            insertLinkDialog = new InsertLinkDialog(string);
            insertLinkDialog.setLocationRelativeTo(HtmlEditor.this);
            insertLinkDialog.show();
        }

        private class InsertLinkDialog
        extends JDialog
        implements ActionListener {
            private JLabel linkTypesLabel;
            private JComboBox linkTypesCB;
            private JLabel urlLabel;
            private JTextField urlText;
            private JButton okButton;
            private JButton cancelButton;
            private String originalText;

            public InsertLinkDialog(String string) {
                super(HtmlEditor.this.parent, RB.getString("HyperlinkTitle"), true);
                String string2 = null;
                Container container = this.getContentPane();
                container.setLayout(new GridBagLayout());
                this.linkTypesLabel = new JLabel(Loc.removeHotChar((String)RB.getString("TypeLabel")));
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.anchor = 17;
                gridBagConstraints.insets = new Insets(5, 5, 0, 5);
                container.add((Component)this.linkTypesLabel, gridBagConstraints);
                this.linkTypesCB = new JComboBox<Object>(hyperLinkTypes);
                this.linkTypesCB.setSelectedIndex(1);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridy = 1;
                gridBagConstraints.fill = 2;
                gridBagConstraints.insets = new Insets(0, 5, 0, 5);
                NConeFactory.makeRelation((JLabel)new JLabel(Loc.removeHotChar((String)RB.getString("TypeLabel"))), (JComboBox)this.linkTypesCB);
                container.add((Component)this.linkTypesCB, gridBagConstraints);
                if (string != null) {
                    for (int i = 0; i < this.linkTypesCB.getItemCount(); ++i) {
                        if (!string.regionMatches(true, 0, (String)this.linkTypesCB.getItemAt(i), 0, ((String)this.linkTypesCB.getItemAt(i)).length())) continue;
                        this.linkTypesCB.setSelectedIndex(i);
                        int n = string.indexOf("://");
                        if (n > 0) {
                            string2 = new String(string.substring(n + 3));
                            break;
                        }
                        string2 = new String(string);
                        break;
                    }
                    if (string2 == null) {
                        string2 = new String(string);
                    }
                }
                this.urlLabel = new JLabel(Loc.removeHotChar((String)"URL:"));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.anchor = 17;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.insets = new Insets(10, 5, 0, 5);
                container.add((Component)this.urlLabel, gridBagConstraints);
                this.urlText = new JTextField();
                if (string2 != null && string2.length() > 0) {
                    this.urlText.setText(string2);
                    this.originalText = new String(string);
                }
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridy = 3;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 2;
                gridBagConstraints.insets = new Insets(0, 5, 0, 5);
                NConeFactory.makeRelation((JLabel)new JLabel(Loc.removeHotChar((String)"URL:")), (JTextField)this.urlText);
                container.add((Component)this.urlText, gridBagConstraints);
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new GridLayout(1, 0, 5, 0));
                this.okButton = RB.getButton("okKey");
                this.okButton.addActionListener(this);
                jPanel.add(this.okButton);
                this.cancelButton = RB.getButton("cancelKey");
                this.cancelButton.addActionListener(this);
                jPanel.add(this.cancelButton);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.anchor = 14;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.insets = new Insets(10, 5, 5, 5);
                container.add((Component)jPanel, gridBagConstraints);
                this.getRootPane().setDefaultButton(this.okButton);
                this.pack();
                this.setSize(400, this.getHeight());
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object == this.okButton) {
                    boolean bl = false;
                    if (this.originalText == null) {
                        if (this.urlText.getText().length() > 0) {
                            bl = true;
                        }
                    } else if (this.originalText.compareToIgnoreCase(this.urlText.getText()) != 0) {
                        bl = true;
                    }
                    if (bl) {
                        HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)HtmlEditor.this.editor.getEditorKitForContentType("text/html");
                        HTMLDocument hTMLDocument = (HTMLDocument)HtmlEditor.this.editor.getDocument();
                        String string = "";
                        String string2 = this.urlText.getText();
                        String string3 = (String)this.linkTypesCB.getSelectedItem();
                        String string4 = "";
                        if (string2.length() > string3.length()) {
                            string4 = string2.substring(0, string3.length());
                        }
                        if (string4.length() > 0 && !string3.equalsIgnoreCase(string4)) {
                            string = string.concat(string3 + "://");
                        }
                        string = string.concat(string2);
                        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                        simpleAttributeSet.addAttribute("href", string);
                        SimpleAttributeSet simpleAttributeSet2 = new SimpleAttributeSet();
                        simpleAttributeSet2.addAttribute(HTML.Tag.A, simpleAttributeSet);
                        simpleAttributeSet2.addAttribute(StyleConstants.Foreground, Color.BLUE);
                        simpleAttributeSet2.addAttribute(StyleConstants.Underline, new Boolean(true));
                        int n = 0;
                        int n2 = 0;
                        try {
                            if (this.originalText == null) {
                                n = HtmlEditor.this.editor.getCaretPosition();
                                n2 = n + string.length();
                                AttributeSet attributeSet = hTMLDocument.getCharacterElement(n).getAttributes();
                                boolean bl2 = false;
                                Enumeration<?> enumeration = attributeSet.getAttributeNames();
                                while (enumeration.hasMoreElements()) {
                                    Object obj = enumeration.nextElement();
                                }
                                hTMLDocument.insertString(n, string + " ", attributeSet);
                            } else {
                                n = HtmlEditor.this.editor.getSelectionStart();
                                n2 = n + string.length();
                                int n3 = HtmlEditor.this.editor.getSelectionEnd();
                                boolean bl3 = false;
                                AttributeSet attributeSet = hTMLDocument.getCharacterElement(n).getAttributes();
                                Enumeration<?> enumeration = attributeSet.getAttributeNames();
                                while (enumeration.hasMoreElements()) {
                                    Object obj = enumeration.nextElement();
                                }
                                if (n3 > n) {
                                    hTMLDocument.remove(n, n3 - n);
                                }
                                hTMLDocument.insertString(n, string, null);
                            }
                            if (n2 > n) {
                                HtmlEditor.this.editor.setSelectionStart(n);
                                HtmlEditor.this.editor.setSelectionEnd(n2);
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            Debug.traceException((Throwable)badLocationException);
                        }
                        HtmlEditor.this.editor.setCharacterAttributes(simpleAttributeSet2, false);
                        if (this.originalText == null) {
                            HtmlEditor.this.editor.setCaretPosition(n2 + 1);
                        }
                        HtmlEditor.this.editor.revalidate();
                        HtmlEditor.this.editor.repaint();
                        this.dispose();
                    }
                } else if (object == this.cancelButton) {
                    this.dispose();
                }
            }
        }
    }

    private class ActionForegroundColor
    extends StyledEditorKit.StyledTextAction {
        String name = "GWFontColor";

        public ActionForegroundColor() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JColorChooser jColorChooser = new JColorChooser();
            jColorChooser.setVisible(true);
            Color color = JColorChooser.showDialog(HtmlEditor.this.editor, RB.getString("FontColor_TT"), Color.black);
            if (color == null) {
                return;
            }
            new StyledEditorKit.ForegroundAction(this.name, color).actionPerformed(actionEvent);
        }
    }

    private class ActionFontSize
    extends StyledEditorKit.StyledTextAction {
        String name = "GWFontSize";

        public ActionFontSize() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!HtmlEditor.this.editor.isFocusOwner()) {
                return;
            }
            actionEvent.setSource(HtmlEditor.this.editor);
            Integer n = new Integer((String)HtmlEditor.this.cbFontSizes.getSelectedItem());
            new StyledEditorKit.FontSizeAction(this.name, n).actionPerformed(actionEvent);
        }
    }

    private class ActionFontName
    extends StyledEditorKit.StyledTextAction {
        String name = "GWFontType";

        public ActionFontName() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!HtmlEditor.this.editor.isFocusOwner()) {
                return;
            }
            new StyledEditorKit.FontFamilyAction(this.name, (String)HtmlEditor.this.cbFontNames.getSelectedItem()).actionPerformed(actionEvent);
        }
    }

    private class ActionAlignParagraph
    extends AbstractAction {
        StyledEditorKit.AlignmentAction alignAction;
        private int type;
        private String name;

        public ActionAlignParagraph(String string, Icon icon, int n) {
            super(string, icon);
            this.init(string, n);
        }

        public ActionAlignParagraph(String string, int n) {
            super(string);
            this.init(string, n);
        }

        private void init(String string, int n) {
            this.alignAction = new StyledEditorKit.AlignmentAction(string, n);
            this.type = n;
            this.name = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.alignAction.actionPerformed(actionEvent);
            HtmlEditor.this.updateAlignmentButtons(this.type);
        }
    }
}

