/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.widgets;

import com.novell.application.console.snapin.NConeFactory;
import com.novell.gw.admin.widgets.GWTextField;
import com.novell.gw.admin.widgets.RB;
import com.novell.gw.admin.widgets.WidgetIcon;
import com.novell.gw.util.Debug;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.Timer;

public class IncrementBox
extends JPanel
implements ActionListener,
MouseListener {
    public static final String DIRTY = "DIRTY";
    protected ImageIcon upArrow;
    protected ImageIcon downArrow;
    protected int lowerBound = Integer.MIN_VALUE;
    protected int upperBound = Integer.MAX_VALUE;
    protected IncrTextField textField = new IncrTextField();
    protected SmallButton upButton;
    protected SmallButton downButton;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private Timer timer;
    private int direction = 0;
    private int interval = 1;
    private int timerReps;
    private boolean capture = false;
    private static final int UP_DIRECTION = 1;
    private static final int DOWN_DIRECTION = -1;
    private static final int INITIAL_DELAY = 300;
    private static final int REGULAR_DELAY = 25;
    private static final int FAST_INC = 2;
    private static final int DEFAULT_WIDTH = 60;
    private static final int OLD_DEFAULT_HEIGHT = 25;
    private static final int DEFAULT_HEIGHT = new GWTextField().getPreferredSize().height;

    public IncrementBox(int n) {
        this();
        this.setValue(n);
    }

    public IncrementBox(int n, int n2, int n3, int n4) {
        this(n, n2, n3);
        this.setMinimumSize(new Dimension(n4, 25));
        this.setPreferredSize(new Dimension(n4, 25));
    }

    public IncrementBox(int n, int n2, int n3) {
        this();
        if (n > n2) {
            n = n2;
        }
        this.setBounds(n, n2);
        this.setValue(n3);
    }

    public IncrementBox() {
        super(new GridBagLayout());
        this.setMinimumSize(new Dimension(60, DEFAULT_HEIGHT));
        this.setPreferredSize(new Dimension(60, DEFAULT_HEIGHT));
        this.timer = new Timer(25, this);
        this.timer.setInitialDelay(300);
        this.upArrow = new WidgetIcon(this.getClass(), "upArrow.gif");
        this.downArrow = new WidgetIcon(this.getClass(), "downArrow.gif");
        this.textField.setHorizontalAlignment(0);
        this.textField.setFont(new Font("SansSerif", 0, 12));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 15.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        ((GridBagLayout)this.getLayout()).setConstraints(this.textField, gridBagConstraints);
        this.add(this.textField);
        Dimension dimension = this.textField.getMinimumSize();
        Dimension dimension2 = this.textField.getPreferredSize();
        Dimension dimension3 = new Dimension(15, dimension.height / 2);
        Dimension dimension4 = new Dimension(15, dimension2.height / 2);
        this.upButton = new SmallButton(this.upArrow);
        this.upButton.setMinimumSize(dimension3);
        this.upButton.setPreferredSize(dimension4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.fill = 3;
        ((GridBagLayout)this.getLayout()).setConstraints(this.upButton, gridBagConstraints);
        this.add(this.upButton);
        this.downButton = new SmallButton(this.downArrow);
        this.downButton.setMinimumSize(dimension3);
        this.downButton.setPreferredSize(dimension4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.fill = 3;
        ((GridBagLayout)this.getLayout()).setConstraints(this.downButton, gridBagConstraints);
        this.add(this.downButton);
        this.upButton.addActionListener(this);
        this.downButton.addActionListener(this);
        this.upButton.addMouseListener(this);
        this.downButton.addMouseListener(this);
    }

    public void setInterval(int n) {
        this.interval = n;
    }

    public void setHorizontalAlignment(int n) {
        this.textField.setHorizontalAlignment(n);
    }

    public void setEnabled(boolean bl) {
        this.upButton.setEnabled(bl);
        this.downButton.setEnabled(bl);
        this.textField.setEnabled(bl);
    }

    public GWTextField getTextField() {
        return this.textField;
    }

    public String getText() {
        return this.textField.getText();
    }

    public void setValue(String string) {
        try {
            int n = Integer.parseInt(string);
            this.setValue(n);
        }
        catch (NumberFormatException numberFormatException) {
            Debug.trace((String)("IncrementBox.setValue: " + numberFormatException.toString()));
            this.setValue(this.upperBound);
            this.firePropertyChangeBox(DIRTY, null, null);
        }
    }

    public void setValue(int n) {
        if (n < this.lowerBound) {
            n = this.lowerBound;
        }
        if (n > this.upperBound) {
            n = this.upperBound;
        }
        this.textField.setText(new Integer(n).toString());
        this.textField.normalize();
    }

    public int getValue() {
        String string = this.textField.getText();
        int n = -1;
        if (string.length() > 0) {
            try {
                n = new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
                Debug.trace((String)("IncrementBox.getValue: " + numberFormatException.toString()));
                n = this.upperBound;
                this.setValue(n);
                this.firePropertyChangeBox(DIRTY, null, null);
            }
        }
        return n;
    }

    public boolean hasValue() {
        return this.textField.getDocument().getLength() > 0;
    }

    public void setBounds(int n, int n2) {
        this.lowerBound = n;
        if (n2 != -1) {
            this.upperBound = n2;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.upButton) {
            this.setValue(this.getValue() + this.interval);
            this.downButton.requestFocus();
            this.upButton.requestFocus();
        } else if (object == this.downButton) {
            this.setValue(this.getValue() - this.interval);
            this.upButton.requestFocus();
            this.downButton.requestFocus();
        } else if (object == this.timer) {
            ++this.timerReps;
            int n = this.interval;
            if (this.timerReps > 10) {
                n *= 10;
            }
            if (this.timerReps > 25) {
                n *= 10;
            }
            int n2 = this.getValue();
            if (this.direction == 1) {
                this.setValue(n2 + n * 2);
            } else if (this.direction == -1) {
                this.setValue(n2 - n * 2);
            }
            this.textField.selectAll();
        }
        this.firePropertyChangeBox(DIRTY, null, null);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.direction = mouseEvent.getSource() == this.upButton ? 1 : -1;
        this.capture = true;
        this.timer.restart();
        this.timerReps = 0;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.capture = false;
        this.timer.stop();
        this.direction = 0;
        this.textField.selectAll();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.capture) {
            this.timer.start();
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.capture) {
            this.timer.stop();
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void firePropertyChangeBox(String string, Object object, Object object2) {
        if (this.pcs != null) {
            this.pcs.firePropertyChange(string, object, object2);
        }
    }

    public void setAccessible(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.upButton) {
            NConeFactory.novellJButton((JButton)this.upButton, (String)(this.textField.getText() + "\t\t\t\t" + RB.getString("UpButton")), (String)"");
        } else if (focusEvent.getSource() == this.downButton) {
            NConeFactory.novellJButton((JButton)this.downButton, (String)(this.textField.getText() + "\t\t\t\t" + RB.getString("DownButton")), (String)"");
        }
    }

    class IncrTextField
    extends GWTextField
    implements ActionListener {
        IncrTextField() {
            this.enableEvents(8L);
            this.enableEvents(4L);
        }

        protected void processFocusEvent(FocusEvent focusEvent) {
            super.processFocusEvent(focusEvent);
            if (focusEvent.getID() == 1005) {
                this.normalize();
            }
        }

        protected void processKeyEvent(KeyEvent keyEvent) {
            int n = keyEvent.getID();
            int n2 = keyEvent.getKeyCode();
            char c = keyEvent.getKeyChar();
            if (n == 401) {
                if (n2 == 38) {
                    int n3 = IncrementBox.this.getValue() + IncrementBox.this.interval;
                    if (n3 > IncrementBox.this.upperBound) {
                        this.getToolkit().beep();
                    } else {
                        this.setText(Integer.toString(n3));
                        IncrementBox.this.firePropertyChangeBox(IncrementBox.DIRTY, null, null);
                        this.transferFocus();
                        this.requestFocus();
                    }
                } else if (n2 == 40) {
                    int n4 = IncrementBox.this.getValue() - IncrementBox.this.interval;
                    if (n4 < IncrementBox.this.lowerBound) {
                        this.getToolkit().beep();
                    } else {
                        this.setText(Integer.toString(n4));
                        IncrementBox.this.firePropertyChangeBox(IncrementBox.DIRTY, null, null);
                        this.transferFocus();
                        this.requestFocus();
                    }
                } else if (this.isInputCharValid(c, n2)) {
                    super.processKeyEvent(keyEvent);
                    if (c != '\t') {
                        IncrementBox.this.firePropertyChangeBox(IncrementBox.DIRTY, null, null);
                    }
                } else {
                    this.getToolkit().beep();
                }
            } else if (n != 402 && n == 400) {
                if (this.isInputCharValid(c, n2)) {
                    super.processKeyEvent(keyEvent);
                    if (c != '\t') {
                        IncrementBox.this.firePropertyChangeBox(IncrementBox.DIRTY, null, null);
                    }
                } else {
                    this.getToolkit().beep();
                }
            }
        }

        private boolean isInputCharValid(char c, int n) {
            if (Character.isDigit(c)) {
                return true;
            }
            return c == '\n' || c == '\b' || c == '\t' || c == '\u001b' || c == '\u007f' || n == 35 || n == 36 || n == 37 || n == 39;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            IncrementBox.this.firePropertyChangeBox(IncrementBox.DIRTY, null, null);
        }

        public void normalize() {
            int n = IncrementBox.this.getValue();
            if (n > IncrementBox.this.upperBound) {
                this.getToolkit().beep();
                this.setText(new Integer(IncrementBox.this.upperBound).toString());
                IncrementBox.this.firePropertyChangeBox(IncrementBox.DIRTY, null, null);
            } else if (n < IncrementBox.this.lowerBound) {
                this.getToolkit().beep();
                this.setText(new Integer(IncrementBox.this.lowerBound).toString());
                IncrementBox.this.firePropertyChangeBox(IncrementBox.DIRTY, null, null);
            }
        }
    }

    class SmallButton
    extends JButton
    implements FocusListener {
        SmallButton(ImageIcon imageIcon) {
            super(imageIcon);
            this.addFocusListener(this);
            this.setDefaultCapable(false);
        }

        public boolean isFocusable() {
            return true;
        }

        public void focusGained(FocusEvent focusEvent) {
            IncrementBox.this.setAccessible(focusEvent);
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }
}

