/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.widgets;

import com.novell.application.console.snapin.NConeFactory;
import com.novell.gw.admin.widgets.GwList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class OrderedList
extends JPanel
implements ActionListener,
ListDataListener,
ListSelectionListener {
    private JList list = new GwList();
    private JScrollPane scrollPane;
    private DefaultListModel listModel = new DefaultListModel();
    private JButton upButton;
    private JButton downButton;
    private boolean orderChanged = false;

    public OrderedList() {
        this("");
    }

    public OrderedList(String string) {
        this.initComponents(string);
        this.list.addListSelectionListener(this);
    }

    private void initComponents(String string) {
        this.setLayout(new GridBagLayout());
        JLabel jLabel = NConeFactory.novellJLabel((JLabel)new JLabel(string), (String)string, (String)"");
        int n = jLabel.getPreferredSize().height;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        this.add((Component)jLabel, gridBagConstraints);
        this.list.getAccessibleContext().setAccessibleName(jLabel.getText());
        this.list.setModel(this.listModel);
        this.scrollPane = new JScrollPane(this.list);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.scrollPane, gridBagConstraints);
        Box box = Box.createVerticalBox();
        box.add(Box.createVerticalGlue());
        Dimension dimension = new Dimension(30, 30);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)box, gridBagConstraints);
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/com/novell/gw/admin/widgets/images/up24.gif"));
        ImageIcon imageIcon2 = new ImageIcon(this.getClass().getResource("/com/novell/gw/admin/widgets/images/down24.gif"));
        JPanel jPanel = NConeFactory.novellJPanel((JPanel)new JPanel(), (String)"", (String)"");
        this.upButton = NConeFactory.novellJButton((JButton)new JButton(imageIcon), (String)"up", (String)"");
        this.upButton.setMinimumSize(dimension);
        this.upButton.setPreferredSize(dimension);
        this.upButton.setVisible(true);
        this.upButton.setEnabled(false);
        this.upButton.addActionListener(this);
        jPanel.add(this.upButton);
        this.downButton = NConeFactory.novellJButton((JButton)new JButton(imageIcon2), (String)"down", (String)"");
        this.downButton.setMinimumSize(dimension);
        this.downButton.setPreferredSize(dimension);
        this.downButton.setVisible(true);
        this.downButton.setEnabled(false);
        this.downButton.addActionListener(this);
        jPanel.add(this.downButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        this.add((Component)jPanel, gridBagConstraints);
    }

    public void addElement(Object object) {
        this.listModel.addElement(object);
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.list.addListSelectionListener(listSelectionListener);
    }

    public void clearSelection() {
        this.list.clearSelection();
    }

    public boolean isOrderChanged() {
        return this.orderChanged;
    }

    public boolean isSelectionEmpty() {
        return this.list.isSelectionEmpty();
    }

    public boolean isSingleSelection() {
        return this.list.getMinSelectionIndex() == this.list.getMaxSelectionIndex();
    }

    public Object getElementAt(int n) {
        Object var2_2 = null;
        int n2 = this.listModel.getSize();
        if (n < n2) {
            var2_2 = this.listModel.elementAt(n);
        }
        return var2_2;
    }

    public int getMaxSelectionIndex() {
        return this.list.getMaxSelectionIndex();
    }

    public int getMinSelectionIndex() {
        return this.list.getMinSelectionIndex();
    }

    public int getSelectedIndex() {
        return this.list.getSelectedIndex();
    }

    public int getListCount() {
        return this.listModel.getSize();
    }

    private void moveSelectedDown() {
        this.moveSelectedVert(1);
    }

    private void moveSelectedUp() {
        this.moveSelectedVert(-1);
    }

    private void moveSelectedVert(int n) {
        this.orderChanged = true;
        int n2 = this.list.getSelectedIndex();
        Object e = this.listModel.elementAt(n2);
        this.listModel.removeElementAt(n2);
        this.listModel.insertElementAt(e, n2 += n);
        this.list.addSelectionInterval(n2, n2);
        this.updateEnabling();
    }

    public void putElement(int n, Object object) {
        int n2 = this.listModel.getSize();
        if (n < n2) {
            this.listModel.removeElementAt(n);
            this.listModel.insertElementAt(object, n);
        }
    }

    public void removeElementAt(int n) {
        int n2 = this.listModel.getSize();
        if (n < n2) {
            this.listModel.removeElementAt(n);
        }
    }

    public void setEnabled(boolean bl) {
        this.list.setEnabled(bl);
        if (!bl) {
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        }
    }

    public void setListPrefSize(Dimension dimension) {
        this.scrollPane.setPreferredSize(dimension);
    }

    public void setVerticalArrowsVisible(boolean bl) {
        this.upButton.setVisible(bl);
        this.downButton.setVisible(bl);
    }

    private void updateEnabling() {
        if (this.isSingleSelection()) {
            int n = this.list.getSelectedIndex();
            boolean bl = n != 0;
            this.upButton.setEnabled(bl);
            int n2 = this.listModel.getSize();
            boolean bl2 = n < n2 - 1;
            this.downButton.setEnabled(bl2);
        } else {
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        }
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.upButton) {
            this.moveSelectedUp();
        } else if (object == this.downButton) {
            this.moveSelectedDown();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object object = listSelectionEvent.getSource();
        if (object == this.list) {
            this.updateEnabling();
        }
    }
}

