/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.widgets;

import com.novell.application.console.snapin.NConeFactory;
import com.novell.gw.util.Debug;
import com.novell.gw.util.Misc;
import com.novell.utility.nmsgbox.NActivityBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

public class PleaseWait
implements Runnable {
    private static final String DOT_STRING = "...";
    private PleaseWaitProgress pw = null;
    private NActivityBox c1pw = null;
    private boolean useC1 = false;
    private volatile boolean wasDisposed = false;
    private volatile boolean wasShown = false;

    public PleaseWait(Window window, String string, boolean bl) {
        this.init(window, string, "", 1000, bl);
    }

    public PleaseWait(Window window, String string, String string2, int n, boolean bl) {
        this.init(window, string, string2, n, bl);
    }

    public void init(Window window, String string, String string2, int n, boolean bl) {
        Frame frame = this.getParentFrame(window);
        this.useC1 = bl;
        if (bl) {
            this.c1pw = new NActivityBox((Component)frame, string);
        } else {
            this.pw = new PleaseWaitProgress(frame, string, string2, n);
        }
        new Thread(this).start();
    }

    private Frame getParentFrame(Component component) {
        while (component != null) {
            if (component instanceof Frame) {
                return (Frame)component;
            }
            component = component.getParent();
        }
        return new Frame();
    }

    public Window getWindow() {
        if (this.useC1) {
            return this.c1pw;
        }
        return this.pw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Thread.currentThread();
            Thread.sleep(250L);
        }
        catch (InterruptedException interruptedException) {
            Debug.traceException((Throwable)interruptedException);
        }
        PleaseWait pleaseWait = this;
        synchronized (pleaseWait) {
            if (!this.wasDisposed) {
                this.wasShown = true;
                if (this.useC1) {
                    this.c1pw.showImmediately();
                } else {
                    this.pw.showImmediately();
                }
            }
        }
    }

    public void setText1(String string) {
        if (!this.useC1) {
            this.pw.setText1(string);
        }
    }

    public void setText2(String string) {
        if (!this.useC1) {
            this.pw.setText2(string);
        }
    }

    public void incrementBy(int n) {
        if (!this.useC1) {
            this.pw.incrementBy(n);
        }
    }

    public void setProgressLimit(int n) {
        if (!this.useC1) {
            this.pw.setProgressLimit(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        PleaseWait pleaseWait = this;
        synchronized (pleaseWait) {
            if (this.wasShown) {
                if (this.useC1) {
                    this.c1pw.dispose();
                } else {
                    this.pw.dispose();
                }
            }
            this.wasDisposed = true;
        }
    }

    class PleaseWaitProgress
    extends Window {
        private JLabel msg1Label = null;
        private JLabel msg2Label = null;
        private JProgressBar pbar = null;
        private int pbarCount = 0;
        private int items;
        private JPanel mainPanel;

        public PleaseWaitProgress(Frame frame, String string, String string2, int n) {
            super(frame);
            this.items = n;
            this.mainPanel = Misc.getVerticalLayoutPanel();
            this.mainPanel.setBorder(new CompoundBorder(new CompoundBorder(new BevelBorder(0), new EtchedBorder()), new EmptyBorder(10, 10, 10, 10)));
            String string3 = string2;
            if (string3 == null) {
                string3 = PleaseWait.DOT_STRING;
            }
            this.msg1Label = NConeFactory.novellJLabel((JLabel)new JLabel(string), (String)string, (String)"");
            this.msg2Label = NConeFactory.novellJLabel((JLabel)new JLabel(string3), (String)string3, (String)"");
            this.pbar = n > 0 ? new JProgressBar(0, n) : new JProgressBar();
            this.pbar.setStringPainted(true);
            this.msg1Label.setAlignmentX(0.5f);
            this.msg2Label.setAlignmentX(0.5f);
            this.pbar.setAlignmentX(0.5f);
            this.msg1Label.setHorizontalAlignment(0);
            this.msg2Label.setHorizontalAlignment(0);
            this.mainPanel.add(this.msg1Label);
            this.mainPanel.add(this.msg2Label);
            this.mainPanel.add(Box.createRigidArea(new Dimension(300, 10)));
            this.mainPanel.add(this.pbar);
            this.add((Component)this.mainPanel, "Center");
            this.pack();
            int n2 = this.getWidth();
            int n3 = this.getHeight() + 20;
            this.setSize(n2, n3);
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation(dimension.width / 2 - n2 / 2, dimension.height / 2 - n3 / 2);
            Dimension dimension2 = this.msg1Label.getPreferredSize();
            dimension2.width = n2 - 10;
            Misc.setAbsoluteSize((JComponent)this.msg1Label, (Dimension)dimension2);
            Misc.setAbsoluteSize((JComponent)this.msg2Label, (Dimension)dimension2);
        }

        public void showImmediately() {
            this.setVisible(true);
            this.forceRepaint();
        }

        private void forceRepaint() {
            Dimension dimension = this.mainPanel.getSize();
            this.mainPanel.paintImmediately(0, 0, dimension.width, dimension.height);
        }

        public void setText1(String string) {
            this.msg1Label.setText(string);
            this.pbar.setValue(++this.pbarCount);
            this.forceRepaint();
        }

        public void setText2(String string) {
            this.msg2Label.setText(string);
            this.pbar.setValue(++this.pbarCount);
            this.forceRepaint();
        }

        public void incrementBy(int n) {
            Debug.trace((String)("PleaseWaitProgress.incrementBy: " + n));
            if (n >= 0 && n <= this.items) {
                this.msg2Label.setText(PleaseWait.DOT_STRING);
                this.pbarCount += n;
                this.pbar.setValue(this.pbarCount);
                this.forceRepaint();
            } else {
                Debug.trace((String)("\n\n      **** PleaseWaitProgress.incrementBy: BOGUS value=" + n));
            }
        }

        public void setProgressLimit(int n) {
            if (n < 1) {
                n = 1;
            }
            this.items = n;
            this.pbar.setMaximum(n);
        }
    }
}

