/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.widgets;

import java.util.BitSet;
import java.util.Vector;

public class SmartBits
implements Cloneable {
    private BitSet bits = new BitSet();

    public SmartBits() {
        this.bits = new BitSet();
    }

    public SmartBits(SmartBits smartBits) {
        this(smartBits.getBits());
    }

    public SmartBits(BitSet bitSet) {
        this.bits = (BitSet)bitSet.clone();
    }

    public SmartBits(byte[] byArray) {
        this();
        this.setValue(byArray);
    }

    public void set(int n) {
        this.bits.set(n);
    }

    public void clear(int n) {
        this.bits.clear(n);
    }

    public boolean get(int n) {
        return this.bits.get(n);
    }

    public void and(BitSet bitSet) {
        this.bits.and(bitSet);
    }

    public void or(BitSet bitSet) {
        this.bits.or(bitSet);
    }

    public void xor(BitSet bitSet) {
        this.bits.xor(bitSet);
    }

    public int hashCode() {
        return this.bits.hashCode();
    }

    public int size() {
        return this.bits.size();
    }

    public boolean equals(Object object) {
        return this.bits.equals(object);
    }

    public Object clone() {
        return new SmartBits((BitSet)this.bits.clone());
    }

    public String toString() {
        return this.bits.toString();
    }

    public BitSet getBits() {
        return (BitSet)this.bits.clone();
    }

    public void setValue(BitSet bitSet) {
        this.bits = (BitSet)bitSet.clone();
    }

    public Vector getSpecificBits() {
        Vector<Integer> vector = new Vector<Integer>();
        int n = this.bits.size();
        for (int i = 0; i < n; ++i) {
            if (!this.bits.get(i)) continue;
            vector.addElement(new Integer(i));
        }
        return vector;
    }

    public void setValue(Vector vector) {
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            Integer n2 = (Integer)vector.elementAt(i);
            this.bits.set(n2);
        }
    }

    public byte[] getByteArray() {
        int n = this.bits.size() / 8;
        if (this.bits.size() % 8 != 0) {
            ++n;
        }
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j <= 7; ++j) {
                int n2 = i * 8 + j;
                if (!this.bits.get(n2)) continue;
                int n3 = i;
                byArray[n3] = (byte)(byArray[n3] | new Integer(1 << j).byteValue());
            }
        }
        return byArray;
    }

    public void setValue(byte[] byArray) {
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j <= 7; ++j) {
                int n2 = i * 8 + j;
                Integer n3 = new Integer(1 << j);
                if ((byArray[i] & n3.byteValue()) != 0) {
                    this.bits.set(n2);
                    continue;
                }
                this.bits.clear(n2);
            }
        }
    }

    public int getNextBit(int n, boolean bl) {
        int n2 = n;
        Vector vector = this.getSpecificBits();
        if (vector.size() == 0) {
            n2 = -1;
        } else {
            boolean bl2 = true;
            do {
                if (++n2 == this.bits.size() && !bl) {
                    n2 = -1;
                    break;
                }
                if (n2 == this.bits.size() && bl) {
                    n2 = 0;
                }
                if (!vector.contains(new Integer(n2))) continue;
                bl2 = false;
            } while (bl2);
        }
        return n2;
    }
}

