/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.widgets;

import com.novell.gw.admin.widgets.GWTextField;
import com.novell.gw.util.Debug;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

public class TimeEditor
extends GregorianCalendar {
    private DateFormat df = null;
    private GWTextField tf = null;
    private String origStr = null;
    private boolean usesAM_PM = false;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public TimeEditor(int n) {
        Debug.trace((String)("\nTimeEditor seconds = " + n));
        this.df = DateFormat.getTimeInstance(3);
        this.tf = new GWTextField(5);
        this.tf.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                GWTextField gWTextField = (GWTextField)focusEvent.getSource();
                TimeEditor.this.parseTimeString(gWTextField.getText());
            }
        });
        int n2 = n % 86400;
        this.set(11, n2 / 3600);
        n2 = n % 3600;
        this.set(12, n2 / 60);
        this.df.setCalendar(this);
        this.origStr = this.getTimeString();
        this.tf.setText(this.origStr);
        Debug.trace((String)("TimeEditor minutes = " + this.getTotalMinutes()));
        Locale locale = Locale.getDefault();
        if (locale.getCountry().equals("US")) {
            this.usesAM_PM = true;
        }
    }

    public void setEnabled(boolean bl) {
        this.tf.setEnabled(bl);
    }

    private void parseTimeString(String string) {
        Debug.trace((String)("TimeEditor.parseTimeString: str= " + string));
        if (string == null) {
            this.tf.setText(this.origStr);
            return;
        }
        if (this.usesAM_PM) {
            int n;
            int n2 = (string = string.toUpperCase()).indexOf(65);
            if (n2 == -1) {
                n2 = string.indexOf(80);
            }
            if (n2 == -1) {
                this.tf.setText(this.origStr);
                return;
            }
            int n3 = string.indexOf(58);
            StringBuffer stringBuffer = new StringBuffer(string.toUpperCase());
            try {
                n = stringBuffer.charAt(n2 + 1);
                if (n != 77) {
                    stringBuffer.insert(n2 + 1, 'M');
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                stringBuffer.append('M');
            }
            if (n3 == -1) {
                stringBuffer.insert(n2, ":00 ");
            }
            if ((n = (string = stringBuffer.toString()).indexOf(32)) == -1) {
                stringBuffer = new StringBuffer(string);
                stringBuffer.insert(n2, ' ');
                string = stringBuffer.toString();
            }
        }
        Date date = null;
        try {
            date = this.df.parse(string);
        }
        catch (ParseException parseException) {
            Debug.trace((String)("====================TimeEditor.parseTimeString: ParseException on string " + string));
        }
        if (date == null) {
            this.tf.setText(this.origStr);
        } else {
            this.setTime(date);
            String string2 = this.getTimeString();
            this.tf.setText(string2);
            this.pcs.firePropertyChange("Date", this.origStr, string2);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public int getTotalMinutes() {
        int n = this.get(11);
        int n2 = this.get(12);
        return 60 * n + n2;
    }

    public int getTotalSeconds() {
        return this.getTotalMinutes() * 60;
    }

    public boolean isModified() {
        String string = this.tf.getText();
        boolean bl = this.origStr.equalsIgnoreCase(string);
        return !bl;
    }

    private String getTimeString() {
        return this.df.format(this.getTime());
    }

    public GWTextField getTextField() {
        return this.tf;
    }

    public String toString() {
        return "TimeEditor: " + this.getTimeString();
    }
}

