/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.widgets;

import com.novell.application.console.widgets.NDialog;
import com.novell.gw.admin.widgets.DisposeWindow;
import com.novell.gw.admin.widgets.ShowNDIalog;
import com.novell.gw.admin.widgets.ShowWindow;
import com.novell.gw.util.Debug;
import java.awt.Dialog;
import java.awt.Window;
import javax.swing.SwingUtilities;

public class WidgetUtils {
    public static void showWindowThreadSafe(Window window) {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                window.show();
            } else {
                ShowWindow showWindow = new ShowWindow(window);
                if (window instanceof Dialog && ((Dialog)window).isModal()) {
                    SwingUtilities.invokeAndWait(showWindow);
                } else {
                    SwingUtilities.invokeLater(showWindow);
                }
            }
        }
        catch (Exception exception) {
            Debug.trace((String)("WidgetUtils.showWindowThreadSafe: ex= " + exception));
            Debug.traceException((Throwable)exception);
        }
    }

    public static int showNDialogThreadSafe(NDialog nDialog) {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                return nDialog.launch();
            }
            ShowNDIalog showNDIalog = new ShowNDIalog(nDialog);
            SwingUtilities.invokeAndWait(showNDIalog);
            return showNDIalog.getResult();
        }
        catch (Exception exception) {
            Debug.trace((String)("WidgetUtils.showNDialogThreadSafe: ex= " + exception));
            Debug.traceException((Throwable)exception);
            return -1;
        }
    }

    public static void disposeWindowThreadSafe(Window window) {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                window.dispose();
            } else {
                DisposeWindow disposeWindow = new DisposeWindow(window);
                SwingUtilities.invokeLater(disposeWindow);
            }
        }
        catch (Exception exception) {
            Debug.trace((String)("WidgetUtils.disposeThreadSafe: ex= " + exception));
            Debug.traceException((Throwable)exception);
        }
    }
}

