/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.directory;

import com.novell.gw.directory.FDoc;
import com.novell.gw.directory.FKey;
import com.novell.gw.directory.FObj;
import com.novell.gw.util.Debug;
import javax.naming.CommunicationException;

public class FObjIterator
implements Cloneable {
    private int ptr;
    private FDoc fDoc;

    private native int getIndexCount();

    public native int getCurrentDirection();

    public native void setBufferSize(int var1);

    public native int getBufferSize();

    private native int moveIterTo(FObj var1);

    private native int moveIterTo(FObj var1, int var2);

    private native int moveIterTo(int var1, String var2);

    private native int moveIterTo(int var1, String var2, int var3);

    private native int moveIterTo(int var1, int var2);

    private native int moveIterTo(FKey var1, int var2);

    private native int startIter();

    private native int startIterFromEnd();

    public native int skip(int var1);

    private native boolean hasMoreElements();

    private native boolean hasPrevElements();

    private native Object nextElement();

    private native Object prevElement();

    private native int compareIterRecsByDrn(int var1, int var2);

    private native int getAdjacentIterDrn(int var1, boolean var2);

    private native void cleanup();

    private native int cloneFDSBrowse();

    private static native void initIDs();

    private native int getIOStatus();

    FObjIterator(int n) {
        this.ptr = n;
    }

    private void checkIOStatus() throws CommunicationException {
        int n = this.getIOStatus();
        if ((n & 0xFF00) == 33280) {
            String string = Integer.toHexString(n).toUpperCase();
            String string2 = "  (0x" + string + ")";
            throw new CommunicationException(string2);
        }
    }

    public int getCount() throws CommunicationException {
        int n = this.getIndexCount();
        this.checkIOStatus();
        return n;
    }

    public void setFDoc(FDoc fDoc) {
        this.fDoc = fDoc;
    }

    public FDoc getFDoc() {
        return this.fDoc;
    }

    public FKey createFkey() {
        return this.fDoc.getKey();
    }

    public Object clone() {
        FObjIterator fObjIterator = new FObjIterator(this.cloneFDSBrowse());
        fObjIterator.setFDoc(this.fDoc);
        try {
            this.checkIOStatus();
        }
        catch (CommunicationException communicationException) {
            Debug.traceException((Throwable)communicationException);
        }
        return fObjIterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.cleanup();
            this.fDoc = null;
        }
        finally {
            this.ptr = 0;
            super.finalize();
        }
    }

    public int compareRecsByDrn(int n, int n2) throws CommunicationException {
        int n3 = this.compareIterRecsByDrn(n, n2);
        this.checkIOStatus();
        return n3;
    }

    public int getAdjacentDrn(int n, boolean bl) throws CommunicationException {
        int n2 = this.getAdjacentIterDrn(n, bl);
        this.checkIOStatus();
        return n2;
    }

    public boolean hasMore() throws CommunicationException {
        boolean bl = this.hasMoreElements();
        this.checkIOStatus();
        return bl;
    }

    public boolean hasPrev() throws CommunicationException {
        boolean bl = this.hasPrevElements();
        this.checkIOStatus();
        return bl;
    }

    public int moveTo(FObj fObj) throws CommunicationException {
        int n = this.moveIterTo(fObj);
        this.checkIOStatus();
        return n;
    }

    public int moveTo(FObj fObj, int n) throws CommunicationException {
        int n2 = this.moveIterTo(fObj, n);
        this.checkIOStatus();
        return n2;
    }

    public int moveTo(int n, String string) throws CommunicationException {
        int n2 = this.moveIterTo(n, string);
        this.checkIOStatus();
        return n2;
    }

    public int moveTo(int n, String string, int n2) throws CommunicationException {
        int n3 = this.moveIterTo(n, string, n2);
        this.checkIOStatus();
        return n3;
    }

    public int moveTo(int n, int n2) throws CommunicationException {
        int n3 = this.moveIterTo(n, n2);
        this.checkIOStatus();
        return n3;
    }

    public int moveTo(FKey fKey, int n) throws CommunicationException {
        int n2 = this.moveIterTo(fKey, n);
        this.checkIOStatus();
        return n2;
    }

    public Object next() throws CommunicationException {
        Object object = this.nextElement();
        this.checkIOStatus();
        return object;
    }

    public Object prev() throws CommunicationException {
        Object object = this.prevElement();
        this.checkIOStatus();
        return object;
    }

    public int start() throws CommunicationException {
        int n = this.startIter();
        this.checkIOStatus();
        return n;
    }

    public int startFromEnd() throws CommunicationException {
        int n = this.startIterFromEnd();
        this.checkIOStatus();
        return n;
    }

    static {
        FObjIterator.initIDs();
    }
}

