/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.directory;

import com.novell.gw.directory.ADADirContext;
import com.novell.gw.directory.ActionContainerDirContext;
import com.novell.gw.directory.ActionDirContext;
import com.novell.gw.directory.AreaContainerDirContext;
import com.novell.gw.directory.ChkOpts;
import com.novell.gw.directory.CustAddrContainerDirContext;
import com.novell.gw.directory.CustomAddrDirContext;
import com.novell.gw.directory.DomainDirContext;
import com.novell.gw.directory.EntityDirContext;
import com.novell.gw.directory.EventContainerDirContext;
import com.novell.gw.directory.EventDirContext;
import com.novell.gw.directory.FDoc;
import com.novell.gw.directory.FFilter;
import com.novell.gw.directory.FKey;
import com.novell.gw.directory.FObj;
import com.novell.gw.directory.FObjIterator;
import com.novell.gw.directory.FView;
import com.novell.gw.directory.GWInformation;
import com.novell.gw.directory.GatewayDirContext;
import com.novell.gw.directory.GroupDirContext;
import com.novell.gw.directory.GwCallBack;
import com.novell.gw.directory.GwDirContext;
import com.novell.gw.directory.GwDirObject;
import com.novell.gw.directory.GwNameClassEnumerator;
import com.novell.gw.directory.GwNameParser;
import com.novell.gw.directory.GwSearchResult;
import com.novell.gw.directory.GwSearchResultEnumerator;
import com.novell.gw.directory.IDomainContainerDirContext;
import com.novell.gw.directory.IDomainDirContext;
import com.novell.gw.directory.LDAPServerContainerDirContext;
import com.novell.gw.directory.LDAPServerDirContext;
import com.novell.gw.directory.LabelsDirContext;
import com.novell.gw.directory.LibAreaDirContext;
import com.novell.gw.directory.LibraryDirContext;
import com.novell.gw.directory.LinkDestDirContext;
import com.novell.gw.directory.LinkSrcDirContext;
import com.novell.gw.directory.MTADirContext;
import com.novell.gw.directory.MTAProfileContainerDirContext;
import com.novell.gw.directory.MTAProfileDirContext;
import com.novell.gw.directory.NdsDsFieldMapDirContext;
import com.novell.gw.directory.NicknameDirContext;
import com.novell.gw.directory.POADirContext;
import com.novell.gw.directory.PostOfficeDirContext;
import com.novell.gw.directory.ResourceDirContext;
import com.novell.gw.directory.RestoreAreaDirContext;
import com.novell.gw.directory.SoftwareAreaDirContext;
import com.novell.gw.directory.SysRecContainerDirContext;
import com.novell.gw.directory.SystemRecDirContext;
import com.novell.gw.directory.TPref;
import com.novell.gw.directory.TZContainerDirContext;
import com.novell.gw.directory.TimeZoneDirContext;
import com.novell.gw.directory.TrustedAppContainerDirContext;
import com.novell.gw.directory.TrustedAppDirContext;
import com.novell.gw.directory.UserDirContext;
import com.novell.gw.directory.X400DirContext;
import com.novell.gw.util.Debug;
import com.novell.gw.util.EngineResource;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.CommunicationException;
import javax.naming.CompoundName;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.InvalidNameException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.SizeLimitExceededException;
import javax.naming.directory.Attribute;
import javax.naming.directory.AttributeModificationException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.directory.InvalidAttributesException;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.spi.ResolveResult;

public class GwComponentDirContext
implements GwDirObject {
    private static final NameParser nameParser = new GwNameParser();
    private static final Object prefLockObj = new Object();
    private Hashtable environment;
    private CompoundName distinguishedName;
    private CompoundName remainingName;
    private FDoc doc;
    private FObj flaimObj;
    private int domainVersion;

    protected GwComponentDirContext(CompoundName compoundName, FDoc fDoc, FObj fObj, Hashtable hashtable, int n) throws NamingException {
        this.distinguishedName = (CompoundName)compoundName.clone();
        this.remainingName = null;
        this.doc = fDoc;
        this.flaimObj = fObj;
        this.environment = hashtable != null ? (Hashtable)hashtable.clone() : null;
        this.domainVersion = n;
    }

    public Hashtable getEnvironment() throws NamingException {
        return (Hashtable)this.environment.clone();
    }

    public Object addToEnvironment(String string, Object object) throws NamingException {
        if (this.environment == null) {
            this.environment = new Hashtable();
        }
        return this.environment.put(string, object);
    }

    public Object removeFromEnvironment(String string) throws NamingException {
        if (this.environment == null) {
            return null;
        }
        return this.environment.remove(string);
    }

    protected void c_bind(CompoundName compoundName, Object object) throws NamingException {
        this.setError(this, compoundName);
        throw this.fillInException(new OperationNotSupportedException());
    }

    protected Context c_createSubcontext(CompoundName compoundName) throws NamingException {
        this.setError(this, compoundName);
        throw this.fillInException(new OperationNotSupportedException());
    }

    protected void c_destroySubcontext(CompoundName compoundName) throws NamingException {
        FObj fObj;
        if (compoundName.isEmpty()) {
            fObj = this.flaimObj;
            if (fObj == null) {
                this.setError(this, compoundName);
                throw this.fillInException(new NameNotFoundException());
            }
        } else {
            try {
                fObj = this.getObjectInstance(compoundName, 0);
            }
            catch (NamingException namingException) {
                this.setError(this, compoundName);
                throw this.fillInException(namingException);
            }
        }
        if (!fObj.isObjectValid()) {
            this.setError(this, compoundName);
            throw this.fillInException(new NameNotFoundException(EngineResource.getString((String)"ObjectInvalid") + " " + compoundName.toString() + "."));
        }
        if (this.doc.canDeleteObject(fObj)) {
            int n = this.doc.deleteObj(fObj);
            if (n != 0) {
                NamingException namingException = new NamingException(EngineResource.getString((String)"DeleteFailed") + " " + this.loadEngErrStr(n) + "  (0x" + Integer.toHexString(n).toUpperCase() + ")");
                this.setError(this, compoundName);
                throw this.fillInException(namingException);
            }
        } else {
            NamingException namingException;
            int n = this.doc.getDeleteError();
            if (n == 0) {
                namingException = new NamingException(EngineResource.getString((String)"DeleteFailed") + " " + compoundName.toString());
            } else {
                Attribute attribute;
                String string = this.loadEngErrStr(n);
                String string2 = Integer.toHexString(n).toUpperCase();
                namingException = n == 56073 ? ((attribute = fObj.getAttribute(63072)) != null && (Integer)attribute.get() != 0 ? new NamingException(EngineResource.getString((String)"DeleteFailed") + " " + string + "  (0x" + string2 + ")") : new ContextNotEmptyException(EngineResource.getString((String)"ContextNotEmpty") + " " + compoundName.toString())) : (n == 56120 ? new ContextNotEmptyException(EngineResource.getString((String)"ContextNotEmpty") + " " + compoundName.toString()) : ((n & 0xFF00) == 33280 ? new CommunicationException(EngineResource.getString((String)"DeleteFailed") + " " + string + "  (0x" + string2 + ")") : new NamingException(EngineResource.getString((String)"DeleteFailed") + " " + string + "  (0x" + string2 + ")")));
            }
            this.setError(this, compoundName);
            throw this.fillInException(namingException);
        }
    }

    protected NameParser c_getNameParser(CompoundName compoundName) throws NamingException {
        return nameParser;
    }

    protected NamingEnumeration c_list(CompoundName compoundName) throws NamingException {
        FObjIterator fObjIterator;
        Vector<NameClassPair> vector = new Vector<NameClassPair>(20, 10);
        CompoundName compoundName2 = (CompoundName)this.distinguishedName.clone();
        compoundName2.addAll(compoundName);
        int n = compoundName2.size();
        switch (n) {
            case 0: {
                vector.addElement(new NameClassPair("{SYSTEM RECORDS}", "SysRecContainerDirContext"));
                FKey fKey = this.doc.getKey();
                FView fView = this.doc.getView();
                fKey.add(50170, 1);
                fView.add(50035);
                fView.add(50168);
                FFilter fFilter = null;
                fObjIterator = this.doc.getElements(101, 266, fKey, fView, fFilter);
                this.addToCombinedList(vector, fObjIterator, 50035, 50168);
                break;
            }
            case 1: {
                if (compoundName2.get(0).equals("{SYSTEM RECORDS}")) {
                    vector.addElement(new NameClassPair("{ACTION RECORDS}", "ActionContainerDirContext"));
                    vector.addElement(new NameClassPair("{CUSTOM ADDRESS RECORDS}", "CustAddrContainerDirContext"));
                    vector.addElement(new NameClassPair("{RESTORE AREA RECORDS}", "AreaContainerDirContext"));
                    vector.addElement(new NameClassPair("{SOFTWARE AREA RECORDS}", "AreaContainerDirContext"));
                    vector.addElement(new NameClassPair("{EVENT RECORDS}", "EventContainerDirContext"));
                    vector.addElement(new NameClassPair("{IDOMAIN RECORDS}", "IDomainContainerDirContext"));
                    vector.addElement(new NameClassPair("{MTA PROFILE RECORDS}", "MTAProfileContainerDirContext"));
                    vector.addElement(new NameClassPair("{TIME ZONE RECORDS}", "TZContainerDirContext"));
                    vector.addElement(new NameClassPair("{TRUSTED APPLICATION RECORDS}", "TrustedAppContainerDirContext"));
                    vector.addElement(new NameClassPair("{LDAP SERVER RECORDS}", "LDAPServerContainerDirContext"));
                    FKey fKey = this.doc.getKey();
                    FView fView = this.doc.getView();
                    fView.add(50155);
                    FFilter fFilter = null;
                    fObjIterator = this.doc.getElements(145, 366, fKey, fView, fFilter);
                    this.addToCombinedList(vector, fObjIterator, 50155, "SystemRecDirContext");
                    break;
                }
                FKey fKey = this.doc.getKey();
                FView fView = this.doc.getView();
                fKey.add(50035, compoundName2.toString());
                fView.add(50062);
                fView.add(50168);
                FFilter fFilter = null;
                fObjIterator = this.doc.getElements(122, 233, fKey, fView, fFilter);
                this.addToCombinedList(vector, fObjIterator, 50062, 50168);
                fKey = this.doc.getKey();
                fView = this.doc.getView();
                fKey.add(50035, compoundName2.toString());
                fView.add(50035);
                fView.add(50162);
                fFilter = null;
                fObjIterator = this.doc.getElements(127, 265, fKey, fView, fFilter);
                this.addToCombinedList(vector, fObjIterator, 50162, "LinkSrcDirContext");
                fKey = this.doc.getKey();
                fView = this.doc.getView();
                fKey.add(50162, compoundName2.toString());
                fView.add(50162);
                fView.add(50035);
                fFilter = null;
                fObjIterator = this.doc.getElements(127, 264, fKey, fView, fFilter);
                this.addToCombinedList(vector, fObjIterator, 50035, "LinkDestDirContext");
                fKey = this.doc.getKey();
                fView = this.doc.getView();
                fKey.add(50035, compoundName2.toString());
                fView.add(50007);
                fView.add(50012);
                fView.add(63063);
                fFilter = null;
                fObjIterator = this.doc.getElements(116, 240, fKey, fView, fFilter);
                this.addAgentsToCombinedList(vector, fObjIterator, 50007);
                fKey = this.doc.getKey();
                fView = this.doc.getView();
                fKey.add(50035, compoundName2.toString());
                fView.add(50012);
                fView.add(63063);
                fFilter = this.doc.getFilter();
                fFilter.add(63063, 1);
                fFilter.add(50062, "", 19);
                fObjIterator = this.doc.getElements(117, 239, fKey, fView, fFilter);
                this.addAgentsToCombinedList(vector, fObjIterator, 50012);
                break;
            }
            case 2: {
                if (compoundName2.get(1).equals("{ACTION RECORDS}")) {
                    FKey fKey = this.doc.getKey();
                    FView fView = this.doc.getView();
                    fView.add(50155);
                    FFilter fFilter = null;
                    fObjIterator = this.doc.getElements(131, 288, fKey, fView, fFilter);
                    this.addToCombinedList(vector, fObjIterator, 50155, "ActionDirContext");
                    break;
                }
                if (compoundName2.get(1).equals("{CUSTOM ADDRESS RECORDS}")) {
                    FKey fKey = this.doc.getKey();
                    FView fView = this.doc.getView();
                    fView.add(50125);
                    FFilter fFilter = null;
                    fObjIterator = this.doc.getElements(129, 286, fKey, fView, fFilter);
                    this.addToCombinedList(vector, fObjIterator, 50125, "CustomAddrDirContext");
                    break;
                }
                if (compoundName2.get(1).equals("{RESTORE AREA RECORDS}")) {
                    FKey fKey = this.doc.getKey();
                    FView fView = this.doc.getView();
                    fKey.add(50075, 3);
                    fView.add(50073);
                    FFilter fFilter = null;
                    fObjIterator = this.doc.getElements(109, 354, fKey, fView, fFilter);
                    this.addToCombinedList(vector, fObjIterator, 50073, "RestoreAreaDirContext");
                    break;
                }
                if (compoundName2.get(1).equals("{SOFTWARE AREA RECORDS}")) {
                    FKey fKey = this.doc.getKey();
                    FView fView = this.doc.getView();
                    fKey.add(50075, 1);
                    fView.add(50073);
                    FFilter fFilter = null;
                    fObjIterator = this.doc.getElements(109, 354, fKey, fView, fFilter);
                    this.addToCombinedList(vector, fObjIterator, 50073, "SoftwareAreaDirContext");
                    break;
                }
                if (compoundName2.get(1).equals("{EVENT RECORDS}")) {
                    FKey fKey = this.doc.getKey();
                    FView fView = this.doc.getView();
                    fView.add(50155);
                    FFilter fFilter = null;
                    fObjIterator = this.doc.getElements(130, 289, fKey, fView, fFilter);
                    this.addToCombinedList(vector, fObjIterator, 50155, "EventDirContext");
                    break;
                }
                if (compoundName2.get(1).equals("{IDOMAIN RECORDS}")) {
                    FKey fKey = this.doc.getKey();
                    FView fView = this.doc.getView();
                    fView.add(50155);
                    FFilter fFilter = null;
                    fObjIterator = this.doc.getElements(146, 371, fKey, fView, fFilter);
                    this.addToCombinedList(vector, fObjIterator, 50155, "IDomainDirContext");
                    break;
                }
                if (compoundName2.get(1).equals("{MTA PROFILE RECORDS}")) {
                    FKey fKey = this.doc.getKey();
                    FView fView = this.doc.getView();
                    fView.add(50155);
                    FFilter fFilter = null;
                    fObjIterator = this.doc.getElements(138, 351, fKey, fView, fFilter);
                    this.addToCombinedList(vector, fObjIterator, 50155, "MTAProfileDirContext");
                    break;
                }
                if (compoundName2.get(1).equals("{TIME ZONE RECORDS}")) {
                    FKey fKey = this.doc.getKey();
                    FView fView = this.doc.getView();
                    fView.add(50088);
                    FFilter fFilter = null;
                    fObjIterator = this.doc.getElements(103, 238, fKey, fView, fFilter);
                    this.addToCombinedList(vector, fObjIterator, 50088, "TimeZoneDirContext");
                    break;
                }
                if (compoundName2.get(1).equals("{TRUSTED APPLICATION RECORDS}")) {
                    FKey fKey = this.doc.getKey();
                    FView fView = this.doc.getView();
                    fView.add(50155);
                    FFilter fFilter = null;
                    fObjIterator = this.doc.getElements(147, 380, fKey, fView, fFilter);
                    this.addToCombinedList(vector, fObjIterator, 50155, "TrustedAppDirContext");
                    break;
                }
                if (compoundName2.get(1).equals("{LDAP SERVER RECORDS}")) {
                    FKey fKey = this.doc.getKey();
                    FView fView = this.doc.getView();
                    fView.add(50155);
                    FFilter fFilter = null;
                    fObjIterator = this.doc.getElements(148, 383, fKey, fView, fFilter);
                    this.addToCombinedList(vector, fObjIterator, 50155, "LDAPServerDirContext");
                    break;
                }
                FKey fKey = this.doc.getKey();
                FView fView = this.doc.getView();
                fKey.add(50075, 2);
                fKey.add(50035, compoundName2.get(0));
                fKey.add(50062, compoundName2.get(1));
                fView.add(50073);
                FFilter fFilter = null;
                fObjIterator = this.doc.getElements(109, 354, fKey, fView, fFilter);
                this.addToCombinedList(vector, fObjIterator, 50073, "LibAreaDirContext");
                fKey = this.doc.getKey();
                fView = this.doc.getView();
                fKey.add(50035, compoundName2.get(0));
                fKey.add(50062, compoundName2.get(1));
                fView.add(50012);
                fView.add(63063);
                fFilter = null;
                fObjIterator = this.doc.getElements(117, 239, fKey, fView, fFilter);
                this.addAgentsToCombinedList(vector, fObjIterator, 50012);
                fKey = this.doc.getKey();
                fView = this.doc.getView();
                fKey.add(50035, compoundName2.get(0));
                fKey.add(50062, compoundName2.get(1));
                fView.add(50073);
                fView.add(50075);
                fView.add(63074);
                fFilter = null;
                fObjIterator = this.doc.getElements(106, 231, fKey, fView, fFilter);
                this.addToCombinedList(vector, fObjIterator, 50073, 50075);
                break;
            }
        }
        fObjIterator = null;
        return new GwNameClassEnumerator(vector.elements());
    }

    private void addToCombinedList(Vector vector, FObjIterator fObjIterator, int n, int n2) throws NamingException {
        while (fObjIterator.hasMore()) {
            String string = "UNKNOWN_TYPE";
            FObj fObj = (FObj)fObjIterator.next();
            Attributes attributes = fObj.getAll();
            Attribute attribute = attributes.get(String.valueOf(n));
            String string2 = (String)attribute.get();
            attribute = attributes.get(String.valueOf(n2));
            int n3 = (Integer)attribute.get();
            block0 : switch (n2) {
                case 50168: {
                    switch (n3) {
                        case 0: {
                            string = "DomainDirContext";
                            break;
                        }
                        case 1: {
                            string = "PostOfficeDirContext";
                            break;
                        }
                        case 2: {
                            string = "GatewayDirContext";
                        }
                    }
                    break;
                }
                case 50075: {
                    switch (n3) {
                        case 6: {
                            attribute = attributes.get(String.valueOf(63074));
                            if (attribute != null && (Integer)attribute.get() == 1) {
                                string = "EntityDirContext";
                                break block0;
                            }
                            string = "UserDirContext";
                            break block0;
                        }
                        case 2: {
                            string = "GroupDirContext";
                            break block0;
                        }
                        case 5: {
                            string = "ResourceDirContext";
                            break block0;
                        }
                        case 3: {
                            string = "NicknameDirContext";
                            break block0;
                        }
                        case 11: {
                            string = "LibraryDirContext";
                        }
                    }
                }
            }
            vector.addElement(new NameClassPair(string2, string));
        }
    }

    private void addToCombinedList(Vector vector, FObjIterator fObjIterator, int n, String string) throws NamingException {
        while (fObjIterator.hasMore()) {
            FObj fObj = (FObj)fObjIterator.next();
            Attribute attribute = fObj.getAttribute(n);
            String string2 = (String)attribute.get();
            vector.addElement(new NameClassPair(string2, string));
        }
    }

    private void addAgentsToCombinedList(Vector vector, FObjIterator fObjIterator, int n) throws NamingException {
        while (fObjIterator.hasMore()) {
            String string;
            String string2 = "UNKNOWN_TYPE";
            FObj fObj = (FObj)fObjIterator.next();
            Attributes attributes = fObj.getAll();
            Attribute attribute = attributes.get(String.valueOf(63063));
            int n2 = attribute != null ? (Integer)attribute.get() : (fObj.getNewObjectType() == 116 ? 3 : 0);
            attribute = attributes.get(String.valueOf(n));
            if (attribute != null) {
                string = (String)attribute.get();
            } else {
                attribute = attributes.get(String.valueOf(50012));
                if (attribute != null) {
                    string = (String)attribute.get();
                } else if (n2 == 3) {
                    string = "MTA";
                } else {
                    Debug.trace((String)("*** Agent record has no name; DRN *** = " + fObj.getObjRecordID()));
                    continue;
                }
            }
            switch (n2) {
                case 1: {
                    string2 = "ADADirContext";
                    break;
                }
                case 2: {
                    string2 = "POADirContext";
                    break;
                }
                case 3: {
                    string2 = "MTADirContext";
                }
            }
            vector.addElement(new NameClassPair(string, string2));
        }
    }

    protected NamingEnumeration c_listBindings(CompoundName compoundName) throws NamingException {
        this.setError(this, compoundName);
        throw this.fillInException(new OperationNotSupportedException());
    }

    protected Object c_lookup(CompoundName compoundName) throws NamingException {
        FObj fObj;
        CompoundName compoundName2 = (CompoundName)this.distinguishedName.clone();
        compoundName2.addAll(compoundName);
        try {
            fObj = this.getObjectInstance(compoundName, 0);
        }
        catch (NameNotFoundException nameNotFoundException) {
            this.setError(this, compoundName);
            throw this.fillInException(new NameNotFoundException(EngineResource.getString((String)"ObjectInvalid") + " " + compoundName.toString() + "."));
        }
        catch (NamingException namingException) {
            this.setError(this, compoundName);
            throw this.fillInException(namingException);
        }
        return this.wrapFObjInDirContext(compoundName, compoundName2, fObj);
    }

    public GwDirContext wrapFObjInDirContext(String string, FObj fObj) throws NamingException {
        CompoundName compoundName = (CompoundName)nameParser.parse(string);
        return this.wrapFObjInDirContext(compoundName, compoundName, fObj);
    }

    private GwDirContext wrapFObjInDirContext(CompoundName compoundName, CompoundName compoundName2, FObj fObj) throws NamingException {
        GwDirContext gwDirContext = null;
        int n = fObj.getNewObjectType();
        if (!fObj.isObjectValid()) {
            this.setError(this, compoundName);
            throw this.fillInException(new NameNotFoundException(EngineResource.getString((String)"ObjectInvalid") + " " + compoundName.toString() + "."));
        }
        GwComponentDirContext gwComponentDirContext = new GwComponentDirContext(compoundName2, this.doc, fObj, this.environment, this.domainVersion);
        switch (n) {
            case 106: {
                Attribute attribute = fObj.getAttribute(63074);
                if (attribute != null && (Integer)attribute.get() == 1) {
                    gwDirContext = new EntityDirContext(false);
                    break;
                }
                gwDirContext = new UserDirContext(false);
                break;
            }
            case 108: {
                gwDirContext = new ResourceDirContext(false);
                break;
            }
            case 110: {
                gwDirContext = new GroupDirContext(false);
                break;
            }
            case 101: {
                gwDirContext = new DomainDirContext(false);
                break;
            }
            case 122: {
                gwDirContext = new PostOfficeDirContext(false);
                break;
            }
            case 123: {
                gwDirContext = new GatewayDirContext(false);
                break;
            }
            case 116: {
                gwDirContext = new MTADirContext(false);
                break;
            }
            case 117: {
                Attribute attribute = fObj.getAttribute(63063);
                if (attribute == null) {
                    throw new InvalidAttributesException(EngineResource.getString((String)"NullAttribute") + " " + 63063 + ".");
                }
                int n2 = (Integer)attribute.get();
                if (n2 == 2) {
                    gwDirContext = new POADirContext(false);
                    break;
                }
                if (n2 == 1) {
                    gwDirContext = new ADADirContext(false);
                    break;
                }
                if (n2 == 3) {
                    gwDirContext = new MTADirContext(false);
                    break;
                }
                throw new InvalidAttributesException(EngineResource.getString((String)"UnknownValueType") + " " + n2 + ".");
            }
            case 133: {
                gwDirContext = new LibraryDirContext(false);
                break;
            }
            case 127: {
                gwDirContext = new LinkSrcDirContext(false);
                break;
            }
            case 107: {
                gwDirContext = new NicknameDirContext(false);
                break;
            }
            case 145: {
                gwDirContext = new SystemRecDirContext(false);
                break;
            }
            case 131: {
                gwDirContext = new ActionDirContext(false);
                break;
            }
            case 109: {
                Attribute attribute = fObj.getAttribute(50075);
                if (attribute == null) {
                    throw new InvalidAttributesException(EngineResource.getString((String)"NullAttribute") + " " + 50075 + ".");
                }
                int n3 = (Integer)attribute.get();
                if (n3 == 3) {
                    gwDirContext = new RestoreAreaDirContext(false);
                    break;
                }
                if (n3 == 1) {
                    gwDirContext = new SoftwareAreaDirContext(false);
                    break;
                }
                if (n3 == 2) {
                    gwDirContext = new LibAreaDirContext(false);
                    break;
                }
                throw new InvalidAttributesException(EngineResource.getString((String)"UnknownValueType") + " " + n3 + ".");
            }
            case 129: {
                gwDirContext = new CustomAddrDirContext(false);
                break;
            }
            case 130: {
                gwDirContext = new EventDirContext(false);
                break;
            }
            case 146: {
                gwDirContext = new IDomainDirContext(false);
                break;
            }
            case 138: {
                gwDirContext = new MTAProfileDirContext(false);
                break;
            }
            case 103: {
                gwDirContext = new TimeZoneDirContext(false);
                break;
            }
            case 147: {
                gwDirContext = new TrustedAppDirContext(false);
                break;
            }
            case 148: {
                gwDirContext = new LDAPServerDirContext(false);
                break;
            }
            case 30101: {
                gwDirContext = new SysRecContainerDirContext();
                break;
            }
            case 30102: {
                gwDirContext = new ActionContainerDirContext();
                break;
            }
            case 30104: {
                gwDirContext = new AreaContainerDirContext();
                break;
            }
            case 30105: {
                gwDirContext = new CustAddrContainerDirContext();
                break;
            }
            case 30106: {
                gwDirContext = new EventContainerDirContext();
                break;
            }
            case 30107: {
                gwDirContext = new IDomainContainerDirContext();
                break;
            }
            case 30108: {
                gwDirContext = new MTAProfileContainerDirContext();
                break;
            }
            case 30109: {
                gwDirContext = new TZContainerDirContext();
                break;
            }
            case 30110: {
                gwDirContext = new TrustedAppContainerDirContext();
                break;
            }
            case 30111: {
                gwDirContext = new LDAPServerContainerDirContext();
                break;
            }
            default: {
                this.setError(this, compoundName);
                throw this.fillInException(new InvalidAttributeValueException(EngineResource.getString((String)"UnknownRecordType") + " " + n + "."));
            }
        }
        gwDirContext.setImplementation(gwComponentDirContext);
        return gwDirContext;
    }

    protected Object c_lookupLink(CompoundName compoundName) throws NamingException {
        return this.c_lookup(compoundName);
    }

    protected void c_rebind(CompoundName compoundName, Object object) throws NamingException {
        if (this.validContext(compoundName)) {
            this.c_unbind(compoundName);
        }
        this.c_bind(compoundName, object);
    }

    protected void c_rename(CompoundName compoundName, CompoundName compoundName2) throws NamingException {
        this.setError(this, compoundName);
        throw this.fillInException(new OperationNotSupportedException());
    }

    protected void c_unbind(CompoundName compoundName) throws NamingException {
        this.setError(this, compoundName);
        throw this.fillInException(new OperationNotSupportedException());
    }

    protected void c_bind(CompoundName compoundName, Object object, Attributes attributes) throws NamingException {
        this.setError(this, compoundName);
        throw this.fillInException(new OperationNotSupportedException());
    }

    protected DirContext c_createSubcontext(CompoundName compoundName, Attributes attributes) throws NamingException {
        FObj fObj;
        int n;
        Object object;
        boolean bl = false;
        GwDirContext gwDirContext = null;
        CompoundName compoundName2 = (CompoundName)this.distinguishedName.clone();
        compoundName2.addAll(compoundName);
        try {
            object = attributes.remove("Record Type");
            if (object == null) {
                throw new InvalidAttributesException(EngineResource.getString((String)"NullAttribute") + " " + "Record Type" + ".");
            }
            n = (Integer)object.get();
        }
        catch (Exception exception) {
            NamingException namingException = new NamingException();
            this.setError(this, compoundName);
            namingException.setRootCause(exception);
            throw this.fillInException(namingException);
        }
        if (n != 131 && n != 130) {
            object = (CompoundName)compoundName.clone();
            if (n != 109) {
                if (this.validContext(compoundName)) {
                    this.setError(this, compoundName);
                    throw this.fillInException(new NameAlreadyBoundException(EngineResource.getString((String)"ContextExists") + " " + compoundName.toString() + "."));
                }
            } else {
                ((CompoundName)object).add("x");
            }
            if (n != 146 && n != 129 && n != 145 && !this.validPenultimateContext((CompoundName)object)) {
                this.setError(this, compoundName);
                throw this.fillInException(new NameNotFoundException(((CompoundName)object).toString()));
            }
        }
        switch (n) {
            case 106: {
                object = attributes.get(String.valueOf(63074));
                if (object != null && (Integer)object.get() == 1) {
                    gwDirContext = new EntityDirContext(false);
                    bl = true;
                    break;
                }
                gwDirContext = new UserDirContext(false);
                bl = true;
                break;
            }
            case 108: {
                gwDirContext = new ResourceDirContext(false);
                break;
            }
            case 110: {
                gwDirContext = new GroupDirContext(false);
                break;
            }
            case 101: {
                gwDirContext = new DomainDirContext(false);
                bl = true;
                break;
            }
            case 122: {
                gwDirContext = new PostOfficeDirContext(false);
                bl = true;
                break;
            }
            case 123: {
                gwDirContext = new GatewayDirContext(false);
                break;
            }
            case 116: {
                gwDirContext = new MTADirContext(false);
                break;
            }
            case 117: {
                object = attributes.get(String.valueOf(63063));
                if (object == null) {
                    throw new InvalidAttributesException(EngineResource.getString((String)"NullAttribute") + " " + 63063 + ".");
                }
                int n2 = (Integer)object.get();
                if (n2 == 2) {
                    gwDirContext = new POADirContext(false);
                    break;
                }
                if (n2 == 1) {
                    gwDirContext = new ADADirContext(false);
                    break;
                }
                if (n2 == 3) {
                    gwDirContext = new MTADirContext(false);
                    break;
                }
                throw new InvalidAttributesException(EngineResource.getString((String)"UnknownValueType") + " " + n2 + ".");
            }
            case 133: {
                gwDirContext = new LibraryDirContext(false);
                break;
            }
            case 127: {
                object = attributes.remove("Link Direction");
                if (object == null) {
                    throw new InvalidAttributesException(EngineResource.getString((String)"NullAttribute") + " " + "Link Direction" + ".");
                }
                int n2 = (Integer)object.get();
                if (n2 == 1) {
                    gwDirContext = new LinkSrcDirContext(false);
                    break;
                }
                if (n2 == 2) {
                    gwDirContext = new LinkDestDirContext(false);
                    break;
                }
                throw new InvalidAttributesException(EngineResource.getString((String)"InvalidValue") + " " + n2 + ".");
            }
            case 107: {
                gwDirContext = new NicknameDirContext(false);
                break;
            }
            case 145: {
                gwDirContext = new SystemRecDirContext(false);
                break;
            }
            case 131: {
                gwDirContext = new ActionDirContext(false);
                break;
            }
            case 109: {
                object = attributes.get(String.valueOf(50075));
                if (object == null) {
                    throw new InvalidAttributesException(EngineResource.getString((String)"NullAttribute") + " " + 50075 + ".");
                }
                int n2 = (Integer)object.get();
                if (n2 == 3) {
                    gwDirContext = new RestoreAreaDirContext(false);
                    break;
                }
                if (n2 == 1) {
                    gwDirContext = new SoftwareAreaDirContext(false);
                    break;
                }
                if (n2 == 2) {
                    gwDirContext = new LibAreaDirContext(false);
                    break;
                }
                throw new InvalidAttributesException(EngineResource.getString((String)"InvalidValue") + " " + n2 + ".");
            }
            case 129: {
                gwDirContext = new CustomAddrDirContext(false);
                break;
            }
            case 130: {
                gwDirContext = new EventDirContext(false);
                break;
            }
            case 146: {
                gwDirContext = new IDomainDirContext(false);
                break;
            }
            case 138: {
                gwDirContext = new MTAProfileDirContext(false);
                break;
            }
            case 103: {
                gwDirContext = new TimeZoneDirContext(false);
                break;
            }
            case 147: {
                gwDirContext = new TrustedAppDirContext(false);
                break;
            }
            case 148: {
                gwDirContext = new LDAPServerDirContext(false);
                break;
            }
            default: {
                this.setError(this, compoundName);
                throw this.fillInException(new InvalidAttributeValueException(EngineResource.getString((String)"UnknownRecordType") + " " + n + "."));
            }
        }
        if (bl) {
            object = "";
            String string = "";
            if (compoundName2.size() > 0) {
                object = compoundName2.get(0);
            }
            if (compoundName2.size() > 1) {
                string = compoundName2.get(1);
            }
            if (!this.doc.canGWCreate(n, (String)object, string)) {
                throw new SizeLimitExceededException(EngineResource.getR2String((String)"EvalViolationError"));
            }
        }
        try {
            fObj = this.getObjectInstance(compoundName, n);
        }
        catch (NamingException namingException) {
            this.setError(this, compoundName);
            throw this.fillInException(namingException);
        }
        if (fObj.isObjectValid()) {
            this.setError(this, compoundName);
            throw this.fillInException(new NameAlreadyBoundException(EngineResource.getString((String)"ContextExists") + " " + compoundName.toString() + "."));
        }
        GwComponentDirContext gwComponentDirContext = new GwComponentDirContext(compoundName2, this.doc, fObj, this.environment, this.domainVersion);
        gwDirContext.setImplementation(gwComponentDirContext);
        if (attributes.size() > 0) {
            gwComponentDirContext.c_modifyAttributes((CompoundName)nameParser.parse(""), 2, attributes);
        } else {
            try {
                int n3 = fObj.objectCommit(this.doc, "CommitError", false);
            }
            catch (NamingException namingException) {
                Debug.trace((String)("GwComponentDirContext.c_createSubcontext>name= " + compoundName));
                this.setError(this, compoundName);
                throw this.fillInException(namingException);
            }
        }
        fObj.objRefresh();
        if (n == 131 || n == 109 || n == 130) {
            String string = null;
            Attribute attribute = n == 109 ? fObj.getAttribute(50073) : fObj.getAttribute(50155);
            if (attribute != null) {
                string = (String)attribute.get();
                gwComponentDirContext.distinguishedName.add(string);
            }
        }
        return gwDirContext;
    }

    protected Attributes c_getAttributes(CompoundName compoundName, String[] stringArray) throws NamingException {
        Attributes attributes;
        FObj fObj = null;
        int n = 0;
        int n2 = 0;
        fObj = this.c_lookup_pcc(compoundName);
        n = fObj.getNewObjectType();
        try {
            Object object;
            if (stringArray != null) {
                boolean bl = false;
                attributes = new BasicAttributes();
                for (int i = 0; i < stringArray.length; ++i) {
                    NamingEnumeration<? extends Attribute> namingEnumeration;
                    Attributes attributes2;
                    object = null;
                    if (stringArray[i] == null) continue;
                    if (stringArray[i].equals("Member To")) {
                        n2 |= 1;
                    } else if (stringArray[i].equals("Member CC")) {
                        n2 |= 2;
                    } else if (stringArray[i].equals("Member BC")) {
                        n2 |= 4;
                    } else if (stringArray[i].equals("Library Member")) {
                        object = this.getLibraryMembersAttr(n, compoundName);
                    } else if (stringArray[i].equals("Gateway Alias")) {
                        object = this.getAliasesAttr(n, compoundName);
                    } else if (stringArray[i].equals("Area Member")) {
                        object = this.getAreaMembersAttr(n, compoundName);
                    } else if ((stringArray[i].equals("Library Area") || stringArray[i].equals("Restore Area") || stringArray[i].equals("Software Area")) && !bl) {
                        attributes2 = this.getAreaAttrs(n, compoundName);
                        namingEnumeration = attributes2.getAll();
                        while (namingEnumeration.hasMore()) {
                            attributes.put(namingEnumeration.next());
                        }
                        bl = true;
                    } else if (stringArray[i].equals("GroupWise Group")) {
                        object = this.getGroupsAttr(n, compoundName);
                    } else if (stringArray[i].equals("Administrator")) {
                        object = this.getAdminAttr(n, compoundName);
                    } else if (stringArray[i].equals("EventAction Member")) {
                        object = this.getEvntActMembersAttr(n, compoundName);
                    } else if (stringArray[i].equals("AppEvent Member")) {
                        object = this.getAppEvntMembersAttr(n, compoundName);
                    } else if (stringArray[i].equals("EventApp Member")) {
                        object = this.getEvntAppMembersAttr(n, compoundName);
                    } else if (stringArray[i].equals("Custom Address Link")) {
                        object = this.getCAddrLinkAttr(n, compoundName);
                    } else if (stringArray[i].equals("Link Profile Blob")) {
                        object = this.getLinkBlobAttr(n, compoundName);
                    } else if (stringArray[i].equals("LDAP Server") || stringArray[i].equals("LDAP Member")) {
                        object = this.getLDAPAttr(n, compoundName);
                    } else if (stringArray[i].equals("Administered Groups")) {
                        object = this.getAdministeredGroupsAttr(n, compoundName);
                    } else if (stringArray[i].equals("Group Administrators")) {
                        object = this.getGroupAdministratorsAttr(n, compoundName);
                    } else if (stringArray[i].equals("Members With Names")) {
                        attributes2 = this.getGroupMembersWithNamesAttrs(n, compoundName);
                        namingEnumeration = attributes2.getAll();
                        while (namingEnumeration.hasMore()) {
                            attributes.put(namingEnumeration.next());
                        }
                    } else {
                        object = fObj.getAttribute(Integer.parseInt(stringArray[i]));
                    }
                    if (object == null) continue;
                    attributes.put((Attribute)object);
                }
            } else {
                attributes = fObj.getAll();
                Attribute attribute = this.getLibraryMembersAttr(n, compoundName);
                if (attribute != null) {
                    attributes.put(attribute);
                }
                if ((attribute = this.getAliasesAttr(n, compoundName)) != null) {
                    attributes.put(attribute);
                }
                if ((attribute = this.getAreaMembersAttr(n, compoundName)) != null) {
                    attributes.put(attribute);
                }
                Attributes attributes3 = this.getAreaAttrs(n, compoundName);
                object = attributes3.getAll();
                while (object.hasMore()) {
                    attributes.put(object.next());
                }
                attribute = this.getGroupsAttr(n, compoundName);
                if (attribute != null) {
                    attributes.put(attribute);
                }
                if ((attribute = this.getAdminAttr(n, compoundName)) != null) {
                    attributes.put(attribute);
                }
                if ((attribute = this.getEvntActMembersAttr(n, compoundName)) != null) {
                    attributes.put(attribute);
                }
                if ((attribute = this.getAppEvntMembersAttr(n, compoundName)) != null) {
                    attributes.put(attribute);
                }
                if ((attribute = this.getEvntAppMembersAttr(n, compoundName)) != null) {
                    attributes.put(attribute);
                }
                if ((attribute = this.getCAddrLinkAttr(n, compoundName)) != null) {
                    attributes.put(attribute);
                }
                if ((attribute = this.getLinkBlobAttr(n, compoundName)) != null) {
                    attributes.put(attribute);
                }
                if ((attribute = this.getLDAPAttr(n, compoundName)) != null) {
                    attributes.put(attribute);
                }
                if ((attribute = this.getAdministeredGroupsAttr(n, compoundName)) != null) {
                    attributes.put(attribute);
                }
                if ((attribute = this.getGroupAdministratorsAttr(n, compoundName)) != null) {
                    attributes.put(attribute);
                }
                n2 = 15;
            }
            if (n2 != 0) {
                Attributes attributes4 = this.getGroupMembersAttrs(n2, n, compoundName);
                NamingEnumeration<? extends Attribute> namingEnumeration = attributes4.getAll();
                while (namingEnumeration.hasMore()) {
                    attributes.put(namingEnumeration.next());
                }
            }
        }
        catch (NamingException namingException) {
            this.setError(this, compoundName);
            throw this.fillInException(namingException);
        }
        return attributes;
    }

    protected DirContext c_getSchema(CompoundName compoundName) throws NamingException {
        this.setError(this, compoundName);
        throw this.fillInException(new OperationNotSupportedException());
    }

    protected DirContext c_getSchemaClassDefinition(CompoundName compoundName) throws NamingException {
        this.setError(this, compoundName);
        throw this.fillInException(new OperationNotSupportedException());
    }

    protected void c_modifyAttributes(CompoundName compoundName, int n, Attributes attributes) throws NamingException {
        ModificationItem[] modificationItemArray = new ModificationItem[attributes.size()];
        NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
        int n2 = 0;
        while (namingEnumeration.hasMore()) {
            modificationItemArray[n2++] = new ModificationItem(n, namingEnumeration.next());
        }
        this.c_modifyAttributes(compoundName, modificationItemArray);
    }

    protected void c_modifyAttributes(CompoundName compoundName, ModificationItem[] modificationItemArray) throws NamingException {
        ModificationItem modificationItem;
        int n;
        FObj fObj = this.c_lookup_pcc(compoundName);
        boolean bl = false;
        for (n = 0; n < modificationItemArray.length; ++n) {
            Attribute attribute;
            String string;
            modificationItem = modificationItemArray[n];
            if (modificationItem == null || (string = (attribute = modificationItem.getAttribute()).getID()).equals("GroupWise Group") || string.equals("Member To") || string.equals("Member CC") || string.equals("Member BC") || string.equals("Library Member") || string.equals("Gateway Alias") || string.equals("Area Member") || string.equals("Library Area") || string.equals("Restore Area") || string.equals("Software Area") || string.equals("Administrator") || string.equals("EventAction Member") || string.equals("AppEvent Member") || string.equals("EventApp Member") || string.equals("Custom Address Link") || string.equals("Link Profile Blob") || string.equals("LDAP Server") || string.equals("LDAP Member") || string.equals("Administered Groups") || string.equals("Group Administrators")) continue;
            try {
                fObj.modifyAttribute(modificationItem.getModificationOp(), attribute);
                modificationItemArray[n] = null;
                continue;
            }
            catch (NamingException namingException) {
                this.setError(this, compoundName);
                throw this.fillInException(namingException);
            }
        }
        try {
            n = fObj.objectCommit(this.doc, "ModifyAttr", false);
            bl = true;
            fObj.objRefresh();
            this.modifyAssociationRecords(compoundName, fObj.getNewObjectType(), modificationItemArray);
        }
        catch (NamingException namingException) {
            Debug.trace((String)("GwComponentDirContext.c_modifyAttributes>name= " + compoundName));
            if (namingException instanceof AttributeModificationException && modificationItemArray != null) {
                modificationItem = null;
                for (int i = 0; i < modificationItemArray.length; ++i) {
                    if (modificationItemArray[i] == null) continue;
                    modificationItem = modificationItemArray[i];
                    break;
                }
                if (modificationItem != null) {
                    ModificationItem[] modificationItemArray2 = new ModificationItem[]{modificationItem};
                    ((AttributeModificationException)namingException).setUnexecutedModifications(modificationItemArray2);
                }
            }
            this.setError(this, compoundName);
            throw this.fillInException(namingException);
        }
        finally {
            if (bl) {
                this.checkAgentRestart();
            }
        }
    }

    protected void modifyAssociationRecords(CompoundName compoundName, int n, ModificationItem[] modificationItemArray) throws NamingException {
        for (int i = 0; i < modificationItemArray.length; ++i) {
            ModificationItem modificationItem = modificationItemArray[i];
            if (modificationItem == null) continue;
            Attribute attribute = modificationItem.getAttribute();
            String string = attribute.getID();
            int n2 = modificationItem.getModificationOp();
            if (string.equals("GroupWise Group")) {
                this.modifyGroupsAttr(compoundName, attribute, n2);
                continue;
            }
            if (string.equals("Member To")) {
                this.modifyMembersAttr(compoundName, 1, attribute, n2);
                continue;
            }
            if (string.equals("Member CC")) {
                this.modifyMembersAttr(compoundName, 2, attribute, n2);
                continue;
            }
            if (string.equals("Member BC")) {
                this.modifyMembersAttr(compoundName, 4, attribute, n2);
                continue;
            }
            if (string.equals("Library Member")) {
                this.modifyLibMembersAttr(compoundName, attribute, n2);
                continue;
            }
            if (string.equals("Gateway Alias")) {
                this.modifyAliasesAttr(compoundName, n, attribute, n2);
                continue;
            }
            if (string.equals("Area Member")) {
                this.modifyAreaMembersAttr(compoundName, attribute, n2);
                continue;
            }
            if (string.equals("Library Area")) {
                this.modifyAreasAttr(compoundName, n, 2, attribute, n2);
                continue;
            }
            if (string.equals("Restore Area")) {
                this.modifyAreasAttr(compoundName, n, 3, attribute, n2);
                continue;
            }
            if (string.equals("Software Area")) {
                this.modifyAreasAttr(compoundName, n, 1, attribute, n2);
                continue;
            }
            if (string.equals("Administrator")) {
                this.modifyAdminAttr(compoundName, attribute, n2);
                continue;
            }
            if (string.equals("EventAction Member")) {
                this.modifyEvntActMembersAttr(compoundName, n, attribute, n2);
                continue;
            }
            if (string.equals("AppEvent Member")) {
                this.modifyAppEvntMembersAttr(compoundName, attribute, n2);
                continue;
            }
            if (string.equals("EventApp Member")) {
                this.modifyEvntAppMembersAttr(compoundName, attribute, n2);
                continue;
            }
            if (string.equals("Custom Address Link")) {
                this.modifyCAddrLinkAttr(compoundName, attribute, n2);
                continue;
            }
            if (string.equals("Link Profile Blob")) {
                this.modifyLinkBlobAttr(compoundName, attribute, n2);
                continue;
            }
            if (string.equals("LDAP Server") || string.equals("LDAP Member")) {
                this.modifyLDAPAttr(compoundName, n, attribute, n2);
                continue;
            }
            if (string.equals("Administered Groups")) {
                this.modifyAdministeredGroupsAttr(compoundName, attribute, n2);
                continue;
            }
            if (string.equals("Group Administrators")) {
                this.modifyGroupAdministratorsAttr(compoundName, attribute, n2);
                continue;
            }
            Debug.trace((String)("modifyAssociationRecords>Invalid Attribute: " + attribute));
        }
    }

    protected void c_rebind(CompoundName compoundName, Object object, Attributes attributes) throws NamingException {
        this.setError(this, compoundName);
        throw this.fillInException(new OperationNotSupportedException());
    }

    protected NamingEnumeration c_search(CompoundName compoundName, Attributes attributes, String[] stringArray, int n) throws NamingException {
        FObjIterator fObjIterator = null;
        int n2 = 0;
        int n3 = 0;
        if (attributes != null && attributes.size() != 0) {
            Object object;
            FKey fKey = this.doc.getKey();
            FView fView = null;
            FFilter fFilter = this.doc.getFilter();
            Attribute attribute = attributes.remove("Search Filter");
            if (attribute != null) {
                object = attribute.getAll();
                while (object.hasMore()) {
                    Attributes attributes2 = (Attributes)object.next();
                    int n4 = (Integer)attributes2.get("Search Attribute ID").get();
                    Object object2 = attributes2.get("Search Attribute Value").get();
                    int n5 = (Integer)attributes2.get("Search Operation").get();
                    if (object2 == null) {
                        throw new NullPointerException("Null value for FILTER attribute " + n4 + " sent into search()");
                    }
                    if (object2 instanceof String) {
                        fFilter.add(n4, (String)object2, n5);
                        continue;
                    }
                    if (!(object2 instanceof Integer)) continue;
                    fFilter.add(n4, (Integer)object2, n5);
                }
            }
            int n6 = (Integer)attributes.remove("Search Index").get();
            n3 = (Integer)attributes.remove("Search New Record Type").get();
            NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
            while (namingEnumeration.hasMore()) {
                object = namingEnumeration.next();
                int n7 = Integer.parseInt(object.getID());
                Object object3 = object.get();
                if (object3 == null) {
                    throw new NullPointerException("Null value for KEY attribute " + n7 + " sent into search()");
                }
                if (object3 instanceof Integer) {
                    fKey.add(n7, (Integer)object3);
                    continue;
                }
                fKey.add(n7, (String)object3);
            }
            switch (n3) {
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 119: 
                case 120: 
                case 133: 
                case 134: 
                case 137: {
                    n2 = 50073;
                    break;
                }
                case 101: {
                    n2 = 50035;
                    break;
                }
                case 122: 
                case 123: {
                    n2 = 50062;
                    break;
                }
                case 112: 
                case 116: 
                case 151: {
                    n2 = 50007;
                    break;
                }
                case 117: {
                    n2 = 50012;
                    break;
                }
                case 127: {
                    if (n6 == 265) {
                        n2 = 50162;
                        break;
                    }
                    n2 = 50035;
                    break;
                }
                case 130: 
                case 131: 
                case 140: 
                case 141: 
                case 145: 
                case 146: 
                case 147: 
                case 148: {
                    n2 = 50155;
                    break;
                }
                case 113: 
                case 138: {
                    n2 = 50155;
                    break;
                }
                case 129: 
                case 132: {
                    n2 = 50125;
                    break;
                }
                case 103: {
                    n2 = 50088;
                    break;
                }
                case 124: 
                case 128: {
                    n2 = 50077;
                    break;
                }
                case 125: {
                    n2 = 50012;
                    break;
                }
                case 152: {
                    n2 = 50073;
                    break;
                }
                default: {
                    this.setError(this, compoundName);
                    throw this.fillInException(new InvalidAttributeValueException(EngineResource.getString((String)"UnknownRecordType") + " " + n3 + "."));
                }
            }
            if (stringArray != null) {
                fView = this.doc.getView();
                for (int i = 0; i < stringArray.length; ++i) {
                    fView.add(Integer.parseInt(stringArray[i]));
                }
                fView.set(n2);
            }
            fObjIterator = this.doc.getElements(n3, n6, fKey, fView, fFilter, n);
        }
        return new GwSearchResultEnumerator(n3, fObjIterator, n2);
    }

    protected NamingEnumeration c_search(CompoundName compoundName, String string, SearchControls searchControls) throws NamingException {
        return this.c_search(compoundName, string, null, searchControls);
    }

    protected NamingEnumeration c_search(CompoundName compoundName, String string, Object[] objectArray, SearchControls searchControls) throws NamingException {
        this.setError(this, compoundName);
        throw this.fillInException(new OperationNotSupportedException());
    }

    protected String c_getNameInNamespace() throws NamingException {
        return this.distinguishedName.toString();
    }

    public void setDistinguishedName(String string) throws NamingException {
        this.distinguishedName = (CompoundName)nameParser.parse(string);
    }

    public void close() throws NamingException {
        this.distinguishedName = null;
        this.flaimObj = null;
        this.environment = null;
        this.doc = null;
    }

    protected ResolveResult c_resolvePenultimate(CompoundName compoundName) throws NamingException {
        if (compoundName.isEmpty()) {
            this.setError(this, compoundName);
            InvalidNameException invalidNameException = new InvalidNameException();
            throw this.fillInException(invalidNameException);
        }
        return new ResolveResult((Object)this, compoundName);
    }

    protected FObj c_lookup_pcc(CompoundName compoundName) throws NamingException {
        FObj fObj;
        if (compoundName.isEmpty()) {
            fObj = this.flaimObj;
            if (fObj == null) {
                this.setError(this, compoundName);
                throw this.fillInException(new NameNotFoundException());
            }
        } else {
            try {
                fObj = this.getObjectInstance(compoundName, 0);
            }
            catch (NamingException namingException) {
                this.setError(this, compoundName);
                throw this.fillInException(namingException);
            }
            if (!fObj.isObjectValid()) {
                this.setError(this, compoundName);
                throw this.fillInException(new NameNotFoundException());
            }
        }
        return fObj;
    }

    protected boolean validContext(CompoundName compoundName) throws NamingException {
        boolean bl;
        if (compoundName.isEmpty()) {
            bl = true;
        } else {
            CompoundName compoundName2 = (CompoundName)this.distinguishedName.clone();
            compoundName2.addAll(compoundName);
            try {
                bl = this.doc.doesObjectExist(compoundName2);
            }
            catch (NamingException namingException) {
                this.setError(this, compoundName);
                throw this.fillInException(namingException);
            }
        }
        return bl;
    }

    protected boolean validPenultimateContext(CompoundName compoundName) throws NamingException {
        if (compoundName.isEmpty()) {
            return false;
        }
        CompoundName compoundName2 = (CompoundName)compoundName.clone();
        compoundName2.remove(compoundName2.size() - 1);
        boolean bl = this.validContext(compoundName2);
        if (!bl) {
            FObj fObj = this.getObjectInstance(compoundName2, 0);
            bl = fObj.isObjectValid();
        }
        return bl;
    }

    private FObj getObjectInstance(CompoundName compoundName, int n) throws NamingException {
        FObj fObj = null;
        CompoundName compoundName2 = (CompoundName)this.distinguishedName.clone();
        compoundName2.addAll(compoundName);
        if (compoundName2.size() > 0 && compoundName2.get(0).equals("{SYSTEM RECORDS}")) {
            fObj = this.getSysRecObjInstance(compoundName2, n);
        } else if (n == 109) {
            fObj = this.doc.getGWObject(109, null, null, 0);
        } else if (n == 119) {
            FKey fKey = this.doc.getKey();
            fKey.add(50035, compoundName2.get(0));
            fKey.add(50062, compoundName2.get(1));
            fKey.add(50073, compoundName2.get(2));
            fObj = this.doc.getGWObject(119, fKey, null, 272);
        } else {
            FKey fKey;
            boolean bl = false;
            if (n != 127 && n != 116 && n != 117) {
                fObj = this.doc.getObjectInstance(compoundName2, n);
                bl = fObj.isObjectValid();
            }
            if (n == 0 && !bl && compoundName2.size() > 2) {
                fKey = this.doc.getKey();
                fKey.add(50075, 2);
                fKey.add(50035, compoundName2.get(0));
                fKey.add(50062, compoundName2.get(1));
                fKey.add(50073, compoundName2.get(2));
                fObj = this.doc.getGWObject(109, fKey, null, 354);
                bl = fObj.isObjectValid();
            }
            if (!(bl || n != 0 && n != 127 && n != 116 && n != 117)) {
                if (compoundName2.size() == 2) {
                    fKey = this.doc.getKey();
                    fKey.add(50035, compoundName2.get(0));
                    fKey.add(50162, compoundName2.get(1));
                    fObj = this.doc.getGWObject(127, fKey, null, 265);
                    bl = fObj.isObjectValid();
                    if (!bl && n != 127) {
                        FFilter fFilter = this.doc.getFilter();
                        fKey = this.doc.getKey();
                        fKey.add(50035, compoundName2.get(0));
                        fKey.add(50012, compoundName2.get(1));
                        fFilter.add(63063, 1);
                        fFilter.add(50062, "", 19);
                        fObj = this.doc.getGWObject(117, fKey, null, 239, fFilter);
                        bl = fObj.isObjectValid();
                        if (!bl) {
                            // empty if block
                        }
                        if (!bl && n != 117) {
                            String string = "MTA";
                            fKey = this.doc.getKey();
                            fKey.add(50035, compoundName2.get(0));
                            fObj = this.doc.getGWObject(116, fKey, null, 240);
                            bl = fObj.isObjectValid();
                            if (bl) {
                                Attributes attributes = fObj.getAll();
                                Attribute attribute = attributes.get(String.valueOf(50007));
                                if (attribute != null) {
                                    string = (String)attribute.get();
                                }
                                if (!string.equals(compoundName2.get(1))) {
                                    if (n == 116) {
                                        this.setError(this, compoundName);
                                        throw this.fillInException(new NameAlreadyBoundException(EngineResource.getString((String)"OneMTA") + string + "."));
                                    }
                                    this.setError(this, compoundName);
                                    throw this.fillInException(new NameNotFoundException(compoundName2.toString()));
                                }
                            }
                        }
                    }
                } else if (compoundName2.size() == 3) {
                    fKey = this.doc.getKey();
                    fKey.add(50035, compoundName2.get(0));
                    fKey.add(50062, compoundName2.get(1));
                    fKey.add(50012, compoundName2.get(2));
                    fObj = this.doc.getGWObject(117, fKey, null, 239);
                } else {
                    this.setError(this, compoundName);
                    throw this.fillInException(new NameNotFoundException(compoundName2.toString()));
                }
            }
        }
        return fObj;
    }

    private FObj getSysRecObjInstance(CompoundName compoundName, int n) throws NamingException {
        FObj fObj;
        if (compoundName.size() > 0 && compoundName.get(0).equals("{SYSTEM RECORDS}")) {
            if (compoundName.size() == 1) {
                fObj = new FObj(0, 30101);
            } else if (compoundName.get(1).equals("{TIME ZONE RECORDS}")) {
                if (compoundName.size() == 2) {
                    fObj = new FObj(0, 30109);
                } else {
                    FKey fKey = this.doc.getKey();
                    fKey.add(50088, compoundName.get(2));
                    fObj = this.doc.getGWObject(103, fKey, null, 238);
                }
            } else if (compoundName.get(1).equals("{ACTION RECORDS}")) {
                if (compoundName.size() == 2 && n != 131) {
                    fObj = new FObj(0, 30102);
                } else {
                    FKey fKey = null;
                    int n2 = 0;
                    if (compoundName.size() > 2) {
                        fKey = this.doc.getKey();
                        fKey.add(50155, compoundName.get(2));
                        n2 = 288;
                    }
                    fObj = this.doc.getGWObject(131, fKey, null, n2);
                }
            } else if (compoundName.get(1).equals("{CUSTOM ADDRESS RECORDS}")) {
                if (compoundName.size() == 2) {
                    fObj = new FObj(0, 30105);
                } else {
                    FKey fKey = this.doc.getKey();
                    fKey.add(50125, compoundName.getSuffix(2).toString());
                    fObj = this.doc.getGWObject(129, fKey, null, 290);
                }
            } else if (compoundName.get(1).equals("{RESTORE AREA RECORDS}")) {
                if (compoundName.size() == 2 && n != 109) {
                    fObj = new FObj(0, 30104);
                } else {
                    FKey fKey = null;
                    int n3 = 0;
                    if (compoundName.size() > 2) {
                        fKey = this.doc.getKey();
                        fKey.add(50075, 3);
                        fKey.add(50073, compoundName.get(2));
                        n3 = 354;
                    }
                    fObj = this.doc.getGWObject(109, fKey, null, n3);
                }
            } else if (compoundName.get(1).equals("{SOFTWARE AREA RECORDS}")) {
                if (compoundName.size() == 2 && n != 109) {
                    fObj = new FObj(0, 30104);
                } else {
                    FKey fKey = null;
                    int n4 = 0;
                    if (compoundName.size() > 2) {
                        fKey = this.doc.getKey();
                        fKey.add(50075, 1);
                        fKey.add(50073, compoundName.get(2));
                        n4 = 354;
                    }
                    fObj = this.doc.getGWObject(109, fKey, null, n4);
                }
            } else if (compoundName.get(1).equals("{EVENT RECORDS}")) {
                if (compoundName.size() == 2 && n != 130) {
                    fObj = new FObj(0, 30106);
                } else {
                    FKey fKey = null;
                    int n5 = 0;
                    if (compoundName.size() > 2) {
                        fKey = this.doc.getKey();
                        fKey.add(50155, compoundName.get(2));
                        n5 = 289;
                    }
                    fObj = this.doc.getGWObject(130, fKey, null, n5);
                }
            } else if (compoundName.get(1).equals("{IDOMAIN RECORDS}")) {
                if (compoundName.size() == 2) {
                    fObj = new FObj(0, 30107);
                } else {
                    FKey fKey = null;
                    fKey = this.doc.getKey();
                    fKey.add(50155, compoundName.getSuffix(2).toString());
                    fObj = this.doc.getGWObject(146, fKey, null, 371);
                }
            } else if (compoundName.get(1).equals("{MTA PROFILE RECORDS}")) {
                if (compoundName.size() == 2) {
                    fObj = new FObj(0, 30108);
                } else {
                    FKey fKey = null;
                    fKey = this.doc.getKey();
                    fKey.add(50155, compoundName.getSuffix(2).toString());
                    fObj = this.doc.getGWObject(138, fKey, null, 351);
                }
            } else if (compoundName.get(1).equals("{TRUSTED APPLICATION RECORDS}")) {
                if (compoundName.size() == 2) {
                    fObj = new FObj(0, 30110);
                } else {
                    FKey fKey = this.doc.getKey();
                    fKey.add(50155, compoundName.getSuffix(2).toString());
                    fObj = this.doc.getGWObject(147, fKey, null, 380);
                }
            } else if (compoundName.get(1).equals("{LDAP SERVER RECORDS}")) {
                if (compoundName.size() == 2) {
                    fObj = new FObj(0, 30111);
                } else {
                    FKey fKey = this.doc.getKey();
                    fKey.add(50155, compoundName.getSuffix(2).toString());
                    fObj = this.doc.getGWObject(148, fKey, null, 383);
                }
            } else {
                FKey fKey = this.doc.getKey();
                fKey.add(50155, compoundName.getSuffix(1).toString());
                fObj = this.doc.getGWObject(145, fKey, null, 366);
            }
        } else {
            this.setError(this, (CompoundName)nameParser.parse(" *** " + compoundName.toString()));
            throw this.fillInException(new NameNotFoundException(EngineResource.getString((String)"NameComponentCount") + " " + compoundName + "."));
        }
        return fObj;
    }

    private Attribute getGroupsAttr(int n, CompoundName compoundName) throws NamingException {
        BasicAttribute basicAttribute = null;
        if (n == 106 || n == 108 || n == 110) {
            BasicAttribute basicAttribute2 = new BasicAttribute("GroupWise Group");
            FKey fKey = this.doc.getKey();
            FView fView = this.doc.getView();
            CompoundName compoundName2 = (CompoundName)this.distinguishedName.clone();
            compoundName2.addAll(compoundName);
            if (compoundName2.size() != 3) {
                throw new NameNotFoundException(EngineResource.getString((String)"NameComponentCount") + " " + compoundName2 + ".");
            }
            fKey.add(50041, compoundName2.get(2));
            fKey.add(50040, compoundName2.get(1));
            fKey.add(50039, compoundName2.get(0));
            fView.add(50035);
            fView.add(50062);
            fView.add(50073);
            fView.add(50042);
            FObjIterator fObjIterator = this.doc.getElements(120, 243, fKey, fView, null);
            while (fObjIterator.hasMore()) {
                FObj fObj = (FObj)fObjIterator.next();
                Attributes attributes = fObj.getAll();
                basicAttribute2.add(attributes);
            }
            fObjIterator = null;
            if (basicAttribute2.size() > 0) {
                basicAttribute = basicAttribute2;
            }
        }
        return basicAttribute;
    }

    private void modifyGroupsAttr(CompoundName compoundName, Attribute attribute, int n) throws NamingException {
        Object object;
        Object object2;
        String string = null;
        NamingEnumeration<?> namingEnumeration = attribute.getAll();
        CompoundName compoundName2 = (CompoundName)this.distinguishedName.clone();
        compoundName2.addAll(compoundName);
        if (compoundName2.size() != 3) {
            throw new NameNotFoundException(EngineResource.getString((String)"NameComponentCount") + " " + compoundName2 + ".");
        }
        if (n == 2 || !namingEnumeration.hasMore() && n == 3) {
            object2 = this.doc.getKey();
            ((FKey)object2).add(50041, compoundName2.get(2));
            ((FKey)object2).add(50040, compoundName2.get(1));
            ((FKey)object2).add(50039, compoundName2.get(0));
            this.removeMultiValueAttr((FKey)object2, null, 120, 243);
        }
        while (namingEnumeration.hasMore()) {
            object = (Attributes)namingEnumeration.next();
            FKey fKey = this.doc.getKey();
            object2 = (String)object.get(String.valueOf(50035)).get();
            String string2 = (String)object.get(String.valueOf(50062)).get();
            String string3 = (String)object.get(String.valueOf(50073)).get();
            fKey.add(50035, (String)object2);
            fKey.add(50062, string2);
            fKey.add(50073, string3);
            fKey.add(50039, compoundName2.get(0));
            fKey.add(50040, compoundName2.get(1));
            fKey.add(50041, compoundName2.get(2));
            if (n == 1 || n == 2) {
                String string4 = (String)object2 + "." + string2 + "." + string3;
                FObj fObj = this.doc.getGWObject(120, fKey, null, 243);
                fObj.setAttr(50042, (Integer)object.get(String.valueOf(50042)).get());
                try {
                    int n2 = fObj.objectCommit(this.doc, "GroupMembership", true);
                    continue;
                }
                catch (CommunicationException communicationException) {
                    Debug.trace((String)("GwComponentDirContext.modifyGroupsAttr>" + communicationException + "; dhoStr = " + string4));
                    throw communicationException;
                }
                catch (NameNotFoundException nameNotFoundException) {
                    Debug.trace((String)"\n\nGwComponentDirContext.modifyGroupsAttr: IGNORE this:");
                    Debug.trace((String)("GwComponentDirContext.modifyGroupsAttr>" + nameNotFoundException + "; dhoStr = " + string4));
                    continue;
                }
                catch (NamingException namingException) {
                    Debug.trace((String)("GwComponentDirContext.modifyGroupsAttr>" + namingException + "; dhoStr = " + string4));
                    if (string == null) {
                        string = string4;
                        continue;
                    }
                    string = string + ", " + string4;
                    continue;
                }
            }
            if (n != 3) continue;
            this.removeMultiValueAttr(fKey, null, 120, 243);
        }
        if (string != null) {
            object = EngineResource.getString((String)"GroupMembership") + "\n" + string;
            throw new NamingException((String)object);
        }
    }

    private Attributes getGroupMembersAttrs(int n, int n2, CompoundName compoundName) throws NamingException {
        BasicAttributes basicAttributes = new BasicAttributes();
        if (n2 == 110) {
            BasicAttribute basicAttribute = new BasicAttribute("Member To");
            BasicAttribute basicAttribute2 = new BasicAttribute("Member CC");
            BasicAttribute basicAttribute3 = new BasicAttribute("Member BC");
            FKey fKey = this.doc.getKey();
            FView fView = this.doc.getView();
            CompoundName compoundName2 = (CompoundName)this.distinguishedName.clone();
            compoundName2.addAll(compoundName);
            if (compoundName2.size() != 3) {
                throw new NameNotFoundException(EngineResource.getString((String)"NameComponentCount") + " " + compoundName2 + ".");
            }
            fKey.add(50035, compoundName2.get(0));
            fKey.add(50062, compoundName2.get(1));
            fKey.add(50073, compoundName2.get(2));
            fView.add(50042);
            fView.add(50039);
            fView.add(50040);
            fView.add(50041);
            FObjIterator fObjIterator = this.doc.getElements(120, 242, fKey, fView, null);
            block5: while (fObjIterator.hasMore()) {
                FObj fObj = (FObj)fObjIterator.next();
                Attributes attributes = fObj.getAll();
                CompoundName compoundName3 = (CompoundName)nameParser.parse((String)attributes.get(String.valueOf(50039)).get());
                compoundName3.add((String)attributes.get(String.valueOf(50040)).get());
                compoundName3.add((String)attributes.get(String.valueOf(50041)).get());
                int n3 = (Integer)attributes.get(String.valueOf(50042)).get();
                switch (n3) {
                    case 1: {
                        basicAttribute.add(compoundName3.toString());
                        continue block5;
                    }
                    case 2: {
                        basicAttribute2.add(compoundName3.toString());
                        continue block5;
                    }
                    case 4: {
                        basicAttribute3.add(compoundName3.toString());
                        continue block5;
                    }
                }
                throw new InvalidAttributeValueException(EngineResource.getString((String)"InvalidParticipation") + " " + n3 + ".");
            }
            fObjIterator = null;
            if (basicAttribute.size() > 0 && (n & 1) != 0) {
                basicAttributes.put(basicAttribute);
            }
            if (basicAttribute2.size() > 0 && (n & 2) != 0) {
                basicAttributes.put(basicAttribute2);
            }
            if (basicAttribute3.size() > 0 && (n & 4) != 0) {
                basicAttributes.put(basicAttribute3);
            }
        }
        return basicAttributes;
    }

    private void modifyMembersAttr(CompoundName compoundName, int n, Attribute attribute, int n2) throws NamingException {
        Object object;
        NamingEnumeration<?> namingEnumeration = attribute.getAll();
        CompoundName compoundName2 = (CompoundName)this.distinguishedName.clone();
        compoundName2.addAll(compoundName);
        if (compoundName2.size() != 3) {
            throw new NameNotFoundException(EngineResource.getString((String)"NameComponentCount") + " " + compoundName2 + ".");
        }
        if (n2 == 2 || !namingEnumeration.hasMore() && n2 == 3) {
            object = this.doc.getKey();
            ((FKey)object).add(50035, compoundName2.get(0));
            ((FKey)object).add(50062, compoundName2.get(1));
            ((FKey)object).add(50073, compoundName2.get(2));
            this.removeMultiValueAttr((FKey)object, null, 120, 242);
        }
        while (namingEnumeration.hasMore()) {
            object = (String)namingEnumeration.next();
            CompoundName compoundName3 = (CompoundName)nameParser.parse((String)object);
            FKey fKey = this.doc.getKey();
            fKey.add(50041, compoundName3.get(2));
            fKey.add(50040, compoundName3.get(1));
            fKey.add(50039, compoundName3.get(0));
            fKey.add(50035, compoundName2.get(0));
            fKey.add(50062, compoundName2.get(1));
            fKey.add(50073, compoundName2.get(2));
            if (n2 == 1 || n2 == 2) {
                FObj fObj = this.doc.getGWObject(120, fKey, null, 243);
                fObj.setAttr(50042, n);
                int n3 = fObj.objectCommit(this.doc, "GroupCommitError", true);
                continue;
            }
            if (n2 != 3) continue;
            this.removeMultiValueAttr(fKey, null, 120, 243);
        }
    }

    private Attributes getGroupMembersWithNamesAttrs(int n, CompoundName compoundName) throws NamingException {
        BasicAttributes basicAttributes = new BasicAttributes();
        if (n == 110) {
            BasicAttribute basicAttribute = new BasicAttribute("Member To");
            BasicAttribute basicAttribute2 = new BasicAttribute("Member CC");
            BasicAttribute basicAttribute3 = new BasicAttribute("Member BC");
            FKey fKey = this.doc.getKey();
            FView fView = this.doc.getView();
            CompoundName compoundName2 = (CompoundName)this.distinguishedName.clone();
            compoundName2.addAll(compoundName);
            if (compoundName2.size() != 3) {
                throw new NameNotFoundException(EngineResource.getString((String)"NameComponentCount") + " " + compoundName2 + ".");
            }
            fKey.add(50035, compoundName2.get(0));
            fKey.add(50062, compoundName2.get(1));
            fKey.add(50073, compoundName2.get(2));
            fView.add(50042);
            fView.add(50039);
            fView.add(50040);
            fView.add(50041);
            fView.add(50091);
            fView.add(50093);
            FObjIterator fObjIterator = this.doc.getElements(120, 242, fKey, fView, null);
            block5: while (fObjIterator.hasMore()) {
                FObj fObj = (FObj)fObjIterator.next();
                Attributes attributes = fObj.getAll();
                CompoundName compoundName3 = (CompoundName)nameParser.parse((String)attributes.get(String.valueOf(50039)).get());
                compoundName3.add((String)attributes.get(String.valueOf(50040)).get());
                compoundName3.add((String)attributes.get(String.valueOf(50041)).get());
                int n2 = (Integer)attributes.get(String.valueOf(50042)).get();
                BasicAttributes basicAttributes2 = new BasicAttributes();
                BasicAttribute basicAttribute4 = new BasicAttribute("Dho String", compoundName3.toString());
                Attribute attribute = attributes.get(String.valueOf(50091));
                Attribute attribute2 = attributes.get(String.valueOf(50093));
                basicAttributes2.put(basicAttribute4);
                if (attribute != null) {
                    basicAttributes2.put(attribute);
                }
                if (attribute2 != null) {
                    basicAttributes2.put(attribute2);
                }
                switch (n2) {
                    case 1: {
                        basicAttribute.add(basicAttributes2);
                        continue block5;
                    }
                    case 2: {
                        basicAttribute2.add(basicAttributes2);
                        continue block5;
                    }
                    case 4: {
                        basicAttribute3.add(basicAttributes2);
                        continue block5;
                    }
                }
                throw new InvalidAttributeValueException(EngineResource.getString((String)"InvalidParticipation") + " " + n2 + ".");
            }
            fObjIterator = null;
            if (basicAttribute.size() > 0) {
                basicAttributes.put(basicAttribute);
            }
            if (basicAttribute2.size() > 0) {
                basicAttributes.put(basicAttribute2);
            }
            if (basicAttribute3.size() > 0) {
                basicAttributes.put(basicAttribute3);
            }
        }
        return basicAttributes;
    }

    private Attribute getLibraryMembersAttr(int n, CompoundName compoundName) throws NamingException {
        BasicAttribute basicAttribute = null;
        if (n == 133) {
            BasicAttribute basicAttribute2 = new BasicAttribute("Library Member");
            FKey fKey = this.doc.getKey();
            FView fView = this.doc.getView();
            CompoundName compoundName2 = (CompoundName)this.distinguishedName.clone();
            compoundName2.addAll(compoundName);
            if (compoundName2.size() != 3) {
                throw new NameNotFoundException(EngineResource.getString((String)"NameComponentCount") + " " + compoundName2 + ".");
            }
            fKey.add(50035, compoundName2.get(0));
            fKey.add(50062, compoundName2.get(1));
            fKey.add(50073, compoundName2.get(2));
            fView.add(50039);
            fView.add(50040);
            fView.add(50041);
            fView.add(61030);
            fView.add(50100);
            FObjIterator fObjIterator = this.doc.getElements(134, 296, fKey, fView, null);
            while (fObjIterator.hasMore()) {
                FObj fObj = (FObj)fObjIterator.next();
                Attributes attributes = fObj.getAll();
                basicAttribute2.add(attributes);
            }
            fObjIterator = null;
            if (basicAttribute2.size() > 0) {
                basicAttribute = basicAttribute2;
            }
        }
        return basicAttribute;
    }

    private void modifyLibMembersAttr(CompoundName compoundName, Attribute attribute, int n) throws NamingException {
        Object object;
        NamingEnumeration<?> namingEnumeration = attribute.getAll();
        CompoundName compoundName2 = (CompoundName)this.distinguishedName.clone();
        compoundName2.addAll(compoundName);
        if (compoundName2.size() != 3) {
            throw new NameNotFoundException(EngineResource.getString((String)"NameComponentCount") + " " + compoundName2 + ".");
        }
        if (n == 2 || !namingEnumeration.hasMore() && n == 3) {
            object = this.doc.getKey();
            ((FKey)object).add(50035, compoundName2.get(0));
            ((FKey)object).add(50062, compoundName2.get(1));
            ((FKey)object).add(50073, compoundName2.get(2));
            this.removeMultiValueAttr((FKey)object, null, 134, 296);
        }
        while (namingEnumeration.hasMore()) {
            object = (Attributes)namingEnumeration.next();
            FKey fKey = this.doc.getKey();
            fKey.add(50039, (String)object.get(String.valueOf(50039)).get());
            fKey.add(50040, (String)object.get(String.valueOf(50040)).get());
            fKey.add(50041, (String)object.get(String.valueOf(50041)).get());
            fKey.add(50035, compoundName2.get(0));
            fKey.add(50062, compoundName2.get(1));
            fKey.add(50073, compoundName2.get(2));
            if (n == 1 || n == 2) {
                FObj fObj = this.doc.getGWObject(134, fKey, null, 297);
                fObj.setAttr(61030, (Integer)object.get(String.valueOf(61030)).get());
                fObj.setAttr(50100, (Integer)object.get(String.valueOf(50100)).get());
                int n2 = fObj.objectCommit(this.doc, "LibraryAccess", false);
                continue;
            }
            if (n != 3) continue;
            this.removeMultiValueAttr(fKey, null, 134, 297);
        }
    }

    private Attribute getAreaMembersAttr(int n, CompoundName compoundName) throws NamingException {
        BasicAttribute basicAttribute = null;
        if (n == 109) {
            BasicAttribute basicAttribute2 = new BasicAttribute("Area Member");
            FKey fKey = this.doc.getKey();
            FView fView = this.doc.getView();
            FFilter fFilter = null;
            CompoundName compoundName2 = (CompoundName)this.distinguishedName.clone();
            compoundName2.addAll(compoundName);
            if (compoundName2.size() != 3) {
                throw new NameNotFoundException(EngineResource.getString((String)"NameComponentCount") + " " + compoundName2 + ".");
            }
            if (compoundName2.get(0).equals("{SYSTEM RECORDS}")) {
                fFilter = this.doc.getFilter();
                fFilter.add(50035, "", 19);
                fFilter.add(50062, "", 19);
            } else {
                fKey.add(50035, compoundName2.get(0));
                fKey.add(50062, compoundName2.get(1));
            }
            fKey.add(50073, compoundName2.get(2));
            fView.add(50039);
            fView.add(50040);
            fView.add(50041);
            fView.add(50100);
            FObjIterator fObjIterator = this.doc.getElements(137, 299, fKey, fView, fFilter);
            while (fObjIterator.hasMore()) {
                FObj fObj = (FObj)fObjIterator.next();
                Attributes attributes = fObj.getAll();
                basicAttribute2.add(attributes);
            }
            fObjIterator = null;
            if (basicAttribute2.size() > 0) {
                basicAttribute = basicAttribute2;
            }
        }
        return basicAttribute;
    }

    private void modifyAreaMembersAttr(CompoundName compoundName, Attribute attribute, int n) throws NamingException {
        Object object;
        NamingEnumeration<?> namingEnumeration = attribute.getAll();
        CompoundName compoundName2 = (CompoundName)this.distinguishedName.clone();
        compoundName2.addAll(compoundName);
        if (compoundName2.size() != 3) {
            throw new NameNotFoundException(EngineResource.getString((String)"NameComponentCount") + " " + compoundName2 + ".");
        }
        if (n == 2 || !namingEnumeration.hasMore() && n == 3) {
            FKey fKey = this.doc.getKey();
            object = null;
            if (compoundName2.get(0).equals("{SYSTEM RECORDS}")) {
                object = this.doc.getFilter();
                ((FFilter)object).add(50035, "", 19);
                ((FFilter)object).add(50062, "", 19);
            } else {
                fKey.add(50035, compoundName2.get(0));
                fKey.add(50062, compoundName2.get(1));
            }
            fKey.add(50073, compoundName2.get(2));
            this.removeMultiValueAttr(fKey, (FFilter)object, 137, 299);
        }
        while (namingEnumeration.hasMore()) {
            int n2;
            object = (Attributes)namingEnumeration.next();
            Attribute attribute2 = object.get(String.valueOf(50041));
            FKey fKey = this.doc.getKey();
            FFilter fFilter = null;
            if (compoundName2.get(0).equals("{SYSTEM RECORDS}")) {
                fFilter = this.doc.getFilter();
                fFilter.add(50035, "", 19);
                fFilter.add(50062, "", 19);
                n2 = compoundName2.get(1).equals("{SOFTWARE AREA RECORDS}") ? 1 : 3;
            } else {
                fKey.add(50035, compoundName2.get(0));
                fKey.add(50062, compoundName2.get(1));
                n2 = 2;
            }
            fKey.add(50073, compoundName2.get(2));
            fKey.add(50039, (String)object.get(String.valueOf(50039)).get());
            fKey.add(50040, (String)object.get(String.valueOf(50040)).get());
            if (attribute2 == null) {
                fFilter.add(50041, "", 19);
            } else {
                fKey.add(50041, (String)attribute2.get());
            }
            if (n == 1 || n == 2) {
                FObj fObj = this.doc.getGWObject(137, fKey, null, 299, fFilter);
                fObj.setAttr(50100, (Integer)object.get(String.valueOf(50100)).get());
                fObj.setAttr(50075, n2);
                int n3 = fObj.objectCommit(this.doc, "AreaAccess", false);
                continue;
            }
            if (n != 3) continue;
            this.removeMultiValueAttr(fKey, fFilter, 137, 299);
        }
    }

    private Attributes getAreaAttrs(int n, CompoundName compoundName) throws NamingException {
        BasicAttributes basicAttributes = new BasicAttributes();
        if (n == 106 || n == 133 || n == 108 || n == 122) {
            BasicAttribute basicAttribute = new BasicAttribute("Library Area");
            BasicAttribute basicAttribute2 = new BasicAttribute("Restore Area");
            BasicAttribute basicAttribute3 = new BasicAttribute("Software Area");
            FKey fKey = this.doc.getKey();
            FView fView = this.doc.getView();
            FFilter fFilter = null;
            CompoundName compoundName2 = (CompoundName)this.distinguishedName.clone();
            compoundName2.addAll(compoundName);
            if (compoundName2.size() < 2) {
                throw new NameNotFoundException(EngineResource.getString((String)"NameComponentCount") + " " + compoundName2 + ".");
            }
            fKey.add(50039, compoundName2.get(0));
            fKey.add(50040, compoundName2.get(1));
            if (n == 122) {
                fFilter = this.doc.getFilter();
                fFilter.add(50041, "", 19);
            } else {
                fKey.add(50041, compoundName2.get(2));
            }
            fView.add(50035);
            fView.add(50062);
            fView.add(50073);
            fView.add(50075);
            FObjIterator fObjIterator = this.doc.getElements(137, 350, fKey, fView, fFilter);
            while (fObjIterator.hasMore()) {
                FObj fObj = (FObj)fObjIterator.next();
                Attributes attributes = fObj.getAll();
                Attribute attribute = attributes.get(String.valueOf(50075));
                int n2 = attribute != null ? (Integer)attribute.get() : 2;
                switch (n2) {
                    case 1: {
                        basicAttribute3.add(attributes);
                        break;
                    }
                    case 2: {
                        basicAttribute.add(attributes);
                        break;
                    }
                    case 3: {
                        basicAttribute2.add(attributes);
                    }
                }
            }
            fObjIterator = null;
            if (basicAttribute.size() > 0) {
                basicAttributes.put(basicAttribute);
            }
            if (basicAttribute2.size() > 0) {
                basicAttributes.put(basicAttribute2);
            }
            if (basicAttribute3.size() > 0) {
                basicAttributes.put(basicAttribute3);
            }
        }
        return basicAttributes;
    }

    private void modifyAreasAttr(CompoundName compoundName, int n, int n2, Attribute attribute, int n3) throws NamingException {
        Object object;
        Object object2;
        int n4 = 0;
        NamingEnumeration<?> namingEnumeration = attribute.getAll();
        CompoundName compoundName2 = (CompoundName)this.distinguishedName.clone();
        compoundName2.addAll(compoundName);
        if (compoundName2.size() < 2) {
            throw new NameNotFoundException(EngineResource.getString((String)"NameComponentCount") + " " + compoundName2 + ".");
        }
        switch (n) {
            case 122: {
                n4 = 1;
                break;
            }
            case 133: {
                n4 = 11;
                break;
            }
            case 108: {
                n4 = 5;
                break;
            }
            case 106: {
                n4 = 6;
            }
        }
        if (n3 == 2 || !namingEnumeration.hasMore() && n3 == 3) {
            object2 = this.doc.getKey();
            object = null;
            ((FKey)object2).add(50039, compoundName2.get(0));
            ((FKey)object2).add(50040, compoundName2.get(1));
            if (n == 122) {
                object = this.doc.getFilter();
                ((FFilter)object).add(50041, "", 19);
            } else {
                ((FKey)object2).add(50041, compoundName2.get(2));
            }
            ((FKey)object2).add(50075, n2);
            this.removeMultiValueAttr((FKey)object2, (FFilter)object, 137, 350);
        }
        while (namingEnumeration.hasMore()) {
            object2 = (Attributes)namingEnumeration.next();
            object = this.doc.getKey();
            FFilter fFilter = null;
            ((FKey)object).add(50039, compoundName2.get(0));
            ((FKey)object).add(50040, compoundName2.get(1));
            if (n == 122) {
                fFilter = this.doc.getFilter();
                fFilter.add(50041, "", 19);
            } else {
                ((FKey)object).add(50041, compoundName2.get(2));
            }
            ((FKey)object).add(50075, n2);
            if (n2 == 2) {
                ((FKey)object).add(50035, (String)object2.get(String.valueOf(50035)).get());
                ((FKey)object).add(50062, (String)object2.get(String.valueOf(50062)).get());
                n2 = 2;
            } else {
                if (fFilter == null) {
                    fFilter = this.doc.getFilter();
                }
                fFilter.add(50035, "", 19);
                fFilter.add(50062, "", 19);
            }
            ((FKey)object).add(50073, (String)object2.get(String.valueOf(50073)).get());
            if (n3 == 1 || n3 == 2) {
                FObj fObj = this.doc.getGWObject(137, (FKey)object, null, 350, fFilter);
                fObj.setAttr(50100, n4);
                int n5 = fObj.objectCommit(this.doc, "AreaRecord", false);
                continue;
            }
            if (n3 != 3) continue;
            this.removeMultiValueAttr((FKey)object, fFilter, 137, 350);
        }
    }

    private Attribute getAliasesAttr(int n, CompoundName compoundName) throws NamingException {
        BasicAttribute basicAttribute = null;
        if (n == 106 || n == 122) {
            int n2;
            int n3;
            BasicAttribute basicAttribute2 = new BasicAttribute("Gateway Alias");
            FKey fKey = this.doc.getKey();
            FView fView = this.doc.getView();
            FFilter fFilter = null;
            CompoundName compoundName2 = (CompoundName)this.distinguishedName.clone();
            compoundName2.addAll(compoundName);
            if (compoundName2.size() < 2) {
                throw new NameNotFoundException(EngineResource.getString((String)"NameComponentCount") + " " + compoundName2 + ".");
            }
            fKey.add(50035, compoundName2.get(0));
            fKey.add(50062, compoundName2.get(1));
            if (n == 122) {
                fFilter = this.doc.getFilter();
                fFilter.add(50073, "", 19);
                n3 = 267;
                n2 = 128;
            } else {
                fKey.add(50073, compoundName2.get(2));
                n3 = 253;
                n2 = 124;
            }
            fView.add(50140);
            fView.add(50077);
            FObjIterator fObjIterator = this.doc.getElements(n2, n3, fKey, fView, fFilter);
            while (fObjIterator.hasMore()) {
                FObj fObj = (FObj)fObjIterator.next();
                Attributes attributes = fObj.getAll();
                basicAttribute2.add(attributes);
            }
            fObjIterator = null;
            if (basicAttribute2.size() > 0) {
                basicAttribute = basicAttribute2;
            }
        }
        return basicAttribute;
    }

    private void modifyAliasesAttr(CompoundName compoundName, int n, Attribute attribute, int n2) throws NamingException {
        Object object;
        Object object2;
        int n3;
        int n4;
        NamingEnumeration<?> namingEnumeration = attribute.getAll();
        CompoundName compoundName2 = (CompoundName)this.distinguishedName.clone();
        compoundName2.addAll(compoundName);
        if (compoundName2.size() < 2) {
            throw new NameNotFoundException(EngineResource.getString((String)"NameComponentCount") + " " + compoundName2 + ".");
        }
        if (n == 122) {
            n4 = 267;
            n3 = 128;
        } else {
            n4 = 253;
            n3 = 124;
        }
        if (n2 == 2 || !namingEnumeration.hasMore() && n2 == 3) {
            object2 = this.doc.getKey();
            object = null;
            ((FKey)object2).add(50035, compoundName2.get(0));
            ((FKey)object2).add(50062, compoundName2.get(1));
            if (n == 122) {
                object = this.doc.getFilter();
                ((FFilter)object).add(50073, "", 19);
            } else {
                ((FKey)object2).add(50073, compoundName2.get(2));
                n4 = 253;
            }
            this.removeMultiValueAttr((FKey)object2, (FFilter)object, n3, n4);
        }
        while (namingEnumeration.hasMore()) {
            object2 = (Attributes)namingEnumeration.next();
            object = this.doc.getKey();
            FFilter fFilter = null;
            ((FKey)object).add(50035, compoundName2.get(0));
            ((FKey)object).add(50062, compoundName2.get(1));
            if (n == 122) {
                fFilter = this.doc.getFilter();
                fFilter.add(50073, "", 19);
            } else {
                ((FKey)object).add(50073, compoundName2.get(2));
            }
            ((FKey)object).add(50140, (String)object2.get(String.valueOf(50140)).get());
            if (n2 == 1 || n2 == 2) {
                FObj fObj = this.doc.getGWObject(n3, (FKey)object, null, n4, fFilter);
                fObj.modifyAttribute(2, object2.get(String.valueOf(50077)));
                int n5 = fObj.objectCommit(this.doc, "GatewayAliasCreateFailed", false);
                continue;
            }
            if (n2 != 3) continue;
            this.removeMultiValueAttr((FKey)object, fFilter, n3, n4);
        }
    }

    private Attribute getAdminAttr(int n, CompoundName compoundName) throws NamingException {
        BasicAttribute basicAttribute = null;
        if (n == 101 || n == 123) {
            BasicAttribute basicAttribute2 = new BasicAttribute("Administrator");
            FFilter fFilter = null;
            FKey fKey = this.doc.getKey();
            FView fView = this.doc.getView();
            CompoundName compoundName2 = (CompoundName)this.distinguishedName.clone();
            compoundName2.addAll(compoundName);
            fKey.add(50035, compoundName2.get(0));
            switch (compoundName2.size()) {
                case 1: {
                    fFilter = this.doc.getFilter();
                    fFilter.add(50062, "", 19);
                    break;
                }
                case 2: {
                    fKey.add(50062, compoundName2.get(1));
                    break;
                }
                default: {
                    throw new NameNotFoundException(EngineResource.getString((String)"NameComponentCount") + " " + compoundName2 + ".");
                }
            }
            fView.add(50005);
            fView.add(50006);
            fView.add(50007);
            fView.add(50154);
            FObjIterator fObjIterator = this.doc.getElements(112, 247, fKey, fView, fFilter);
            while (fObjIterator.hasMore()) {
                FObj fObj = (FObj)fObjIterator.next();
                Attributes attributes = fObj.getAll();
                basicAttribute2.add(attributes);
            }
            fObjIterator = null;
            if (basicAttribute2.size() > 0) {
                basicAttribute = basicAttribute2;
            }
        }
        return basicAttribute;
    }

    private void modifyAdminAttr(CompoundName compoundName, Attribute attribute, int n) throws NamingException {
        Object object;
        Object object2;
        NamingEnumeration<?> namingEnumeration = attribute.getAll();
        CompoundName compoundName2 = (CompoundName)this.distinguishedName.clone();
        compoundName2.addAll(compoundName);
        if (n == 2 || !namingEnumeration.hasMore() && n == 3) {
            object2 = null;
            object = this.doc.getKey();
            ((FKey)object).add(50035, compoundName2.get(0));
            switch (compoundName2.size()) {
                case 1: {
                    object2 = this.doc.getFilter();
                    ((FFilter)object2).add(50062, "", 19);
                    break;
                }
                case 2: {
                    ((FKey)object).add(50062, compoundName2.get(1));
                    break;
                }
                default: {
                    throw new NameNotFoundException(EngineResource.getString((String)"NameComponentCount") + " " + compoundName2 + ".");
                }
            }
            this.removeMultiValueAttr((FKey)object, (FFilter)object2, 112, 247);
        }
        while (namingEnumeration.hasMore()) {
            object2 = (Attributes)namingEnumeration.next();
            object = null;
            FKey fKey = this.doc.getKey();
            fKey.add(50005, (String)object2.get(String.valueOf(50005)).get());
            fKey.add(50006, (String)object2.get(String.valueOf(50006)).get());
            fKey.add(50007, (String)object2.get(String.valueOf(50007)).get());
            fKey.add(50035, compoundName2.get(0));
            if (compoundName2.size() == 1) {
                object = this.doc.getFilter();
                ((FFilter)object).add(50062, "", 19);
            } else if (compoundName2.size() == 2) {
                fKey.add(50062, compoundName2.get(1));
            } else {
                throw new NameNotFoundException(EngineResource.getString((String)"NameComponentCount") + " " + compoundName2 + ".");
            }
            fKey.add(50154, (Integer)object2.get(String.valueOf(50154)).get());
            if (n == 1 || n == 2) {
                FObj fObj = this.doc.getGWObject(112, fKey, null, 246, (FFilter)object);
                int n2 = fObj.objectCommit(this.doc, "AdministratorRecord", false);
                continue;
            }
            if (n != 3) continue;
            this.removeMultiValueAttr(fKey, (FFilter)object, 112, 246);
        }
    }

    private Attribute getEvntActMembersAttr(int n, CompoundName compoundName) throws NamingException {
        BasicAttribute basicAttribute = null;
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (n == 131) {
            n2 = 356;
            n3 = 50041;
            n4 = 50155;
            bl = true;
        } else if (n == 130) {
            n2 = 355;
            n3 = 50155;
            n4 = 50041;
            bl = true;
        }
        if (bl) {
            FKey fKey = this.doc.getKey();
            FView fView = this.doc.getView();
            CompoundName compoundName2 = (CompoundName)this.distinguishedName.clone();
            compoundName2.addAll(compoundName);
            if (compoundName2.size() != 3) {
                throw new NameNotFoundException(EngineResource.getString((String)"NameComponentCount") + " " + compoundName2 + ".");
            }
            fKey.add(n3, compoundName2.get(2));
            fView.add(n4);
            FObjIterator fObjIterator = this.doc.getElements(141, n2, fKey, fView, null);
            if (fObjIterator.hasMore()) {
                basicAttribute = new BasicAttribute("EventAction Member");
            }
            while (fObjIterator.hasMore()) {
                FObj fObj = (FObj)fObjIterator.next();
                Attributes attributes = fObj.getAll();
                basicAttribute.add((String)attributes.get(String.valueOf(n4)).get());
            }
            fObjIterator = null;
        }
        return basicAttribute;
    }

    private void modifyEvntActMembersAttr(CompoundName compoundName, int n, Attribute attribute, int n2) throws NamingException {
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (n == 131) {
            n3 = 356;
            n4 = 50041;
            n5 = 50155;
            bl = true;
        } else if (n == 130) {
            n3 = 355;
            n4 = 50155;
            n5 = 50041;
            bl = true;
        }
        if (bl) {
            FKey fKey;
            NamingEnumeration<?> namingEnumeration = attribute.getAll();
            CompoundName compoundName2 = (CompoundName)this.distinguishedName.clone();
            compoundName2.addAll(compoundName);
            if (compoundName2.size() != 3) {
                throw new NameNotFoundException(EngineResource.getString((String)"NameComponentCount") + " " + compoundName2 + ".");
            }
            if (n2 == 2 || !namingEnumeration.hasMore() && n2 == 3) {
                fKey = this.doc.getKey();
                fKey.add(n4, compoundName2.get(2));
                this.removeMultiValueAttr(fKey, null, 141, n3);
            }
            while (namingEnumeration.hasMore()) {
                fKey = this.doc.getKey();
                fKey.add(n4, compoundName2.get(2));
                fKey.add(n5, (String)namingEnumeration.next());
                if (n2 == 1 || n2 == 2) {
                    FObj fObj = this.doc.getGWObject(141, fKey, null, n3);
                    int n6 = fObj.objectCommit(this.doc, "EventActionCreateFailed", false);
                    continue;
                }
                if (n2 != 3) continue;
                this.removeMultiValueAttr(fKey, null, 141, n3);
            }
        }
    }

    private Attribute getAppEvntMembersAttr(int n, CompoundName compoundName) throws NamingException {
        BasicAttribute basicAttribute = null;
        if (n == 117 || n == 116) {
            FFilter fFilter = null;
            FKey fKey = this.doc.getKey();
            FView fView = this.doc.getView();
            CompoundName compoundName2 = (CompoundName)this.distinguishedName.clone();
            compoundName2.addAll(compoundName);
            fKey.add(50035, compoundName2.get(0));
            switch (compoundName2.size()) {
                case 2: {
                    fKey.add(50012, "ADS");
                    fFilter = this.doc.getFilter();
                    fFilter.add(50062, "", 19);
                    break;
                }
                case 3: {
                    fKey.add(50062, compoundName2.get(1));
                    fKey.add(50012, compoundName2.get(2));
                    break;
                }
                default: {
                    throw new NameNotFoundException(EngineResource.getString((String)"NameComponentCount") + " " + compoundName2 + ".");
                }
            }
            fView.add(50155);
            FObjIterator fObjIterator = this.doc.getElements(140, 358, fKey, fView, fFilter);
            if (fObjIterator.hasMore()) {
                basicAttribute = new BasicAttribute("AppEvent Member");
            }
            while (fObjIterator.hasMore()) {
                FObj fObj = (FObj)fObjIterator.next();
                Attributes attributes = fObj.getAll();
                basicAttribute.add((String)attributes.get(String.valueOf(50155)).get());
            }
            fObjIterator = null;
        }
        return basicAttribute;
    }

    private void modifyAppEvntMembersAttr(CompoundName compoundName, Attribute attribute, int n) throws NamingException {
        Object object;
        Object object2;
        NamingEnumeration<?> namingEnumeration = attribute.getAll();
        CompoundName compoundName2 = (CompoundName)this.distinguishedName.clone();
        compoundName2.addAll(compoundName);
        if (n == 2 || !namingEnumeration.hasMore() && n == 3) {
            object2 = null;
            object = this.doc.getKey();
            ((FKey)object).add(50035, compoundName2.get(0));
            switch (compoundName2.size()) {
                case 2: {
                    ((FKey)object).add(50012, "ADS");
                    object2 = this.doc.getFilter();
                    ((FFilter)object2).add(50062, "", 19);
                    break;
                }
                case 3: {
                    ((FKey)object).add(50062, compoundName2.get(1));
                    ((FKey)object).add(50012, compoundName2.get(2));
                    break;
                }
                default: {
                    throw new NameNotFoundException(EngineResource.getString((String)"NameComponentCount") + " " + compoundName2 + ".");
                }
            }
            this.removeMultiValueAttr((FKey)object, (FFilter)object2, 140, 358);
        }
        while (namingEnumeration.hasMore()) {
            object2 = (String)namingEnumeration.next();
            object = null;
            FKey fKey = this.doc.getKey();
            fKey.add(50035, compoundName2.get(0));
            if (compoundName2.size() == 2) {
                fKey.add(50012, "ADS");
                object = this.doc.getFilter();
                ((FFilter)object).add(50062, "", 19);
            } else if (compoundName2.size() == 3) {
                fKey.add(50062, compoundName2.get(1));
                fKey.add(50012, compoundName2.get(2));
            } else {
                throw new NameNotFoundException(EngineResource.getString((String)"NameComponentCount") + " " + compoundName2 + ".");
            }
            fKey.add(50155, (String)object2);
            if (n == 1 || n == 2) {
                FObj fObj = this.doc.getGWObject(140, fKey, null, 358, (FFilter)object);
                int n2 = fObj.objectCommit(this.doc, "AppEventRecord", false);
                continue;
            }
            if (n != 3) continue;
            this.removeMultiValueAttr(fKey, (FFilter)object, 140, 358);
        }
    }

    private Attribute getEvntAppMembersAttr(int n, CompoundName compoundName) throws NamingException {
        BasicAttribute basicAttribute = null;
        if (n == 130) {
            FKey fKey = this.doc.getKey();
            FView fView = this.doc.getView();
            CompoundName compoundName2 = (CompoundName)this.distinguishedName.clone();
            compoundName2.addAll(compoundName);
            if (compoundName2.size() != 3) {
                throw new NameNotFoundException(EngineResource.getString((String)"NameComponentCount") + " " + compoundName2 + ".");
            }
            fKey.add(50155, compoundName2.get(2));
            fView.add(50035);
            fView.add(50062);
            fView.add(50012);
            FObjIterator fObjIterator = this.doc.getElements(140, 359, fKey, fView, null);
            if (fObjIterator.hasMore()) {
                basicAttribute = new BasicAttribute("EventApp Member");
            }
            while (fObjIterator.hasMore()) {
                FObj fObj = (FObj)fObjIterator.next();
                Attributes attributes = fObj.getAll();
                basicAttribute.add(attributes);
            }
            fObjIterator = null;
        }
        return basicAttribute;
    }

    private void modifyEvntAppMembersAttr(CompoundName compoundName, Attribute attribute, int n) throws NamingException {
        Object object;
        NamingEnumeration<?> namingEnumeration = attribute.getAll();
        CompoundName compoundName2 = (CompoundName)this.distinguishedName.clone();
        compoundName2.addAll(compoundName);
        if (n == 2 || !namingEnumeration.hasMore() && n == 3) {
            object = this.doc.getKey();
            ((FKey)object).add(50155, compoundName2.get(2));
            this.removeMultiValueAttr((FKey)object, null, 140, 359);
        }
        while (namingEnumeration.hasMore()) {
            Attributes attributes = (Attributes)namingEnumeration.next();
            FFilter fFilter = null;
            FKey fKey = this.doc.getKey();
            fKey.add(50155, compoundName2.get(2));
            fKey.add(50035, (String)attributes.get(String.valueOf(50035)).get());
            object = attributes.get(String.valueOf(50062));
            if (object == null) {
                fFilter = this.doc.getFilter();
                fFilter.add(50062, "", 19);
                fKey.add(50012, "ADS");
            } else {
                fKey.add(50062, (String)object.get());
                fKey.add(50012, (String)attributes.get(String.valueOf(50012)).get());
            }
            if (n == 1 || n == 2) {
                FObj fObj = this.doc.getGWObject(140, fKey, null, 359, fFilter);
                int n2 = fObj.objectCommit(this.doc, "AppEventRecord", false);
                continue;
            }
            if (n != 3) continue;
            this.removeMultiValueAttr(fKey, fFilter, 140, 359);
        }
    }

    private Attribute getCAddrLinkAttr(int n, CompoundName compoundName) throws NamingException {
        BasicAttribute basicAttribute = null;
        if (n == 101) {
            FKey fKey = this.doc.getKey();
            FView fView = this.doc.getView();
            CompoundName compoundName2 = (CompoundName)this.distinguishedName.clone();
            compoundName2.addAll(compoundName);
            if (compoundName2.size() != 1) {
                throw new NameNotFoundException(EngineResource.getString((String)"NameComponentCount") + " " + compoundName2 + ".");
            }
            fKey.add(50035, compoundName2.get(0));
            fView.add(50125);
            FObjIterator fObjIterator = this.doc.getElements(132, 292, fKey, fView, null);
            if (fObjIterator.hasMore()) {
                basicAttribute = new BasicAttribute("Custom Address Link");
            }
            while (fObjIterator.hasMore()) {
                FObj fObj = (FObj)fObjIterator.next();
                Attributes attributes = fObj.getAll();
                basicAttribute.add((String)attributes.get(String.valueOf(50125)).get());
            }
            fObjIterator = null;
        }
        return basicAttribute;
    }

    private void modifyCAddrLinkAttr(CompoundName compoundName, Attribute attribute, int n) throws NamingException {
        FKey fKey;
        NamingEnumeration<?> namingEnumeration = attribute.getAll();
        CompoundName compoundName2 = (CompoundName)this.distinguishedName.clone();
        compoundName2.addAll(compoundName);
        if (compoundName2.size() != 1) {
            throw new NameNotFoundException(EngineResource.getString((String)"NameComponentCount") + " " + compoundName2 + ".");
        }
        if (n == 2 || !namingEnumeration.hasMore() && n == 3) {
            fKey = this.doc.getKey();
            fKey.add(50035, compoundName2.get(0));
            this.removeMultiValueAttr(fKey, null, 132, 292);
        }
        while (namingEnumeration.hasMore()) {
            fKey = this.doc.getKey();
            fKey.add(50035, compoundName2.get(0));
            fKey.add(50125, (String)namingEnumeration.next());
            if (n == 1 || n == 2) {
                FObj fObj = this.doc.getGWObject(132, fKey, null, 292);
                int n2 = fObj.objectCommit(this.doc, "CustomAddressLink", false);
                continue;
            }
            if (n != 3) continue;
            this.removeMultiValueAttr(fKey, null, 132, 292);
        }
    }

    private Attribute getLinkBlobAttr(int n, CompoundName compoundName) throws NamingException {
        BasicAttribute basicAttribute = null;
        if (n == 127) {
            FKey fKey = this.doc.getKey();
            FView fView = this.doc.getView();
            CompoundName compoundName2 = (CompoundName)this.distinguishedName.clone();
            compoundName2.addAll(compoundName);
            if (compoundName2.size() != 2) {
                throw new NameNotFoundException(EngineResource.getString((String)"NameComponentCount") + " " + compoundName2 + ".");
            }
            fKey.add(50035, compoundName2.get(0));
            fKey.add(50162, compoundName2.get(1));
            fView.add(60005);
            FObjIterator fObjIterator = this.doc.getElements(113, 352, fKey, fView, null);
            if (fObjIterator.hasMore()) {
                FObj fObj = (FObj)fObjIterator.next();
                Attributes attributes = fObj.getAll();
                basicAttribute = new BasicAttribute("Link Profile Blob");
                basicAttribute.add(attributes.get(String.valueOf(60005)).get());
            }
            fObjIterator = null;
        }
        return basicAttribute;
    }

    private void modifyLinkBlobAttr(CompoundName compoundName, Attribute attribute, int n) throws NamingException {
        FKey fKey;
        byte[] byArray = (byte[])attribute.get();
        CompoundName compoundName2 = (CompoundName)this.distinguishedName.clone();
        compoundName2.addAll(compoundName);
        if (compoundName2.size() != 2) {
            throw new NameNotFoundException(EngineResource.getString((String)"NameComponentCount") + " " + compoundName2 + ".");
        }
        if (n == 2 || n == 3) {
            fKey = this.doc.getKey();
            fKey.add(50035, compoundName2.get(0));
            fKey.add(50162, compoundName2.get(1));
            this.removeMultiValueAttr(fKey, null, 113, 352);
        }
        fKey = this.doc.getKey();
        fKey.add(50035, compoundName2.get(0));
        fKey.add(50162, compoundName2.get(1));
        if (n == 1 || n == 2) {
            BasicAttribute basicAttribute = new BasicAttribute(String.valueOf(60005), byArray);
            FObj fObj = this.doc.getGWObject(113, fKey, null, 352);
            fObj.modifyAttribute(2, basicAttribute);
            int n2 = fObj.objectCommit(this.doc, "MTAProfileCreateFailed", false);
        } else if (n == 3) {
            this.removeMultiValueAttr(fKey, null, 113, 352);
        }
    }

    private Attribute getLDAPAttr(int n, CompoundName compoundName) throws NamingException {
        BasicAttribute basicAttribute = null;
        if (n == 148 || n == 122) {
            int n2;
            BasicAttribute basicAttribute2;
            FKey fKey = this.doc.getKey();
            FView fView = this.doc.getView();
            int n3 = 149;
            CompoundName compoundName2 = (CompoundName)this.distinguishedName.clone();
            compoundName2.addAll(compoundName);
            if (compoundName2.size() < 2) {
                throw new NameNotFoundException(EngineResource.getString((String)"NameComponentCount") + " " + compoundName2 + ".");
            }
            if (n == 122) {
                basicAttribute2 = new BasicAttribute("LDAP Server");
                fKey.add(50035, compoundName2.get(0));
                fKey.add(50062, compoundName2.get(1));
                fView.add(50155);
                n2 = 385;
            } else {
                basicAttribute2 = new BasicAttribute("LDAP Member");
                fKey.add(50155, compoundName2.get(2));
                fView.add(50035);
                fView.add(50062);
                n2 = 384;
            }
            fView.add(63161);
            FObjIterator fObjIterator = this.doc.getElements(n3, n2, fKey, fView, null);
            while (fObjIterator.hasMore()) {
                FObj fObj = (FObj)fObjIterator.next();
                Attributes attributes = fObj.getAll();
                basicAttribute2.add(attributes);
            }
            fObjIterator = null;
            if (basicAttribute2.size() > 0) {
                basicAttribute = basicAttribute2;
            }
        }
        return basicAttribute;
    }

    private void modifyLDAPAttr(CompoundName compoundName, int n, Attribute attribute, int n2) throws NamingException {
        Object object;
        NamingEnumeration<?> namingEnumeration = attribute.getAll();
        int n3 = 149;
        CompoundName compoundName2 = (CompoundName)this.distinguishedName.clone();
        compoundName2.addAll(compoundName);
        if (compoundName2.size() < 2) {
            throw new NameNotFoundException(EngineResource.getString((String)"NameComponentCount") + " " + compoundName2 + ".");
        }
        int n4 = n == 122 ? 385 : 384;
        if (n2 == 2 || !namingEnumeration.hasMore() && n2 == 3) {
            object = this.doc.getKey();
            if (n == 122) {
                ((FKey)object).add(50035, compoundName2.get(0));
                ((FKey)object).add(50062, compoundName2.get(1));
            } else {
                ((FKey)object).add(50155, compoundName2.get(2));
            }
            this.removeMultiValueAttr((FKey)object, null, n3, n4);
        }
        while (namingEnumeration.hasMore()) {
            object = (Attributes)namingEnumeration.next();
            FKey fKey = this.doc.getKey();
            if (n == 122) {
                fKey.add(50035, compoundName2.get(0));
                fKey.add(50062, compoundName2.get(1));
                fKey.add(50155, (String)object.get(String.valueOf(50155)).get());
            } else {
                fKey.add(50155, compoundName2.get(2));
                fKey.add(50035, (String)object.get(String.valueOf(50035)).get());
                fKey.add(50062, (String)object.get(String.valueOf(50062)).get());
            }
            if (n2 == 1 || n2 == 2) {
                FObj fObj = this.doc.getGWObject(n3, fKey, null, n4);
                fObj.setAttr(63161, (Integer)object.get(String.valueOf(63161)).get());
                int n5 = fObj.objectCommit(this.doc, "LDAPAssocCreateFailed", false);
                continue;
            }
            if (n2 != 3) continue;
            this.removeMultiValueAttr(fKey, null, n3, n4);
        }
    }

    private Attribute getAdministeredGroupsAttr(int n, CompoundName compoundName) throws NamingException {
        BasicAttribute basicAttribute = null;
        if (n == 106) {
            BasicAttribute basicAttribute2 = new BasicAttribute("Administered Groups");
            FKey fKey = this.doc.getKey();
            FView fView = this.doc.getView();
            CompoundName compoundName2 = (CompoundName)this.distinguishedName.clone();
            compoundName2.addAll(compoundName);
            if (compoundName2.size() != 3) {
                throw new NameNotFoundException(EngineResource.getString((String)"NameComponentCount") + " " + compoundName2 + ".");
            }
            fKey.add(50005, compoundName2.get(0));
            fKey.add(50006, compoundName2.get(1));
            fKey.add(50007, compoundName2.get(2));
            fView.add(50039);
            fView.add(50040);
            fView.add(50041);
            fView.add(50191);
            FObjIterator fObjIterator = this.doc.getElements(151, 388, fKey, fView, null);
            while (fObjIterator.hasMore()) {
                FObj fObj = (FObj)fObjIterator.next();
                Attributes attributes = fObj.getAll();
                basicAttribute2.add(attributes);
            }
            fObjIterator = null;
            if (basicAttribute2.size() > 0) {
                basicAttribute = basicAttribute2;
            }
        }
        return basicAttribute;
    }

    private void modifyAdministeredGroupsAttr(CompoundName compoundName, Attribute attribute, int n) throws NamingException {
        Object object;
        NamingEnumeration<?> namingEnumeration = attribute.getAll();
        CompoundName compoundName2 = (CompoundName)this.distinguishedName.clone();
        compoundName2.addAll(compoundName);
        if (compoundName2.size() != 3) {
            throw new NameNotFoundException(EngineResource.getString((String)"NameComponentCount") + " " + compoundName2 + ".");
        }
        if (n == 2 || !namingEnumeration.hasMore() && n == 3) {
            object = this.doc.getKey();
            ((FKey)object).add(50005, compoundName2.get(0));
            ((FKey)object).add(50006, compoundName2.get(1));
            ((FKey)object).add(50007, compoundName2.get(2));
            this.removeMultiValueAttr((FKey)object, null, 151, 388);
        }
        while (namingEnumeration.hasMore()) {
            object = (Attributes)namingEnumeration.next();
            FKey fKey = this.doc.getKey();
            fKey.add(50005, compoundName2.get(0));
            fKey.add(50006, compoundName2.get(1));
            fKey.add(50007, compoundName2.get(2));
            fKey.add(50039, (String)object.get(String.valueOf(50039)).get());
            fKey.add(50040, (String)object.get(String.valueOf(50040)).get());
            fKey.add(50041, (String)object.get(String.valueOf(50041)).get());
            if (n == 1 || n == 2) {
                FObj fObj = this.doc.getGWObject(151, fKey, null, 388);
                fObj.setAttr(50191, (Integer)object.get(String.valueOf(50191)).get());
                int n2 = fObj.objectCommit(this.doc, "AccessControl", false);
                continue;
            }
            if (n != 3) continue;
            this.removeMultiValueAttr(fKey, null, 151, 388);
        }
    }

    private Attribute getGroupAdministratorsAttr(int n, CompoundName compoundName) throws NamingException {
        BasicAttribute basicAttribute = null;
        if (n == 110) {
            BasicAttribute basicAttribute2 = new BasicAttribute("Group Administrators");
            FKey fKey = this.doc.getKey();
            FView fView = this.doc.getView();
            CompoundName compoundName2 = (CompoundName)this.distinguishedName.clone();
            compoundName2.addAll(compoundName);
            if (compoundName2.size() != 3) {
                throw new NameNotFoundException(EngineResource.getString((String)"NameComponentCount") + " " + compoundName2 + ".");
            }
            fKey.add(50039, compoundName2.get(0));
            fKey.add(50040, compoundName2.get(1));
            fKey.add(50041, compoundName2.get(2));
            fView.add(50005);
            fView.add(50006);
            fView.add(50007);
            fView.add(50191);
            FObjIterator fObjIterator = this.doc.getElements(151, 389, fKey, fView, null);
            while (fObjIterator.hasMore()) {
                FObj fObj = (FObj)fObjIterator.next();
                Attributes attributes = fObj.getAll();
                basicAttribute2.add(attributes);
            }
            fObjIterator = null;
            if (basicAttribute2.size() > 0) {
                basicAttribute = basicAttribute2;
            }
        }
        return basicAttribute;
    }

    private void modifyGroupAdministratorsAttr(CompoundName compoundName, Attribute attribute, int n) throws NamingException {
        Object object;
        NamingEnumeration<?> namingEnumeration = attribute.getAll();
        CompoundName compoundName2 = (CompoundName)this.distinguishedName.clone();
        compoundName2.addAll(compoundName);
        if (compoundName2.size() != 3) {
            throw new NameNotFoundException(EngineResource.getString((String)"NameComponentCount") + " " + compoundName2 + ".");
        }
        if (n == 2 || !namingEnumeration.hasMore() && n == 3) {
            object = this.doc.getKey();
            ((FKey)object).add(50039, compoundName2.get(0));
            ((FKey)object).add(50040, compoundName2.get(1));
            ((FKey)object).add(50041, compoundName2.get(2));
            this.removeMultiValueAttr((FKey)object, null, 151, 389);
        }
        while (namingEnumeration.hasMore()) {
            object = (Attributes)namingEnumeration.next();
            FKey fKey = this.doc.getKey();
            fKey.add(50039, compoundName2.get(0));
            fKey.add(50040, compoundName2.get(1));
            fKey.add(50041, compoundName2.get(2));
            fKey.add(50005, (String)object.get(String.valueOf(50005)).get());
            fKey.add(50006, (String)object.get(String.valueOf(50006)).get());
            fKey.add(50007, (String)object.get(String.valueOf(50007)).get());
            if (n == 1 || n == 2) {
                FObj fObj = this.doc.getGWObject(151, fKey, null, 389);
                fObj.setAttr(50191, (Integer)object.get(String.valueOf(50191)).get());
                int n2 = fObj.objectCommit(this.doc, "AccessControl", false);
                continue;
            }
            if (n != 3) continue;
            this.removeMultiValueAttr(fKey, null, 151, 389);
        }
    }

    private void removeMultiValueAttr(FKey fKey, FFilter fFilter, int n, int n2) throws NamingException {
        FObjIterator fObjIterator = this.doc.getElements(n, n2, fKey, null, fFilter);
        while (fObjIterator.hasMore()) {
            FObj fObj = (FObj)fObjIterator.next();
            if (this.doc.canDeleteObject(fObj)) {
                int n3 = this.doc.deleteObj(fObj);
                if (n3 == 0) continue;
                throw new NamingException(EngineResource.getString((String)"DeleteFailed") + " " + this.loadEngErrStr(n3) + "  (0x" + Integer.toHexString(n3).toUpperCase() + ")");
            }
            throw new ContextNotEmptyException();
        }
        fObjIterator = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Attributes getPreferences(String[] stringArray, boolean bl) throws NamingException {
        BasicAttributes basicAttributes = new BasicAttributes();
        int n = this.flaimObj.getNewObjectType();
        if (n < 30100) {
            Object object = prefLockObj;
            synchronized (object) {
                TPref tPref = null;
                try {
                    int n2;
                    switch (n) {
                        case 101: {
                            n2 = 7;
                            break;
                        }
                        case 122: {
                            n2 = 6;
                            break;
                        }
                        default: {
                            n2 = 5;
                        }
                    }
                    BasicAttribute basicAttribute = new BasicAttribute("Current Lock Level", new Integer(n2));
                    basicAttributes.put(basicAttribute);
                    tPref = this.flaimObj.getPreferenceInstance();
                    for (int i = 0; i < stringArray.length; ++i) {
                        Attributes attributes;
                        int n3;
                        Object object2;
                        if (bl) {
                            object2 = (String)FObj.groupToPrefMapperHash.get(stringArray[i].toLowerCase());
                            if (object2 == null) continue;
                            n3 = Integer.parseInt((String)object2);
                        } else {
                            n3 = Integer.parseInt(stringArray[i]);
                        }
                        switch (n3) {
                            case 39804: {
                                attributes = this.flaimObj.getPasswordPreferences(tPref, bl, n2);
                                break;
                            }
                            case 39805: {
                                attributes = this.flaimObj.getMailPreferences(tPref, bl);
                                break;
                            }
                            case 39806: {
                                attributes = this.flaimObj.getApptMsgPreferences(tPref, bl);
                                break;
                            }
                            case 39807: {
                                attributes = this.flaimObj.getToDoPreferences(tPref, bl);
                                break;
                            }
                            case 39808: {
                                attributes = this.flaimObj.getNoteMsgPreferences(tPref, bl);
                                break;
                            }
                            case 39810: {
                                attributes = this.flaimObj.getBusyPreferences(tPref, bl);
                                break;
                            }
                            case 39814: {
                                attributes = this.flaimObj.getViewsPreferences(tPref, bl);
                                break;
                            }
                            case 39820: {
                                attributes = this.flaimObj.getActionPreferences(tPref, bl);
                                break;
                            }
                            case 39815: {
                                attributes = this.flaimObj.getApptViewPreferences(tPref, bl);
                                break;
                            }
                            case 39817: {
                                attributes = this.flaimObj.getCalendarPreferences(tPref, bl);
                                break;
                            }
                            case 39818: {
                                attributes = this.flaimObj.getDiscardPreferences(tPref, bl);
                                break;
                            }
                            case 39824: {
                                attributes = this.flaimObj.getNotifyPreferences(tPref, bl);
                                break;
                            }
                            case 39800: {
                                attributes = this.flaimObj.getEnvironmentPreferences(tPref, bl);
                                break;
                            }
                            case 39812: {
                                attributes = this.flaimObj.getSpamPreferences(tPref, bl);
                                break;
                            }
                            case 39809: {
                                attributes = this.flaimObj.getAdvancedPreferences(tPref, bl, n2);
                                break;
                            }
                            case 39835: {
                                attributes = this.flaimObj.getLocationPreferences(tPref, bl);
                                break;
                            }
                            case 39823: {
                                attributes = this.flaimObj.getAppearancePreferences(tPref, bl);
                                break;
                            }
                            default: {
                                throw new InvalidAttributesException();
                            }
                        }
                        if (bl) {
                            basicAttributes.put(attributes.get(stringArray[i]));
                            continue;
                        }
                        object2 = attributes.getAll();
                        while (object2.hasMore()) {
                            basicAttributes.put((Attribute)object2.next());
                        }
                    }
                    Object var14_13 = null;
                    if (tPref != null) {
                        tPref.delTPreferences();
                        tPref = null;
                    }
                }
                catch (Throwable throwable) {
                    Object var14_14 = null;
                    if (tPref != null) {
                        tPref.delTPreferences();
                        tPref = null;
                    }
                    throw throwable;
                }
            }
        }
        return basicAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPreferences(Attributes attributes, boolean bl) throws NamingException {
        Object object = prefLockObj;
        synchronized (object) {
            TPref tPref = null;
            try {
                int n;
                int n2 = this.flaimObj.getNewObjectType();
                switch (n2) {
                    case 101: {
                        n = 128;
                        break;
                    }
                    case 122: {
                        n = 64;
                        break;
                    }
                    default: {
                        n = 32;
                    }
                }
                tPref = this.flaimObj.getPreferenceInstance();
                this.flaimObj.setPasswordPreferences(tPref, attributes, n, bl);
                this.flaimObj.setMailPreferences(tPref, attributes, n, bl);
                this.flaimObj.setApptMsgPreferences(tPref, attributes, n, bl);
                this.flaimObj.setToDoPreferences(tPref, attributes, n, bl);
                this.flaimObj.setNoteMsgPreferences(tPref, attributes, n, bl);
                this.flaimObj.setBusyPreferences(tPref, attributes, n, bl);
                this.flaimObj.setViewsPreferences(tPref, attributes, n, bl);
                this.flaimObj.setActionPreferences(tPref, attributes, n, bl);
                this.flaimObj.setApptViewPreferences(tPref, attributes, n, bl);
                this.flaimObj.setCalendarPreferences(tPref, attributes, n, bl);
                this.flaimObj.setDiscardPreferences(tPref, attributes, n, bl);
                this.flaimObj.setNotifyPreferences(tPref, attributes, n, bl);
                this.flaimObj.setEnvironmentPreferences(tPref, attributes, n, bl);
                this.flaimObj.setSpamPreferences(tPref, attributes, n, bl);
                this.flaimObj.setAdvancedPreferences(tPref, attributes, n, bl);
                this.flaimObj.setLocationPreferences(tPref, attributes, n, bl);
                this.flaimObj.setAppearancePreferences(tPref, attributes, n, bl);
                tPref.prefCommit();
                Object var8_7 = null;
                if (tPref != null) {
                    tPref.delTPreferences();
                    tPref = null;
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (tPref != null) {
                    tPref.delTPreferences();
                    tPref = null;
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUserPassword(String string, String string2) throws NamingException {
        int n = this.flaimObj.getNewObjectType();
        if (n == 106) {
            Object object = prefLockObj;
            synchronized (object) {
                TPref tPref = null;
                try {
                    tPref = this.flaimObj.getPreferenceInstance();
                    BasicAttributes basicAttributes = new BasicAttributes();
                    basicAttributes.put("User Password", string);
                    basicAttributes.put("Verify Password", string2);
                    this.flaimObj.setPasswordPreferences(tPref, basicAttributes, 32, false);
                    tPref.prefCommit();
                    Object var8_7 = null;
                    if (tPref != null) {
                        tPref.delTPreferences();
                        tPref = null;
                    }
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    if (tPref != null) {
                        tPref.delTPreferences();
                        tPref = null;
                    }
                    throw throwable;
                }
            }
        }
    }

    private void setError(Object object, CompoundName compoundName) {
        this.remainingName = (CompoundName)this.distinguishedName.clone();
        if (compoundName != null) {
            try {
                this.remainingName.addAll(compoundName);
            }
            catch (InvalidNameException invalidNameException) {
                // empty catch block
            }
        }
    }

    private NamingException fillInException(NamingException namingException) {
        namingException.setRemainingName(this.remainingName);
        return namingException;
    }

    public String getINetAddress() throws CommunicationException {
        String string = "";
        if (this.flaimObj != null) {
            string = this.flaimObj.getObjINetAddress();
        }
        return string;
    }

    public String getSystemGUID() throws CommunicationException {
        return this.doc.getTheSystemGUID();
    }

    public int getNewRecordType() {
        return this.flaimObj.getNewObjectType();
    }

    public GWInformation getGWInformation() throws CommunicationException {
        GWInformation gWInformation = null;
        gWInformation = this.doc.getGWInfo(this.flaimObj);
        return gWInformation;
    }

    public NamingEnumeration listOwnedResources(String string) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration listOwnedResources(CompoundName compoundName) throws NamingException {
        Vector vector = new Vector(20, 10);
        FKey fKey = this.doc.getKey();
        FView fView = this.doc.getView();
        CompoundName compoundName2 = (CompoundName)this.distinguishedName.clone();
        compoundName2.addAll(compoundName);
        if (compoundName2.size() != 3) {
            throw new NameNotFoundException(EngineResource.getString((String)"NameComponentCount") + " " + compoundName2 + ".");
        }
        fKey.add(50035, compoundName2.get(0));
        fKey.add(50062, compoundName2.get(1));
        fKey.add(50081, compoundName2.get(2));
        fView.add(50073);
        FObjIterator fObjIterator = this.doc.getElements(108, 252, fKey, fView, null);
        this.addToCombinedList(vector, fObjIterator, 50073, "ResourceDirContext");
        fObjIterator = null;
        return new GwNameClassEnumerator(vector.elements());
    }

    public boolean canDelete(CompoundName compoundName) throws NamingException {
        FObj fObj;
        boolean bl = false;
        if (compoundName.isEmpty()) {
            fObj = this.flaimObj;
            if (fObj == null) {
                this.setError(this, compoundName);
                throw this.fillInException(new NameNotFoundException());
            }
        } else {
            try {
                fObj = this.getObjectInstance(compoundName, 0);
            }
            catch (NamingException namingException) {
                this.setError(this, compoundName);
                throw this.fillInException(namingException);
            }
        }
        if (!fObj.isObjectValid()) {
            this.setError(this, compoundName);
            throw this.fillInException(new NameNotFoundException(EngineResource.getString((String)"ObjectInvalid") + " " + compoundName.toString() + "."));
        }
        if (!this.doc.canDeleteObject(fObj)) {
            this.setError(this, compoundName);
            throw this.fillInException(new ContextNotEmptyException(EngineResource.getString((String)"ContextNotEmpty") + " " + compoundName.toString() + "."));
        }
        bl = true;
        return bl;
    }

    public boolean getAdminPreference(String string) throws CommunicationException {
        return this.doc.getGWAdminPreference(string);
    }

    public void setAdminPreference(String string, boolean bl) throws CommunicationException {
        this.doc.setGWAdminPreference(string, bl);
    }

    public String getGWGlobalSignature(String string) throws CommunicationException {
        return this.doc.getGWGlobalSignature(string);
    }

    public String[] getGWGlobalSignatures(String string) throws CommunicationException {
        return this.doc.getGWGlobalSignatures(string);
    }

    public String[] getGWGlobalSignatureList() throws CommunicationException {
        return this.doc.getGWGlobalSignatureList();
    }

    public int putGWGlobalSignature(String string, String string2, String string3) throws CommunicationException {
        return this.doc.putGWGlobalSignature(string, string2, string3);
    }

    public int deleteGWGlobalSignature(String string) throws CommunicationException {
        return this.doc.deleteGWGlobalSignature(string);
    }

    public String getGWPOSoftwareAreaName(String string, String string2) throws CommunicationException {
        return this.doc.getGWPOSoftwareAreaName(string, string2);
    }

    public ChkOpts getChkOpts(String string) {
        return this.doc.getChkOpts(string);
    }

    public int moveFObjToCKOPTS(ChkOpts chkOpts) throws NamingException {
        int n = -2;
        if (this.flaimObj.getNewObjectType() != 131) {
            throw new OperationNotSupportedException();
        }
        n = chkOpts.moveFObjToCKOPTS(this.flaimObj);
        return n;
    }

    public int moveCKOPTSToFObj(ChkOpts chkOpts) throws NamingException {
        int n = -2;
        if (this.flaimObj.getNewObjectType() != 131) {
            throw new OperationNotSupportedException();
        }
        n = chkOpts.moveCKOPTSToFObj(this.flaimObj);
        return n;
    }

    public GwSearchResult searchForEMailAddress(String string) throws NamingException {
        FObj fObj = this.doc.getGWObjectByEMailAddress(string);
        GwSearchResult gwSearchResult = null;
        if (fObj != null) {
            int n = fObj.getNewObjectType();
            Object var7_5 = null;
            int n2 = n == 124 ? 50077 : 50073;
            Attributes attributes = fObj.getAll();
            gwSearchResult = new GwSearchResult(n2, fObj, attributes);
        }
        return gwSearchResult;
    }

    public FObj getGWObjectByDrn(int n, int n2) throws CommunicationException {
        return this.doc.getGWObjectByDRN(n, n2);
    }

    public int callBacksOn(GwCallBack gwCallBack) {
        return this.doc.callBacksOn(gwCallBack);
    }

    public void callBacksOff() {
        this.doc.callBacksOff();
    }

    public int compareAdminDate(int n) throws NamingException {
        int n2 = -1;
        if (this.flaimObj.getNewObjectType() != 145 && this.flaimObj.getNewObjectType() != 101) {
            throw new OperationNotSupportedException();
        }
        n2 = this.doc.compareAdminDate(n);
        return n2;
    }

    public int compareAdminVersion(String string) throws NamingException {
        int n = -1;
        if (this.flaimObj.getNewObjectType() != 145 && this.flaimObj.getNewObjectType() != 101) {
            throw new OperationNotSupportedException();
        }
        n = this.doc.compareAdminVersion(string);
        return n;
    }

    public int syncRecord() throws CommunicationException {
        return this.doc.syncGWRecord(this.flaimObj);
    }

    public int sendRefreshViewsTask(String string, String string2) throws CommunicationException {
        return this.doc.sendGWRefreshViewsTask(string, string2);
    }

    public int sendRestoreTask(String string, String string2, String string3) throws CommunicationException {
        return this.doc.sendGWRestoreTask(string, string2, string3);
    }

    public int sendMoveForceComplete(String string, String string2, String string3) throws CommunicationException {
        return this.doc.sendGWMoveForceComplete(string, string2, string3);
    }

    public int sendMoveRestart(String string, String string2, String string3) throws CommunicationException {
        return this.doc.sendGWMoveRestart(string, string2, string3);
    }

    public int sendMoveRetry(String string, String string2, String string3) throws CommunicationException {
        return this.doc.sendGWMoveRetry(string, string2, string3);
    }

    public int sendMoveInhibit(String string, String string2, String string3) throws CommunicationException {
        return this.doc.sendGWMoveInhibit(string, string2, string3);
    }

    public int sendMoveUpdate(String string, String string2, String string3) throws CommunicationException {
        return this.doc.sendGWMoveUpdate(string, string2, string3);
    }

    public int sendMovePending(String string, String string2, String string3) throws CommunicationException {
        return this.doc.sendGWMovePending(string, string2, string3);
    }

    public String getLanguageString(int n) {
        return this.doc.getLanguageString(n);
    }

    public String getRestoreAreaPath(int n, String string, String string2, String string3) {
        return this.doc.getRestoreAreaPath(n, string, string2, string3);
    }

    public String loadEngErrStr(int n) {
        return this.doc.loadEngErrStr(n);
    }

    public String loadMoveUserStatusStr(int n) {
        return this.doc.loadMoveUserStatusStr(n);
    }

    public String getRestoreAreaName(String string, String string2, String string3) {
        return this.doc.getRestoreAreaName(string, string2, string3);
    }

    public String getCurrentDomainName() {
        return this.doc.getCurrentDomainName();
    }

    public String getCurrentAdminVersion() {
        return this.doc.getCurrentAdminVersion();
    }

    public String getPrimaryDomainName() {
        return this.doc.getPrimaryDomainName();
    }

    public int getDomainVersion() {
        return this.domainVersion;
    }

    public int replaceDomainDB(String string, String string2) {
        return this.doc.replaceDomainDB(string, string2);
    }

    public boolean isIDomainLocal(String string) {
        return this.doc.isIDomainLocal(string);
    }

    public int validateDB(String string, int n) {
        return this.doc.validateDB(string, n);
    }

    public int recoverDB(String string, String string2, String string3, int n) {
        return this.doc.recoverDB(string, string2, string3, n);
    }

    public int rebuildDB(String string, String string2, String string3) {
        return this.doc.rebuildDB(string, string2, string3);
    }

    public int reclaimDBSpace(String string, String string2, String string3) {
        return this.doc.reclaimDBSpace(string, string2, string3);
    }

    public int resetAdminDBIndexes(String string, String string2, String string3) {
        return this.doc.resetAdminDBIndexes(string, string2, string3);
    }

    public int syncPrimaryWithSecondary(String string, String string2) {
        return this.doc.syncPrimaryWithSecondary(string, string2);
    }

    public int mergeSystem(String string, String string2, boolean bl) {
        return this.doc.mergeSystem(string, string2, bl);
    }

    public int releaseDomain(String string, String string2, String string3) {
        return this.doc.releaseDomain(string, string2, string3);
    }

    public int changePrimary(String string, String string2) {
        return this.doc.changePrimary(string, string2);
    }

    public int sendSetTimestampTask(String string, String string2, String string3, int n, int n2) {
        return this.doc.sendSetTimestampTask(string, string2, string3, n, n2);
    }

    public String testCustomAddress(String string, String[] stringArray, String[] stringArray2) {
        return this.doc.testCustomAddress(string, stringArray, stringArray2);
    }

    public int requestAllExtSysInfo(String string) throws CommunicationException {
        return this.doc.requestAllGWExtSysInfo(string);
    }

    public int clearCompletedMoveStatus() throws CommunicationException {
        return this.doc.clearGWCompletedMoveStatus();
    }

    public int clearSingleCompletedMoveStatus(String string, String string2, String string3) throws CommunicationException {
        return this.doc.clearGWSingleCompletedMoveStatus(string, string2, string3);
    }

    public void checkAgentRestart() throws CommunicationException {
        Debug.trace((String)"\t\t\t\t\t\t\t GwComponentDirContext.checkAgentRestart");
        this.doc.checkSendAgentRestart();
    }

    public boolean doesMailIDExist(String string) throws CommunicationException {
        return this.doc.doesGWMailIDExist(string);
    }

    public void setAdminName(String string, String string2) {
        this.doc.setAdminName(string, string2);
    }

    public void addNdsDsFieldMapToEnv() throws CommunicationException {
        try {
            this.addToEnvironment("com.novell.gw.directory.adminDefinedMap", this.doc.getGWNdsDsFieldMap());
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    public Object getNdsDsFieldMapObject() throws NamingException {
        FObj fObj = this.doc.getGWObject("", "", "", 400);
        NdsDsFieldMapDirContext ndsDsFieldMapDirContext = new NdsDsFieldMapDirContext(false);
        GwComponentDirContext gwComponentDirContext = new GwComponentDirContext((CompoundName)nameParser.parse(""), this.doc, fObj, this.environment, this.domainVersion);
        ndsDsFieldMapDirContext.setImplementation(gwComponentDirContext);
        return ndsDsFieldMapDirContext;
    }

    public Object getLabelsObject(String string) throws NamingException {
        FObj fObj = this.doc.getGWObject(string, "", "", 5);
        LabelsDirContext labelsDirContext = new LabelsDirContext(false);
        GwComponentDirContext gwComponentDirContext = new GwComponentDirContext((CompoundName)nameParser.parse(string), this.doc, fObj, this.environment, this.domainVersion);
        labelsDirContext.setImplementation(gwComponentDirContext);
        return labelsDirContext;
    }

    public Object getEmptyLabelObject(String string) throws NamingException {
        FObj fObj = this.doc.getEmptyLabelObject();
        LabelsDirContext labelsDirContext = new LabelsDirContext(false);
        GwComponentDirContext gwComponentDirContext = new GwComponentDirContext((CompoundName)nameParser.parse(string), this.doc, fObj, this.environment, this.domainVersion);
        labelsDirContext.setImplementation(gwComponentDirContext);
        return labelsDirContext;
    }

    public int[] getViewList(String string, int n) throws NamingException {
        if (n <= 0) {
            throw new InvalidAttributesException();
        }
        FObj fObj = this.doc.getGWAddressBookView(n, string);
        int n2 = fObj.getFieldCount();
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = fObj.getIDAtIdx(i);
        }
        return nArray;
    }

    public int putViewList(String string, int n, int[] nArray) throws NamingException {
        FObj fObj = this.doc.getGWAddressBookView(n, string);
        fObj.flush();
        for (int i = 0; i < nArray.length; ++i) {
            fObj.setAttr(nArray[i], 0, 10);
        }
        return this.doc.putGWAddressBookView(fObj, n, string);
    }

    public X400DirContext getX400DirContext() throws NamingException {
        X400DirContext x400DirContext = null;
        if (this.flaimObj.getNewObjectType() == 106) {
            FObj fObj;
            CompoundName compoundName = (CompoundName)nameParser.parse("");
            try {
                fObj = this.getObjectInstance(compoundName, 119);
            }
            catch (NamingException namingException) {
                this.setError(this, compoundName);
                throw this.fillInException(namingException);
            }
            GwComponentDirContext gwComponentDirContext = new GwComponentDirContext(this.distinguishedName, this.doc, fObj, this.environment, this.domainVersion);
            x400DirContext = new X400DirContext(false);
            x400DirContext.setImplementation(gwComponentDirContext);
        }
        return x400DirContext;
    }

    public void reInitContext() throws NamingException {
        if (this.flaimObj.getNewObjectType() == 119) {
            CompoundName compoundName = (CompoundName)nameParser.parse("");
            if (this.flaimObj.isObjectValid()) {
                this.c_destroySubcontext(compoundName);
            }
            try {
                this.flaimObj = this.getObjectInstance((CompoundName)nameParser.parse(""), 119);
            }
            catch (NamingException namingException) {
                this.setError(this, compoundName);
                throw this.fillInException(namingException);
            }
        }
    }

    public String toString() {
        String string = this.distinguishedName.toString();
        if (Debug.trace) {
            string = "GwComponentDirContext.toString: Object Dump for [" + this.distinguishedName.toString() + "] ";
            if (this.flaimObj == null) {
                string = string + "\n";
                string = string + this.environment;
                string = string + "\n";
                return string;
            }
            string = string + "(DRN = " + this.flaimObj.getObjRecordID() + ")";
            string = string + "\n";
            try {
                Attributes attributes = this.c_getAttributes((CompoundName)nameParser.parse(""), null);
                string = string + this.attrsToString(attributes, "");
            }
            catch (Exception exception) {
                Debug.trace((String)("GwComponentDirContext.toString: e= " + exception));
                exception.printStackTrace();
            }
        }
        return string;
    }

    private String attrsToString(Attributes attributes, String string) {
        String string2 = string;
        try {
            NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
            while (namingEnumeration.hasMore()) {
                Object obj;
                Attribute attribute = namingEnumeration.next();
                String string3 = attribute.getID();
                string2 = string2 + string3 + ":";
                if (string3 == String.valueOf(55001)) {
                    string2 = string2 + "\t";
                    string2 = string2 + "<attribute value suppressed>";
                    string2 = string2 + "\n" + string;
                    continue;
                }
                int n = 0;
                NamingEnumeration<?> namingEnumeration2 = attribute.getAll();
                while (namingEnumeration2.hasMore()) {
                    obj = namingEnumeration2.next();
                    ++n;
                }
                if (n > 1) {
                    string2 = string2 + "\n" + string;
                }
                namingEnumeration2 = attribute.getAll();
                while (namingEnumeration2.hasMore()) {
                    int n2;
                    Object object;
                    obj = namingEnumeration2.next();
                    if (obj instanceof Attributes) {
                        object = ((Attributes)obj).getAll();
                        string2 = string2 + "\n" + string;
                        while (object.hasMore()) {
                            Object obj2;
                            Attribute attribute2 = (Attribute)object.next();
                            n2 = 0;
                            NamingEnumeration<?> namingEnumeration3 = attribute2.getAll();
                            string2 = string2 + "\t" + attribute2.getID() + ":";
                            while (namingEnumeration3.hasMore()) {
                                obj2 = namingEnumeration3.next();
                                ++n2;
                            }
                            if (n2 > 1) {
                                string2 = string2 + "\n" + string;
                            }
                            namingEnumeration3 = attribute2.getAll();
                            while (namingEnumeration3.hasMore()) {
                                obj2 = namingEnumeration3.next();
                                string2 = string2 + "\t\t";
                                string2 = string2 + obj2;
                                string2 = string2 + "\n" + string;
                            }
                        }
                        string2 = string2 + "\n" + string;
                        continue;
                    }
                    if (obj instanceof byte[]) {
                        object = (byte[])obj;
                        int n3 = ((Object)object).length;
                        string2 = string2 + "\tbyte[].length = " + n3 + "\n" + string;
                        for (n2 = 0; n2 < n3; ++n2) {
                            string2 = string2 + (int)object[n2] + "; ";
                            if (n2 % 10 != 0) continue;
                            string2 = string2 + "\n" + string;
                        }
                        string2 = string2 + "\n" + string;
                        continue;
                    }
                    string2 = string2 + "\t";
                    string2 = string2 + obj;
                    string2 = string2 + "\n" + string;
                }
            }
        }
        catch (Exception exception) {
            Debug.trace((String)("GwComponentDirContext.attrsToString: e= " + exception));
            exception.printStackTrace();
        }
        string2 = string2 + "\n";
        return string2;
    }
}

