/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.directory;

import com.novell.gw.directory.GroupDirContext;
import com.novell.gw.directory.GwDirContext;
import com.novell.gw.directory.ResourceDirContext;
import com.novell.gw.directory.UserDirContext;
import com.novell.gw.util.Debug;
import com.novell.gw.util.Dho;
import javax.naming.CommunicationException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;

public class Gwid {
    private static final String GWID_RECTYPE_SEP = "{";
    private static final String GWID_ID_SEP = "}";
    private static final String GWID_MOVE_SEP = ",";
    private String sGwid;
    private String sSystemID;
    private Dho dhoNew;
    private Dho dhoOld;
    private Dho dhoJNDI;
    private int iAreaType;
    private int iNewRecType;
    private String objName;

    public Gwid(Gwid gwid) {
        this.setGwid(gwid);
    }

    public Gwid(String string) {
        this.parseGwidString(string);
    }

    public Gwid(String string, String string2) {
        this.objName = string2;
        this.parseGwidString(string);
    }

    public Gwid(GwDirContext gwDirContext) throws CommunicationException {
        this.buildGroupWiseID(gwDirContext);
    }

    public boolean containsDho(Dho dho, boolean bl) {
        if (!this.dhoNew.isEmpty() && this.dhoNew.equals(dho)) {
            return true;
        }
        if (bl) {
            return this.dhoJNDI.equals(dho);
        }
        return this.dhoOld.equals(dho);
    }

    public Dho getDho() {
        return this.dhoJNDI;
    }

    public Dho getNewDho() {
        return this.dhoNew;
    }

    public Dho getNewestDho() {
        if (this.isChanging()) {
            return this.dhoNew;
        }
        return this.dhoJNDI;
    }

    public int getNewRecType() {
        return this.iNewRecType;
    }

    public String getSystemID() {
        return this.sSystemID;
    }

    public static boolean areSameObjects(String string, String string2) {
        boolean bl = false;
        if (string != null && string2 != null) {
            if (string.equalsIgnoreCase(string2)) {
                bl = true;
            } else {
                String string3;
                String string4;
                Gwid gwid = new Gwid(string2);
                Gwid gwid2 = new Gwid(string);
                if (gwid2.getNewRecType() == gwid.getNewRecType() && gwid2.getSystemID().equals(gwid.getSystemID()) && (string4 = gwid.getDho().toString()).equalsIgnoreCase(string3 = gwid2.getNewestDho().toString())) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    public boolean isChanging() {
        return !this.dhoNew.isEmpty();
    }

    public boolean isMovePending(GwDirContext gwDirContext) throws NamingException {
        Dho dho;
        return this.isChanging() && (dho = gwDirContext.buildDHO(false)).equals(this.dhoOld);
    }

    private void parseGwidString(String string) {
        this.sGwid = "";
        this.sSystemID = "";
        this.dhoNew = new Dho();
        this.dhoOld = new Dho();
        this.dhoJNDI = new Dho();
        if (string == null || string.length() == 0) {
            Debug.trace((String)"\n\n*******************************************************");
            Debug.trace((String)("Found ojbect without GWID ... Call Art; this.objName = " + this.objName));
            Debug.trace((String)"*******************************************************\n\n");
            this.dhoJNDI.setDho(this.objName);
        } else {
            String string2;
            int n;
            this.sGwid = string;
            this.iNewRecType = 0;
            int n2 = string.lastIndexOf(GWID_RECTYPE_SEP);
            int n3 = string.lastIndexOf(GWID_ID_SEP, n2 + 5);
            if (n2 != -1 && n3 != -1) {
                this.sSystemID = string.substring(n3 + 1);
                try {
                    this.iNewRecType = Integer.parseInt(string.substring(n2 + 1, n3));
                }
                catch (NumberFormatException numberFormatException) {
                    Debug.trace((String)("Bad rectype in GroupWiseID: " + string.substring(n2 + 1, n3)));
                }
            }
            if ((n = (string2 = n2 == -1 ? string : string.substring(0, n2)).indexOf(GWID_MOVE_SEP)) == -1) {
                this.dhoOld.setDho(string2);
            } else {
                int n4 = string2.indexOf(GWID_RECTYPE_SEP);
                this.dhoNew.setDho(string2.substring(0, n4 == -1 ? n : n4));
                this.dhoOld.setDho(string2.substring(n + 1));
            }
            this.dhoJNDI.setDho(this.dhoOld);
        }
        switch (this.iNewRecType) {
            case 116: {
                this.dhoJNDI.setHost(this.objName);
                break;
            }
            case 131: {
                Debug.trace((String)"\n***************************************************");
                Debug.trace((String)"Tell Art Gwid called for OBJ_ACTION");
                Debug.trace((String)"***************************************************\n");
                this.dhoJNDI.setObject(this.dhoJNDI.getDomain());
                this.dhoJNDI.setDomain("{SYSTEM RECORDS}");
                this.dhoJNDI.setHost("{ACTION RECORDS}");
                break;
            }
            case 109: {
                Debug.trace((String)"\n***************************************************");
                Debug.trace((String)"Tell Art Gwid called for OBJ_AREA");
                Debug.trace((String)"***************************************************\n");
                if (this.dhoJNDI.getObject().length() != 0) break;
                this.dhoJNDI.setObject(this.dhoJNDI.getDomain());
                this.dhoJNDI.setDomain("{SYSTEM RECORDS}");
                if (this.iAreaType == 3) {
                    this.dhoJNDI.setHost("{RESTORE AREA RECORDS}");
                    break;
                }
                this.dhoJNDI.setHost("{SOFTWARE AREA RECORDS}");
                break;
            }
            case 130: {
                Debug.trace((String)"\n***************************************************");
                Debug.trace((String)"Tell Art Gwid called for OBJ_EVENT");
                Debug.trace((String)"***************************************************\n");
                this.dhoJNDI.setObject(this.dhoJNDI.getDomain());
                this.dhoJNDI.setDomain("{SYSTEM RECORDS}");
                this.dhoJNDI.setHost("{EVENT RECORDS}");
                break;
            }
            case 138: {
                Debug.trace((String)"\n***************************************************");
                Debug.trace((String)"Tell Art Gwid called for OBJ_MTA_PROFILE");
                Debug.trace((String)"***************************************************\n");
                this.dhoJNDI.setObject(this.dhoJNDI.getDomain());
                this.dhoJNDI.setDomain("{SYSTEM RECORDS}");
                this.dhoJNDI.setHost("MTAProfileContainerDirContext");
                break;
            }
            case 103: {
                Debug.trace((String)"\n***************************************************");
                Debug.trace((String)"Tell Art Gwid called for OBJ_TIMEZONE");
                Debug.trace((String)"***************************************************\n");
                this.dhoJNDI.setObject(this.dhoJNDI.getDomain());
                this.dhoJNDI.setDomain("{SYSTEM RECORDS}");
                this.dhoJNDI.setHost("{TIME ZONE RECORDS}");
                break;
            }
            case 145: {
                Debug.trace((String)"\n***************************************************");
                Debug.trace((String)"Tell Art Gwid called for OBJ_SYSTEM");
                Debug.trace((String)"***************************************************\n");
                this.dhoJNDI.setHost(this.dhoJNDI.toString());
                this.dhoJNDI.setDomain("{SYSTEM RECORDS}");
                break;
            }
            case 129: {
                Debug.trace((String)"\n***************************************************");
                Debug.trace((String)"Tell Art Gwid called for OBJ_CUST_ADDR");
                Debug.trace((String)"***************************************************\n");
                this.dhoJNDI.setObject(this.dhoJNDI.toString());
                this.dhoJNDI.setDomain("{SYSTEM RECORDS}");
                this.dhoJNDI.setHost("{CUSTOM ADDRESS RECORDS}");
                break;
            }
            case 146: {
                Debug.trace((String)"\n***************************************************");
                Debug.trace((String)"Tell Art Gwid called for OBJ_IDOMAIN");
                Debug.trace((String)"***************************************************\n");
                this.dhoJNDI.setObject(this.dhoJNDI.toString());
                this.dhoJNDI.setDomain("{SYSTEM RECORDS}");
                this.dhoJNDI.setHost("{IDOMAIN RECORDS}");
                break;
            }
            case 147: {
                Debug.trace((String)"\n***************************************************");
                Debug.trace((String)"Tell Art Gwid called for OBJ_TRUSTED_APP");
                Debug.trace((String)"***************************************************\n");
                this.dhoJNDI.setObject(this.dhoJNDI.getDomain());
                this.dhoJNDI.setDomain("{SYSTEM RECORDS}");
                this.dhoJNDI.setHost("{TRUSTED APPLICATION RECORDS}");
                break;
            }
            case 148: {
                Debug.trace((String)"\n***************************************************");
                Debug.trace((String)"Tell Art Gwid called for OBJ_LDAP_SERVER");
                Debug.trace((String)"***************************************************\n");
                this.dhoJNDI.setObject(this.dhoJNDI.getDomain());
                this.dhoJNDI.setDomain("{SYSTEM RECORDS}");
                this.dhoJNDI.setHost("{LDAP SERVER RECORDS}");
            }
        }
    }

    private void setGwid(Gwid gwid) {
        if (gwid == null) {
            this.sGwid = "";
            this.sSystemID = "";
            this.dhoNew = new Dho();
            this.dhoOld = new Dho();
            this.dhoJNDI = new Dho();
            this.iNewRecType = 0;
            this.iAreaType = 0;
        } else {
            this.sGwid = gwid.getGwid();
            this.sSystemID = gwid.getSystemID();
            this.dhoNew = new Dho(gwid.getNewDho());
            this.dhoOld = new Dho(gwid.getOldDho());
            this.dhoJNDI = new Dho(gwid.getJNDIDho());
            this.iNewRecType = gwid.getNewRecType();
            this.iAreaType = gwid.getAreaType();
            this.objName = gwid.getObjectName();
        }
    }

    private void buildGroupWiseID(GwDirContext gwDirContext) throws CommunicationException {
        block5: {
            this.sSystemID = gwDirContext.getSystemGUID();
            this.iNewRecType = gwDirContext.getNewRecordType();
            this.dhoNew = new Dho();
            try {
                int n;
                String[] stringArray;
                Attributes attributes;
                Attribute attribute;
                this.dhoOld = gwDirContext.buildDHO(false);
                this.dhoJNDI = gwDirContext.buildDHO(true);
                if (this.dhoOld == null) {
                    throw new NamingException("Missing Naming Attribute");
                }
                if ((gwDirContext instanceof UserDirContext || gwDirContext instanceof ResourceDirContext || gwDirContext instanceof GroupDirContext) && (attribute = (attributes = gwDirContext.getAttributes("", stringArray = new String[]{String.valueOf(50169)})).get(String.valueOf(50169))) != null && (n = ((Integer)attribute.get()).intValue()) == 4) {
                    this.dhoNew = gwDirContext.buildNewDHO();
                    if (this.dhoNew == null) {
                        throw new NamingException("Missing Naming Attribute for New Name");
                    }
                }
                this.sync();
            }
            catch (NamingException namingException) {
                this.sGwid = "";
                this.dhoOld = new Dho();
                this.dhoJNDI = new Dho();
                this.dhoNew = new Dho();
                if (this.iNewRecType >= 30100) break block5;
                Debug.trace((String)("\nGwid(GwDirContext ctx) failed on object (" + namingException.getMessage() + "):\n     " + gwDirContext));
                Debug.traceException((Throwable)namingException);
            }
        }
    }

    private void sync() {
        String string = this.dhoOld.toString();
        if (string.length() > 0) {
            this.sGwid = this.dhoNew.toString();
            if (this.sGwid.length() > 0) {
                this.sGwid = this.sGwid + GWID_MOVE_SEP;
            }
            this.sGwid = this.sGwid + string + GWID_RECTYPE_SEP + this.iNewRecType + GWID_ID_SEP + this.sSystemID;
        } else {
            this.sGwid = "";
        }
    }

    public String getGwid() {
        return this.sGwid;
    }

    public String toString() {
        return this.sGwid;
    }

    private Dho getOldDho() {
        return this.dhoOld;
    }

    private Dho getJNDIDho() {
        return this.dhoJNDI;
    }

    private int getAreaType() {
        return this.iAreaType;
    }

    private String getObjectName() {
        return this.objName;
    }
}

