/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.gwcheck;

import com.novell.gw.admin.gwcheck.CheckApp;
import com.novell.gw.admin.gwcheck.GlueObject;
import com.novell.gw.admin.gwcheck.Misc;
import com.novell.gw.admin.gwcheck.Resource;
import com.novell.gw.directory.GwCallBack;
import com.novell.gw.directory.GwDirContext;
import com.novell.gw.util.Debug;
import com.novell.gw.util.Operable;
import com.novell.utility.localization.Loc;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class CallBackDialog
extends JDialog
implements ActionListener,
GwCallBack {
    private static final int CK_CANCEL_REQUEST = 1;
    private static final int CK_STATS_REQUEST = 2;
    private static final int CK_FIELD_NULL = 0;
    private static final int CK_FIELD_UL_LABEL = 1;
    private static final int CK_FIELD_UL_VALUE = 2;
    private static final int CK_FIELD_LL_LABEL = 3;
    private static final int CK_FIELD_LL_VALUE = 4;
    private static final int CK_FIELD_UR_LABEL = 5;
    private static final int CK_FIELD_UR_VALUE = 6;
    private static final int CK_FIELD_LR_LABEL = 7;
    private static final int CK_FIELD_LR_VALUE = 8;
    private static final int CK_PROCESSING_DONE = 9;
    private static final int CK_PROCESSING_RESET = 10;
    private int returnAction = 0;
    private JLabel labelUL;
    private JLabel labelULV;
    private JLabel labelUR;
    private JLabel labelURV;
    private JLabel labelLL;
    private JLabel labelLLV;
    private JLabel labelLR;
    private JLabel labelLRV;
    private JTextArea mainTA;
    private JButton closeBtn;
    private JButton statsBtn;
    private volatile boolean isShowLocked = false;
    private volatile boolean wasDisposed = false;
    private Object returnVal;
    private Operable operable;
    private Object args;
    private GwDirContext ictx;
    private CheckApp ckApp;
    private LogUpdater updater = new LogUpdater();

    public CallBackDialog(CheckApp checkApp, JFrame jFrame, String string, Operable operable) {
        super(jFrame, string, true);
        this.ckApp = checkApp;
        this.operable = operable;
        this.initComponents();
        this.pack();
        this.setSize(600, 500);
        this.setLocationRelativeTo(jFrame);
    }

    private void initComponents() {
        this.labelUL = new JLabel("        ");
        this.labelULV = new JLabel("        ");
        this.labelUR = new JLabel("        ");
        this.labelURV = new JLabel("        ");
        this.labelLL = new JLabel("        ");
        this.labelLLV = new JLabel("        ");
        this.labelLR = new JLabel("        ");
        this.labelLRV = new JLabel("        ");
        this.mainTA = new JTextArea();
        this.mainTA.setEditable(false);
        this.closeBtn = Resource.getButton("StopKey");
        this.closeBtn.addActionListener(this);
        this.statsBtn = Resource.getButton("StatsKey");
        this.statsBtn.addActionListener(this);
        JPanel jPanel = Misc.getPanel((LayoutManager)new GridLayout(2, 4));
        jPanel.setBorder(new TitledBorder(Resource.getString("csStatus")));
        jPanel.add(this.labelUL);
        jPanel.add(this.labelULV);
        jPanel.add(this.labelUR);
        jPanel.add(this.labelURV);
        jPanel.add(this.labelLL);
        jPanel.add(this.labelLLV);
        jPanel.add(this.labelLR);
        jPanel.add(this.labelLRV);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(new EmptyBorder(10, 10, 10, 10));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel2.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        jPanel2.add((Component)new JScrollPane(this.mainTA), gridBagConstraints);
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 0, 0));
        jPanel3.add(this.closeBtn);
        jPanel3.add(Misc.getBoxHorizontalSpacing((int)8));
        jPanel3.add(this.statsBtn);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 14;
        gridBagConstraints.gridy = 2;
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        Container container = this.getContentPane();
        container.setLayout(new GridLayout(1, 1));
        container.add(jPanel2);
    }

    public void setOpParameters(Object object) {
        this.args = object;
    }

    public void showDelayed() {
        new OpThread().start();
        try {
            Thread.currentThread();
            Thread.sleep(250L);
        }
        catch (InterruptedException interruptedException) {
            Debug.traceException((Throwable)interruptedException);
        }
        this.doShow();
    }

    public void showImmediately() {
        new OpThread().start();
        this.doShow();
    }

    private void doShow() {
        if (this.startShowLock()) {
            this.show();
        }
    }

    private synchronized boolean startShowLock() {
        if (!this.wasDisposed) {
            this.isShowLocked = true;
        }
        return this.isShowLocked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        CallBackDialog callBackDialog = this;
        synchronized (callBackDialog) {
            if (this.isShowLocked) {
                block5: while (true) {
                    try {
                        while (true) {
                            if (this.isShowing()) {
                                this.isShowLocked = false;
                                break block5;
                            }
                            Thread.sleep(100L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        Debug.traceException((Throwable)interruptedException);
                        continue;
                    }
                    break;
                }
            }
            if (this.isShowing()) {
                Debug.trace((String)"CallBackDialog.dispose: calling super.dispose()");
                super.dispose();
            }
            this.wasDisposed = true;
        }
    }

    public Object getReturnVal() {
        return this.returnVal;
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            return;
        }
        super.processWindowEvent(windowEvent);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.closeBtn) {
            Debug.trace((String)"CallBackDialog.actionPerformed: CK_CANCEL_REQUEST");
            this.returnAction = 1;
            String string = Loc.removeHotChar((String)Resource.getString("CloseKey"));
            if (this.closeBtn.getText().equals(string)) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        CallBackDialog.this.dispose();
                    }
                };
                try {
                    SwingUtilities.invokeLater(runnable);
                }
                catch (Exception exception) {
                    Debug.trace((String)("CallBackDialog.OpThread.run: ex= " + exception));
                    Debug.traceException((Throwable)exception);
                }
            }
        } else if (object == this.statsBtn) {
            Debug.trace((String)"CallBackDialog.actionPerformed: CK_STATS_REQUEST");
            this.returnAction = 2;
        } else {
            Debug.traceDlg((String)("CallBackDialog.actionPerformed: no action for " + object));
        }
    }

    public int callBack(int n, int n2, String string) {
        Debug.trace((String)("CallBackDialog.callBack: callBacktype= " + n));
        Debug.trace((String)("               msgId= " + n2));
        Debug.trace((String)("               msgStr= " + string));
        try {
            switch (n2) {
                case 1: {
                    this.labelUL.setText(string);
                    break;
                }
                case 2: {
                    this.labelULV.setText(string);
                    break;
                }
                case 3: {
                    this.labelLL.setText(string);
                    break;
                }
                case 4: {
                    this.labelLLV.setText(string);
                    break;
                }
                case 5: {
                    this.labelUR.setText(string);
                    break;
                }
                case 6: {
                    this.labelURV.setText(string);
                    break;
                }
                case 7: {
                    this.labelLR.setText(string);
                    break;
                }
                case 8: {
                    this.labelLRV.setText(string);
                    break;
                }
                case 9: {
                    this.returnAction = 1;
                    break;
                }
                case 10: {
                    this.returnAction = 0;
                    break;
                }
                default: {
                    boolean bl = this.updater.append(string + "\n");
                    if (!bl) {
                        SwingUtilities.invokeLater(this.updater);
                    }
                    break;
                }
            }
        }
        catch (Exception exception) {
            Debug.trace((String)("CallBackDialog.callBack: ex= " + exception));
            Debug.traceException((Throwable)exception);
            this.returnAction = 1;
        }
        Debug.trace((String)("CallBackDialog.callBack: returning returnAction= " + this.returnAction));
        return this.returnAction;
    }

    private class OpThread
    extends Thread {
        private OpThread() {
        }

        public void run() {
            GlueObject glueObject = CallBackDialog.this.ckApp.getMyChkOpts();
            glueObject.gwCheckCallBacksOn(CallBackDialog.this);
            Debug.trace((String)"run standalone start");
            int n = glueObject.runStandalone(false);
            Debug.trace((String)("run standalone end, rc = " + n + ", hex = 0x" + Integer.toHexString(n)));
            Loc.setText((AbstractButton)CallBackDialog.this.closeBtn, (String)Resource.getString("CloseKey"));
            CallBackDialog.this.statsBtn.setEnabled(false);
            glueObject.gwCheckCallBacksOff();
            if (CallBackDialog.this.ckApp.getBatchMode()) {
                CallBackDialog.this.closeBtn.doClick();
            }
            CallBackDialog.this.returnVal = new Integer(n);
        }
    }

    private class LogUpdater
    implements Runnable {
        boolean pending = false;
        StringBuffer buffer = new StringBuffer();

        private LogUpdater() {
        }

        public synchronized void run() {
            try {
                Document document = CallBackDialog.this.mainTA.getDocument();
                int n = document.getLength();
                int n2 = this.buffer.length();
                int n3 = n + n2 - 50000;
                if (n > 0 && n2 > 0 && n3 > 0) {
                    document.remove(0, n3);
                }
                document.insertString(document.getLength(), this.buffer.toString(), null);
                CallBackDialog.this.mainTA.setCaretPosition(CallBackDialog.this.mainTA.getText().length());
                this.buffer = new StringBuffer();
                this.pending = false;
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }

        public synchronized boolean append(String string) {
            boolean bl = this.pending;
            this.buffer.append(string);
            this.pending = true;
            return bl;
        }
    }
}

