/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.gwcheck;

import com.novell.application.console.snapin.Shell;
import com.novell.gw.admin.common.MsgDisplayer;
import com.novell.gw.admin.gwcheck.CheckApp;
import com.novell.gw.admin.gwcheck.CheckPanel;
import com.novell.gw.admin.gwcheck.GWObjectsPanel;
import com.novell.gw.admin.gwcheck.GlueObject;
import com.novell.gw.admin.gwcheck.LogDialog;
import com.novell.gw.admin.gwcheck.Resource;
import com.novell.gw.admin.gwcheck.myObjectEntry;
import com.novell.gw.admin.widgets.UncFileChooser;
import com.novell.gw.util.Debug;
import java.awt.Component;
import java.awt.Window;
import java.io.File;

public class Processor {
    public static final int WERR_OK = 0;
    public static final int CKOPT_ANALYZE = 0;
    public static final int CKOPT_EXPIRE = 1;
    public static final int CKOPT_STATS = 2;
    public static final int CKOPT_REBUILD = 3;
    public static final int CKOPT_PREFS = 4;
    public static final int CKOPT_RECREATE = 5;
    public static final int CKOPT_MERGE = 6;
    public static final int CKOPT_DMS_AGE = 7;
    public static final int CKOPT_DMS_LOG_CLEANUP = 8;
    public static final int CKOPT_DMS_CONTENTS = 9;
    public static final int CKOPT_RESET_PW = 10;
    public static final int CKOPT_SET_PW = 11;
    public static final int CKOPT_SET_PW_BIT = 12;
    public static final int CKOPT_DISK_SPACE_USAGE = 13;
    public static final int CKOPT_AUDIT_REPORT = 14;
    private CheckApp ckApp = null;
    private CheckPanel cpanel = null;
    private GlueObject glueObj = null;
    private String wptoolsDir = null;
    private String optionsFilePath = null;

    public Processor(CheckApp checkApp, CheckPanel checkPanel) {
        this.ckApp = checkApp;
        this.cpanel = checkPanel;
        this.glueObj = checkApp.getMyChkOpts();
        this.initOptFile();
        this.initOptions(true);
    }

    public void close() {
        Debug.trace((String)"Processor.close");
        this.ckApp = null;
        this.cpanel = null;
        this.glueObj = null;
        this.wptoolsDir = null;
        this.optionsFilePath = null;
    }

    private File newFile(File file) {
        File file2 = null;
        if (file != null) {
            file2 = new File(file.getParent(), file.getName());
        }
        return file2;
    }

    private void setOptFileNameText(File file) {
        Debug.trace((String)("Processor.setOptFileNameText: file=" + file));
        this.cpanel.getLeftPanel().setOptFileLabel(file);
    }

    private File showFileDialog(String string, boolean bl) {
        File file = null;
        File file2 = this.glueObj.getOptnFile();
        if (file2 == null) {
            file2 = this.ckApp.getDefaultOptionsFile();
        }
        UncFileChooser uncFileChooser = new UncFileChooser(file2);
        uncFileChooser.setSelectedFile(file2);
        uncFileChooser.setDialogTitle(string);
        uncFileChooser.setMultiSelectionEnabled(false);
        uncFileChooser.setFileSelectionMode(0);
        int n = -1;
        n = bl ? uncFileChooser.showOpenDialog((Component)this.ckApp.getParentFrame()) : uncFileChooser.showSaveDialog((Component)this.ckApp.getParentFrame());
        if (n == 0) {
            file = uncFileChooser.getSelectedFile();
        }
        return file;
    }

    public void doRetrieve() {
        Debug.trace((String)"****************************************");
        Debug.trace((String)"Processor.doRetrieve()");
        Debug.trace((String)"****************************************");
        File file = this.newFile(this.glueObj.getOptnFile());
        File file2 = this.showFileDialog(Resource.getString("csRetrieveOptionsFromFile"), true);
        if (file2 != null) {
            String string = file2.getAbsolutePath();
            if (file2.exists()) {
                int n = this.glueObj.loadOptions(string);
                if (n != 0) {
                    Debug.trace((String)"***************************************************");
                    Debug.trace((String)("rc = " + n + ", hex = 0x" + Integer.toHexString(n)));
                    Debug.trace((String)"***************************************************");
                    String string2 = Resource.putStringInFormat("csErrorLoadingOptionsFile", string) + "\n 0x" + Integer.toHexString(n);
                    MsgDisplayer.showErr((Component)this.ckApp.getParentFrame(), (String)string2, (boolean)this.ckApp.inConsoleOne());
                    if (file != null) {
                        this.glueObj.loadOptions(file.getAbsolutePath());
                    }
                } else {
                    n = this.commitOptFile(file2);
                    if (n != 0) {
                        Debug.trace((String)"doRetrieve's call to commitOptFile FAILED, returning");
                        return;
                    }
                    this.initOptions(false);
                }
            } else {
                MsgDisplayer.showErr((Component)this.ckApp.getParentFrame(), (String)Resource.putStringInFormat("csFileNotFound", string), (boolean)this.ckApp.inConsoleOne());
            }
        }
    }

    private void setTargetStandalone(GWObjectsPanel gWObjectsPanel) {
        int n = gWObjectsPanel.getGWObjectType();
        if (n == 2) {
            this.glueObj.setTargetStandalone(gWObjectsPanel.getPathToPO(), gWObjectsPanel.getPOName(), null, null, false);
        } else if (n == 3) {
            this.glueObj.setTargetStandalone(gWObjectsPanel.getPathToPO(), null, gWObjectsPanel.getUser_DBName(), null, false);
        } else if (n == 4) {
            this.glueObj.setTargetStandalone(gWObjectsPanel.getPathToPO(), null, gWObjectsPanel.getUser_DBName(), null, true);
        } else if (n == 0) {
            this.glueObj.setTargetStandalone(gWObjectsPanel.getPathToPO(), gWObjectsPanel.getPOName(), gWObjectsPanel.getUser_DBName(), null, false);
        } else if (n == 1) {
            this.glueObj.setTargetStandalone(gWObjectsPanel.getPathToPO(), gWObjectsPanel.getPOName(), null, gWObjectsPanel.getLibName(), false);
        } else if (this.ckApp.isInvokeFromClient()) {
            this.glueObj.setTargetStandalone(this.ckApp.getPathToPO(), null, new String(), null, this.ckApp.getArchiveMode());
        }
    }

    public void doSave() {
        File file = this.newFile(this.glueObj.getOptnFile());
        File file2 = this.showFileDialog(Resource.getString("csSaveOptionsToFile"), false);
        if (file2 != null) {
            Object object;
            String string;
            Object object2;
            int n;
            String string2 = file2.getAbsolutePath();
            if (file2.exists() && (n = MsgDisplayer.showYesNo((Component)this.ckApp.getParentFrame(), (String)Resource.getString("csSaveOptionsToFile"), (String)Resource.putStringInFormat("csOptionsFileAlreadyExists", string2), (boolean)this.ckApp.inConsoleOne())) == 0) {
                Debug.trace((String)"NO selected, returning");
                return;
            }
            n = this.commitOptFile(file2);
            if (n != 0) {
                this.commitOptFile(file);
                Debug.trace((String)"doSave's call to commitOptFile FAILED, returning");
                return;
            }
            this.glueObj.setOptnFile(file2);
            this.commitOptions();
            GWObjectsPanel gWObjectsPanel = this.cpanel.getLeftPanel();
            if (gWObjectsPanel != null) {
                if (this.ckApp.isRunningStandalone()) {
                    this.setTargetStandalone(gWObjectsPanel);
                } else if (gWObjectsPanel.inObjectTypeMode()) {
                    object2 = gWObjectsPanel.getSelectedValues();
                    string = gWObjectsPanel.getEnteredDB();
                    if (string != null && string.length() > 0) {
                        object = (myObjectEntry)object2[0];
                        String string3 = ((myObjectEntry)object).getDomain();
                        String string4 = ((myObjectEntry)object).getHost();
                        this.glueObj.setTarget(string3, string4, string);
                    }
                }
            }
            if ((n = this.glueObj.save()) != 0) {
                Debug.trace((String)("rc = " + n + ", hex = 0x" + Integer.toHexString(n)));
                object2 = this.glueObj.getOptnFile();
                string = object2 == null ? "NULL" : this.glueObj.getOptnFile().getAbsolutePath();
                object = Resource.putStringInFormat("csErrorSavingOptionsFile", string) + "\n 0x" + Integer.toHexString(n);
                MsgDisplayer.showErr((Component)this.ckApp.getParentFrame(), (String)object, (boolean)this.ckApp.inConsoleOne());
                this.glueObj.setOptnFile(file);
                return;
            }
        }
    }

    public void showHelp(String string, Window window) {
        Debug.trace((String)("Processor.showHelp:  tag= " + string));
        if (!this.ckApp.inConsoleOne()) {
            Debug.traceDlg((String)("Processor.showHelp: No Help when running outside of shell - " + string));
            return;
        }
        Shell shell = this.ckApp.getShell();
        if (shell == null) {
            Debug.traceDlg((String)"Processor.showHelp: NULL shell.");
        } else {
            shell.launchHelp("novellgwadmin", string, window);
        }
    }

    public void doDump() {
        if (Debug.trace) {
            this.glueObj.dumpCKOPT();
        }
    }

    public void doRun() {
        int n;
        block14: {
            GWObjectsPanel gWObjectsPanel;
            int n2;
            block13: {
                myObjectEntry myObjectEntry2;
                Debug.trace((String)"\n---------------------------------------------------Processor.doRun\n");
                if (!this.cpanel.getTabbedPanel().getFixLibPanel().OkayToProceed()) {
                    return;
                }
                n2 = this.commitOptFile(this.glueObj.getOptnFile());
                if (n2 != 0) {
                    Debug.traceDlg((String)"doRun's call to commitOptFile FAILED, returning");
                    return;
                }
                n2 = this.commitOptions();
                if (n2 != 0) {
                    Debug.traceDlg((String)"doRun's call to commitOptions FAILED, returning");
                    return;
                }
                n = 0;
                n2 = 0;
                gWObjectsPanel = this.cpanel.getLeftPanel();
                if (gWObjectsPanel == null) {
                    Debug.traceDlg((String)"Processor.doRun: NULL objPanel should never happen");
                }
                if (!gWObjectsPanel.inObjectTypeMode()) break block13;
                String string = gWObjectsPanel.getEnteredDB();
                Debug.trace((String)("Processor.doRun: Entered DB = " + string));
                if (string == null || string.length() <= 0) break block14;
                Object[] objectArray = gWObjectsPanel.getSelectedValues();
                if (objectArray == null) {
                    Debug.traceDlg((String)"Processor.doRun: NULL tmp should never happen");
                }
                if ((n2 = this.commitObject((myObjectEntry2 = (myObjectEntry)objectArray[0]).getDomain(), myObjectEntry2.getHost(), string)) != 0) break block14;
                ++n;
                break block14;
            }
            if (this.ckApp.doingSchedEvents()) {
                this.ckApp.getActionObject().commit(this.glueObj.getChkOpts());
            } else if (this.ckApp.isRunningStandalone()) {
                this.setTargetStandalone(gWObjectsPanel);
                LogDialog logDialog = new LogDialog(this.ckApp);
            } else {
                Object[] objectArray = this.cpanel.getLeftPanel().getSelectedValues();
                if (objectArray == null) {
                    Debug.trace((String)"Processor.doRun: NULL oeA");
                    return;
                }
                int n3 = objectArray.length;
                for (int i = 0; i < n3; ++i) {
                    myObjectEntry myObjectEntry3 = (myObjectEntry)objectArray[i];
                    n2 = this.commitObject(myObjectEntry3.getDomain(), myObjectEntry3.getHost(), myObjectEntry3.getObjectName());
                    if (n2 != 0) continue;
                    ++n;
                }
            }
        }
        if (n > 0) {
            MsgDisplayer.showInfo((Component)this.ckApp.getParentFrame(), (String)Resource.getString("csTaskMsgSent"), (boolean)this.ckApp.inConsoleOne());
            Debug.trace((String)"Should be a message in <domdir>/wpcsin/5 of the domain connected to.");
        }
        Debug.trace((String)"--- END ------------------------------------------------Processor.doRun\n");
        if (Debug.trace) {
            Debug.trace((String)"Processor.doRun: Calling doDump at end of method.");
            this.doDump();
        }
    }

    private int commitObject(String string, String string2, String string3) {
        this.glueObj.setTarget(string, string2, string3);
        int n = this.glueObj.run();
        if (n != 0) {
            String string4 = string + "." + string2 + "." + string3;
            MsgDisplayer.showErr((Component)this.ckApp.getParentFrame(), (String)Resource.putStringInFormat("csErrorSendingTask", string4), (boolean)this.ckApp.inConsoleOne());
            return 2;
        }
        return 0;
    }

    private static int makeSureFileExists(File file) {
        int n = 0;
        Debug.trace((String)("Processor.makeSureFileExists: " + file));
        String string = file.getAbsolutePath();
        if (!file.exists()) {
            try {
                Debug.trace((String)(".......NO file: Creating [" + string + "]"));
                boolean bl = file.createNewFile();
                if (!bl) {
                    String string2 = file.getParent();
                    Debug.trace((String)("parentPath= " + string2));
                    File file2 = null;
                    if (string2 != null) {
                        file2 = new File(string2);
                    }
                    if (file2 == null || !file2.exists() && !file2.mkdirs()) {
                        Debug.traceDlg((String)("makeSureFileExists: ***** FAILED creating " + string));
                        n = 1;
                    }
                }
            }
            catch (Exception exception) {
                Debug.traceDlg((String)("makeSureFileExists: Exception on " + string));
                Debug.traceException((Throwable)exception);
                n = 2;
            }
        }
        return n;
    }

    private int commitOptFile(File file) {
        Debug.trace((String)("Processor.commitOptFile: " + file));
        if (file == null) {
            Debug.trace((String)".... NULL file passed to commitOptFile");
            return 0;
        }
        File file2 = this.newFile(file);
        int n = Processor.makeSureFileExists(file2);
        if (n == 0) {
            this.glueObj.setOptnFile(file2);
        } else {
            MsgDisplayer.showErr((Component)this.ckApp.getParentFrame(), (String)Resource.putStringInFormat("csErrorCreatingFile", file2.getAbsolutePath()), (boolean)this.ckApp.inConsoleOne());
        }
        this.setOptFileNameText(this.glueObj.getOptnFile());
        return n;
    }

    private int actionIndexToChkoptItem(int n) {
        int n2 = -1;
        switch (n) {
            case 0: 
            case 6: 
            case 10: 
            case 17: 
            case 22: {
                n2 = 0;
                break;
            }
            case 1: 
            case 11: 
            case 18: {
                n2 = 1;
                break;
            }
            case 2: 
            case 12: 
            case 19: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 4;
                break;
            }
            case 4: 
            case 20: {
                n2 = 5;
                break;
            }
            case 5: 
            case 21: 
            case 23: {
                n2 = 3;
                break;
            }
            case 7: 
            case 13: {
                n2 = 7;
                break;
            }
            case 8: 
            case 14: {
                n2 = 8;
                break;
            }
            case 9: 
            case 15: {
                n2 = 9;
                break;
            }
            case 16: {
                n2 = 14;
            }
        }
        if (n2 == -1 && Debug.trace) {
            Debug.traceDlg((String)("Processor.actionIndexToChkoptItem: deal with " + n));
        }
        return n2;
    }

    private int chkoptItemToActionIndex(int n) {
        int n2 = -1;
        int n3 = -1;
        GWObjectsPanel gWObjectsPanel = this.cpanel.getLeftPanel();
        if (gWObjectsPanel != null) {
            n3 = gWObjectsPanel.getGWObjectType();
        }
        block0 : switch (n) {
            case 0: {
                switch (n3) {
                    case 0: {
                        n2 = 0;
                        break block0;
                    }
                    case 1: {
                        n2 = 6;
                        break block0;
                    }
                    case 2: {
                        n2 = 10;
                        break block0;
                    }
                    case 3: 
                    case 4: {
                        n2 = 17;
                        break block0;
                    }
                }
                n2 = 22;
                break;
            }
            case 1: {
                switch (n3) {
                    case 0: {
                        n2 = 1;
                        break;
                    }
                    case 2: {
                        n2 = 11;
                        break;
                    }
                    case 3: 
                    case 4: {
                        n2 = 18;
                    }
                }
                break;
            }
            case 2: {
                switch (n3) {
                    case 0: {
                        n2 = 2;
                        break;
                    }
                    case 2: {
                        n2 = 12;
                        break;
                    }
                    case 3: 
                    case 4: {
                        n2 = 19;
                    }
                }
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
            case 5: {
                switch (n3) {
                    case 0: {
                        n2 = 4;
                        break;
                    }
                    case 3: 
                    case 4: {
                        n2 = 20;
                    }
                }
                break;
            }
            case 3: {
                switch (n3) {
                    case 0: {
                        n2 = 5;
                        break;
                    }
                    case 3: 
                    case 4: {
                        n2 = 21;
                        break;
                    }
                    case 5: {
                        n2 = 23;
                    }
                }
                break;
            }
            case 8: {
                switch (n3) {
                    case 1: {
                        n2 = 8;
                        break;
                    }
                    case 2: {
                        n2 = 14;
                    }
                }
                break;
            }
            case 9: {
                switch (n3) {
                    case 1: {
                        n2 = 9;
                        break;
                    }
                    case 2: {
                        n2 = 15;
                    }
                }
                break;
            }
            case 7: {
                n2 = 13;
                break;
            }
            case 14: {
                n2 = 16;
            }
        }
        if (n2 == -1 && Debug.trace) {
            Debug.traceDlg((String)("Processor.chkoptItemToActionIndex: deal with " + n));
        }
        return n2;
    }

    private int commitOptions() {
        Debug.trace((String)"Processor.commitOptions");
        this.glueObj.setDefaults();
        int n = 0;
        int n2 = this.cpanel.getActionPanel().getCurrentActionIndex();
        int n3 = this.actionIndexToChkoptItem(n2);
        if (n3 == -1) {
            Debug.trace((String)"Processor.commitOptions: Bogus actItem");
            n = -1;
        } else {
            this.glueObj.setAction(n3);
            n = this.cpanel.getActionPanel().doCommitsToChkOpts(this.glueObj);
            if (n != 0) {
                Debug.traceDlg((String)"Processor.commitOptions: FAILURE on doCommitsToChkOpts");
            } else {
                this.cpanel.getTabbedPanel().saveData(this.glueObj);
            }
        }
        return n;
    }

    private void initOptions(boolean bl) {
        int n;
        int n2;
        Debug.trace((String)"Processor.initOptions");
        String string = this.glueObj.getObjectName();
        GWObjectsPanel gWObjectsPanel = null;
        if (this.ckApp.isRunningStandalone()) {
            if (!this.ckApp.isInvokeFromClient() && (gWObjectsPanel = this.cpanel.getLeftPanel()) != null) {
                String string2 = null;
                n2 = 0;
                if (bl) {
                    string2 = this.ckApp.getPathToPO();
                    if (string2 == null) {
                        string2 = this.glueObj.getPathToPo();
                        n2 = this.glueObj.getProgram();
                    } else {
                        n = this.ckApp.getInvokeMode();
                        if (n == 1) {
                            n2 = 1;
                        } else if (n == 2) {
                            n2 = 2;
                        }
                    }
                } else {
                    n2 = this.glueObj.getProgram();
                    string2 = this.glueObj.getPathToPo();
                }
                gWObjectsPanel.setStandaloneEnteredDB(string2, this.glueObj.getPOName(), string, n2, this.glueObj.getCkObjType());
            }
        } else {
            gWObjectsPanel = this.cpanel.getLeftPanel();
            if (gWObjectsPanel != null && !string.equals("") && string.compareToIgnoreCase("all") != 0) {
                gWObjectsPanel.setEnteredDB(this.glueObj.getPOName(), string);
            }
        }
        this.cpanel.getTabbedPanel().initData(this.glueObj);
        Debug.trace((String)"Processor.initOptions. before glueObj.getAction()");
        int n3 = this.glueObj.getAction();
        n2 = -1;
        switch (n3) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: {
                n2 = n3;
                break;
            }
            default: {
                Debug.traceDlg((String)("Processor.initOptions: do what with gval= " + n3));
            }
        }
        Debug.trace((String)("Processor.initOptions. actItem=" + n2));
        if (n2 == -1) {
            MsgDisplayer.showErr((Component)this.ckApp.getParentFrame(), (String)(Resource.getString("csUnavailableGWObject") + "\n" + Resource.getString("csDefaultSettingsUsed")), (boolean)this.ckApp.inConsoleOne());
            return;
        }
        n = this.chkoptItemToActionIndex(n2);
        if (n != -1) {
            this.cpanel.getActionPanel().setCurrentActionIndex(n);
            this.cpanel.getActionPanel().doInitsFromChkOpts(this.glueObj);
        }
    }

    private void initOptFile() {
        String string;
        Debug.trace((String)"Processor.initOptFile");
        if (this.ckApp.isInvokeFromClient()) {
            return;
        }
        File file = this.ckApp.getDefaultOptionsFile();
        if (!file.exists() || this.ckApp.doingSchedEvents()) {
            string = null;
        } else {
            string = file.getAbsolutePath();
            int n = this.glueObj.loadOptions(string);
            if (n != 0) {
                Debug.trace((String)("rc = " + n + ", hex = 0x" + Integer.toHexString(n)));
                String string2 = Resource.putStringInFormat("csErrorLoadingOptionsFile", string) + "\n" + Resource.getString("csDefaultSettingsUsed") + "\n 0x" + Integer.toHexString(n);
                MsgDisplayer.showErr((Component)this.ckApp.getParentFrame(), (String)string2, (boolean)this.ckApp.inConsoleOne());
                String string3 = this.glueObj.getOptnFile().getAbsolutePath();
                Debug.trace((String)("Processor.initOptFile szDefOptFile=" + string3));
                n = this.glueObj.loadOptions(string3);
                if (n == 0) {
                    Debug.trace((String)("........................use as default: szDefOptFile=" + string3));
                    string = string3;
                } else {
                    Debug.trace((String)"........................use as default: NULL");
                    string = null;
                    this.glueObj.setDefaults();
                }
            }
        }
        if (string == null) {
            this.setOptFileNameText(null);
        } else {
            this.setOptFileNameText(new File(string));
        }
    }
}

