/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.gwcheck;

import com.novell.application.console.snapin.NConeFactory;
import com.novell.gw.admin.common.MsgDisplayer;
import com.novell.gw.admin.gwcheck.ActionPanel;
import com.novell.gw.admin.gwcheck.CheckApp;
import com.novell.gw.admin.gwcheck.CheckPanel;
import com.novell.gw.admin.gwcheck.ExcludeDialog;
import com.novell.gw.admin.gwcheck.ExcludePanel;
import com.novell.gw.admin.gwcheck.GWObjectsPanel;
import com.novell.gw.admin.gwcheck.GlueObject;
import com.novell.gw.admin.gwcheck.Misc;
import com.novell.gw.admin.gwcheck.RVCheckBox;
import com.novell.gw.admin.gwcheck.Resource;
import com.novell.gw.admin.widgets.EditField;
import com.novell.gw.admin.widgets.EnterTextDialog;
import com.novell.gw.admin.widgets.GWTextField;
import com.novell.gw.admin.widgets.RB;
import com.novell.gw.util.Debug;
import com.novell.utility.layouts.VerticalFlowLayout;
import com.novell.utility.localization.Loc;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TabbedPanel
extends JPanel {
    private final String DBPANEL_STR = Resource.getString("csDatabases");
    private final String LOGGING_STR = Resource.getString("csLogging");
    private final String RESULTS_STR = Resource.getString("csResults");
    private final String MISC_STR = Resource.getString("csMisc");
    private final String EXCLUDE_STR = Resource.getString("csExclude");
    private final String NOTIFY_STR = Resource.getString("csNotification");
    private JPanel topPanel = Misc.getPanel((LayoutManager)new GridLayout(1, 1));
    private CheckApp ckApp = null;
    private CheckPanel cpanel = null;
    private JTabbedPane tabbedPane = NConeFactory.novellJTabbedPane((JTabbedPane)new JTabbedPane(), (String)"", (String)"tab pane");
    private DatabasesPanel dbPanel = null;
    private LoggingPanel loggingPanel = null;
    private ResultsPanel resultsPanel = null;
    private MiscPanel miscPanel = null;
    private ExcludePanel excludePanel = null;
    private NotifyPanel notifyPanel = null;
    private IncludePanel includePanel = null;
    private FixLibPanel fixLibPanel = null;
    private static EnterTextDialog msgDlg = null;

    public TabbedPanel(CheckApp checkApp, CheckPanel checkPanel) {
        this.ckApp = checkApp;
        this.cpanel = checkPanel;
        this.setLayout(new GridLayout(2, 1));
        this.add(this.topPanel);
        this.dbPanel = new DatabasesPanel();
        this.loggingPanel = new LoggingPanel();
        this.resultsPanel = new ResultsPanel();
        this.miscPanel = new MiscPanel();
        this.excludePanel = new ExcludePanel(checkApp, checkPanel);
        this.notifyPanel = new NotifyPanel();
        this.toggleTabs();
        this.tabbedPane.setPreferredSize(new Dimension(299, 115));
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
                int n = jTabbedPane.getSelectedIndex();
                switch (n) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                    case 4: {
                        TabbedPanel.this.excludePanel.reInitData();
                        break;
                    }
                }
            }
        };
        this.tabbedPane.addChangeListener(changeListener);
        this.add(this.tabbedPane);
    }

    public void initData(GlueObject glueObject) {
        this.dbPanel.initData(glueObject);
        this.loggingPanel.initData(glueObject);
        this.resultsPanel.initData(glueObject);
        this.miscPanel.initData(glueObject);
        if (this.ckApp.doingSchedEvents()) {
            this.notifyPanel.initData(glueObject);
        }
        this.setPanelToActionIndex(-1);
    }

    public void saveData(GlueObject glueObject) {
        Debug.trace((String)"TabbedPanel.saveData");
        this.dbPanel.saveData(glueObject);
        this.loggingPanel.saveData(glueObject);
        if (!this.ckApp.isInvokeFromClient() && this.cpanel.getLeftPanel().getGWObjectType() != 3 && this.cpanel.getLeftPanel().getGWObjectType() != 4) {
            this.resultsPanel.saveData(glueObject);
            this.miscPanel.saveData(glueObject);
            int n = this.cpanel.getActionPanel().getCurrentActionIndex();
            if (this.excludePanelDisplayed(n)) {
                this.excludePanel.saveData(glueObject);
            }
        }
        if (this.ckApp.doingSchedEvents()) {
            this.notifyPanel.saveData(glueObject);
        }
    }

    public boolean isAnyDBSelected() {
        boolean bl = false;
        if (this.dbPanel.userCB.isSelected() || this.dbPanel.msgCB.isSelected() || this.dbPanel.docCB.isSelected()) {
            bl = true;
        }
        return bl;
    }

    private boolean excludePanelDisplayed(int n) {
        boolean bl = false;
        if (!this.ckApp.isInvokeFromClient() && this.cpanel.getLeftPanel().getGWObjectType() != 3 && this.cpanel.getLeftPanel().getGWObjectType() != 4) {
            if (n == -1) {
                n = this.cpanel.getActionPanel().getCurrentActionIndex();
            }
            switch (n) {
                case 10: 
                case 11: 
                case 12: {
                    bl = true;
                }
            }
        }
        return bl;
    }

    public static void cleanupMessageDialog() {
        msgDlg = null;
    }

    private void enableIndividualUCB(int n) {
        Debug.trace((String)("TabbedPanel.enableIndividualUCB: index = " + n));
        boolean bl = this.dbPanel.userCB.isSelected();
        switch (n) {
            case 3: 
            case 4: 
            case 5: {
                bl = false;
            }
        }
        if (!this.ckApp.isInvokeFromClient() && this.cpanel.getLeftPanel().getGWObjectType() != 3 && this.cpanel.getLeftPanel().getGWObjectType() != 4) {
            Debug.trace((String)("TabbedPanel.enableIndividualUCB: gwObjectType = " + this.cpanel.getLeftPanel().getGWObjectType()));
            this.resultsPanel.individualUCB.setEnabled(bl);
        }
    }

    public boolean getRunButtonValueForTabP_5() {
        Debug.trace((String)"TabbedPanel.getRunButtonValueForTabP_5");
        boolean bl = false;
        if (this.fixLibPanel.resetWordListsCB.isSelected()) {
            bl = true;
        } else if (this.fixLibPanel.reassignOrphDocCB.isSelected()) {
            String string = this.fixLibPanel.userTF.getText();
            if (string != null && string.length() > 0) {
                bl = true;
            }
        } else if (this.fixLibPanel.resetWordListsCB.isSelected()) {
            bl = true;
        }
        return bl;
    }

    private void toggleTabs() {
        Debug.trace((String)"TabbedPanel.toggleTabs");
        int n = this.tabbedPane.getSelectedIndex();
        if (n == -1) {
            n = 0;
        }
        this.tabbedPane.removeAll();
        this.tabbedPane.addTab(this.DBPANEL_STR, this.dbPanel);
        this.tabbedPane.addTab(this.LOGGING_STR, this.loggingPanel);
        if (!this.ckApp.isInvokeFromClient()) {
            if (this.cpanel.getLeftPanel().getGWObjectType() != 3 && this.cpanel.getLeftPanel().getGWObjectType() != 4) {
                this.tabbedPane.addTab(this.RESULTS_STR, this.resultsPanel);
                this.tabbedPane.addTab(this.MISC_STR, this.miscPanel);
                int n2 = this.cpanel.getActionPanel().getCurrentActionIndex();
                if (this.excludePanelDisplayed(n2)) {
                    this.tabbedPane.addTab(this.EXCLUDE_STR, this.excludePanel);
                } else if (n >= 3) {
                    n = 0;
                }
                if (this.ckApp.doingSchedEvents() && this.ckApp.getActionObject().isDiskCheckEvent()) {
                    this.tabbedPane.addTab(this.NOTIFY_STR, this.notifyPanel);
                }
            } else if (n >= 2) {
                n = 0;
            }
        }
        this.tabbedPane.setSelectedIndex(n);
        this.tabbedPane.repaint();
        this.tabbedPane.updateUI();
    }

    public void includePanelEnable(boolean bl) {
        this.getIncludePanel().enablePanel(bl);
    }

    public boolean includePanelValidSelection() {
        return this.getIncludePanel().isValidSelection();
    }

    public void fixLibPanelEnable(boolean bl) {
        if (this.fixLibPanel == null) {
            this.fixLibPanel = new FixLibPanel();
        }
        this.fixLibPanel.enableTextField(bl);
    }

    public void setPanelToActionIndex(int n) {
        GWObjectsPanel gWObjectsPanel = this.cpanel.getLeftPanel();
        if (n == -1) {
            n = this.cpanel.getActionPanel().getCurrentActionIndex();
        }
        this.toggleTabs();
        this.topPanel.removeAll();
        this.dbPanel.resetDBCheckboxes();
        switch (n) {
            case 0: {
                this.dbPanel.docCB.setSelected(false);
                this.dbPanel.enableDBPanel(true, true, false);
                break;
            }
            case 1: 
            case 11: 
            case 18: {
                IncludePanel includePanel = this.getIncludePanel();
                includePanel.checkEnable();
                this.topPanel.add(includePanel);
                if (this.cpanel.getActionPanel().isExpireReduceRBSelected()) {
                    this.dbPanel.selectDBPanel(true, false, false);
                    this.dbPanel.enableDBPanel(false, false, false);
                    break;
                }
                this.dbPanel.docCB.setSelected(false);
                this.dbPanel.enableDBPanel(true, true, false);
                break;
            }
            case 2: 
            case 12: 
            case 19: {
                IncludePanel includePanel = this.getIncludePanel();
                includePanel.checkEnable();
                this.topPanel.add(includePanel);
                this.dbPanel.selectDBPanel(true, false, false);
                this.dbPanel.enableDBPanel(false, false, false);
                break;
            }
            case 3: 
            case 4: 
            case 20: {
                this.dbPanel.selectDBPanel(true, false, false);
                this.dbPanel.enableDBPanel(false, false, false);
                break;
            }
            case 5: {
                this.dbPanel.docCB.setSelected(false);
                this.dbPanel.enableDBPanel(true, true, false);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: {
                this.dbPanel.selectDBPanel(false, false, true);
                this.dbPanel.enableDBPanel(false, false, false);
                break;
            }
            case 9: 
            case 15: {
                if (this.fixLibPanel == null) {
                    this.fixLibPanel = new FixLibPanel();
                }
                this.topPanel.add(this.fixLibPanel);
                this.dbPanel.selectDBPanel(false, false, true);
                this.dbPanel.enableDBPanel(false, false, false);
                break;
            }
            case 10: 
            case 17: 
            case 21: 
            case 22: 
            case 23: {
                this.dbPanel.enableDBPanel(true, true, true);
                break;
            }
            case 16: {
                this.dbPanel.selectDBPanel(true, false, false);
                this.dbPanel.enableDBPanel(false, false, false);
            }
        }
        this.enableIndividualUCB(n);
        this.cpanel.getButtonPanel().enableRunButton(n, "TabbedPanel.setPanelToActionIndex");
        this.topPanel.repaint();
        this.topPanel.updateUI();
    }

    public IncludePanel getIncludePanel() {
        if (this.includePanel == null) {
            this.includePanel = new IncludePanel();
        }
        return this.includePanel;
    }

    public FixLibPanel getFixLibPanel() {
        if (this.fixLibPanel == null) {
            this.fixLibPanel = new FixLibPanel();
        }
        return this.fixLibPanel;
    }

    class FixLibPanel
    extends JPanel
    implements ItemListener {
        private JCheckBox reassignOrphDocCB = null;
        private JCheckBox resetWordListsCB = null;
        private GWTextField userTF = null;
        private JLabel authorLabel = null;
        private JButton authorButton = null;

        FixLibPanel() {
            this.setLayout((LayoutManager)new VerticalFlowLayout(false, 0));
            this.reassignOrphDocCB = Resource.getCheckBox("csReassignOrphanDocs");
            this.reassignOrphDocCB.addItemListener(this);
            this.add(this.reassignOrphDocCB);
            JPanel jPanel = Misc.getVerticalLayoutPanel();
            jPanel.setBorder(new EmptyBorder(0, 20, 0, 0));
            String string = Resource.getStringWithColon("csNewAuthor");
            this.authorLabel = NConeFactory.novellJLabel((JLabel)new JLabel(string), (String)Loc.removeHotChar((String)string), (String)"This is a label");
            jPanel.add(this.authorLabel);
            this.authorButton = NConeFactory.novellJButton((JButton)new JButton(TabbedPanel.this.ckApp.getIcon("globe1.gif")), (String)Loc.removeHotChar((String)Resource.getString("AuthorityKey")), (String)"This is a button");
            this.authorButton.setAlignmentY(0.5f);
            Misc.setAbsoluteSize((JComponent)this.authorButton, (Dimension)new Dimension(24, RB.BTN_HT));
            this.authorButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ FixLibPanel this$1;
                {
                    this.this$1 = fixLibPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.doNewAuthor();
                }
            });
            this.userTF = new GWTextField();
            NConeFactory.makeRelation((JLabel)this.authorLabel, (JTextField)this.userTF);
            this.userTF.setPreferredSize(new Dimension(200, RB.FLD_HT));
            if (!TabbedPanel.this.ckApp.isRunningStandalone()) {
                this.userTF.setEditable(false);
                jPanel.add(Misc.setHorizontalPair((JComponent)this.userTF, this.authorButton, 5));
            } else {
                this.userTF.setEditable(true);
                jPanel.add(Misc.setHorizontalPair((JComponent)this.userTF, this.authorButton, 5));
                this.authorButton.setEnabled(false);
                this.authorButton.setVisible(false);
            }
            this.add(jPanel);
            this.resetWordListsCB = Resource.getCheckBox("csResetWordLists");
            this.resetWordListsCB.addItemListener(this);
            this.add(this.resetWordListsCB);
            this.enableTextField(false);
        }

        public void doNewAuthor() {
            new ExcludeDialog(TabbedPanel.this.ckApp, TabbedPanel.this.cpanel, (JComponent)this.userTF, null);
        }

        public void initFromChkOpts(GlueObject glueObject) {
            Debug.trace((String)"TabbedPanel.FixLibPanel.initFromChkOpts");
            this.reassignOrphDocCB.setSelected(glueObject.getFLReassignOrphDocs());
            this.resetWordListsCB.setSelected(glueObject.getFLResetWordLists());
            String string = glueObject.getDocAuthor();
            if (string != null) {
                this.userTF.setText(string);
            }
        }

        public boolean OkayToProceed() {
            boolean bl = true;
            if (this.resetWordListsCB.isSelected()) {
                String string = Resource.getString("csResetWordListsWarning");
                String string2 = null;
                int n = MsgDisplayer.showYesNo((Component)TabbedPanel.this.ckApp.getParentFrame(), string2, (String)string, (boolean)TabbedPanel.this.ckApp.inConsoleOne());
                if (n == 0) {
                    bl = false;
                }
            }
            return bl;
        }

        public void commitToChkOpts(GlueObject glueObject) {
            Debug.trace((String)"TabbedPanel.FixLibPanel.commitToChkOpts");
            glueObject.setFLReassignOrphDocs(this.reassignOrphDocCB.isSelected());
            glueObject.setFLResetWordLists(this.resetWordListsCB.isSelected());
            String string = this.userTF.getText();
            if (string != null) {
                glueObject.setDocAuthor(string);
            }
        }

        public void enableTextField(boolean bl) {
            this.authorLabel.setEnabled(bl);
            if (!TabbedPanel.this.ckApp.isRunningStandalone()) {
                this.authorButton.setEnabled(bl);
            }
            this.userTF.setEnabled(bl);
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            Debug.trace((String)"FixLibPanel.itemStateChanged");
            JCheckBox jCheckBox = (JCheckBox)itemEvent.getSource();
            if (jCheckBox == this.reassignOrphDocCB) {
                this.enableTextField(jCheckBox.isSelected());
            }
            TabbedPanel.this.cpanel.getButtonPanel().enableRunButton(-1, "TabbedPanel.FixLibPanel.itemStateChanged");
        }
    }

    class NotifyPanel
    extends JPanel
    implements ItemListener {
        private JCheckBox beginCB = null;
        private JCheckBox failCB = null;
        private JCheckBox endCB = null;

        public NotifyPanel() {
            this.setLayout(new BoxLayout(this, this, 1){
                private final /* synthetic */ NotifyPanel this$1;
                {
                    this.this$1 = notifyPanel;
                }

                public float getLayoutAlignmentX(Container container) {
                    return 0.0f;
                }

                public float getLayoutAlignmentY(Container container) {
                    return 0.0f;
                }
            });
            this.setBorder(Misc.EMPTY_BORDER_10);
            this.beginCB = Resource.getCheckBox("csNotifyBegin");
            this.beginCB.addItemListener(this);
            this.add(this.beginCB);
            this.failCB = Resource.getCheckBox("csNotifyFail");
            this.failCB.addItemListener(this);
            this.add(this.failCB);
            this.endCB = Resource.getCheckBox("csNotifyEnd");
            this.endCB.addItemListener(this);
            this.add(this.endCB);
        }

        public void initData(GlueObject glueObject) {
            this.beginCB.setSelected(glueObject.getNotifyBegin());
            this.failCB.setSelected(glueObject.getNotifyFail());
            this.endCB.setSelected(glueObject.getNotifyEnd());
        }

        public void saveData(GlueObject glueObject) {
            glueObject.setNotifyBegin(this.beginCB.isSelected());
            glueObject.setNotifyFail(this.failCB.isSelected());
            glueObject.setNotifyEnd(this.endCB.isSelected());
        }

        public void itemStateChanged(ItemEvent itemEvent) {
        }
    }

    class IncludePanel
    extends JPanel
    implements ItemListener {
        private RVCheckBox inboxCB = null;
        private RVCheckBox outboxCB = null;
        private RVCheckBox calCB = null;
        private RVCheckBox onlyBackedupCB = null;
        private RVCheckBox onlyRetainedCB = null;

        IncludePanel() {
            String string = Resource.getString("csReceivedItems");
            this.inboxCB = new RVCheckBox(string);
            NConeFactory.novellJCheckBox((JCheckBox)this.inboxCB, (String)Loc.removeHotChar((String)string), (String)"");
            Loc.setText((AbstractButton)this.inboxCB, (String)string);
            this.inboxCB.addItemListener(this);
            string = Resource.getString("csSentItems");
            this.outboxCB = new RVCheckBox(string);
            NConeFactory.novellJCheckBox((JCheckBox)this.outboxCB, (String)Loc.removeHotChar((String)string), (String)"");
            Loc.setText((AbstractButton)this.outboxCB, (String)string);
            this.outboxCB.addItemListener(this);
            string = Resource.getString("csCalendarItems");
            this.calCB = new RVCheckBox(string);
            NConeFactory.novellJCheckBox((JCheckBox)this.calCB, (String)Loc.removeHotChar((String)string), (String)"");
            Loc.setText((AbstractButton)this.calCB, (String)string);
            string = Resource.getString("csOnlyBackedupItems");
            this.onlyBackedupCB = new RVCheckBox(string);
            NConeFactory.novellJCheckBox((JCheckBox)this.onlyBackedupCB, (String)Loc.removeHotChar((String)string), (String)"");
            Loc.setText((AbstractButton)this.onlyBackedupCB, (String)string);
            string = Resource.getString("csOnlyRetainedItems");
            this.onlyRetainedCB = new RVCheckBox(string);
            NConeFactory.novellJCheckBox((JCheckBox)this.onlyRetainedCB, (String)Loc.removeHotChar((String)string), (String)"");
            Loc.setText((AbstractButton)this.onlyRetainedCB, (String)string);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.add((Component)this.inboxCB, gridBagConstraints);
            this.add((Component)this.outboxCB, gridBagConstraints);
            this.add((Component)this.calCB, gridBagConstraints);
            this.add((Component)this.onlyBackedupCB, gridBagConstraints);
            this.add((Component)this.onlyRetainedCB, gridBagConstraints);
            this.inboxCB.setSelected(true);
            this.outboxCB.setSelected(true);
            this.calCB.setSelected(true);
            this.onlyBackedupCB.setSelected(false);
            this.onlyRetainedCB.setSelected(false);
            this.enablePanel(false);
            this.setBorder(new TitledBorder(Resource.getString("csInclude")));
        }

        public void initFromChkOpts(GlueObject glueObject, int n) {
            Debug.trace((String)"\n^^^^^^^ TabbedPanel.IncludePanel.initFromChkOpts");
            switch (n) {
                case 1: {
                    this.inboxCB.setSelected(glueObject.getIncExpInbox());
                    this.outboxCB.setSelected(glueObject.getIncExpOutbox());
                    this.checkEnable();
                    if (!this.inboxCB.isSelected() && !this.outboxCB.isSelected()) break;
                    this.calCB.setSelected(glueObject.getIncExpCal());
                    this.onlyBackedupCB.setSelected(glueObject.getIncExpOnlyBackedupItems());
                    this.onlyRetainedCB.setSelected(glueObject.getIncExpOnlyRetainedItems());
                    break;
                }
                case 2: {
                    this.inboxCB.setSelected(glueObject.getIncStatsInbox());
                    this.outboxCB.setSelected(glueObject.getIncStatsOutbox());
                    this.checkEnable();
                    if (!this.inboxCB.isSelected() && !this.outboxCB.isSelected()) break;
                    this.calCB.setSelected(glueObject.getIncStatsCal());
                    this.onlyBackedupCB.setSelected(glueObject.getIncStatsOnlyBackedupItems());
                    this.onlyRetainedCB.setSelected(glueObject.getIncStatsOnlyRetainedItems());
                }
            }
        }

        public void commitToChkOpts(GlueObject glueObject, int n) {
            Debug.trace((String)("TabbedPanel.IncludePanel.commitToChkOpts: index = " + n));
            switch (n) {
                case 1: {
                    glueObject.setIncExpInbox(this.inboxCB.isSelected());
                    glueObject.setIncExpOutbox(this.outboxCB.isSelected());
                    glueObject.setIncExpCal(this.calCB.isSelected());
                    glueObject.setIncExpOnlyBackedupItems(this.onlyBackedupCB.isSelected());
                    glueObject.setIncExpOnlyRetainedItems(this.onlyRetainedCB.isSelected());
                    break;
                }
                case 2: {
                    glueObject.setIncStatsInbox(this.inboxCB.isSelected());
                    glueObject.setIncStatsOutbox(this.outboxCB.isSelected());
                    glueObject.setIncStatsCal(this.calCB.isSelected());
                    glueObject.setIncStatsOnlyBackedupItems(this.onlyBackedupCB.isSelected());
                    glueObject.setIncStatsOnlyRetainedItems(this.onlyRetainedCB.isSelected());
                }
            }
        }

        public void enablePanel(boolean bl) {
            this.inboxCB.setEnabled(bl);
            this.outboxCB.setEnabled(bl);
            this.checkEnable();
        }

        private void checkEnable() {
            GWObjectsPanel gWObjectsPanel = TabbedPanel.this.cpanel.getLeftPanel();
            if (this.inboxCB.isSelected() && this.inboxCB.isEnabled() || this.outboxCB.isSelected() && this.outboxCB.isEnabled()) {
                this.calCB.setEnabled(true);
                if (gWObjectsPanel != null && gWObjectsPanel.IsInRemoteArchiveMode()) {
                    this.onlyBackedupCB.setEnabled(false);
                    this.onlyRetainedCB.setEnabled(false);
                } else {
                    this.onlyBackedupCB.setEnabled(true);
                    this.onlyRetainedCB.setEnabled(true);
                }
            } else {
                this.calCB.setEnabled(false);
                this.onlyBackedupCB.setEnabled(false);
                this.onlyRetainedCB.setEnabled(false);
            }
        }

        public boolean isValidSelection() {
            boolean bl = false;
            if (this.inboxCB.isSelected() && this.inboxCB.isEnabled() || this.outboxCB.isSelected() && this.outboxCB.isEnabled()) {
                bl = true;
            }
            return bl;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            RVCheckBox rVCheckBox = (RVCheckBox)itemEvent.getSource();
            if (rVCheckBox.isBusy) {
                return;
            }
            Debug.trace((String)"IncludePanel.itemStateChanged");
            if (rVCheckBox == this.inboxCB || rVCheckBox == this.outboxCB) {
                this.checkEnable();
            }
            TabbedPanel.this.cpanel.getButtonPanel().enableRunButton(-1, "IncludePanel.itemStateChanged");
        }
    }

    class MiscPanel
    extends JPanel {
        private EditField miscEF = null;

        public MiscPanel() {
            this.setLayout((LayoutManager)new VerticalFlowLayout(false, 0));
            this.setBorder(new EmptyBorder(20, 10, 10, 10));
            this.miscEF = new EditField("", false, false);
            JLabel jLabel = Resource.getLabel("csSupportOptions_", (Component)this.miscEF);
            String string = Resource.getString("csSupportOptions_");
            NConeFactory.novellJTextField((JTextField)this.miscEF, (String)Loc.removeHotChar((String)string), (String)"");
            this.add(jLabel);
            this.miscEF.setMaxLength(256);
            this.miscEF.setPreferredSize(new Dimension(300, RB.FLD_HT));
            this.add((Component)this.miscEF);
        }

        public void initData(GlueObject glueObject) {
            String string = glueObject.getOptConfig();
            if (string != null) {
                this.miscEF.setText(string);
            }
        }

        public void saveData(GlueObject glueObject) {
            glueObject.setOptConfig(this.miscEF.getText());
        }
    }

    class ResultsPanel
    extends JPanel {
        private JCheckBox individualUCB = null;
        private JCheckBox adminCB = null;
        private EditField ccListEF = null;
        private String msgText = null;

        public ResultsPanel() {
            JPanel jPanel = Misc.getPanel((LayoutManager)new VerticalFlowLayout(true, 5));
            String string = Loc.removeHotChar((String)Resource.getString("csSendResultsTo")) + " ";
            String string2 = Resource.getString("csAdministrator");
            this.adminCB = NConeFactory.novellJCheckBox((JCheckBox)new JCheckBox(), (String)(string + Loc.removeHotChar((String)string2)), (String)"This is a check box");
            Loc.setText((AbstractButton)this.adminCB, (String)string2);
            string2 = Resource.getString("csIndividualUsers");
            this.individualUCB = NConeFactory.novellJCheckBox((JCheckBox)new JCheckBox(), (String)(string + Loc.removeHotChar((String)string2)), (String)"This is a check box");
            Loc.setText((AbstractButton)this.individualUCB, (String)string2);
            JLabel jLabel = Resource.getLabel("csSendResultsTo");
            JPanel jPanel2 = Misc.getHorizontalLayoutPanel();
            jPanel2.add(jLabel);
            jPanel2.add(Misc.getBoxHorizontalSpacing((int)10));
            jPanel2.add(this.adminCB);
            jPanel2.add(Misc.getBoxHorizontalSpacing((int)10));
            jPanel2.add(this.individualUCB);
            jPanel.add(jPanel2);
            jLabel = Resource.getLabel("csCC_");
            this.ccListEF = new EditField("", false, false);
            this.ccListEF.setMaxLength(256);
            jPanel2 = Misc.setHorizontalPair(jLabel, (JComponent)this.ccListEF, 5);
            NConeFactory.makeRelation((JLabel)jLabel, (JTextField)this.ccListEF);
            jPanel2.setBorder(new EmptyBorder(0, 0, 5, 0));
            jPanel.add(jPanel2);
            JButton jButton = Resource.getButton("MessageKey");
            jButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ ResultsPanel this$1;
                {
                    this.this$1 = resultsPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ResultsPanel.access$800(this.this$1);
                }
            });
            jPanel2 = Misc.setHorizontalPair(new JLabel(""), jButton, 0);
            jPanel.add(jPanel2);
            this.setLayout(new GridLayout(1, 1));
            this.setBorder(new EmptyBorder(0, 10, 0, 10));
            this.add(jPanel);
        }

        public void initData(GlueObject glueObject) {
            this.individualUCB.setSelected(glueObject.getRTIndividualUsers());
            this.adminCB.setSelected(glueObject.getRTAdmin());
            String string = glueObject.getRTCCList();
            if (string != null) {
                this.ccListEF.setText(string);
            }
            this.msgText = glueObject.getRTMessage();
        }

        public void saveData(GlueObject glueObject) {
            glueObject.setRTAdmin(this.adminCB.isSelected());
            glueObject.setRTIndividualUsers(this.individualUCB.isSelected());
            String string = this.ccListEF.getText();
            if (string != null && string.length() > 0) {
                glueObject.setRTCCList(string);
            }
            if (msgDlg != null) {
                glueObject.setRTMessage(msgDlg.getText());
            }
        }

        private void doMessage() {
            String string;
            if (msgDlg == null) {
                if (TabbedPanel.this.ckApp.getDialog() instanceof JFrame) {
                    msgDlg = new EnterTextDialog((Frame)TabbedPanel.this.ckApp.getDialog(), Resource.getString("csEnterMessageToSend"), 1024, this.msgText);
                } else {
                    msgDlg = new EnterTextDialog((JDialog)TabbedPanel.this.ckApp.getDialog(), Resource.getString("csEnterMessageToSend"), 1024, this.msgText);
                }
                string = this.msgText;
            } else {
                string = msgDlg.getText();
            }
            int n = msgDlg.showWithResult();
            if (n == 0) {
                msgDlg.setText(string);
            }
        }

        static /* synthetic */ void access$800(ResultsPanel resultsPanel) {
            resultsPanel.doMessage();
        }
    }

    class LoggingPanel
    extends JPanel {
        private JCheckBox verboseCB = null;
        private EditField logfileEF = null;

        public LoggingPanel() {
            this.setLayout(new GridBagLayout());
            this.setBorder(Misc.EMPTY_BORDER_10);
            String string = Resource.getStringWithColon("csLogFile");
            JLabel jLabel = NConeFactory.novellJLabel((JLabel)new JLabel(string), (String)Loc.removeHotChar((String)string), (String)"This is a label");
            this.logfileEF = new EditField("gwchk32.log", false, false);
            this.logfileEF.setMaxLength(12);
            this.logfileEF.setColumns(12);
            this.logfileEF.setMaximumSize(new Dimension(100, RB.FLD_HT));
            NConeFactory.makeRelation((JLabel)jLabel, (JTextField)this.logfileEF);
            JPanel jPanel = Misc.getPanel(null);
            jPanel.setLayout(new BoxLayout(this, jPanel, 0){
                private final /* synthetic */ LoggingPanel this$1;
                {
                    this.this$1 = loggingPanel;
                }

                public float getLayoutAlignmentX(Container container) {
                    return 0.0f;
                }

                public float getLayoutAlignmentY(Container container) {
                    return 0.5f;
                }
            });
            jPanel.add(jLabel);
            jPanel.add(Box.createHorizontalStrut(5));
            jPanel.add((Component)this.logfileEF);
            jPanel.setBorder(new EmptyBorder(0, 0, 5, 0));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)jPanel, gridBagConstraints);
            string = Resource.getString("csVerboseLogging");
            this.verboseCB = NConeFactory.novellJCheckBox((JCheckBox)new JCheckBox(), (String)Loc.removeHotChar((String)string), (String)"This is a check box");
            Loc.setText((AbstractButton)this.verboseCB, (String)string);
            this.verboseCB.setMargin(new Insets(0, 0, 0, 0));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weighty = 1.0;
            this.add((Component)this.verboseCB, gridBagConstraints);
        }

        public void initData(GlueObject glueObject) {
            this.logfileEF.setText(glueObject.getLogFilename());
            this.verboseCB.setSelected(glueObject.getVerbose());
        }

        public void saveData(GlueObject glueObject) {
            String string = this.logfileEF.getText();
            if (string == null || string.equals("")) {
                string = "";
            } else {
                String string2 = null;
                int n = string.indexOf(46);
                if (n == -1) {
                    if (string.length() > 8) {
                        String string3 = string.substring(0, 8);
                        string2 = string3 + ".log";
                    }
                } else {
                    String string4 = n > 8 ? string.substring(0, 8) : string.substring(0, n);
                    String string5 = string.substring(n + 1);
                    if (string5.length() > 3) {
                        string5 = string5.substring(0, 3);
                    }
                    string2 = string4 + "." + string5;
                }
                if (Debug.trace) {
                    Debug.trace((String)("\nold= [" + string + "], new= [" + string2 + "]\n"));
                }
                if (string2 != null && !string2.equals(string)) {
                    string = string2;
                    MsgDisplayer.showInfo((Component)TabbedPanel.this.ckApp.getParentFrame(), (String)Resource.putStringInFormat("csLogFileChangedMsg", string), (boolean)TabbedPanel.this.ckApp.inConsoleOne());
                }
            }
            if (Debug.trace) {
                Debug.trace((String)("*** LoggingPanel.saveData setting logfile to [" + string + "]"));
            }
            glueObject.setLogFileName(string);
            glueObject.setVerbose(this.verboseCB.isSelected());
        }
    }

    class DatabasesPanel
    extends JPanel
    implements ItemListener {
        private boolean userSelected = false;
        private boolean msgSelected = false;
        private boolean docSelected = false;
        private JCheckBox userCB = null;
        private JCheckBox msgCB = null;
        private JCheckBox docCB = null;

        public DatabasesPanel() {
            this.setLayout(new BoxLayout(this, this, 1){
                private final /* synthetic */ DatabasesPanel this$1;
                {
                    this.this$1 = databasesPanel;
                }

                public float getLayoutAlignmentX(Container container) {
                    return 0.0f;
                }

                public float getLayoutAlignmentY(Container container) {
                    return 0.0f;
                }
            });
            this.setBorder(Misc.EMPTY_BORDER_10);
            String string = Resource.getString("csUser");
            this.userCB = NConeFactory.novellJCheckBox((JCheckBox)new JCheckBox(), (String)Loc.removeHotChar((String)string), (String)"This is a check box");
            Loc.setText((AbstractButton)this.userCB, (String)string);
            this.userCB.addItemListener(this);
            this.add(this.userCB);
            string = Resource.getString("csMessage");
            this.msgCB = NConeFactory.novellJCheckBox((JCheckBox)new JCheckBox(), (String)Loc.removeHotChar((String)string), (String)"This is a check box");
            Loc.setText((AbstractButton)this.msgCB, (String)string);
            this.msgCB.addItemListener(this);
            this.add(this.msgCB);
            string = Resource.getString("csDocument");
            this.docCB = NConeFactory.novellJCheckBox((JCheckBox)new JCheckBox(), (String)Loc.removeHotChar((String)string), (String)"This is a check box");
            Loc.setText((AbstractButton)this.docCB, (String)string);
            this.docCB.addItemListener(this);
            this.add(this.docCB);
        }

        public void selectDBPanel(boolean bl, boolean bl2, boolean bl3) {
            this.userCB.setSelected(bl);
            this.msgCB.setSelected(bl2);
            this.docCB.setSelected(bl3);
        }

        public void enableDBPanel(boolean bl, boolean bl2, boolean bl3) {
            this.userCB.setEnabled(bl);
            this.msgCB.setEnabled(bl2);
            this.docCB.setEnabled(bl3);
        }

        public void initData(GlueObject glueObject) {
            this.userSelected = glueObject.getUserDB();
            this.msgSelected = glueObject.getMsgDB();
            this.docSelected = glueObject.getDocDB();
            this.userCB.setSelected(this.userSelected);
            this.msgCB.setSelected(this.msgSelected);
            this.docCB.setSelected(this.docSelected);
        }

        public void saveData(GlueObject glueObject) {
            int n = TabbedPanel.this.cpanel.getActionPanel().getCurrentActionIndex();
            if (n == 16) {
                glueObject.setMsgDB(false);
                glueObject.setDocDB(false);
                glueObject.setUserDB(true);
            } else {
                glueObject.setUserDB(this.userCB.isSelected());
                glueObject.setMsgDB(this.msgCB.isSelected());
                glueObject.setDocDB(this.docCB.isSelected());
            }
        }

        public void resetDBCheckboxes() {
            if (this.userCB.isEnabled()) {
                this.userSelected = this.userCB.isSelected();
            } else {
                this.userCB.setSelected(this.userSelected);
            }
            if (this.msgCB.isEnabled()) {
                this.msgSelected = this.msgCB.isSelected();
            } else {
                this.msgCB.setSelected(this.msgSelected);
            }
            if (this.docCB.isEnabled()) {
                this.docSelected = this.docCB.isSelected();
            } else {
                this.docCB.setSelected(this.docSelected);
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            Debug.trace((String)"DatabasesPanel.itemStateChanged");
            JCheckBox jCheckBox = (JCheckBox)itemEvent.getSource();
            int n = -1;
            ActionPanel actionPanel = TabbedPanel.this.cpanel.getActionPanel();
            if (actionPanel != null) {
                n = actionPanel.getCurrentActionIndex();
            }
            if (jCheckBox == this.userCB) {
                TabbedPanel.this.enableIndividualUCB(n);
            }
            TabbedPanel.this.cpanel.getButtonPanel().enableRunButton(n, "DatabasesPanel.itemStateChanged");
        }
    }
}

