/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl;

import com.objectspace.jgl.Container;
import com.objectspace.jgl.Deque;
import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InputIterator;
import com.objectspace.jgl.Opaque;
import com.objectspace.jgl.RandomAccessIterator;
import java.io.Serializable;
import java.util.NoSuchElementException;

public final class DequeIterator
implements RandomAccessIterator,
Serializable,
Opaque {
    Deque myDeque;
    int myBlockIndex;
    int myMapIndex;
    static final long serialVersionUID = 8197515993982694406L;

    public DequeIterator() {
    }

    public DequeIterator(DequeIterator dequeIterator) {
        this.myDeque = dequeIterator.myDeque;
        this.myMapIndex = dequeIterator.myMapIndex;
        this.myBlockIndex = dequeIterator.myBlockIndex;
    }

    DequeIterator(Deque deque, int n, int n2) {
        this.myDeque = deque;
        this.myBlockIndex = n;
        this.myMapIndex = n2;
    }

    public Object clone() {
        return new DequeIterator(this);
    }

    public boolean atBegin() {
        return this.equals(this.myDeque.myStart);
    }

    public boolean atEnd() {
        return this.equals(this.myDeque.myFinish);
    }

    public boolean hasMoreElements() {
        return !this.equals(this.myDeque.myFinish);
    }

    public void advance() {
        if (++this.myBlockIndex == 128) {
            ++this.myMapIndex;
            this.myBlockIndex = 0;
        }
    }

    public void advance(int n) {
        this.myBlockIndex += n;
        if (this.myBlockIndex >= 128) {
            int n2 = this.myBlockIndex / 128;
            this.myMapIndex += n2;
            this.myBlockIndex %= 128;
            return;
        }
        if (this.myBlockIndex < 0) {
            int n3 = (127 - this.myBlockIndex) / 128;
            this.myMapIndex -= n3;
            this.myBlockIndex += n3 * 128;
        }
    }

    public void retreat() {
        if (--this.myBlockIndex == -1) {
            --this.myMapIndex;
            this.myBlockIndex = 127;
        }
    }

    public void retreat(int n) {
        this.advance(-n);
    }

    public Object nextElement() {
        try {
            Object object = this.myDeque.myMap[this.myMapIndex][this.myBlockIndex];
            if (++this.myBlockIndex == 128) {
                ++this.myMapIndex;
                this.myBlockIndex = 0;
            }
            return object;
        }
        catch (NullPointerException nullPointerException) {
            throw new NoSuchElementException("DequeIterator");
        }
    }

    DequeIterator copy(int n) {
        DequeIterator dequeIterator = new DequeIterator(this);
        dequeIterator.advance(n);
        return dequeIterator;
    }

    public int distance(ForwardIterator forwardIterator) {
        dequeinfo dequeinfo2 = (dequeinfo)((Opaque)((Object)forwardIterator)).opaqueData();
        int n = dequeinfo2.block - this.myBlockIndex;
        if (this.myMapIndex == dequeinfo2.map) {
            return n;
        }
        return 128 * (dequeinfo2.map - this.myMapIndex) + n;
    }

    public int index() {
        return this.myDeque.myStart.distance(this);
    }

    public Object get() {
        return this.myDeque.myMap[this.myMapIndex][this.myBlockIndex];
    }

    public void put(Object object) {
        this.myDeque.myMap[this.myMapIndex][this.myBlockIndex] = object;
    }

    public Object get(int n) {
        int n2 = this.myMapIndex;
        int n3 = this.myBlockIndex;
        this.advance(n);
        Object object = this.myDeque.myMap[this.myMapIndex][this.myBlockIndex];
        this.myMapIndex = n2;
        this.myBlockIndex = n3;
        return object;
    }

    public void put(int n, Object object) {
        int n2 = this.myMapIndex;
        int n3 = this.myBlockIndex;
        this.advance(n);
        this.myDeque.myMap[this.myMapIndex][this.myBlockIndex] = object;
        this.myMapIndex = n2;
        this.myBlockIndex = n3;
    }

    public boolean equals(Object object) {
        if (object instanceof Opaque) {
            InputIterator inputIterator;
            dequeinfo dequeinfo2 = (dequeinfo)((Opaque)object).opaqueData();
            return this.myMapIndex == dequeinfo2.map && this.myBlockIndex == dequeinfo2.block && (inputIterator = (InputIterator)object) instanceof Opaque && (System.identityHashCode(this.myDeque) == ((Opaque)((Object)inputIterator)).opaqueId() || false);
        }
        return false;
    }

    public boolean less(RandomAccessIterator randomAccessIterator) {
        dequeinfo dequeinfo2 = (dequeinfo)((Opaque)((Object)randomAccessIterator)).opaqueData();
        return this.myMapIndex < dequeinfo2.map || this.myMapIndex == dequeinfo2.map && this.myBlockIndex < dequeinfo2.block;
    }

    public Container getContainer() {
        return this.myDeque;
    }

    public boolean isCompatibleWith(InputIterator inputIterator) {
        return inputIterator instanceof Opaque && System.identityHashCode(this.myDeque) == ((Opaque)((Object)inputIterator)).opaqueId();
    }

    public Object opaqueData() {
        return new dequeinfo(this.myBlockIndex, this.myMapIndex);
    }

    public int opaqueId() {
        return System.identityHashCode(this.myDeque);
    }

    private static class dequeinfo
    implements Serializable {
        public int block;
        public int map;

        public dequeinfo(int n, int n2) {
            this.block = n;
            this.map = n2;
        }
    }
}

