/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.adapters;

import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InvalidOperationException;
import com.objectspace.jgl.Sequence;
import com.objectspace.jgl.adapters.Algorithms;
import com.objectspace.jgl.adapters.ArrayAdapter;
import com.objectspace.jgl.adapters.FloatArray;
import com.objectspace.jgl.adapters.FloatIterator;
import java.io.Serializable;
import java.util.Enumeration;

public class FloatBuffer
implements Sequence {
    static final float defaultValue = 0.0f;
    float[] storage;
    int length;
    static final long serialVersionUID = -8621530464035268438L;

    public FloatBuffer() {
        this.clear();
    }

    public FloatBuffer(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Attempt to create an FloatBuffer with a negative size");
        }
        this.length = n;
        this.storage = new float[this.length];
    }

    public FloatBuffer(int n, float f) {
        this(n);
        int n2 = 0;
        while (n2 < this.length) {
            this.storage[n2] = f;
            ++n2;
        }
    }

    public FloatBuffer(float[] fArray) {
        this(fArray, true);
    }

    FloatBuffer(float[] fArray, boolean bl) {
        float[] fArray2 = fArray;
        synchronized (fArray2) {
            this.length = fArray.length;
            if (bl) {
                this.storage = new float[this.length];
                System.arraycopy(fArray, 0, this.storage, 0, this.length);
            } else {
                this.storage = fArray;
            }
            return;
        }
    }

    public FloatBuffer(FloatBuffer floatBuffer) {
        this(floatBuffer.storage);
    }

    public synchronized Object clone() {
        return new FloatBuffer(this);
    }

    public boolean equals(Object object) {
        return object instanceof FloatBuffer && this.equals((FloatBuffer)object) || object instanceof FloatArray && this.equals((FloatArray)object);
    }

    public boolean equals(FloatBuffer floatBuffer) {
        return this.equals(new FloatArray(floatBuffer.storage));
    }

    public synchronized boolean equals(FloatArray floatArray) {
        return floatArray.equals(this.storage);
    }

    public boolean equals(float[] fArray) {
        return this.equals(new FloatArray(fArray));
    }

    public synchronized String toString() {
        return Algorithms.Printing.toString(this, "FloatBuffer");
    }

    public synchronized void copy(FloatBuffer floatBuffer) {
        if (this == floatBuffer) {
            return;
        }
        FloatBuffer floatBuffer2 = floatBuffer;
        synchronized (floatBuffer2) {
            if (floatBuffer.length > this.storage.length) {
                this.storage = floatBuffer.get();
            } else {
                System.arraycopy(floatBuffer.storage, 0, this.storage, 0, floatBuffer.length);
                int n = floatBuffer.length;
                while (n < this.length) {
                    this.storage[n] = 0.0f;
                    ++n;
                }
            }
            this.length = floatBuffer.length;
            return;
        }
    }

    public synchronized void copyTo(float[] fArray) {
        float[] fArray2 = fArray;
        synchronized (fArray2) {
            System.arraycopy(this.storage, 0, fArray, 0, Math.min(this.length, fArray.length));
            return;
        }
    }

    public synchronized float[] get() {
        float[] fArray = new float[this.length];
        this.copyTo(fArray);
        return fArray;
    }

    public synchronized int hashCode() {
        return Algorithms.Hashing.orderedHash(this.begin(), this.length);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Object back() {
        return this.at(this.size() - 1);
    }

    public Object front() {
        return this.at(0);
    }

    public int size() {
        return this.length;
    }

    public int capacity() {
        return this.storage.length;
    }

    public int maxSize() {
        return Integer.MAX_VALUE;
    }

    public Object at(int n) {
        return new Float(this.floatAt(n));
    }

    public synchronized float floatAt(int n) {
        ArrayAdapter.checkIndex(n, this.length);
        return this.storage[n];
    }

    public synchronized void put(int n, Object object) {
        this.put(n, ((Number)object).floatValue());
    }

    public synchronized void put(int n, float f) {
        ArrayAdapter.checkIndex(n, this.length);
        this.storage[n] = f;
    }

    public synchronized void clear() {
        this.storage = new float[10];
        this.length = 0;
    }

    public Object remove(Enumeration enumeration) {
        if (!(enumeration instanceof FloatIterator)) {
            throw new IllegalArgumentException("Enumeration not an FloatIterator");
        }
        if (((FloatIterator)enumeration).buffer != this.storage) {
            throw new IllegalArgumentException("Enumeration not for this FloatBuffer ");
        }
        Serializable serializable = (FloatIterator)enumeration;
        serializable = new Float(serializable.buffer[serializable.index]);
        this.remove(((FloatIterator)enumeration).index);
        return serializable;
    }

    public synchronized Object remove(int n) {
        ArrayAdapter.checkIndex(n, this.length);
        Float f = new Float(this.storage[n]);
        System.arraycopy(this.storage, n + 1, this.storage, n, this.length - n - 1);
        this.storage[--this.length] = 0.0f;
        return f;
    }

    public int remove(Enumeration enumeration, Enumeration enumeration2) {
        block5: {
            block4: {
                if (!(enumeration instanceof FloatIterator) || !(enumeration2 instanceof FloatIterator)) {
                    throw new IllegalArgumentException("Enumeration not an FloatIterator");
                }
                if (((FloatIterator)enumeration).buffer != this.storage) break block4;
                FloatIterator floatIterator = (FloatIterator)enumeration;
                FloatIterator floatIterator2 = (FloatIterator)enumeration2;
                if (!(floatIterator2 instanceof FloatIterator) || floatIterator.buffer != floatIterator2.buffer && !false) break block5;
            }
            throw new IllegalArgumentException("Enumeration not compatible");
        }
        return this.remove(((FloatIterator)enumeration).index, ((FloatIterator)enumeration2).index - 1);
    }

    public synchronized int remove(int n, int n2) {
        if (n2 < n) {
            return 0;
        }
        int n3 = this.length;
        ArrayAdapter.checkIndex(n, n3);
        ArrayAdapter.checkIndex(n2, n3);
        n3 = n2 - n + 1;
        System.arraycopy(this.storage, n2 + 1, this.storage, n, this.length - n2 - 1);
        int n4 = this.length - n3;
        while (n4 < this.length) {
            this.storage[n4] = 0.0f;
            ++n4;
        }
        this.length -= n3;
        return n3;
    }

    public synchronized Object popBack() {
        if (this.length == 0) {
            throw new InvalidOperationException("FloatBuffer is empty");
        }
        Float f = new Float(this.storage[--this.length]);
        this.storage[this.length] = 0.0f;
        return f;
    }

    public synchronized Object add(Object object) {
        this.add(((Number)object).floatValue());
        return null;
    }

    public synchronized void add(float f) {
        if (this.length == this.storage.length) {
            float[] fArray = this.getNextStorage(1);
            this.copyTo(fArray);
            this.storage = fArray;
        }
        this.storage[this.length++] = f;
    }

    public void pushBack(Object object) {
        this.add(((Number)object).floatValue());
    }

    public void pushBack(float f) {
        this.add(f);
    }

    public FloatIterator insert(FloatIterator floatIterator, Object object) {
        return this.insert(floatIterator, ((Number)object).floatValue());
    }

    public FloatIterator insert(FloatIterator floatIterator, float f) {
        this.insert(floatIterator.index, f);
        return new FloatIterator(this, floatIterator.index);
    }

    public void insert(int n, Object object) {
        this.insert(n, ((Number)object).floatValue());
    }

    public synchronized void insert(int n, float f) {
        ArrayAdapter.checkIndex(n, this.length + 1);
        if (this.length != this.storage.length) {
            if (n != this.length) {
                System.arraycopy(this.storage, n, this.storage, n + 1, this.length - n);
            }
        } else {
            float[] fArray = this.getNextStorage(1);
            System.arraycopy(this.storage, 0, fArray, 0, n);
            System.arraycopy(this.storage, n, fArray, n + 1, this.length - n);
            this.storage = fArray;
        }
        this.storage[n] = f;
        ++this.length;
    }

    public void insert(FloatIterator floatIterator, int n, Object object) {
        this.insert(floatIterator, n, ((Number)object).floatValue());
    }

    public void insert(FloatIterator floatIterator, int n, float f) {
        this.insert(floatIterator.index, n, f);
    }

    public void insert(int n, int n2, Object object) {
        this.insert(n, n2, ((Number)object).floatValue());
    }

    public synchronized void insert(int n, int n2, float f) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Attempt to insert a negative number of objects.");
        }
        if (n2 == 0) {
            return;
        }
        ArrayAdapter.checkIndex(n, this.length + 1);
        if (this.storage.length - this.length >= n2) {
            System.arraycopy(this.storage, n, this.storage, n + n2, this.length - n);
        } else {
            float[] fArray = this.getNextStorage(n2);
            System.arraycopy(this.storage, 0, fArray, 0, n);
            System.arraycopy(this.storage, n, fArray, n + n2, this.length - n);
            this.storage = fArray;
        }
        int n3 = n;
        while (n3 < n + n2) {
            this.storage[n3] = f;
            ++n3;
        }
        this.length += n2;
    }

    public void insert(FloatIterator floatIterator, ForwardIterator forwardIterator, ForwardIterator forwardIterator2) {
        this.insert(floatIterator.index, forwardIterator, forwardIterator2);
    }

    public synchronized void insert(int n, ForwardIterator forwardIterator, ForwardIterator forwardIterator2) {
        int n2 = forwardIterator.distance(forwardIterator2);
        if (n2 == 0) {
            return;
        }
        ForwardIterator forwardIterator3 = (ForwardIterator)forwardIterator.clone();
        if (this.storage.length - this.length >= n2) {
            System.arraycopy(this.storage, n, this.storage, n + n2, this.length - n);
        } else {
            float[] fArray = this.getNextStorage(n2);
            System.arraycopy(this.storage, 0, fArray, 0, n);
            System.arraycopy(this.storage, n, fArray, n + n2, this.length - n);
            this.storage = fArray;
        }
        this.length += n2;
        int n3 = n;
        while (n3 < n + n2) {
            this.put(n3, forwardIterator3.nextElement());
            ++n3;
        }
    }

    public synchronized void swap(FloatBuffer floatBuffer) {
        FloatBuffer floatBuffer2 = floatBuffer;
        synchronized (floatBuffer2) {
            int n = this.length;
            float[] fArray = this.storage;
            this.length = floatBuffer.length;
            this.storage = floatBuffer.storage;
            floatBuffer.length = n;
            floatBuffer.storage = fArray;
            return;
        }
    }

    public Enumeration elements() {
        return this.begin();
    }

    public ForwardIterator start() {
        return this.begin();
    }

    public ForwardIterator finish() {
        return this.end();
    }

    public synchronized FloatIterator begin() {
        return new FloatIterator(this, 0);
    }

    public synchronized FloatIterator end() {
        return new FloatIterator(this, this.length);
    }

    public synchronized void trimToSize() {
        if (this.length < this.storage.length) {
            this.storage = this.get();
        }
    }

    public synchronized void ensureCapacity(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Attempt to reserve a negative size.");
        }
        if (this.storage.length < n) {
            float[] fArray = new float[n];
            if (this.length > 0) {
                System.arraycopy(this.storage, 0, fArray, 0, this.length);
            }
            this.storage = fArray;
        }
    }

    public synchronized Object popFront() {
        if (this.length == 0) {
            throw new InvalidOperationException("FloatBuffer is empty");
        }
        Float f = new Float(this.storage[0]);
        this.remove(0);
        return f;
    }

    public void pushFront(Object object) {
        this.insert(0, object);
    }

    public void pushFront(float f) {
        this.insert(0, f);
    }

    public int remove(Object object) {
        return this.remove(object, this.length);
    }

    public synchronized int remove(Object object, int n) {
        float f = ((Number)object).floatValue();
        int n2 = 0;
        while (n > 0) {
            int n3 = this.indexOf(f);
            if (n3 < 0) break;
            --n;
            ++n2;
            this.remove(n3);
        }
        return n2;
    }

    public synchronized int remove(int n, int n2, Object object) {
        ((Number)object).floatValue();
        if (n2 < n) {
            return 0;
        }
        int n3 = this.length;
        ArrayAdapter.checkIndex(n, n3);
        ArrayAdapter.checkIndex(n2, n3);
        FloatIterator floatIterator = new FloatIterator(this, n);
        FloatIterator floatIterator2 = new FloatIterator(this, n2 + 1);
        FloatIterator floatIterator3 = (FloatIterator)Algorithms.Removing.remove(floatIterator, floatIterator2, object);
        return this.remove(floatIterator3.index, n2);
    }

    public int replace(Object object, Object object2) {
        return this.replace(((Number)object).floatValue(), ((Number)object2).floatValue());
    }

    public int replace(float f, float f2) {
        return this.replace(0, this.length - 1, f, f2);
    }

    public int replace(int n, int n2, Object object, Object object2) {
        return this.replace(n, n2, ((Number)object).floatValue(), ((Number)object2).floatValue());
    }

    public synchronized int replace(int n, int n2, float f, float f2) {
        int n3 = this.length;
        ArrayAdapter.checkIndex(n, n3);
        ArrayAdapter.checkIndex(n2, n3);
        n3 = 0;
        while (n < n2) {
            if (this.storage[n] == f) {
                this.storage[n] = f2;
                ++n3;
            }
            ++n;
        }
        return n3;
    }

    public int count(Object object) {
        return this.count(((Number)object).floatValue());
    }

    public int count(float f) {
        return this.count(0, this.length - 1, f);
    }

    public int count(int n, int n2, Object object) {
        return this.count(n, n2, ((Number)object).floatValue());
    }

    public synchronized int count(int n, int n2, float f) {
        int n3 = this.length;
        ArrayAdapter.checkIndex(n, n3);
        ArrayAdapter.checkIndex(n2, n3);
        n3 = 0;
        while (n < n2) {
            if (this.storage[n] == f) {
                ++n3;
            }
            ++n;
        }
        return n3;
    }

    public int indexOf(Object object) {
        return this.indexOf(((Number)object).floatValue());
    }

    public int indexOf(float f) {
        return this.indexOf(0, this.length - 1, f);
    }

    public int indexOf(int n, int n2, Object object) {
        return this.indexOf(n, n2, ((Number)object).floatValue());
    }

    public synchronized int indexOf(int n, int n2, float f) {
        if (n2 < n) {
            return -1;
        }
        int n3 = this.length;
        ArrayAdapter.checkIndex(n, n3);
        ArrayAdapter.checkIndex(n2, n3);
        while (n < n2) {
            if (this.storage[n] == f) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public synchronized void setSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Attempt to become a negative size.");
        }
        if (this.length > n) {
            this.remove(n, this.length - 1);
            return;
        }
        if (this.length < n) {
            this.insert(this.length, n - this.length, 0.0f);
        }
    }

    public boolean contains(Object object) {
        return this.contains(((Number)object).floatValue());
    }

    public boolean contains(float f) {
        return this.indexOf(f) != -1;
    }

    private float[] getNextStorage(int n) {
        int n2 = Math.max(ArrayAdapter.getNextSize(this.length), this.length + n);
        float[] fArray = new float[n2];
        return fArray;
    }

    static float asFloat(Object object) {
        return ((Number)object).floatValue();
    }
}

