/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.algorithms;

import com.objectspace.jgl.Container;
import com.objectspace.jgl.ForwardIterator;

public final class Hashing {
    static final int HASH_SIZE = 16;

    private Hashing() {
    }

    public static int orderedHash(Container container) {
        return Hashing.orderedHash(container.start(), container.finish());
    }

    public static int orderedHash(ForwardIterator forwardIterator, ForwardIterator forwardIterator2) {
        if (!forwardIterator.isCompatibleWith(forwardIterator2)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        int n = 0;
        int n2 = forwardIterator.distance(forwardIterator2);
        int n3 = 0;
        int n4 = 1;
        if (n2 >= 16) {
            n4 = n2 / 16;
            forwardIterator.advance(n2 % 16);
        }
        ForwardIterator forwardIterator3 = (ForwardIterator)forwardIterator.clone();
        while (!forwardIterator3.equals(forwardIterator2)) {
            Object object = forwardIterator3.get();
            if (object != null) {
                n ^= object.hashCode() / (n3 % 16 + 1);
            }
            ++n3;
            forwardIterator3.advance(n4);
        }
        return n;
    }

    public static int unorderedHash(Container container) {
        return Hashing.unorderedHash(container.start(), container.finish());
    }

    public static int unorderedHash(ForwardIterator forwardIterator, ForwardIterator forwardIterator2) {
        if (!forwardIterator.isCompatibleWith(forwardIterator2)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        int n = 0;
        ForwardIterator forwardIterator3 = (ForwardIterator)forwardIterator.clone();
        while (!forwardIterator3.equals(forwardIterator2)) {
            Object object = forwardIterator3.get();
            if (object != null) {
                n ^= object.hashCode();
            }
            forwardIterator3.advance();
        }
        return n;
    }
}

