/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.algorithms;

import com.objectspace.jgl.Container;
import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InputIterator;
import com.objectspace.jgl.OutputIterator;
import com.objectspace.jgl.UnaryPredicate;
import com.objectspace.jgl.util.InsertIterator;

public final class Replacing {
    private Replacing() {
    }

    public static int replace(ForwardIterator forwardIterator, ForwardIterator forwardIterator2, Object object, Object object2) {
        if (!forwardIterator.isCompatibleWith(forwardIterator2)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        ForwardIterator forwardIterator3 = (ForwardIterator)forwardIterator.clone();
        int n = 0;
        while (!forwardIterator3.equals(forwardIterator2)) {
            if (forwardIterator3.get().equals(object)) {
                forwardIterator3.put(object2);
                ++n;
            }
            forwardIterator3.advance();
        }
        return n;
    }

    public static int replace(Container container, Object object, Object object2) {
        return Replacing.replace(container.start(), container.finish(), object, object2);
    }

    public static int replaceIf(ForwardIterator forwardIterator, ForwardIterator forwardIterator2, UnaryPredicate unaryPredicate, Object object) {
        if (!forwardIterator.isCompatibleWith(forwardIterator2)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        ForwardIterator forwardIterator3 = (ForwardIterator)forwardIterator.clone();
        int n = 0;
        while (!forwardIterator3.equals(forwardIterator2)) {
            if (unaryPredicate.execute(forwardIterator3.get())) {
                forwardIterator3.put(object);
                ++n;
            }
            forwardIterator3.advance();
        }
        return n;
    }

    public static int replaceIf(Container container, UnaryPredicate unaryPredicate, Object object) {
        return Replacing.replaceIf(container.start(), container.finish(), unaryPredicate, object);
    }

    public static OutputIterator replaceCopy(InputIterator inputIterator, InputIterator inputIterator2, OutputIterator outputIterator, Object object, Object object2) {
        if (!inputIterator.isCompatibleWith(inputIterator2)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        InputIterator inputIterator3 = (InputIterator)inputIterator.clone();
        OutputIterator outputIterator2 = (OutputIterator)outputIterator.clone();
        while (!inputIterator3.equals(inputIterator2)) {
            outputIterator2.put(inputIterator3.get().equals(object) ? object2 : inputIterator3.get());
            outputIterator2.advance();
            inputIterator3.advance();
        }
        return outputIterator2;
    }

    public static OutputIterator replaceCopy(Container container, OutputIterator outputIterator, Object object, Object object2) {
        return Replacing.replaceCopy(container.start(), container.finish(), outputIterator, object, object2);
    }

    public static void replaceCopy(Container container, Container container2, Object object, Object object2) {
        Replacing.replaceCopy(container.start(), container.finish(), new InsertIterator(container2), object, object2);
    }

    public static OutputIterator replaceCopyIf(InputIterator inputIterator, InputIterator inputIterator2, OutputIterator outputIterator, UnaryPredicate unaryPredicate, Object object) {
        if (!inputIterator.isCompatibleWith(inputIterator2)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        InputIterator inputIterator3 = (InputIterator)inputIterator.clone();
        OutputIterator outputIterator2 = (OutputIterator)outputIterator.clone();
        while (!inputIterator3.equals(inputIterator2)) {
            outputIterator2.put(unaryPredicate.execute(inputIterator3.get()) ? object : inputIterator3.get());
            outputIterator2.advance();
            inputIterator3.advance();
        }
        return outputIterator2;
    }

    public static OutputIterator replaceCopyIf(Container container, OutputIterator outputIterator, UnaryPredicate unaryPredicate, Object object) {
        return Replacing.replaceCopyIf(container.start(), container.finish(), outputIterator, unaryPredicate, object);
    }

    public static void replaceCopyIf(Container container, Container container2, UnaryPredicate unaryPredicate, Object object) {
        Replacing.replaceCopyIf(container.start(), container.finish(), new InsertIterator(container2), unaryPredicate, object);
    }
}

