/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.ds;

import com.novell.gw.ds.AttrStrategy;
import com.novell.gw.ds.BufferedAttributes;
import com.novell.gw.util.Debug;
import com.novell.gw.util.EngineResource;
import java.io.Serializable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;

public class BufferedAttrStrategy
implements AttrStrategy,
Serializable {
    private DirContext ctx = null;
    private BufferedAttributes currentAttrs = null;
    private BufferedAttributes addedAttrs = null;
    private BufferedAttributes deletedAttrs = null;
    private BufferedAttributes modifiedAttrs = null;

    public BufferedAttrStrategy(DirContext dirContext) {
        this.ctx = dirContext;
    }

    public Attributes getAttrs() throws NamingException {
        if (this.currentAttrs == null) {
            this.initAttributes();
        }
        return this.currentAttrs;
    }

    public Attributes getAttrs(String[] stringArray) throws NamingException {
        if (this.currentAttrs == null) {
            this.initAttributes();
        }
        BasicAttributes basicAttributes = new BasicAttributes();
        for (int i = 0; i < stringArray.length; ++i) {
            Attribute attribute = this.getAttr(stringArray[i]);
            if (attribute == null) continue;
            basicAttributes.put(attribute);
        }
        return basicAttributes;
    }

    public Attributes getSpecifiedAttrs(String[] stringArray) throws NamingException {
        if (this.currentAttrs == null) {
            this.initAttributes(stringArray);
        }
        return this.currentAttrs;
    }

    public Attribute getAttr(String string) throws NamingException {
        if (this.currentAttrs == null) {
            this.initAttributes();
        }
        return this.currentAttrs.get(string);
    }

    public Object getAttrValue(String string, int n) throws NamingException {
        Attribute attribute;
        Object var3_3 = null;
        if (this.currentAttrs == null) {
            this.initAttributes();
        }
        if ((attribute = this.getAttr(string)) != null) {
            NamingEnumeration<?> namingEnumeration = attribute.getAll();
            for (int i = 1; namingEnumeration.hasMore() && i <= n; ++i) {
                if (i == n) {
                    var3_3 = namingEnumeration.next();
                    break;
                }
                namingEnumeration.next();
            }
        }
        return var3_3;
    }

    public NamingEnumeration getAttrIds() throws NamingException {
        Attributes attributes = this.getAttrs();
        return attributes.getIDs();
    }

    public void addAttr(Attribute attribute) throws NamingException {
        if (this.currentAttrs == null) {
            this.initAttributes();
        }
        this.deletedAttrs.removeValues(attribute);
        this.addedAttrs.addValues(attribute);
        this.currentAttrs.addValues(attribute);
    }

    public void setAttr(Attribute attribute) throws NamingException {
        String string = attribute.getID();
        if (this.currentAttrs == null) {
            this.initAttributes();
        }
        if (attribute == null) {
            throw new NamingException(EngineResource.getString("NullAttribute"));
        }
        this.addedAttrs.remove(string);
        this.deletedAttrs.remove(string);
        this.modifiedAttrs.put(attribute);
        this.currentAttrs.put(attribute);
    }

    public void setAttrValue(String string, Object object) throws NamingException {
        BasicAttribute basicAttribute = new BasicAttribute(string, object);
        this.setAttr(basicAttribute);
    }

    public void removeAttr(Attribute attribute) throws NamingException {
        if (this.currentAttrs == null) {
            this.initAttributes();
        }
        this.addedAttrs.removeValues(attribute);
        this.modifiedAttrs.removeValues(attribute);
        this.deletedAttrs.addValues(attribute);
        this.currentAttrs.removeValues(attribute);
    }

    public void removeAttrFromBuffers(String string) throws NamingException {
        BasicAttribute basicAttribute = new BasicAttribute(string);
        if (this.currentAttrs == null) {
            this.initAttributes();
        }
        this.addedAttrs.removeValues(basicAttribute);
        this.modifiedAttrs.removeValues(basicAttribute);
        this.deletedAttrs.removeValues(basicAttribute);
        this.currentAttrs.removeValues(basicAttribute);
    }

    public boolean hasAttr(String string) {
        if (this.currentAttrs == null) {
            try {
                this.initAttributes();
            }
            catch (NamingException namingException) {
                return false;
            }
        }
        return this.currentAttrs.get(string) != null;
    }

    public int getAttrCount() {
        if (this.currentAttrs == null) {
            try {
                this.initAttributes();
            }
            catch (NamingException namingException) {
                return 0;
            }
        }
        return this.currentAttrs.size();
    }

    public void applyModifications() throws NamingException {
        if (this.addedAttrs != null) {
            ModificationItem[] modificationItemArray = new ModificationItem[this.addedAttrs.size() + this.modifiedAttrs.size() + this.deletedAttrs.size()];
            int n = 0;
            n = this.extractPendingModifications(this.deletedAttrs, 3, modificationItemArray, n);
            n = this.extractPendingModifications(this.modifiedAttrs, 2, modificationItemArray, n);
            n = this.extractPendingModifications(this.addedAttrs, 1, modificationItemArray, n);
            this.ctx.modifyAttributes("", modificationItemArray);
            this.resetPendingModifications();
        }
    }

    private void initAttributes() throws NamingException {
        this.initAttributes(null);
    }

    private void initAttributes(String[] stringArray) throws NamingException {
        Attributes attributes = this.ctx.getAttributes("", stringArray);
        NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
        this.currentAttrs = new BufferedAttributes(false);
        while (namingEnumeration.hasMore()) {
            this.currentAttrs.put(namingEnumeration.next());
        }
        this.resetPendingModifications();
    }

    private void resetPendingModifications() {
        this.addedAttrs = new BufferedAttributes(false);
        this.modifiedAttrs = new BufferedAttributes(true);
        this.deletedAttrs = new BufferedAttributes(true);
    }

    private int extractPendingModifications(Attributes attributes, int n, ModificationItem[] modificationItemArray, int n2) {
        NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
        while (namingEnumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)namingEnumeration.nextElement();
            if (Debug.trace) {
                Debug.trace("extractPendingModifications>mods[" + n2 + "] = new ModificationItem( " + n + ", " + attribute);
            }
            modificationItemArray[n2++] = new ModificationItem(n, attribute);
        }
        return n2;
    }
}

