/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.ds;

import com.novell.gw.ds.AttrConstraints;
import com.novell.gw.ds.AttrInfo;
import com.novell.gw.ds.AttrStrategy;
import com.novell.gw.ds.ExtendedDirContext;
import com.novell.gw.ds.FullAccessRights;
import com.novell.gw.ds.NodeInspector;
import com.novell.gw.ds.Rights;
import com.novell.gw.ds.SimpleExDirContextWrapper;
import com.novell.gw.ds.WriteThroughAttrStrategy;
import com.novell.gw.util.ContainerListener;
import com.novell.gw.util.Debug;
import com.novell.gw.util.NotComparableException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Enumeration;
import javax.naming.Binding;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;

public abstract class ExtendedDirContextImpl
implements ExtendedDirContext {
    protected AttrStrategy attrStrategy = new WriteThroughAttrStrategy(this);
    protected transient PropertyChangeSupport propSupport = new PropertyChangeSupport(this);

    public AttrStrategy getAttrStrategy() {
        return this.attrStrategy;
    }

    public void setAttrStrategy(AttrStrategy attrStrategy) {
        this.attrStrategy = attrStrategy;
    }

    public void reset() throws NamingException {
    }

    public void modifyAttributes(int n, Attributes attributes) throws NamingException {
        this.modifyAttributes("", n, attributes);
    }

    public void modifyAttributes(ModificationItem[] modificationItemArray) throws NamingException {
        this.modifyAttributes("", modificationItemArray);
    }

    public NamingEnumeration search(Attributes attributes) throws NamingException {
        return this.search("", attributes);
    }

    public NamingEnumeration search(Attributes attributes, String[] stringArray) throws NamingException {
        return this.search("", attributes, stringArray);
    }

    public NamingEnumeration search(String string, SearchControls searchControls) throws NamingException {
        return this.search("", string, searchControls);
    }

    public NamingEnumeration search(String string, Object[] objectArray, SearchControls searchControls) throws NamingException {
        return this.search("", string, objectArray, searchControls);
    }

    public Attributes getAttrs() throws NamingException {
        return this.attrStrategy.getAttrs();
    }

    public Attributes getAttrs(String[] stringArray) throws NamingException {
        return this.attrStrategy.getAttrs(stringArray);
    }

    public Attributes getSpecifiedAttrs(String[] stringArray) throws NamingException {
        return this.attrStrategy.getSpecifiedAttrs(stringArray);
    }

    public Attribute getAttr(String string) throws NamingException {
        return this.attrStrategy.getAttr(string);
    }

    public Object getAttrValue(String string, int n) throws NamingException {
        return this.attrStrategy.getAttrValue(string, n);
    }

    public Object getAttrValue(String string) throws NamingException {
        return this.getAttrValue(string, 1);
    }

    public NamingEnumeration getAttrIds() throws NamingException {
        return this.attrStrategy.getAttrIds();
    }

    public void addAttr(Attribute attribute) throws NamingException {
        String string = attribute.getID();
        Attribute attribute2 = this.attrStrategy.getAttr(string);
        if (attribute2 != null) {
            attribute2 = (Attribute)attribute2.clone();
        }
        this.attrStrategy.addAttr(attribute);
        Attribute attribute3 = this.attrStrategy.getAttr(string);
        this.propSupport.firePropertyChange(string, attribute2, attribute3);
    }

    public void addAttrValue(String string, Object object) throws NamingException {
        BasicAttribute basicAttribute = new BasicAttribute(string, object);
        this.addAttr(basicAttribute);
    }

    public void setAttr(Attribute attribute) throws NamingException {
        Attribute attribute2 = this.attrStrategy.getAttr(attribute.getID());
        if (attribute2 != null) {
            attribute2 = (Attribute)attribute2.clone();
        }
        this.attrStrategy.setAttr(attribute);
        this.propSupport.firePropertyChange(attribute.getID(), attribute2, attribute);
    }

    public void setAttrValue(String string, Object object) throws NamingException {
        BasicAttribute basicAttribute = new BasicAttribute(string, object);
        this.setAttr(basicAttribute);
    }

    public void removeAttr(String string) throws NamingException {
        BasicAttribute basicAttribute = new BasicAttribute(string);
        this.removeAttr(basicAttribute);
    }

    public void removeAttr(Attribute attribute) throws NamingException {
        String string = attribute.getID();
        Attribute attribute2 = this.attrStrategy.getAttr(string);
        if (attribute2 != null) {
            attribute2 = (Attribute)attribute2.clone();
        }
        this.attrStrategy.removeAttr(attribute);
        Attribute attribute3 = this.attrStrategy.getAttr(string);
        if (attribute2 != null) {
            this.propSupport.firePropertyChange(string, attribute2, attribute3);
        }
    }

    public void removeAttrValue(String string, Object object) throws NamingException {
        BasicAttribute basicAttribute = new BasicAttribute(string, object);
        this.removeAttr(basicAttribute);
    }

    public void removeAttrFromBuffers(String string) throws NamingException {
        this.attrStrategy.removeAttrFromBuffers(string);
    }

    public boolean hasAttr(String string) {
        return this.attrStrategy.hasAttr(string);
    }

    public int getAttrCount() {
        return this.attrStrategy.getAttrCount();
    }

    public Object getAttrSyntax(String string) throws NamingException {
        AttrInfo attrInfo = this.getAttrInfo(string);
        if (attrInfo != null) {
            return attrInfo.syntax;
        }
        return null;
    }

    public AttrConstraints getAttrConstraints(String string) throws NamingException {
        AttrInfo attrInfo = this.getAttrInfo(string);
        if (attrInfo != null) {
            return attrInfo.constraints;
        }
        return null;
    }

    public Rights getObjectRights() {
        return new FullAccessRights();
    }

    public Rights getAttrRights(String string) {
        return new FullAccessRights();
    }

    public void commit() throws NamingException {
        this.attrStrategy.applyModifications();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void addContainerListener(ContainerListener containerListener) {
    }

    public void removeContainerListener(ContainerListener containerListener) {
    }

    public void clearContainerListeners() {
    }

    public int compare(Object object) throws NotComparableException {
        throw new NotComparableException();
    }

    public boolean matches(String string) {
        return false;
    }

    public boolean matches(int n, Object object) {
        return false;
    }

    public Object getObject(String string) throws NamingException {
        return this.lookup(string);
    }

    public Object getObject(String string, Object[] objectArray) throws NamingException {
        NamingEnumeration namingEnumeration = this.search(string, objectArray, new SearchControls());
        if (namingEnumeration.hasMore()) {
            return namingEnumeration.next();
        }
        return null;
    }

    public Enumeration getObjects(String string, Object[] objectArray) throws NamingException {
        return this.search(string, objectArray, new SearchControls());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("ExtendedDirContextImpl.toString [");
        try {
            Attributes attributes = this.getAttributes("");
            NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
            int n = 0;
            while (namingEnumeration.hasMore()) {
                if (n > 0) {
                    stringBuffer.append("\n");
                }
                Attribute attribute = namingEnumeration.next();
                NamingEnumeration<?> namingEnumeration2 = attribute.getAll();
                stringBuffer.append(attribute.getID() + ": ");
                namingEnumeration2 = attribute.getAll();
                int n2 = 0;
                while (namingEnumeration2.hasMore()) {
                    Object obj = namingEnumeration2.next();
                    if (n2 > 0) {
                        stringBuffer.append(" | ");
                    }
                    stringBuffer.append(obj);
                    ++n2;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            Debug.traceException(exception);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void traverse(NodeInspector nodeInspector) throws NamingException {
        try {
            NamingEnumeration<Binding> namingEnumeration = this.listBindings("");
            while (namingEnumeration.hasMore()) {
                Binding binding = namingEnumeration.next();
                Object object = binding.getObject();
                nodeInspector.inspectNode(object);
                if (object instanceof DirContext && !(object instanceof ExtendedDirContext)) {
                    object = new SimpleExDirContextWrapper((DirContext)object);
                }
                if (!(object instanceof ExtendedDirContext)) continue;
                ((ExtendedDirContext)object).traverse(nodeInspector);
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }
}

