/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.ds.values;

import com.novell.gw.ds.SearchSupport;
import com.novell.gw.ds.values.IntegerValue;
import com.novell.gw.ds.values.OctetStringValue;
import com.novell.gw.util.Comparable;
import com.novell.gw.util.Matchable;
import com.novell.gw.util.NotComparableException;
import com.novell.service.schema.SchemaComposite;
import com.novell.service.schema.SchemaValue;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class NetAddressValue
implements SchemaComposite,
Comparable,
Matchable,
Cloneable,
Serializable {
    public static final int TYPE_NULL = -1;
    public static final int TYPE_IPX = 0;
    public static final int TYPE_IP = 1;
    public static final int TYPE_NSAP = 4;
    public static final int TYPE_APPLETALK = 5;
    public static final int TYPE_IPV6 = 11;
    protected int type;
    protected byte[] value;
    private static final String[] compositeIds = new String[3];

    public NetAddressValue() {
        this.type = -1;
        this.value = new byte[0];
    }

    public NetAddressValue(int n, byte[] byArray) {
        this.type = n;
        this.value = (byte[])byArray.clone();
    }

    public NetAddressValue(NetAddressValue netAddressValue) {
        this.value = (byte[])netAddressValue.value.clone();
        this.type = netAddressValue.type;
    }

    public Object clone() {
        return new NetAddressValue(this.type, this.value);
    }

    public int compareTo(Object object) throws Exception {
        return this.compare(object);
    }

    public boolean equals(Object object) {
        if (object instanceof NetAddressValue) {
            NetAddressValue netAddressValue = (NetAddressValue)object;
            if (this.type == netAddressValue.type) {
                int n = SearchSupport.compareBytes(this.value, netAddressValue.value);
                return n == 0;
            }
        }
        return false;
    }

    public String getName() {
        return "";
    }

    public String getSyntaxId() {
        return "";
    }

    public int count() {
        return compositeIds.length;
    }

    public SchemaValue getValue(String string) {
        if (string.equals(compositeIds[0])) {
            return new IntegerValue(this.type);
        }
        if (string.equals(compositeIds[1])) {
            return new IntegerValue(this.value.length);
        }
        if (string.equals(compositeIds[2])) {
            return new OctetStringValue(this.value);
        }
        return null;
    }

    public Enumeration getValueIds() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < compositeIds.length; ++i) {
            vector.addElement(compositeIds[i]);
        }
        return vector.elements();
    }

    public Enumeration getValues() {
        Vector<SchemaValue> vector = new Vector<SchemaValue>();
        for (int i = 0; i < compositeIds.length; ++i) {
            vector.addElement(this.getValue(compositeIds[i]));
        }
        return vector.elements();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(this.type) + ":");
        for (int i = 0; i < this.value.length; ++i) {
            if (i > 0) {
                stringBuffer.append(' ');
            }
            int n = this.value[i] & 0xFF;
            stringBuffer.append(Integer.toHexString(n).toUpperCase());
        }
        return stringBuffer.toString();
    }

    public int compare(Object object) throws NotComparableException {
        throw new NotComparableException();
    }

    public boolean matches(String string) {
        return false;
    }

    public boolean matches(int n, Object object) {
        return false;
    }

    static {
        NetAddressValue.compositeIds[0] = "type";
        NetAddressValue.compositeIds[1] = "length";
        NetAddressValue.compositeIds[2] = "address";
    }
}

