/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.util;

import com.novell.gw.util.Swap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class ByteArray {
    private ByteArrayInputStream bis = null;
    private ByteArrayOutputStream bos = null;

    public ByteArray(byte[] byArray) {
        this.bis = new ByteArrayInputStream(byArray, 0, byArray.length);
    }

    public ByteArray() {
        this.bos = new ByteArrayOutputStream();
    }

    public Object getStream() {
        if (this.bis != null) {
            return this.bis;
        }
        return this.bos;
    }

    public void close() throws IOException {
        if (this.bis != null) {
            this.bis.close();
        }
        if (this.bos != null) {
            this.bos.close();
        }
    }

    public int getInt() {
        int n = -1;
        byte[] byArray = new byte[4];
        int n2 = this.bis.read(byArray, 0, 4);
        if (n2 == 4) {
            n = Swap.bits32ToInt(byArray);
        }
        return n;
    }

    public int getWord() {
        int n = -1;
        byte[] byArray = new byte[2];
        int n2 = this.bis.read(byArray, 0, 2);
        if (n2 == 2) {
            n = Swap.bits16ToShort(byArray);
        }
        return n;
    }

    public int getByte() {
        return this.bis.read();
    }

    public String getString(int n) {
        byte[] byArray;
        int n2;
        String string = null;
        if (n > 0 && (n2 = this.bis.read(byArray = new byte[n], 0, n)) == n) {
            int n3;
            for (n3 = 0; n3 < n && byArray[n3] != 0; ++n3) {
            }
            string = new String(byArray, 0, n3);
        }
        return string;
    }

    public void setInt(int n) {
        byte[] byArray = Swap.intTo32Bits(n);
        this.bos.write(byArray, 0, 4);
    }

    public void setWord(short s) {
        byte[] byArray = Swap.shortTo16Bits(s);
        this.bos.write(byArray, 0, 2);
    }

    public void setByte(int n) {
        this.bos.write(n);
    }

    public void setString(String string, int n) {
        if (n > 0) {
            int n2;
            byte[] byArray = new byte[n];
            byte[] byArray2 = string.getBytes();
            for (n2 = 0; n2 < byArray2.length; ++n2) {
                byArray[n2] = byArray2[n2];
            }
            for (n2 = byArray2.length; n2 < n; ++n2) {
                byArray[n2] = 0;
            }
            this.bos.write(byArray, 0, n);
        }
    }
}

