/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.util;

import com.novell.gw.util.Debug;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class ClassHeirarchy {
    public static final String NAMING_SEPARATOR = ".";

    public static Vector getSubclassNames(Class clazz, boolean bl) {
        Vector<String> vector = new Vector<String>();
        for (Class clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            String string = bl ? ClassHeirarchy.getSimpleClassName(clazz2) : clazz2.getName();
            vector.insertElementAt(string, 0);
        }
        return vector;
    }

    public static String getHeirarchyString(Class clazz) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = ClassHeirarchy.getSubclassNames(clazz, false).elements();
        while (enumeration.hasMoreElements()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(NAMING_SEPARATOR);
            }
            stringBuffer.append(ClassHeirarchy.getSimpleClassName((String)enumeration.nextElement()));
        }
        return stringBuffer.toString();
    }

    public static String getHeirarchyString(Class clazz, String string, boolean bl) throws ClassNotFoundException {
        StringBuffer stringBuffer = new StringBuffer();
        Class<?> clazz2 = Class.forName(string);
        if (clazz2.isInterface()) {
            Class clazz3;
            Vector<String> vector = new Vector<String>();
            for (clazz3 = clazz; clazz3 != null && !ClassHeirarchy.implementsInterface(clazz3.getName(), string); clazz3 = clazz3.getSuperclass()) {
                vector.insertElementAt(ClassHeirarchy.getSimpleClassName(clazz3.getName()), 0);
            }
            if (clazz3 != null && bl) {
                vector.insertElementAt(ClassHeirarchy.getSimpleClassName(clazz3.getName()), 0);
            }
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(NAMING_SEPARATOR);
                }
                stringBuffer.append((String)enumeration.nextElement());
            }
        } else {
            Enumeration enumeration = ClassHeirarchy.getSubclassNames(clazz, false).elements();
            boolean bl2 = false;
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (bl2) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(NAMING_SEPARATOR);
                    }
                    stringBuffer.append(ClassHeirarchy.getSimpleClassName(string2));
                    continue;
                }
                if (!ClassHeirarchy.isSubclassOf(string2, string)) continue;
                bl2 = true;
                if (!bl) continue;
                stringBuffer.append(ClassHeirarchy.getSimpleClassName(string2));
            }
        }
        return stringBuffer.toString();
    }

    public static String getSimpleClassName(Class clazz) {
        return ClassHeirarchy.getSimpleClassName(clazz.getName());
    }

    public static String getSimpleClassName(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, NAMING_SEPARATOR);
        String string2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        return string2;
    }

    public static boolean isSubclassOf(String string, String string2) {
        try {
            Class<?> clazz = Class.forName(string2);
            Class<?> clazz2 = Class.forName(string);
            return clazz.isAssignableFrom(clazz2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Debug.traceException(classNotFoundException);
            return false;
        }
    }

    public static boolean implementsInterface(String string, String string2) {
        try {
            Class<?> clazz = Class.forName(string);
            Class<?>[] classArray = clazz.getInterfaces();
            for (int i = 0; i < classArray.length; ++i) {
                if (!classArray[i].getName().equals(string2)) continue;
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            Debug.traceException(classNotFoundException);
        }
        return false;
    }

    public static void main(String[] stringArray) {
        try {
            Class<?> clazz = Class.forName("com.novell.gw.admin.monitor.PollerException");
            String string = ClassHeirarchy.getHeirarchyString(clazz, "com.novell.gw.admin.common.ExceptionNamingRoot", true);
            System.out.println("Heirarchy = " + string);
            Class<?>[] classArray = clazz.getInterfaces();
            System.out.println("Interfaces = ");
            for (int i = 0; i < classArray.length; ++i) {
                System.out.println(classArray[i].getName());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

