/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.util;

import com.novell.gw.util.Debug;
import com.novell.gw.util.EngineResource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;

public class FileHandler {
    public static int MAX_BYTE_ARRAY_SIZE = 4096;

    public void copyFile(File file, File file2) throws FileNotFoundException, IOException {
        int n = 0;
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        byte[] byArray = new byte[MAX_BYTE_ARRAY_SIZE];
        if (!file.exists() || !file.isFile()) {
            Debug.trace("Source File: " + file + " isn't a file");
            throw new FileNotFoundException(EngineResource.getString("FileNotExist") + " " + file);
        }
        if (file2.exists()) {
            Debug.trace("Dest File: " + file2 + " already exists!!");
        }
        fileInputStream = new FileInputStream(file);
        fileOutputStream = new FileOutputStream(file2);
        while ((n = fileInputStream.read(byArray)) != -1) {
            fileOutputStream.write(byArray, 0, n);
        }
        fileInputStream.close();
        fileOutputStream.close();
        file2.setLastModified(file.lastModified());
    }

    public void copyDirectory(File file, File file2, boolean bl) throws FileNotFoundException, IOException {
        if (!file.isDirectory()) {
            throw new FileNotFoundException("Source Directory: " + file + " doesn't exist");
        }
        if (!file2.isDirectory()) {
            if (!bl) {
                throw new FileNotFoundException("Destination Directory: " + file2 + "doesn't exist");
            }
            Debug.trace("Making Directory " + file2.getCanonicalPath());
            file2.mkdir();
        }
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            File file3;
            File file4 = new File(file, stringArray[i]);
            if (file4.isDirectory()) {
                Debug.trace("child: " + file4.getCanonicalPath() + " is a directory");
                file3 = new File(file2, stringArray[i]);
                boolean bl2 = file3.mkdir();
                Debug.trace("Made Directory? " + bl2);
                this.copyDirectory(file4, file3, true);
                continue;
            }
            file3 = new File(file2, stringArray[i]);
            this.copyFile(file4, file3);
        }
    }

    public int containsLine(File file, String string, int n) throws FileNotFoundException, IOException {
        FileReader fileReader = new FileReader(file);
        LineNumberReader lineNumberReader = new LineNumberReader(fileReader);
        String string2 = "";
        try {
            string = string.toUpperCase();
            for (int i = 1; i < n; ++i) {
                string2 = lineNumberReader.readLine();
            }
            while ((string2 = lineNumberReader.readLine()) != null) {
                string2 = string2.trim();
                if (!(string2 = string2.toUpperCase()).startsWith(string)) continue;
                lineNumberReader.close();
                fileReader.close();
                return lineNumberReader.getLineNumber();
            }
            lineNumberReader.close();
            fileReader.close();
        }
        catch (IOException iOException) {
            throw new IOException(file.toString());
        }
        return -1;
    }

    public String getLine(File file, int n) throws FileNotFoundException, IOException {
        String string = "";
        try {
            FileReader fileReader = new FileReader(file);
            LineNumberReader lineNumberReader = new LineNumberReader(fileReader);
            for (int i = 0; i < n; ++i) {
                string = lineNumberReader.readLine();
            }
            lineNumberReader.close();
            fileReader.close();
        }
        catch (IOException iOException) {
            throw new IOException(file.toString());
        }
        return string;
    }
}

